-- 
-- Table structure for table `mod63_commentmeta` 
-- 

DROP TABLE IF EXISTS `mod63_commentmeta`; 
CREATE TABLE `mod63_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci; 

-- 
-- Dumping data for table `mod63_commentmeta` 
-- 

LOCK TABLES `mod63_commentmeta` WRITE; 
INSERT INTO `mod63_commentmeta` VALUES ('1', '2', 'akismet_error', '1540067998'); 
INSERT INTO `mod63_commentmeta` VALUES ('2', '2', 'akismet_history', 'a:4:{s:4:"time";d:1540067998.5477581;s:5:"event";s:11:"check-error";s:4:"user";s:9:"admin2047";s:4:"meta";a:1:{s:8:"response";s:7:"invalid";}}'); 
INSERT INTO `mod63_commentmeta` VALUES ('3', '2', 'akismet_as_submitted', 'a:13:{s:14:"comment_author";s:9:"admin2047";s:20:"comment_author_email";s:22:"beyondtech96@gmail.com";s:18:"comment_author_url";s:0:"";s:15:"comment_content";s:12:"good product";s:12:"comment_type";s:0:"";s:7:"user_ID";i:1;s:7:"user_id";i:1;s:7:"user_ip";s:14:"197.155.143.28";s:10:"user_agent";s:115:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36";s:4:"blog";s:18:"http://eakmali.com";s:9:"blog_lang";s:5:"fr_FR";s:12:"blog_charset";s:5:"UTF-8";s:9:"permalink";s:62:"http://eakmali.com/produit/air-water-reel-10mm-x-30m-lubemate/";}'); 
INSERT INTO `mod63_commentmeta` VALUES ('4', '2', 'rating', '5'); 
INSERT INTO `mod63_commentmeta` VALUES ('5', '2', 'verified', '0'); 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_comments` 
-- 

DROP TABLE IF EXISTS `mod63_comments`; 
CREATE TABLE `mod63_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci; 

-- 
-- Dumping data for table `mod63_comments` 
-- 

LOCK TABLES `mod63_comments` WRITE; 
INSERT INTO `mod63_comments` VALUES ('1', '1', 'Un commentateur WordPress', 'wapuu@wordpress.example', 'https://wordpress.org/', '', '2018-10-04 15:56:28', '2018-10-04 13:56:28', 'Bonjour, ceci est un commentaire.
Pour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.
Les avatars des personnes qui commentent arrivent depuis <a href="https://gravatar.com">Gravatar</a>.', '0', 'post-trashed', '', '', '0', '0'); 
INSERT INTO `mod63_comments` VALUES ('2', '981', 'admin2047', 'beyondtech96@gmail.com', '', '197.155.143.28', '2018-10-20 20:39:58', '2018-10-20 20:39:58', 'good product', '0', '1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36', '', '0', '1'); 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_fb3d_pages` 
-- 

DROP TABLE IF EXISTS `mod63_fb3d_pages`; 
CREATE TABLE `mod63_fb3d_pages` (
  `page_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page_post_ID` bigint(20) unsigned NOT NULL,
  `page_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `page_source_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `page_source_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `page_thumbnail_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `page_thumbnail_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `page_meta_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `page_number` int(11) NOT NULL,
  PRIMARY KEY (`page_ID`),
  KEY `page_post_ID` (`page_post_ID`),
  KEY `page_source_type` (`page_source_type`),
  KEY `page_thumbnail_type` (`page_thumbnail_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci; 

-- 
-- Dumping data for table `mod63_fb3d_pages` 
-- 

LOCK TABLES `mod63_fb3d_pages` WRITE; 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_ipages_flipbook` 
-- 

DROP TABLE IF EXISTS `mod63_ipages_flipbook`; 
CREATE TABLE `mod63_ipages_flipbook` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `data` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `config` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1; 

-- 
-- Dumping data for table `mod63_ipages_flipbook` 
-- 

LOCK TABLES `mod63_ipages_flipbook` WRITE; 
INSERT INTO `mod63_ipages_flipbook` VALUES ('1', '', '1', 'O:8:"stdClass":56:{s:5:"title";N;s:6:"active";b:1;s:10:"bookEngine";s:11:"TwoPageFlip";s:9:"pageWidth";i:300;s:10:"pageHeight";i:360;s:9:"pageStart";i:1;s:6:"pdfUrl";s:59:"http://eakmali.com/wp-content/uploads/2018/10/Catalogue.pdf";s:18:"pdfAutoCreatePages";b:1;s:23:"pdfBookSizeFromDocument";b:1;s:21:"pdfProgressiveLoading";b:1;s:17:"preloadNeighbours";b:1;s:10:"responsive";b:1;s:7:"autoFit";b:0;s:9:"flipSound";b:1;s:12:"flipSoundUrl";N;s:12:"flipDuration";i:300;s:9:"bookTheme";s:4:"dark";s:9:"bookClass";N;s:9:"autoWidth";b:1;s:10:"autoHeight";b:1;s:15:"containerHeight";N;s:14:"containerWidth";N;s:7:"padding";O:8:"stdClass":4:{s:3:"top";i:10;s:5:"right";i:10;s:6:"bottom";i:10;s:4:"left";i:10;}s:11:"perspective";i:1500;s:15:"backgroundColor";N;s:15:"backgroundImage";O:8:"stdClass":2:{s:8:"relative";b:1;s:3:"url";N;}s:14:"backgroundSize";N;s:16:"backgroundRepeat";N;s:18:"backgroundPosition";N;s:15:"prevnextButtons";b:1;s:15:"touchNavigation";b:1;s:18:"keyboardNavigation";b:1;s:20:"mouseWheelNavigation";b:0;s:24:"mouseWheelPreventDefault";b:0;s:4:"zoom";i:1;s:7:"zoomMax";i:7;s:7:"zoomMin";i:1;s:8:"zoomStep";d:0.050000000000000003;s:9:"zoomFocal";b:1;s:19:"dblClickZoomDefault";b:0;s:14:"mouseWheelZoom";b:1;s:12:"keyboardZoom";b:1;s:9:"pinchZoom";b:1;s:13:"pinchZoomCoef";d:0.0050000000000000001;s:11:"pageNumbers";b:0;s:16:"pageNumbersFirst";i:1;s:17:"pageNumbersHidden";N;s:5:"pages";a:0:{}s:7:"toolbar";b:1;s:15:"toolbarControls";a:15:{i:0;O:8:"stdClass":5:{s:4:"type";s:5:"share";s:6:"active";b:1;s:5:"title";s:5:"share";s:4:"icon";s:29:"ipages-icon ipages-icon-share";s:8:"optional";b:0;}i:1;O:8:"stdClass":5:{s:4:"type";s:7:"outline";s:6:"active";b:1;s:5:"title";s:23:"toggle outline/bookmark";s:4:"icon";s:31:"ipages-icon ipages-icon-outline";s:8:"optional";b:0;}i:2;O:8:"stdClass":5:{s:4:"type";s:10:"thumbnails";s:6:"active";b:1;s:5:"title";s:17:"toggle thumbnails";s:4:"icon";s:34:"ipages-icon ipages-icon-thumbnails";s:8:"optional";b:0;}i:3;O:8:"stdClass":5:{s:4:"type";s:9:"gotofirst";s:6:"active";b:0;s:5:"title";s:15:"goto first page";s:4:"icon";s:33:"ipages-icon ipages-icon-gotofirst";s:8:"optional";b:0;}i:4;O:8:"stdClass":5:{s:4:"type";s:4:"prev";s:6:"active";b:1;s:5:"title";s:9:"prev page";s:4:"icon";s:28:"ipages-icon ipages-icon-prev";s:8:"optional";b:0;}i:5;O:8:"stdClass":5:{s:4:"type";s:10:"pagenumber";s:6:"active";b:1;s:5:"title";s:16:"goto page number";s:4:"icon";s:34:"ipages-icon ipages-icon-pagenumber";s:8:"optional";b:0;}i:6;O:8:"stdClass":5:{s:4:"type";s:4:"next";s:6:"active";b:1;s:5:"title";s:9:"next page";s:4:"icon";s:28:"ipages-icon ipages-icon-next";s:8:"optional";b:0;}i:7;O:8:"stdClass":5:{s:4:"type";s:8:"gotolast";s:6:"active";b:0;s:5:"title";s:14:"goto last page";s:4:"icon";s:32:"ipages-icon ipages-icon-gotolast";s:8:"optional";b:0;}i:8;O:8:"stdClass":5:{s:4:"type";s:7:"zoom-in";s:6:"active";b:1;s:5:"title";s:7:"zoom in";s:4:"icon";s:31:"ipages-icon ipages-icon-zoom-in";s:8:"optional";b:0;}i:9;O:8:"stdClass":5:{s:4:"type";s:8:"zoom-out";s:6:"active";b:1;s:5:"title";s:8:"zoom out";s:4:"icon";s:32:"ipages-icon ipages-icon-zoom-out";s:8:"optional";b:0;}i:10;O:8:"stdClass":5:{s:4:"type";s:12:"zoom-default";s:6:"active";b:1;s:5:"title";s:12:"zoom default";s:4:"icon";s:36:"ipages-icon ipages-icon-zoom-default";s:8:"optional";b:0;}i:11;O:8:"stdClass":5:{s:4:"type";s:8:"optional";s:6:"active";b:1;s:5:"title";s:8:"optional";s:4:"icon";s:28:"ipages-icon ipages-icon-more";s:8:"optional";b:0;}i:12;O:8:"stdClass":5:{s:4:"type";s:10:"fullscreen";s:6:"active";b:1;s:5:"title";s:17:"toggle fullscreen";s:4:"icon";s:34:"ipages-icon ipages-icon-fullscreen";s:8:"optional";b:1;}i:13;O:8:"stdClass":5:{s:4:"type";s:5:"sound";s:6:"active";b:1;s:5:"title";s:22:"turn on/off flip sound";s:4:"icon";s:29:"ipages-icon ipages-icon-sound";s:8:"optional";b:1;}i:14;O:8:"stdClass":5:{s:4:"type";s:8:"download";s:6:"active";b:1;s:5:"title";s:12:"download pdf";s:4:"icon";s:32:"ipages-icon ipages-icon-download";s:8:"optional";b:1;}}s:20:"autoEnableThumbnails";b:0;s:17:"autoEnableOutline";b:0;s:15:"autoEnableShare";b:0;s:9:"bookmarks";a:0:{}s:9:"customCSS";O:8:"stdClass":2:{s:6:"active";b:0;s:4:"data";N;}s:8:"customJS";O:8:"stdClass":2:{s:6:"active";b:0;s:4:"data";N;}}', 'O:8:"stdClass":42:{s:10:"bookEngine";s:11:"TwoPageFlip";s:9:"bookTheme";N;s:9:"pageWidth";i:300;s:10:"pageHeight";i:360;s:9:"pageStart";i:1;s:6:"pdfUrl";s:59:"http://eakmali.com/wp-content/uploads/2018/10/Catalogue.pdf";s:18:"pdfAutoCreatePages";b:1;s:23:"pdfBookSizeFromDocument";b:1;s:23:"pdfDisableRangeRequests";b:0;s:17:"preloadNeighbours";b:1;s:10:"responsive";b:1;s:7:"autoFit";b:0;s:9:"flipSound";b:1;s:12:"flipSoundUrl";N;s:11:"perspective";i:1500;s:10:"autoHeight";b:1;s:7:"padding";O:8:"stdClass":4:{s:3:"top";i:10;s:5:"right";i:10;s:6:"bottom";i:10;s:4:"left";i:10;}s:12:"flipDuration";i:300;s:11:"pageNumbers";b:0;s:16:"pageNumbersFirst";i:1;s:17:"pageNumbersHidden";a:0:{}s:15:"prevnextButtons";b:1;s:15:"touchNavigation";b:1;s:18:"keyboardNavigation";b:1;s:20:"mouseWheelNavigation";b:0;s:24:"mouseWheelPreventDefault";b:0;s:4:"zoom";i:1;s:7:"zoomMax";i:7;s:7:"zoomMin";i:1;s:8:"zoomStep";d:0.050000000000000003;s:9:"zoomFocal";b:1;s:19:"dblClickZoomDefault";b:0;s:14:"mouseWheelZoom";b:1;s:12:"keyboardZoom";b:1;s:9:"pinchZoom";b:1;s:13:"pinchZoomCoef";d:0.0050000000000000001;s:7:"toolbar";b:1;s:15:"toolbarControls";a:15:{i:0;O:8:"stdClass":5:{s:4:"type";s:5:"share";s:6:"active";b:1;s:5:"title";s:5:"share";s:4:"icon";s:29:"ipages-icon ipages-icon-share";s:8:"optional";b:0;}i:1;O:8:"stdClass":5:{s:4:"type";s:7:"outline";s:6:"active";b:1;s:5:"title";s:23:"toggle outline/bookmark";s:4:"icon";s:31:"ipages-icon ipages-icon-outline";s:8:"optional";b:0;}i:2;O:8:"stdClass":5:{s:4:"type";s:10:"thumbnails";s:6:"active";b:1;s:5:"title";s:17:"toggle thumbnails";s:4:"icon";s:34:"ipages-icon ipages-icon-thumbnails";s:8:"optional";b:0;}i:3;O:8:"stdClass":5:{s:4:"type";s:9:"gotofirst";s:6:"active";b:0;s:5:"title";s:15:"goto first page";s:4:"icon";s:33:"ipages-icon ipages-icon-gotofirst";s:8:"optional";b:0;}i:4;O:8:"stdClass":5:{s:4:"type";s:4:"prev";s:6:"active";b:1;s:5:"title";s:9:"prev page";s:4:"icon";s:28:"ipages-icon ipages-icon-prev";s:8:"optional";b:0;}i:5;O:8:"stdClass":5:{s:4:"type";s:10:"pagenumber";s:6:"active";b:1;s:5:"title";s:16:"goto page number";s:4:"icon";s:34:"ipages-icon ipages-icon-pagenumber";s:8:"optional";b:0;}i:6;O:8:"stdClass":5:{s:4:"type";s:4:"next";s:6:"active";b:1;s:5:"title";s:9:"next page";s:4:"icon";s:28:"ipages-icon ipages-icon-next";s:8:"optional";b:0;}i:7;O:8:"stdClass":5:{s:4:"type";s:8:"gotolast";s:6:"active";b:0;s:5:"title";s:14:"goto last page";s:4:"icon";s:32:"ipages-icon ipages-icon-gotolast";s:8:"optional";b:0;}i:8;O:8:"stdClass":5:{s:4:"type";s:7:"zoom-in";s:6:"active";b:1;s:5:"title";s:7:"zoom in";s:4:"icon";s:31:"ipages-icon ipages-icon-zoom-in";s:8:"optional";b:0;}i:9;O:8:"stdClass":5:{s:4:"type";s:8:"zoom-out";s:6:"active";b:1;s:5:"title";s:8:"zoom out";s:4:"icon";s:32:"ipages-icon ipages-icon-zoom-out";s:8:"optional";b:0;}i:10;O:8:"stdClass":5:{s:4:"type";s:12:"zoom-default";s:6:"active";b:1;s:5:"title";s:12:"zoom default";s:4:"icon";s:36:"ipages-icon ipages-icon-zoom-default";s:8:"optional";b:0;}i:11;O:8:"stdClass":5:{s:4:"type";s:8:"optional";s:6:"active";b:1;s:5:"title";s:8:"optional";s:4:"icon";s:28:"ipages-icon ipages-icon-more";s:8:"optional";b:0;}i:12;O:8:"stdClass":5:{s:4:"type";s:10:"fullscreen";s:6:"active";b:1;s:5:"title";s:17:"toggle fullscreen";s:4:"icon";s:34:"ipages-icon ipages-icon-fullscreen";s:8:"optional";b:1;}i:13;O:8:"stdClass":5:{s:4:"type";s:5:"sound";s:6:"active";b:1;s:5:"title";s:22:"turn on/off flip sound";s:4:"icon";s:29:"ipages-icon ipages-icon-sound";s:8:"optional";b:1;}i:14;O:8:"stdClass":5:{s:4:"type";s:8:"download";s:6:"active";b:1;s:5:"title";s:12:"download pdf";s:4:"icon";s:32:"ipages-icon ipages-icon-download";s:8:"optional";b:1;}}s:20:"autoEnableThumbnails";b:0;s:17:"autoEnableOutline";b:0;s:15:"autoEnableShare";b:0;s:9:"bookmarks";a:0:{}}', '1', '2018-10-13 01:17:29', '2018-10-13 01:25:57'); 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_ksp_layers` 
-- 

DROP TABLE IF EXISTS `mod63_ksp_layers`; 
CREATE TABLE `mod63_ksp_layers` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `slider_parent` mediumint(9) DEFAULT NULL,
  `slide_parent` mediumint(9) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `type` text CHARACTER SET utf8,
  `inner_html` text CHARACTER SET utf8,
  `image_src` text CHARACTER SET utf8,
  `image_alt` text CHARACTER SET utf8,
  `align_horizontal` text CHARACTER SET utf8,
  `align_veritcal` text CHARACTER SET utf8,
  `data_y` int(11) DEFAULT NULL,
  `data_x` int(11) DEFAULT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `font_color` text CHARACTER SET utf8,
  `font_hover_color` text CHARACTER SET utf8,
  `background_color` text CHARACTER SET utf8,
  `background_hover_color` text CHARACTER SET utf8,
  `border_color` text CHARACTER SET utf8,
  `border_hover_color` text CHARACTER SET utf8,
  `border_width` int(11) DEFAULT NULL,
  `border_radius` int(11) DEFAULT NULL,
  `letter_spacing` int(11) DEFAULT NULL,
  `padding` int(11) DEFAULT NULL,
  `font_size` int(11) DEFAULT NULL,
  `line_height` text CHARACTER SET utf8,
  `font` text CHARACTER SET utf8,
  `data_delay` int(11) DEFAULT NULL,
  `data_time` text CHARACTER SET utf8,
  `data_in` text CHARACTER SET utf8,
  `data_out` text CHARACTER SET utf8,
  `data_ease` int(11) DEFAULT NULL,
  `link` text CHARACTER SET utf8,
  `link_new_tab` int(11) DEFAULT '0',
  `z_index` int(11) DEFAULT NULL,
  `text_shadow` text CHARACTER SET utf8,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1; 

-- 
-- Dumping data for table `mod63_ksp_layers` 
-- 

LOCK TABLES `mod63_ksp_layers` WRITE; 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_ksp_sliders` 
-- 

DROP TABLE IF EXISTS `mod63_ksp_sliders`; 
CREATE TABLE `mod63_ksp_sliders` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` text CHARACTER SET utf8,
  `responsive` int(11) DEFAULT NULL,
  `maxHeight` int(11) DEFAULT NULL,
  `maxWidth` int(11) DEFAULT NULL,
  `fullHeight` int(11) DEFAULT NULL,
  `full_offset` text CHARACTER SET utf8,
  `fullWidth` int(11) DEFAULT NULL,
  `autoPlay` int(11) DEFAULT NULL,
  `pauseTime` int(11) DEFAULT NULL,
  `enableParallax` int(11) DEFAULT NULL,
  `singleSlide` int(11) DEFAULT NULL,
  `minHeight` int(11) DEFAULT NULL,
  `pauseonHover` int(11) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1; 

-- 
-- Dumping data for table `mod63_ksp_sliders` 
-- 

LOCK TABLES `mod63_ksp_sliders` WRITE; 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_ksp_slides` 
-- 

DROP TABLE IF EXISTS `mod63_ksp_slides`; 
CREATE TABLE `mod63_ksp_slides` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `slider_parent` mediumint(9) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `background_type_image` text CHARACTER SET utf8,
  `background_type_color` text CHARACTER SET utf8,
  `background_propriety_position` text CHARACTER SET utf8,
  `background_repeat` text CHARACTER SET utf8,
  `background_propriety_size` text CHARACTER SET utf8,
  `background_type_video` text CHARACTER SET utf8,
  `background_type_video_youtube` text CHARACTER SET utf8,
  `background_type_video_mute` int(11) DEFAULT NULL,
  `background_type_video_loop` int(11) DEFAULT NULL,
  `background_type_video_playpause` int(11) DEFAULT NULL,
  `background_type_video_ratio` text CHARACTER SET utf8,
  `background_type_video_start` int(11) DEFAULT NULL,
  `background_type_video_mp4` text CHARACTER SET utf8,
  `background_type_video_webm` text CHARACTER SET utf8,
  `background_link` text CHARACTER SET utf8,
  `background_link_new_tab` int(11) DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1; 

-- 
-- Dumping data for table `mod63_ksp_slides` 
-- 

LOCK TABLES `mod63_ksp_slides` WRITE; 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_links` 
-- 

DROP TABLE IF EXISTS `mod63_links`; 
CREATE TABLE `mod63_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci; 

-- 
-- Dumping data for table `mod63_links` 
-- 

LOCK TABLES `mod63_links` WRITE; 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_mtouchquiz_answer` 
-- 

DROP TABLE IF EXISTS `mod63_mtouchquiz_answer`; 
CREATE TABLE `mod63_mtouchquiz_answer` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `question_id` int(11) unsigned NOT NULL,
  `answer` varchar(1024) CHARACTER SET utf8 NOT NULL,
  `hint` varchar(1024) CHARACTER SET utf8 NOT NULL,
  `correct` enum('0','1') NOT NULL DEFAULT '0',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1; 

-- 
-- Dumping data for table `mod63_mtouchquiz_answer` 
-- 

LOCK TABLES `mod63_mtouchquiz_answer` WRITE; 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_mtouchquiz_question` 
-- 

DROP TABLE IF EXISTS `mod63_mtouchquiz_question`; 
CREATE TABLE `mod63_mtouchquiz_question` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) unsigned NOT NULL,
  `question` mediumtext CHARACTER SET utf8 NOT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `point_value` int(3) NOT NULL DEFAULT '100',
  `number_correct` int(3) NOT NULL DEFAULT '1',
  `explanation` mediumtext CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `quiz_id` (`quiz_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1; 

-- 
-- Dumping data for table `mod63_mtouchquiz_question` 
-- 

LOCK TABLES `mod63_mtouchquiz_question` WRITE; 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_mtouchquiz_quiz` 
-- 

DROP TABLE IF EXISTS `mod63_mtouchquiz_quiz`; 
CREATE TABLE `mod63_mtouchquiz_quiz` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8 NOT NULL,
  `description` mediumtext CHARACTER SET utf8 NOT NULL,
  `final_screen` mediumtext CHARACTER SET utf8 NOT NULL,
  `form_code` varchar(100) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `added_on` datetime NOT NULL,
  `show_hints` enum('0','1') NOT NULL DEFAULT '1',
  `show_start` enum('0','1') NOT NULL DEFAULT '1',
  `show_final` enum('0','1') NOT NULL DEFAULT '1',
  `random_questions` enum('0','1') NOT NULL DEFAULT '0',
  `random_answers` enum('0','1') NOT NULL DEFAULT '0',
  `multiple_chances` enum('0','1') NOT NULL DEFAULT '1',
  `single_page` enum('0','1') NOT NULL DEFAULT '0',
  `answer_mode` enum('0','1','2') NOT NULL DEFAULT '2',
  `time_limit` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1; 

-- 
-- Dumping data for table `mod63_mtouchquiz_quiz` 
-- 

LOCK TABLES `mod63_mtouchquiz_quiz` WRITE; 
INSERT INTO `mod63_mtouchquiz_quiz` VALUES ('1', 'quiz', '', 'Félicitation - vous avez complété %%QUIZ_NAME%%.

Vous avez obtenu %%SCORE%% sur %%TOTAL%%.

Votre performance a été évaluée à %%RATING%%', '', '2018-10-19 18:13:06', '1', '1', '1', '0', '0', '1', '0', '2', '0'); 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_mtouchquiz_ratings` 
-- 

DROP TABLE IF EXISTS `mod63_mtouchquiz_ratings`; 
CREATE TABLE `mod63_mtouchquiz_ratings` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) unsigned NOT NULL,
  `score_rating` varchar(1024) CHARACTER SET utf8 NOT NULL,
  `min_points` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1; 

-- 
-- Dumping data for table `mod63_mtouchquiz_ratings` 
-- 

LOCK TABLES `mod63_mtouchquiz_ratings` WRITE; 
INSERT INTO `mod63_mtouchquiz_ratings` VALUES ('1', '1', 'Vous avez besoin de plus d\\'entraînement ! 
', '0'); 
INSERT INTO `mod63_mtouchquiz_ratings` VALUES ('2', '1', 'Persévérez ! 
', '40'); 
INSERT INTO `mod63_mtouchquiz_ratings` VALUES ('3', '1', 'Pas mal ! 
', '60'); 
INSERT INTO `mod63_mtouchquiz_ratings` VALUES ('4', '1', 'Bon travail ! 
', '80'); 
INSERT INTO `mod63_mtouchquiz_ratings` VALUES ('5', '1', 'Parfait ! 
', '100'); 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_options` 
-- 

DROP TABLE IF EXISTS `mod63_options`; 
CREATE TABLE `mod63_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=6108 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci; 

-- 
-- Dumping data for table `mod63_options` 
-- 

LOCK TABLES `mod63_options` WRITE; 
INSERT INTO `mod63_options` VALUES ('1', 'siteurl', 'http://eakmali.com', 'yes'); 
INSERT INTO `mod63_options` VALUES ('2', 'home', 'http://eakmali.com', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3', 'blogname', 'Eak Mali', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4', 'blogdescription', 'The Business Spirit', 'yes'); 
INSERT INTO `mod63_options` VALUES ('5', 'users_can_register', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('6', 'admin_email', 'eak2018ml@gmail.com', 'yes'); 
INSERT INTO `mod63_options` VALUES ('7', 'start_of_week', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('8', 'use_balanceTags', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('9', 'use_smilies', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('10', 'require_name_email', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('11', 'comments_notify', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('12', 'posts_per_rss', '10', 'yes'); 
INSERT INTO `mod63_options` VALUES ('13', 'rss_use_excerpt', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('14', 'mailserver_url', 'mail.example.com', 'yes'); 
INSERT INTO `mod63_options` VALUES ('15', 'mailserver_login', 'login@example.com', 'yes'); 
INSERT INTO `mod63_options` VALUES ('16', 'mailserver_pass', 'password', 'yes'); 
INSERT INTO `mod63_options` VALUES ('17', 'mailserver_port', '110', 'yes'); 
INSERT INTO `mod63_options` VALUES ('18', 'default_category', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('19', 'default_comment_status', 'open', 'yes'); 
INSERT INTO `mod63_options` VALUES ('20', 'default_ping_status', 'open', 'yes'); 
INSERT INTO `mod63_options` VALUES ('21', 'default_pingback_flag', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('22', 'posts_per_page', '10', 'yes'); 
INSERT INTO `mod63_options` VALUES ('23', 'date_format', 'j F Y', 'yes'); 
INSERT INTO `mod63_options` VALUES ('24', 'time_format', 'G \h i \m\i\n', 'yes'); 
INSERT INTO `mod63_options` VALUES ('25', 'links_updated_date_format', 'j F Y G \h i \m\i\n', 'yes'); 
INSERT INTO `mod63_options` VALUES ('26', 'comment_moderation', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('27', 'moderation_notify', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('28', 'permalink_structure', '/%postname%/', 'yes'); 
INSERT INTO `mod63_options` VALUES ('29', 'rewrite_rules', 'a:246:{s:14:"sitemap.xml.gz";s:60:"index.php?aiosp_sitemap_gzipped=1&aiosp_sitemap_path=root.gz";s:25:"sitemap_(.+)_(\d+).xml.gz";s:74:"index.php?aiosp_sitemap_path=$matches[1].gz&aiosp_sitemap_page=$matches[2]";s:19:"sitemap_(.+).xml.gz";s:43:"index.php?aiosp_sitemap_path=$matches[1].gz";s:11:"sitemap.xml";s:33:"index.php?aiosp_sitemap_path=root";s:22:"sitemap_(.+)_(\d+).xml";s:71:"index.php?aiosp_sitemap_path=$matches[1]&aiosp_sitemap_page=$matches[2]";s:16:"sitemap_(.+).xml";s:40:"index.php?aiosp_sitemap_path=$matches[1]";s:11:"sitemap.rss";s:32:"index.php?aiosp_sitemap_path=rss";s:17:"sitemaplatest.rss";s:39:"index.php?aiosp_sitemap_path=rss_latest";s:34:"sitemap(-+([a-zA-Z0-9_-]+))?\.xml$";s:40:"index.php?xml_sitemap=params=$matches[2]";s:38:"sitemap(-+([a-zA-Z0-9_-]+))?\.xml\.gz$";s:49:"index.php?xml_sitemap=params=$matches[2];zip=true";s:35:"sitemap(-+([a-zA-Z0-9_-]+))?\.html$";s:50:"index.php?xml_sitemap=params=$matches[2];html=true";s:38:"sitemap(-+([a-zA-Z0-9_-]+))?\.html.gz$";s:59:"index.php?xml_sitemap=params=$matches[2];html=true;zip=true";s:24:"^wc-auth/v([1]{1})/(.*)?";s:63:"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]";s:22:"^wc-api/v([1-3]{1})/?$";s:51:"index.php?wc-api-version=$matches[1]&wc-api-route=/";s:24:"^wc-api/v([1-3]{1})(.*)?";s:61:"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]";s:11:"boutique/?$";s:27:"index.php?post_type=product";s:41:"boutique/feed/(feed|rdf|rss|rss2|atom)/?$";s:44:"index.php?post_type=product&feed=$matches[1]";s:36:"boutique/(feed|rdf|rss|rss2|atom)/?$";s:44:"index.php?post_type=product&feed=$matches[1]";s:28:"boutique/page/([0-9]{1,})/?$";s:45:"index.php?post_type=product&paged=$matches[1]";s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:37:"portfolio/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:47:"portfolio/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:67:"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:62:"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:62:"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:43:"portfolio/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:26:"portfolio/([^/]+)/embed/?$";s:42:"index.php?portfolio=$matches[1]&embed=true";s:30:"portfolio/([^/]+)/trackback/?$";s:36:"index.php?portfolio=$matches[1]&tb=1";s:50:"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:48:"index.php?portfolio=$matches[1]&feed=$matches[2]";s:45:"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:48:"index.php?portfolio=$matches[1]&feed=$matches[2]";s:38:"portfolio/([^/]+)/page/?([0-9]{1,})/?$";s:49:"index.php?portfolio=$matches[1]&paged=$matches[2]";s:41:"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:52:"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:34:"portfolio/([^/]+)(?:/([0-9]+))?/?$";s:48:"index.php?portfolio=$matches[1]&page=$matches[2]";s:26:"portfolio/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:36:"portfolio/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:56:"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:51:"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:51:"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:32:"portfolio/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:32:"category/(.+?)/wc-api(/(.*))?/?$";s:54:"index.php?category_name=$matches[1]&wc-api=$matches[3]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:29:"tag/([^/]+)/wc-api(/(.*))?/?$";s:44:"index.php?tag=$matches[1]&wc-api=$matches[3]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:55:"portfolio-type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:53:"index.php?portfolio-type=$matches[1]&feed=$matches[2]";s:50:"portfolio-type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:53:"index.php?portfolio-type=$matches[1]&feed=$matches[2]";s:31:"portfolio-type/([^/]+)/embed/?$";s:47:"index.php?portfolio-type=$matches[1]&embed=true";s:43:"portfolio-type/([^/]+)/page/?([0-9]{1,})/?$";s:54:"index.php?portfolio-type=$matches[1]&paged=$matches[2]";s:25:"portfolio-type/([^/]+)/?$";s:36:"index.php?portfolio-type=$matches[1]";s:54:"portfolio-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?portfolio-tag=$matches[1]&feed=$matches[2]";s:49:"portfolio-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?portfolio-tag=$matches[1]&feed=$matches[2]";s:30:"portfolio-tag/([^/]+)/embed/?$";s:46:"index.php?portfolio-tag=$matches[1]&embed=true";s:42:"portfolio-tag/([^/]+)/page/?([0-9]{1,})/?$";s:53:"index.php?portfolio-tag=$matches[1]&paged=$matches[2]";s:24:"portfolio-tag/([^/]+)/?$";s:35:"index.php?portfolio-tag=$matches[1]";s:56:"categorie-produit/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?product_cat=$matches[1]&feed=$matches[2]";s:51:"categorie-produit/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?product_cat=$matches[1]&feed=$matches[2]";s:32:"categorie-produit/(.+?)/embed/?$";s:44:"index.php?product_cat=$matches[1]&embed=true";s:44:"categorie-produit/(.+?)/page/?([0-9]{1,})/?$";s:51:"index.php?product_cat=$matches[1]&paged=$matches[2]";s:26:"categorie-produit/(.+?)/?$";s:33:"index.php?product_cat=$matches[1]";s:58:"etiquette-produit/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?product_tag=$matches[1]&feed=$matches[2]";s:53:"etiquette-produit/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?product_tag=$matches[1]&feed=$matches[2]";s:34:"etiquette-produit/([^/]+)/embed/?$";s:44:"index.php?product_tag=$matches[1]&embed=true";s:46:"etiquette-produit/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?product_tag=$matches[1]&paged=$matches[2]";s:28:"etiquette-produit/([^/]+)/?$";s:33:"index.php?product_tag=$matches[1]";s:35:"produit/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:45:"produit/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:65:"produit/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:60:"produit/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:60:"produit/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:41:"produit/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:24:"produit/([^/]+)/embed/?$";s:40:"index.php?product=$matches[1]&embed=true";s:28:"produit/([^/]+)/trackback/?$";s:34:"index.php?product=$matches[1]&tb=1";s:48:"produit/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:46:"index.php?product=$matches[1]&feed=$matches[2]";s:43:"produit/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:46:"index.php?product=$matches[1]&feed=$matches[2]";s:36:"produit/([^/]+)/page/?([0-9]{1,})/?$";s:47:"index.php?product=$matches[1]&paged=$matches[2]";s:43:"produit/([^/]+)/comment-page-([0-9]{1,})/?$";s:47:"index.php?product=$matches[1]&cpage=$matches[2]";s:33:"produit/([^/]+)/wc-api(/(.*))?/?$";s:48:"index.php?product=$matches[1]&wc-api=$matches[3]";s:39:"produit/[^/]+/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:50:"produit/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:32:"produit/([^/]+)(?:/([0-9]+))?/?$";s:46:"index.php?product=$matches[1]&page=$matches[2]";s:24:"produit/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:34:"produit/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:54:"produit/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:49:"produit/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:49:"produit/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:30:"produit/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:58:"testimonial-group/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:56:"index.php?testimonial-group=$matches[1]&feed=$matches[2]";s:53:"testimonial-group/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:56:"index.php?testimonial-group=$matches[1]&feed=$matches[2]";s:34:"testimonial-group/([^/]+)/embed/?$";s:50:"index.php?testimonial-group=$matches[1]&embed=true";s:46:"testimonial-group/([^/]+)/page/?([0-9]{1,})/?$";s:57:"index.php?testimonial-group=$matches[1]&paged=$matches[2]";s:28:"testimonial-group/([^/]+)/?$";s:39:"index.php?testimonial-group=$matches[1]";s:39:"testimonial/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:49:"testimonial/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:69:"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:64:"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:64:"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:45:"testimonial/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:28:"testimonial/([^/]+)/embed/?$";s:44:"index.php?testimonial=$matches[1]&embed=true";s:32:"testimonial/([^/]+)/trackback/?$";s:38:"index.php?testimonial=$matches[1]&tb=1";s:40:"testimonial/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?testimonial=$matches[1]&paged=$matches[2]";s:47:"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$";s:51:"index.php?testimonial=$matches[1]&cpage=$matches[2]";s:37:"testimonial/([^/]+)/wc-api(/(.*))?/?$";s:52:"index.php?testimonial=$matches[1]&wc-api=$matches[3]";s:43:"testimonial/[^/]+/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:54:"testimonial/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:36:"testimonial/([^/]+)(?:/([0-9]+))?/?$";s:50:"index.php?testimonial=$matches[1]&page=$matches[2]";s:28:"testimonial/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:38:"testimonial/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:58:"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:53:"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:53:"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:34:"testimonial/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:52:"staff-group/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?staff-group=$matches[1]&feed=$matches[2]";s:47:"staff-group/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?staff-group=$matches[1]&feed=$matches[2]";s:28:"staff-group/([^/]+)/embed/?$";s:44:"index.php?staff-group=$matches[1]&embed=true";s:40:"staff-group/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?staff-group=$matches[1]&paged=$matches[2]";s:22:"staff-group/([^/]+)/?$";s:33:"index.php?staff-group=$matches[1]";s:33:"staff/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:43:"staff/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:63:"staff/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"staff/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"staff/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:39:"staff/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:22:"staff/([^/]+)/embed/?$";s:38:"index.php?staff=$matches[1]&embed=true";s:26:"staff/([^/]+)/trackback/?$";s:32:"index.php?staff=$matches[1]&tb=1";s:34:"staff/([^/]+)/page/?([0-9]{1,})/?$";s:45:"index.php?staff=$matches[1]&paged=$matches[2]";s:41:"staff/([^/]+)/comment-page-([0-9]{1,})/?$";s:45:"index.php?staff=$matches[1]&cpage=$matches[2]";s:31:"staff/([^/]+)/wc-api(/(.*))?/?$";s:46:"index.php?staff=$matches[1]&wc-api=$matches[3]";s:37:"staff/[^/]+/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:48:"staff/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:30:"staff/([^/]+)(?:/([0-9]+))?/?$";s:44:"index.php?staff=$matches[1]&page=$matches[2]";s:22:"staff/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:32:"staff/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:52:"staff/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:47:"staff/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:47:"staff/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:28:"staff/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:12:"robots\.txt$";s:18:"index.php?robots=1";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:17:"wc-api(/(.*))?/?$";s:29:"index.php?&wc-api=$matches[2]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:26:"comments/wc-api(/(.*))?/?$";s:29:"index.php?&wc-api=$matches[2]";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:29:"search/(.+)/wc-api(/(.*))?/?$";s:42:"index.php?s=$matches[1]&wc-api=$matches[3]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:32:"author/([^/]+)/wc-api(/(.*))?/?$";s:52:"index.php?author_name=$matches[1]&wc-api=$matches[3]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:54:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$";s:82:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:41:"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$";s:66:"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:28:"([0-9]{4})/wc-api(/(.*))?/?$";s:45:"index.php?year=$matches[1]&wc-api=$matches[3]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:25:"(.?.+?)/wc-api(/(.*))?/?$";s:49:"index.php?pagename=$matches[1]&wc-api=$matches[3]";s:28:"(.?.+?)/order-pay(/(.*))?/?$";s:52:"index.php?pagename=$matches[1]&order-pay=$matches[3]";s:33:"(.?.+?)/order-received(/(.*))?/?$";s:57:"index.php?pagename=$matches[1]&order-received=$matches[3]";s:25:"(.?.+?)/orders(/(.*))?/?$";s:49:"index.php?pagename=$matches[1]&orders=$matches[3]";s:29:"(.?.+?)/view-order(/(.*))?/?$";s:53:"index.php?pagename=$matches[1]&view-order=$matches[3]";s:28:"(.?.+?)/downloads(/(.*))?/?$";s:52:"index.php?pagename=$matches[1]&downloads=$matches[3]";s:31:"(.?.+?)/edit-account(/(.*))?/?$";s:55:"index.php?pagename=$matches[1]&edit-account=$matches[3]";s:31:"(.?.+?)/edit-address(/(.*))?/?$";s:55:"index.php?pagename=$matches[1]&edit-address=$matches[3]";s:34:"(.?.+?)/payment-methods(/(.*))?/?$";s:58:"index.php?pagename=$matches[1]&payment-methods=$matches[3]";s:32:"(.?.+?)/lost-password(/(.*))?/?$";s:56:"index.php?pagename=$matches[1]&lost-password=$matches[3]";s:34:"(.?.+?)/customer-logout(/(.*))?/?$";s:58:"index.php?pagename=$matches[1]&customer-logout=$matches[3]";s:37:"(.?.+?)/add-payment-method(/(.*))?/?$";s:61:"index.php?pagename=$matches[1]&add-payment-method=$matches[3]";s:40:"(.?.+?)/delete-payment-method(/(.*))?/?$";s:64:"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]";s:45:"(.?.+?)/set-default-payment-method(/(.*))?/?$";s:69:"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]";s:31:".?.+?/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:42:".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:27:"[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:"[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"([^/]+)/embed/?$";s:37:"index.php?name=$matches[1]&embed=true";s:20:"([^/]+)/trackback/?$";s:31:"index.php?name=$matches[1]&tb=1";s:40:"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:35:"([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:28:"([^/]+)/page/?([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&paged=$matches[2]";s:35:"([^/]+)/comment-page-([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&cpage=$matches[2]";s:25:"([^/]+)/wc-api(/(.*))?/?$";s:45:"index.php?name=$matches[1]&wc-api=$matches[3]";s:31:"[^/]+/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:42:"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$";s:51:"index.php?attachment=$matches[1]&wc-api=$matches[3]";s:24:"([^/]+)(?:/([0-9]+))?/?$";s:43:"index.php?name=$matches[1]&page=$matches[2]";s:16:"[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:26:"[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:46:"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:22:"[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('30', 'hack_file', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('31', 'blog_charset', 'UTF-8', 'yes'); 
INSERT INTO `mod63_options` VALUES ('32', 'moderation_keys', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('33', 'active_plugins', 'a:20:{i:0;s:19:"akismet/akismet.php";i:1;s:43:"all-in-one-seo-pack/all_in_one_seo_pack.php";i:2;s:35:"backup-database/backup-database.php";i:3;s:53:"cc-bcc-for-woocommerce-order-emails/dc-cc-bcc-woe.php";i:4;s:35:"fourteen-colors/fourteen-colors.php";i:5;s:29:"gmap-embed/srm_gmap_embed.php";i:6;s:36:"google-sitemap-generator/sitemap.php";i:7;s:25:"gtranslate/gtranslate.php";i:8;s:95:"ic-hide-add-to-cart-and-prices-in-woocommerce/IC-Hide-add-to-cart-and-prices-in-WooCommerce.php";i:9;s:45:"kadence-custom-fonts/kadence-custom-fonts.php";i:10;s:39:"kadence-recaptcha/kadence-recaptcha.php";i:11;s:33:"kadence-slider/kadence-slider.php";i:12;s:23:"ml-slider/ml-slider.php";i:13;s:49:"simple-file-downloader/simple-file-downloader.php";i:14;s:39:"simple-pdf-viewer/simple-pdf-viewer.php";i:15;s:39:"siteorigin-panels/siteorigin-panels.php";i:16;s:39:"so-widgets-bundle/so-widgets-bundle.php";i:17;s:27:"woocommerce/woocommerce.php";i:18;s:41:"wordpress-importer/wordpress-importer.php";i:19;s:21:"wp-reset/wp-reset.php";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('34', 'category_base', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('35', 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'); 
INSERT INTO `mod63_options` VALUES ('36', 'comment_max_links', '2', 'yes'); 
INSERT INTO `mod63_options` VALUES ('37', 'gmt_offset', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('38', 'default_email_category', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('39', 'recently_edited', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('40', 'template', 'virtue_premium', 'yes'); 
INSERT INTO `mod63_options` VALUES ('41', 'stylesheet', 'virtue_premium', 'yes'); 
INSERT INTO `mod63_options` VALUES ('42', 'comment_whitelist', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('43', 'blacklist_keys', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('44', 'comment_registration', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('45', 'html_type', 'text/html', 'yes'); 
INSERT INTO `mod63_options` VALUES ('46', 'use_trackback', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('47', 'default_role', 'subscriber', 'yes'); 
INSERT INTO `mod63_options` VALUES ('48', 'db_version', '38590', 'yes'); 
INSERT INTO `mod63_options` VALUES ('49', 'uploads_use_yearmonth_folders', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('50', 'upload_path', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('51', 'blog_public', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('52', 'default_link_category', '2', 'yes'); 
INSERT INTO `mod63_options` VALUES ('53', 'show_on_front', 'posts', 'yes'); 
INSERT INTO `mod63_options` VALUES ('54', 'tag_base', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('55', 'show_avatars', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('56', 'avatar_rating', 'G', 'yes'); 
INSERT INTO `mod63_options` VALUES ('57', 'upload_url_path', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('58', 'thumbnail_size_w', '150', 'yes'); 
INSERT INTO `mod63_options` VALUES ('59', 'thumbnail_size_h', '150', 'yes'); 
INSERT INTO `mod63_options` VALUES ('60', 'thumbnail_crop', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('61', 'medium_size_w', '300', 'yes'); 
INSERT INTO `mod63_options` VALUES ('62', 'medium_size_h', '300', 'yes'); 
INSERT INTO `mod63_options` VALUES ('63', 'avatar_default', 'mystery', 'yes'); 
INSERT INTO `mod63_options` VALUES ('64', 'large_size_w', '1024', 'yes'); 
INSERT INTO `mod63_options` VALUES ('65', 'large_size_h', '1024', 'yes'); 
INSERT INTO `mod63_options` VALUES ('66', 'image_default_link_type', 'none', 'yes'); 
INSERT INTO `mod63_options` VALUES ('67', 'image_default_size', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('68', 'image_default_align', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('69', 'close_comments_for_old_posts', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('70', 'close_comments_days_old', '14', 'yes'); 
INSERT INTO `mod63_options` VALUES ('71', 'thread_comments', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('72', 'thread_comments_depth', '5', 'yes'); 
INSERT INTO `mod63_options` VALUES ('73', 'page_comments', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('74', 'comments_per_page', '50', 'yes'); 
INSERT INTO `mod63_options` VALUES ('75', 'default_comments_page', 'newest', 'yes'); 
INSERT INTO `mod63_options` VALUES ('76', 'comment_order', 'asc', 'yes'); 
INSERT INTO `mod63_options` VALUES ('77', 'sticky_posts', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('78', 'widget_categories', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('79', 'widget_text', 'a:4:{i:1;a:0:{}i:2;a:4:{s:5:"title";s:21:"Pour tout information";s:4:"text";s:178:"S/C : Immeuble Cissé / Sotuba ACI

BAMAKO / MALI

Tel: +223 20719063

Portable: +223 66974286

Email : sales@eakmali.com

eakbusiness@hotmail.fr

Moribabougou / Kati";s:6:"filter";b:1;s:6:"visual";b:1;}i:4;a:4:{s:5:"title";s:7:"Contact";s:4:"text";s:214:"S/C: Immeuble Cissé / Sotuba ACI

BAMAKO-MALI - Rue: 310 - Porte: 1207

BP: 2488

Tel : (+223) 20719063 / 66974286

Email: sales@eakmali.com

eakbusiness@hotmail.fr

site web: www.eakmali.com

&nbsp;";s:6:"filter";b:1;s:6:"visual";b:1;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('80', 'widget_rss', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('81', 'uninstall_plugins', 'a:2:{s:21:"wp-reset/wp-reset.php";a:2:{i:0;s:8:"WP_Reset";i:1;s:9:"uninstall";}s:57:"multisite-language-switcher/MultisiteLanguageSwitcher.php";a:2:{i:0;s:10:"MslsPlugin";i:1;s:9:"uninstall";}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('82', 'timezone_string', 'Africa/Bamako', 'yes'); 
INSERT INTO `mod63_options` VALUES ('83', 'page_for_posts', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('84', 'page_on_front', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('85', 'default_post_format', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('86', 'link_manager_enabled', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('87', 'finished_splitting_shared_terms', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('88', 'site_icon', '916', 'yes'); 
INSERT INTO `mod63_options` VALUES ('89', 'medium_large_size_w', '768', 'yes'); 
INSERT INTO `mod63_options` VALUES ('90', 'medium_large_size_h', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('91', 'wp_page_for_privacy_policy', '3', 'yes'); 
INSERT INTO `mod63_options` VALUES ('92', 'show_comments_cookies_opt_in', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('93', 'initial_db_version', '38590', 'yes'); 
INSERT INTO `mod63_options` VALUES ('94', 'mod63_user_roles', 'a:7:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:115:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:18:"manage_woocommerce";b:1;s:24:"view_woocommerce_reports";b:1;s:12:"edit_product";b:1;s:12:"read_product";b:1;s:14:"delete_product";b:1;s:13:"edit_products";b:1;s:20:"edit_others_products";b:1;s:16:"publish_products";b:1;s:21:"read_private_products";b:1;s:15:"delete_products";b:1;s:23:"delete_private_products";b:1;s:25:"delete_published_products";b:1;s:22:"delete_others_products";b:1;s:21:"edit_private_products";b:1;s:23:"edit_published_products";b:1;s:20:"manage_product_terms";b:1;s:18:"edit_product_terms";b:1;s:20:"delete_product_terms";b:1;s:20:"assign_product_terms";b:1;s:15:"edit_shop_order";b:1;s:15:"read_shop_order";b:1;s:17:"delete_shop_order";b:1;s:16:"edit_shop_orders";b:1;s:23:"edit_others_shop_orders";b:1;s:19:"publish_shop_orders";b:1;s:24:"read_private_shop_orders";b:1;s:18:"delete_shop_orders";b:1;s:26:"delete_private_shop_orders";b:1;s:28:"delete_published_shop_orders";b:1;s:25:"delete_others_shop_orders";b:1;s:24:"edit_private_shop_orders";b:1;s:26:"edit_published_shop_orders";b:1;s:23:"manage_shop_order_terms";b:1;s:21:"edit_shop_order_terms";b:1;s:23:"delete_shop_order_terms";b:1;s:23:"assign_shop_order_terms";b:1;s:16:"edit_shop_coupon";b:1;s:16:"read_shop_coupon";b:1;s:18:"delete_shop_coupon";b:1;s:17:"edit_shop_coupons";b:1;s:24:"edit_others_shop_coupons";b:1;s:20:"publish_shop_coupons";b:1;s:25:"read_private_shop_coupons";b:1;s:19:"delete_shop_coupons";b:1;s:27:"delete_private_shop_coupons";b:1;s:29:"delete_published_shop_coupons";b:1;s:26:"delete_others_shop_coupons";b:1;s:25:"edit_private_shop_coupons";b:1;s:27:"edit_published_shop_coupons";b:1;s:24:"manage_shop_coupon_terms";b:1;s:22:"edit_shop_coupon_terms";b:1;s:24:"delete_shop_coupon_terms";b:1;s:24:"assign_shop_coupon_terms";b:1;s:16:"aiosp_manage_seo";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:34:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}s:8:"customer";a:2:{s:4:"name";s:8:"Customer";s:12:"capabilities";a:1:{s:4:"read";b:1;}}s:12:"shop_manager";a:2:{s:4:"name";s:12:"Shop manager";s:12:"capabilities";a:92:{s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:4:"read";b:1;s:18:"read_private_pages";b:1;s:18:"read_private_posts";b:1;s:10:"edit_users";b:1;s:10:"edit_posts";b:1;s:10:"edit_pages";b:1;s:20:"edit_published_posts";b:1;s:20:"edit_published_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"edit_private_posts";b:1;s:17:"edit_others_posts";b:1;s:17:"edit_others_pages";b:1;s:13:"publish_posts";b:1;s:13:"publish_pages";b:1;s:12:"delete_posts";b:1;s:12:"delete_pages";b:1;s:20:"delete_private_pages";b:1;s:20:"delete_private_posts";b:1;s:22:"delete_published_pages";b:1;s:22:"delete_published_posts";b:1;s:19:"delete_others_posts";b:1;s:19:"delete_others_pages";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:17:"moderate_comments";b:1;s:12:"upload_files";b:1;s:6:"export";b:1;s:6:"import";b:1;s:10:"list_users";b:1;s:18:"manage_woocommerce";b:1;s:24:"view_woocommerce_reports";b:1;s:12:"edit_product";b:1;s:12:"read_product";b:1;s:14:"delete_product";b:1;s:13:"edit_products";b:1;s:20:"edit_others_products";b:1;s:16:"publish_products";b:1;s:21:"read_private_products";b:1;s:15:"delete_products";b:1;s:23:"delete_private_products";b:1;s:25:"delete_published_products";b:1;s:22:"delete_others_products";b:1;s:21:"edit_private_products";b:1;s:23:"edit_published_products";b:1;s:20:"manage_product_terms";b:1;s:18:"edit_product_terms";b:1;s:20:"delete_product_terms";b:1;s:20:"assign_product_terms";b:1;s:15:"edit_shop_order";b:1;s:15:"read_shop_order";b:1;s:17:"delete_shop_order";b:1;s:16:"edit_shop_orders";b:1;s:23:"edit_others_shop_orders";b:1;s:19:"publish_shop_orders";b:1;s:24:"read_private_shop_orders";b:1;s:18:"delete_shop_orders";b:1;s:26:"delete_private_shop_orders";b:1;s:28:"delete_published_shop_orders";b:1;s:25:"delete_others_shop_orders";b:1;s:24:"edit_private_shop_orders";b:1;s:26:"edit_published_shop_orders";b:1;s:23:"manage_shop_order_terms";b:1;s:21:"edit_shop_order_terms";b:1;s:23:"delete_shop_order_terms";b:1;s:23:"assign_shop_order_terms";b:1;s:16:"edit_shop_coupon";b:1;s:16:"read_shop_coupon";b:1;s:18:"delete_shop_coupon";b:1;s:17:"edit_shop_coupons";b:1;s:24:"edit_others_shop_coupons";b:1;s:20:"publish_shop_coupons";b:1;s:25:"read_private_shop_coupons";b:1;s:19:"delete_shop_coupons";b:1;s:27:"delete_private_shop_coupons";b:1;s:29:"delete_published_shop_coupons";b:1;s:26:"delete_others_shop_coupons";b:1;s:25:"edit_private_shop_coupons";b:1;s:27:"edit_published_shop_coupons";b:1;s:24:"manage_shop_coupon_terms";b:1;s:22:"edit_shop_coupon_terms";b:1;s:24:"delete_shop_coupon_terms";b:1;s:24:"assign_shop_coupon_terms";b:1;}}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('95', 'fresh_site', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('96', 'WPLANG', 'fr_FR', 'yes'); 
INSERT INTO `mod63_options` VALUES ('97', 'widget_search', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('98', 'widget_recent-posts', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('99', 'widget_recent-comments', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('100', 'widget_archives', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('101', 'widget_meta', 'a:2:{i:2;a:1:{s:5:"title";s:7:"Sign in";}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('102', 'sidebars_widgets', 'a:9:{s:8:"footer_1";a:1:{i:0;s:6:"text-4";}s:19:"wp_inactive_widgets";a:2:{i:0;s:10:"nav_menu-4";i:1;s:25:"virtue_about_with_image-3";}s:15:"sidebar-primary";a:2:{i:0;s:28:"woocommerce_product_search-2";i:1;s:32:"woocommerce_product_categories-3";}s:8:"sidebar1";a:3:{i:0;s:28:"woocommerce_product_search-3";i:1;s:32:"woocommerce_product_categories-6";i:2;s:6:"meta-2";}s:10:"homewidget";a:2:{i:0;s:13:"media_image-2";i:1;s:24:"virtue_carousel_widget-2";}s:14:"footer_third_1";a:0:{}s:14:"footer_third_2";a:1:{i:0;s:6:"text-2";}s:14:"footer_third_3";a:1:{i:0;s:13:"media_image-3";}s:13:"array_version";i:3;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('103', 'woocommerce_permalinks', 'a:5:{s:12:"product_base";s:8:"/produit";s:13:"category_base";s:17:"categorie-produit";s:8:"tag_base";s:17:"etiquette-produit";s:14:"attribute_base";s:0:"";s:22:"use_verbose_page_rules";b:0;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('104', 'widget_pages', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('105', 'widget_calendar', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('106', 'widget_media_audio', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('107', 'widget_media_image', 'a:3:{i:2;a:15:{s:13:"attachment_id";i:1029;s:3:"url";s:63:"http://eakmali.com/wp-content/uploads/2018/10/PARTEN-300x55.jpg";s:5:"title";s:15:"Nos Partenaires";s:4:"size";s:6:"medium";s:5:"width";i:416;s:6:"height";i:76;s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:9:"link_type";s:6:"custom";s:8:"link_url";s:0:"";s:13:"image_classes";s:0:"";s:12:"link_classes";s:0:"";s:8:"link_rel";s:0:"";s:17:"link_target_blank";b:0;s:11:"image_title";s:0:"";}i:3;a:15:{s:13:"attachment_id";i:1029;s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/PARTEN.jpg";s:5:"title";s:7:"Partner";s:4:"size";s:4:"full";s:5:"width";i:416;s:6:"height";i:76;s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:9:"link_type";s:6:"custom";s:8:"link_url";s:0:"";s:13:"image_classes";s:0:"";s:12:"link_classes";s:0:"";s:8:"link_rel";s:0:"";s:17:"link_target_blank";b:0;s:11:"image_title";s:0:"";}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('108', 'widget_media_gallery', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('109', 'widget_media_video', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('110', 'widget_tag_cloud', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('111', 'widget_nav_menu', 'a:2:{i:4;a:1:{s:8:"nav_menu";i:18;}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('112', 'widget_custom_html', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('113', 'cron', 'a:20:{i:1541021474;a:1:{s:26:"action_scheduler_run_queue";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:12:"every_minute";s:4:"args";a:0:{}s:8:"interval";i:60;}}}i:1541022253;a:1:{s:41:"check_plugin_updates-kadence-custom-fonts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1541022597;a:1:{s:35:"check_plugin_updates-kadence-slider";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1541022988;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1541023313;a:1:{s:38:"check_plugin_updates-kadence-recaptcha";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1541024112;a:1:{s:32:"woocommerce_cancel_unpaid_orders";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:2:{s:8:"schedule";b:0;s:4:"args";a:0:{}}}}i:1541024244;a:1:{s:29:"akismet_schedule_cron_recheck";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:2:{s:8:"schedule";b:0;s:4:"args";a:0:{}}}}i:1541027945;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1541030400;a:1:{s:27:"woocommerce_scheduled_sales";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1541031312;a:1:{s:24:"woocommerce_cleanup_logs";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1541037388;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1541042112;a:1:{s:28:"woocommerce_cleanup_sessions";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1541080614;a:2:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1541082092;a:1:{s:13:"sm_ping_daily";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1541104798;a:1:{s:24:"akismet_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1541106912;a:1:{s:33:"woocommerce_cleanup_personal_data";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1541106922;a:1:{s:30:"woocommerce_tracker_send_event";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1541107020;a:1:{s:31:"aiosp_sitemap_daily_update_cron";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1541462400;a:1:{s:25:"woocommerce_geoip_updater";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:7:"monthly";s:4:"args";a:0:{}s:8:"interval";i:2635200;}}}s:7:"version";i:2;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('114', 'theme_mods_twentyseventeen', 'a:3:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1538699284;s:4:"data";a:4:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}s:9:"sidebar-2";a:0:{}s:9:"sidebar-3";a:0:{}}}s:18:"nav_menu_locations";a:0:{}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('117', 'wp-reset', 'a:4:{s:4:"meta";a:3:{s:13:"first_version";s:4:"1.35";s:13:"first_install";i:1538661284;s:11:"reset_count";i:1;}s:17:"dismissed_notices";a:1:{s:7:"welcome";b:1;}s:8:"last_run";a:0:{}s:7:"options";a:0:{}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('118', 'woocommerce_meta_box_errors', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('119', 'woocommerce_admin_notices', 'a:3:{i:0;s:6:"update";i:1;s:20:"no_secure_connection";i:2;s:14:"template_files";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('133', 'can_compress_scripts', '0', 'no'); 
INSERT INTO `mod63_options` VALUES ('145', 'recently_activated', 'a:1:{s:33:"virtue-toolkit/virtue_toolkit.php";i:1541020689;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('147', 'current_theme', 'Virtue - Premium', 'yes'); 
INSERT INTO `mod63_options` VALUES ('148', 'theme_mods_virtue', 'a:5:{i:0;b:0;s:18:"nav_menu_locations";a:0:{}s:18:"custom_css_post_id";i:-1;s:6:"virtue";a:1:{s:11:"footer_text";s:54:"[copyright] [the-year] [site-name] [Beyond Technology]";}s:16:"sidebars_widgets";a:2:{s:4:"time";i:1538698281;s:4:"data";a:6:{s:19:"wp_inactive_widgets";a:0:{}s:15:"sidebar-primary";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}s:8:"sidebar1";a:0:{}s:14:"footer_third_1";a:0:{}s:14:"footer_third_2";a:0:{}s:14:"footer_third_3";a:0:{}}}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('149', 'theme_switched', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('150', 'widget_widget_kadence_contact', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('151', 'widget_widget_kadence_social', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('152', 'widget_kadence_recent_posts', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('153', 'widget_kadence_image_grid', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('154', 'widget_virtue_about_with_image', 'a:2:{i:3;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('157', 'woocommerce_store_address', 'Sotuba', 'yes'); 
INSERT INTO `mod63_options` VALUES ('158', 'woocommerce_store_address_2', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('159', 'woocommerce_store_city', 'Bamako', 'yes'); 
INSERT INTO `mod63_options` VALUES ('160', 'woocommerce_default_country', 'ML', 'yes'); 
INSERT INTO `mod63_options` VALUES ('161', 'woocommerce_store_postcode', '2488', 'yes'); 
INSERT INTO `mod63_options` VALUES ('162', 'woocommerce_allowed_countries', 'all', 'yes'); 
INSERT INTO `mod63_options` VALUES ('163', 'woocommerce_all_except_countries', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('164', 'woocommerce_specific_allowed_countries', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('165', 'woocommerce_ship_to_countries', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('166', 'woocommerce_specific_ship_to_countries', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('167', 'woocommerce_default_customer_address', 'geolocation', 'yes'); 
INSERT INTO `mod63_options` VALUES ('168', 'woocommerce_calc_taxes', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('169', 'woocommerce_enable_coupons', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('170', 'woocommerce_calc_discounts_sequentially', 'no', 'no'); 
INSERT INTO `mod63_options` VALUES ('171', 'woocommerce_currency', 'XOF', 'yes'); 
INSERT INTO `mod63_options` VALUES ('172', 'woocommerce_currency_pos', 'left', 'yes'); 
INSERT INTO `mod63_options` VALUES ('173', 'woocommerce_price_thousand_sep', '.', 'yes'); 
INSERT INTO `mod63_options` VALUES ('174', 'woocommerce_price_decimal_sep', ',', 'yes'); 
INSERT INTO `mod63_options` VALUES ('175', 'woocommerce_price_num_decimals', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('176', 'woocommerce_shop_page_id', '5', 'yes'); 
INSERT INTO `mod63_options` VALUES ('177', 'woocommerce_cart_redirect_after_add', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('178', 'woocommerce_enable_ajax_add_to_cart', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('179', 'woocommerce_weight_unit', 'kg', 'yes'); 
INSERT INTO `mod63_options` VALUES ('180', 'woocommerce_dimension_unit', 'cm', 'yes'); 
INSERT INTO `mod63_options` VALUES ('181', 'woocommerce_enable_reviews', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('182', 'woocommerce_review_rating_verification_label', 'yes', 'no'); 
INSERT INTO `mod63_options` VALUES ('183', 'woocommerce_review_rating_verification_required', 'no', 'no'); 
INSERT INTO `mod63_options` VALUES ('184', 'woocommerce_enable_review_rating', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('185', 'woocommerce_review_rating_required', 'yes', 'no'); 
INSERT INTO `mod63_options` VALUES ('186', 'woocommerce_manage_stock', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('187', 'woocommerce_hold_stock_minutes', '60', 'no'); 
INSERT INTO `mod63_options` VALUES ('188', 'woocommerce_notify_low_stock', 'yes', 'no'); 
INSERT INTO `mod63_options` VALUES ('189', 'woocommerce_notify_no_stock', 'yes', 'no'); 
INSERT INTO `mod63_options` VALUES ('190', 'woocommerce_stock_email_recipient', 'beyondtech96@gmail.com', 'no'); 
INSERT INTO `mod63_options` VALUES ('191', 'woocommerce_notify_low_stock_amount', '2', 'no'); 
INSERT INTO `mod63_options` VALUES ('192', 'woocommerce_notify_no_stock_amount', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('193', 'woocommerce_hide_out_of_stock_items', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('194', 'woocommerce_stock_format', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('195', 'woocommerce_file_download_method', 'force', 'no'); 
INSERT INTO `mod63_options` VALUES ('196', 'woocommerce_downloads_require_login', 'no', 'no'); 
INSERT INTO `mod63_options` VALUES ('197', 'woocommerce_downloads_grant_access_after_payment', 'yes', 'no'); 
INSERT INTO `mod63_options` VALUES ('198', 'woocommerce_prices_include_tax', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('199', 'woocommerce_tax_based_on', 'shipping', 'yes'); 
INSERT INTO `mod63_options` VALUES ('200', 'woocommerce_shipping_tax_class', 'inherit', 'yes'); 
INSERT INTO `mod63_options` VALUES ('201', 'woocommerce_tax_round_at_subtotal', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('202', 'woocommerce_tax_classes', 'Taux réduit
Taux Zéro', 'yes'); 
INSERT INTO `mod63_options` VALUES ('203', 'woocommerce_tax_display_shop', 'excl', 'yes'); 
INSERT INTO `mod63_options` VALUES ('204', 'woocommerce_tax_display_cart', 'excl', 'yes'); 
INSERT INTO `mod63_options` VALUES ('205', 'woocommerce_price_display_suffix', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('206', 'woocommerce_tax_total_display', 'itemized', 'no'); 
INSERT INTO `mod63_options` VALUES ('207', 'woocommerce_enable_shipping_calc', 'yes', 'no'); 
INSERT INTO `mod63_options` VALUES ('208', 'woocommerce_shipping_cost_requires_address', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('209', 'woocommerce_ship_to_destination', 'billing', 'no'); 
INSERT INTO `mod63_options` VALUES ('210', 'woocommerce_shipping_debug_mode', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('211', 'woocommerce_enable_guest_checkout', 'yes', 'no'); 
INSERT INTO `mod63_options` VALUES ('212', 'woocommerce_enable_checkout_login_reminder', 'no', 'no'); 
INSERT INTO `mod63_options` VALUES ('213', 'woocommerce_enable_signup_and_login_from_checkout', 'no', 'no'); 
INSERT INTO `mod63_options` VALUES ('214', 'woocommerce_enable_myaccount_registration', 'no', 'no'); 
INSERT INTO `mod63_options` VALUES ('215', 'woocommerce_registration_generate_username', 'yes', 'no'); 
INSERT INTO `mod63_options` VALUES ('216', 'woocommerce_registration_generate_password', 'yes', 'no'); 
INSERT INTO `mod63_options` VALUES ('217', 'woocommerce_erasure_request_removes_order_data', 'no', 'no'); 
INSERT INTO `mod63_options` VALUES ('218', 'woocommerce_erasure_request_removes_download_data', 'no', 'no'); 
INSERT INTO `mod63_options` VALUES ('219', 'woocommerce_registration_privacy_policy_text', 'Vos données personnelles seront utilisées pour vous accompagner au cours de votre visite du site web, gérer l’accès à votre compte, et pour d’autres raisons décrites dans notre [privacy_policy].', 'yes'); 
INSERT INTO `mod63_options` VALUES ('220', 'woocommerce_checkout_privacy_policy_text', 'Vos données personnelles seront utilisées pour le traitement de votre commande, vous accompagner au cours de votre visite du site web, et pour d’autres raisons décrites dans notre [privacy_policy].', 'yes'); 
INSERT INTO `mod63_options` VALUES ('221', 'woocommerce_delete_inactive_accounts', 'a:2:{s:6:"number";s:0:"";s:4:"unit";s:6:"months";}', 'no'); 
INSERT INTO `mod63_options` VALUES ('222', 'woocommerce_trash_pending_orders', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('223', 'woocommerce_trash_failed_orders', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('224', 'woocommerce_trash_cancelled_orders', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('225', 'woocommerce_anonymize_completed_orders', 'a:2:{s:6:"number";s:0:"";s:4:"unit";s:6:"months";}', 'no'); 
INSERT INTO `mod63_options` VALUES ('226', 'woocommerce_email_from_name', 'Eak', 'no'); 
INSERT INTO `mod63_options` VALUES ('227', 'woocommerce_email_from_address', 'sales@eakmali.com', 'no'); 
INSERT INTO `mod63_options` VALUES ('228', 'woocommerce_email_header_image', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('229', 'woocommerce_email_footer_text', '{site_title}', 'no'); 
INSERT INTO `mod63_options` VALUES ('230', 'woocommerce_email_base_color', '#96588a', 'no'); 
INSERT INTO `mod63_options` VALUES ('231', 'woocommerce_email_background_color', '#f7f7f7', 'no'); 
INSERT INTO `mod63_options` VALUES ('232', 'woocommerce_email_body_background_color', '#ffffff', 'no'); 
INSERT INTO `mod63_options` VALUES ('233', 'woocommerce_email_text_color', '#3c3c3c', 'no'); 
INSERT INTO `mod63_options` VALUES ('234', 'woocommerce_cart_page_id', '6', 'yes'); 
INSERT INTO `mod63_options` VALUES ('235', 'woocommerce_checkout_page_id', '7', 'yes'); 
INSERT INTO `mod63_options` VALUES ('236', 'woocommerce_myaccount_page_id', '8', 'yes'); 
INSERT INTO `mod63_options` VALUES ('237', 'woocommerce_terms_page_id', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('238', 'woocommerce_force_ssl_checkout', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('239', 'woocommerce_unforce_ssl_checkout', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('240', 'woocommerce_checkout_pay_endpoint', 'order-pay', 'yes'); 
INSERT INTO `mod63_options` VALUES ('241', 'woocommerce_checkout_order_received_endpoint', 'order-received', 'yes'); 
INSERT INTO `mod63_options` VALUES ('242', 'woocommerce_myaccount_add_payment_method_endpoint', 'add-payment-method', 'yes'); 
INSERT INTO `mod63_options` VALUES ('243', 'woocommerce_myaccount_delete_payment_method_endpoint', 'delete-payment-method', 'yes'); 
INSERT INTO `mod63_options` VALUES ('244', 'woocommerce_myaccount_set_default_payment_method_endpoint', 'set-default-payment-method', 'yes'); 
INSERT INTO `mod63_options` VALUES ('245', 'woocommerce_myaccount_orders_endpoint', 'orders', 'yes'); 
INSERT INTO `mod63_options` VALUES ('246', 'woocommerce_myaccount_view_order_endpoint', 'view-order', 'yes'); 
INSERT INTO `mod63_options` VALUES ('247', 'woocommerce_myaccount_downloads_endpoint', 'downloads', 'yes'); 
INSERT INTO `mod63_options` VALUES ('248', 'woocommerce_myaccount_edit_account_endpoint', 'edit-account', 'yes'); 
INSERT INTO `mod63_options` VALUES ('249', 'woocommerce_myaccount_edit_address_endpoint', 'edit-address', 'yes'); 
INSERT INTO `mod63_options` VALUES ('250', 'woocommerce_myaccount_payment_methods_endpoint', 'payment-methods', 'yes'); 
INSERT INTO `mod63_options` VALUES ('251', 'woocommerce_myaccount_lost_password_endpoint', 'lost-password', 'yes'); 
INSERT INTO `mod63_options` VALUES ('252', 'woocommerce_logout_endpoint', 'customer-logout', 'yes'); 
INSERT INTO `mod63_options` VALUES ('253', 'woocommerce_api_enabled', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('254', 'woocommerce_single_image_width', '600', 'yes'); 
INSERT INTO `mod63_options` VALUES ('255', 'woocommerce_thumbnail_image_width', '300', 'yes'); 
INSERT INTO `mod63_options` VALUES ('256', 'woocommerce_checkout_highlight_required_fields', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('257', 'woocommerce_demo_store', 'no', 'no'); 
INSERT INTO `mod63_options` VALUES ('258', 'current_theme_supports_woocommerce', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('259', 'woocommerce_queue_flush_rewrite_rules', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('262', 'default_product_cat', '15', 'yes'); 
INSERT INTO `mod63_options` VALUES ('267', '_transient_woocommerce_webhook_ids', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('268', 'widget_woocommerce_widget_cart', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('269', 'widget_woocommerce_layered_nav_filters', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('270', 'widget_woocommerce_layered_nav', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('271', 'widget_woocommerce_price_filter', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('272', 'widget_woocommerce_product_categories', 'a:3:{i:3;a:8:{s:5:"title";s:18:"Product categories";s:7:"orderby";s:4:"name";s:8:"dropdown";i:0;s:5:"count";i:0;s:12:"hierarchical";i:1;s:18:"show_children_only";i:1;s:10:"hide_empty";i:0;s:9:"max_depth";s:0:"";}i:6;a:8:{s:5:"title";s:18:"Product Categories";s:7:"orderby";s:4:"name";s:8:"dropdown";i:0;s:5:"count";i:0;s:12:"hierarchical";i:0;s:18:"show_children_only";i:1;s:10:"hide_empty";i:0;s:9:"max_depth";s:0:"";}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('273', 'widget_woocommerce_product_search', 'a:3:{i:2;a:1:{s:5:"title";s:17:"Find your product";}i:3;a:1:{s:5:"title";s:17:"Find your Product";}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('274', 'widget_woocommerce_product_tag_cloud', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('275', 'widget_woocommerce_products', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('276', 'widget_woocommerce_recently_viewed_products', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('277', 'widget_woocommerce_top_rated_products', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('278', 'widget_woocommerce_recent_reviews', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('279', 'widget_woocommerce_rating_filter', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('286', 'kadence_toolkit_flushpermalinks', '2', 'yes'); 
INSERT INTO `mod63_options` VALUES ('287', 'virtue', 'a:149:{s:8:"last_tab";s:0:"";s:12:"boxed_layout";s:5:"boxed";s:13:"footer_layout";s:6:"threec";s:11:"logo_layout";s:8:"logoleft";s:21:"x1_virtue_logo_upload";a:5:{s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/logo-1.jpg";s:2:"id";s:1:"9";s:6:"height";s:3:"279";s:5:"width";s:3:"562";s:9:"thumbnail";s:64:"http://eakmali.com/wp-content/uploads/2018/10/logo-1-150x150.jpg";}s:21:"x2_virtue_logo_upload";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:15:"font_logo_style";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"32px";s:11:"line-height";s:4:"40px";s:5:"color";s:0:"";}s:15:"logo_below_text";s:0:"";s:18:"font_tagline_style";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"14px";s:11:"line-height";s:4:"20px";s:5:"color";s:7:"#444444";}s:16:"logo_padding_top";s:2:"25";s:19:"logo_padding_bottom";s:2:"10";s:17:"logo_padding_left";s:1:"0";s:18:"logo_padding_right";s:1:"0";s:15:"menu_margin_top";s:2:"40";s:18:"menu_margin_bottom";s:2:"10";s:20:"virtue_banner_upload";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:6:"topbar";s:1:"1";s:12:"topbar_icons";s:1:"0";s:16:"topbar_icon_menu";a:2:{i:0;a:10:{s:6:"icon_o";s:19:"icon-facebook-sign ";s:3:"url";s:0:"";s:5:"title";s:8:"Facebook";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:1:"0";s:13:"attachment_id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:10:{s:6:"icon_o";s:18:"icon-twitter-sign ";s:3:"url";s:0:"";s:5:"title";s:7:"Twitter";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:1:"1";s:13:"attachment_id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}s:14:"show_cartcount";s:1:"1";s:13:"topbar_search";s:1:"1";s:13:"topbar_widget";s:1:"0";s:13:"topbar_layout";s:1:"0";s:13:"choose_slider";s:0:"";s:11:"home_slider";a:1:{i:0;a:8:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:1:"0";s:13:"attachment_id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";}}s:11:"slider_size";s:3:"400";s:17:"slider_size_width";s:4:"1170";s:15:"slider_autoplay";s:1:"1";s:16:"slider_pausetime";s:4:"7000";s:10:"trans_type";s:4:"fade";s:16:"slider_transtime";s:3:"600";s:15:"slider_captions";s:1:"0";s:11:"video_embed";s:0:"";s:13:"mobile_switch";s:1:"0";s:20:"choose_mobile_slider";s:4:"none";s:18:"home_mobile_slider";a:1:{i:0;a:8:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:1:"0";s:13:"attachment_id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";}}s:18:"mobile_slider_size";s:3:"300";s:24:"mobile_slider_size_width";s:3:"480";s:22:"mobile_slider_autoplay";s:1:"1";s:23:"mobile_slider_pausetime";s:4:"7000";s:17:"mobile_trans_type";s:4:"fade";s:23:"mobile_slider_transtime";s:3:"600";s:22:"mobile_slider_captions";s:1:"0";s:18:"mobile_video_embed";s:0:"";s:19:"home_sidebar_layout";s:4:"full";s:12:"home_sidebar";s:15:"sidebar-primary";s:15:"homepage_layout";a:2:{s:8:"disabled";a:4:{s:7:"placebo";s:7:"placebo";s:10:"block_five";s:17:"Articles récents";s:9:"block_six";s:23:"Carrousel de portefolio";s:11:"block_seven";s:14:"Menu d\'icônes";}s:7:"enabled";a:3:{s:7:"placebo";s:7:"placebo";s:9:"block_one";s:16:"Titre de la page";s:10:"block_four";s:18:"Contenu de la page";}}s:10:"blog_title";s:0:"";s:15:"home_post_count";s:1:"4";s:14:"home_post_type";s:0:"";s:15:"portfolio_title";s:0:"";s:29:"home_portfolio_carousel_count";s:1:"6";s:20:"home_portfolio_order";s:10:"menu_order";s:19:"portfolio_show_type";s:1:"0";s:9:"icon_menu";a:1:{i:0;a:10:{s:6:"icon_o";s:0:"";s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:1:"0";s:13:"attachment_id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}s:21:"home_icon_menu_column";s:1:"3";s:17:"home_post_summery";s:7:"summery";s:11:"shop_layout";s:4:"full";s:12:"shop_sidebar";s:15:"sidebar-primary";s:17:"products_per_page";s:2:"12";s:11:"shop_rating";s:1:"1";s:22:"product_quantity_input";s:1:"1";s:21:"product_cat_img_ratio";s:13:"widelandscape";s:15:"font_shop_title";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:3:"700";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"16px";s:11:"line-height";s:4:"20px";s:5:"color";s:0:"";}s:20:"shop_title_uppercase";s:1:"0";s:21:"shop_title_min_height";s:2:"40";s:18:"product_img_resize";s:1:"1";s:19:"product_simg_resize";s:1:"1";s:22:"product_gallery_slider";s:1:"0";s:20:"product_gallery_zoom";s:1:"0";s:12:"product_tabs";s:1:"1";s:16:"related_products";s:1:"1";s:15:"skin_stylesheet";s:11:"default.css";s:13:"primary_color";s:0:"";s:15:"primary20_color";s:0:"";s:15:"gray_font_color";s:0:"";s:16:"footerfont_color";s:0:"";s:16:"content_bg_color";s:0:"";s:17:"bg_content_bg_img";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:17:"content_bg_repeat";s:0:"";s:21:"content_bg_placementx";s:0:"";s:21:"content_bg_placementy";s:0:"";s:15:"topbar_bg_color";s:0:"";s:16:"bg_topbar_bg_img";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:16:"topbar_bg_repeat";s:0:"";s:20:"topbar_bg_placementx";s:0:"";s:20:"topbar_bg_placementy";s:0:"";s:15:"header_bg_color";s:0:"";s:16:"bg_header_bg_img";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:16:"header_bg_repeat";s:0:"";s:20:"header_bg_placementx";s:0:"";s:20:"header_bg_placementy";s:0:"";s:13:"menu_bg_color";s:0:"";s:14:"bg_menu_bg_img";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:14:"menu_bg_repeat";s:0:"";s:18:"menu_bg_placementx";s:0:"";s:18:"menu_bg_placementy";s:0:"";s:15:"mobile_bg_color";s:0:"";s:16:"bg_mobile_bg_img";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:16:"mobile_bg_repeat";s:0:"";s:20:"mobile_bg_placementx";s:0:"";s:20:"mobile_bg_placementy";s:0:"";s:15:"footer_bg_color";s:0:"";s:16:"bg_footer_bg_img";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:16:"footer_bg_repeat";s:0:"";s:20:"footer_bg_placementx";s:0:"";s:20:"footer_bg_placementy";s:0:"";s:14:"boxed_bg_color";s:0:"";s:15:"bg_boxed_bg_img";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:15:"boxed_bg_repeat";s:0:"";s:19:"boxed_bg_placementx";s:0:"";s:19:"boxed_bg_placementy";s:0:"";s:14:"boxed_bg_fixed";s:0:"";s:7:"font_h1";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:3:"400";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"38px";s:11:"line-height";s:4:"40px";s:5:"color";s:0:"";}s:7:"font_h2";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:6:"normal";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"32px";s:11:"line-height";s:4:"40px";s:5:"color";s:0:"";}s:7:"font_h3";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:3:"400";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"28px";s:11:"line-height";s:4:"40px";s:5:"color";s:0:"";}s:7:"font_h4";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:3:"400";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"24px";s:11:"line-height";s:4:"40px";s:5:"color";s:0:"";}s:7:"font_h5";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:3:"700";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"18px";s:11:"line-height";s:4:"24px";s:5:"color";s:0:"";}s:6:"font_p";a:9:{s:11:"font-family";s:27:"Verdana, Geneva, sans-serif";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:3:"400";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"14px";s:11:"line-height";s:4:"20px";s:5:"color";s:0:"";}s:17:"font_primary_menu";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:3:"400";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"12px";s:11:"line-height";s:4:"18px";s:5:"color";s:0:"";}s:19:"font_secondary_menu";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:3:"400";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"18px";s:11:"line-height";s:4:"22px";s:5:"color";s:0:"";}s:23:"mobile_submenu_collapse";s:1:"0";s:16:"font_mobile_menu";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:3:"400";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"16px";s:11:"line-height";s:4:"20px";s:5:"color";s:0:"";}s:23:"paragraph_margin_bottom";s:2:"16";s:15:"page_title_show";s:1:"1";s:26:"default_page_content_width";s:9:"contained";s:25:"default_page_show_sidebar";s:3:"yes";s:14:"close_comments";s:1:"0";s:13:"page_comments";s:1:"0";s:18:"portfolio_comments";s:1:"0";s:14:"portfolio_link";s:0:"";s:22:"portfolio_type_columns";s:1:"3";s:26:"portfolio_type_under_title";s:1:"1";s:20:"post_summery_default";s:12:"img_portrait";s:26:"post_summery_default_image";a:5:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}s:17:"post_head_default";s:4:"none";s:14:"show_postlinks";s:1:"0";s:11:"hide_author";s:1:"1";s:19:"post_author_default";s:2:"no";s:21:"post_carousel_default";s:2:"no";s:17:"blog_archive_full";s:7:"summery";s:17:"hide_image_border";s:1:"0";s:13:"contact_email";s:13:"test@test.com";s:11:"footer_text";s:54:"[copyright] [the-year] [site-name] [Beyond Technology]";s:13:"cust_sidebars";a:1:{i:0;s:0:"";}s:14:"virtue_gallery";s:1:"1";s:16:"kadence_lightbox";s:1:"0";s:14:"google_map_api";s:0:"";s:10:"custom_css";s:0:"";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('288', 'virtue-transients', 'a:2:{s:14:"changed_values";a:0:{}s:9:"last_save";i:1538662690;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('289', 'woocommerce_product_type', 'physical', 'yes'); 
INSERT INTO `mod63_options` VALUES ('290', 'woocommerce_sell_in_person', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('291', 'woocommerce_allow_tracking', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('293', 'woocommerce_tracker_last_send', '1540647075', 'yes'); 
INSERT INTO `mod63_options` VALUES ('294', 'woocommerce_ppec_paypal_settings', 'a:2:{s:16:"reroute_requests";b:0;s:5:"email";b:0;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('295', 'woocommerce_cheque_settings', 'a:1:{s:7:"enabled";s:3:"yes";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('296', 'woocommerce_bacs_settings', 'a:1:{s:7:"enabled";s:3:"yes";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('297', 'woocommerce_cod_settings', 'a:1:{s:7:"enabled";s:3:"yes";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('298', '_transient_shipping-transient-version', '1540220560', 'yes'); 
INSERT INTO `mod63_options` VALUES ('303', '_transient_timeout_wc_shipping_method_count_0_1538661693', '1541253898', 'no'); 
INSERT INTO `mod63_options` VALUES ('304', '_transient_wc_shipping_method_count_0_1538661693', '0', 'no'); 
INSERT INTO `mod63_options` VALUES ('314', '_transient_random_seed', '5a7696164c89f31c0d038fdbdfad3e3c', 'yes'); 
INSERT INTO `mod63_options` VALUES ('320', 'woocommerce_maybe_regenerate_images_hash', '991b1ca641921cf0f5baf7a2fe85861b', 'yes'); 
INSERT INTO `mod63_options` VALUES ('325', 'new_admin_email', 'eak2018ml@gmail.com', 'yes'); 
INSERT INTO `mod63_options` VALUES ('336', '_transient_product_query-transient-version', '1540307553', 'yes'); 
INSERT INTO `mod63_options` VALUES ('337', '_transient_product-transient-version', '1540084707', 'yes'); 
INSERT INTO `mod63_options` VALUES ('467', 'theme_mods_twentyfifteen', 'a:3:{i:0;b:0;s:18:"nav_menu_locations";a:0:{}s:16:"sidebars_widgets";a:2:{s:4:"time";i:1538696812;s:4:"data";a:2:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}}}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('503', 'theme_mods_virtue_premium', 'a:4:{i:0;b:0;s:18:"nav_menu_locations";a:3:{s:18:"primary_navigation";i:17;s:17:"mobile_navigation";i:17;s:20:"secondary_navigation";i:27;}s:18:"custom_css_post_id";i:-1;s:14:"virtue_premium";a:7:{s:13:"topbar_layout";s:1:"1";s:13:"footer_layout";s:6:"threec";s:15:"skin_stylesheet";s:9:"blush.css";s:11:"menu_search";s:1:"0";s:12:"menu_account";s:1:"0";s:9:"menu_cart";s:1:"1";s:17:"font_primary_menu";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:4:"true";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"16px";s:11:"line-height";s:4:"18px";s:5:"color";s:7:"#000000";}}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('504', 'widget_kadence_testimonials_slider', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('505', 'widget_virtue_gallery_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('506', 'widget_virtue_carousel_widget', 'a:2:{i:2;a:11:{s:4:"type";s:13:"best-products";s:7:"c_items";i:0;s:9:"c_columns";s:1:"4";s:8:"autoplay";s:4:"true";s:7:"c_order";s:10:"menu_order";s:8:"c_scroll";s:3:"all";s:7:"postcat";s:0:"";s:12:"portfoliocat";s:0:"";s:10:"productcat";s:0:"";s:7:"c_speed";i:3000;s:5:"title";s:13:"Best Products";}s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('507', 'widget_virtue_infobox_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('508', 'widget_virtue_gmap_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('509', 'widget_kadence_calltoaction_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('510', 'widget_virtue_imgmenu_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('511', 'widget_virtue_split_content_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('512', 'widget_virtue_icon_flip_box_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('517', 'kt_api_manager', 'a:2:{s:10:"kt_api_key";s:42:"vps_wc_order_5bb6a37c91baf_am_NwggajNS9WH1";s:16:"activation_email";s:22:"beyondtech96@gmail.com";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('518', 'virtue_premium_api_key', 'virtue_premium', 'yes'); 
INSERT INTO `mod63_options` VALUES ('519', 'kt_api_manager_virtue_premium_instance', '5zTr9Ent2pcI', 'yes'); 
INSERT INTO `mod63_options` VALUES ('520', 'kt_deactivate_example_checkbox', 'off', 'yes'); 
INSERT INTO `mod63_options` VALUES ('521', 'kt_api_manager_virtue_premium_activated', 'Activated', 'yes'); 
INSERT INTO `mod63_options` VALUES ('522', 'virtue_premium', 'a:405:{s:8:"last_tab";s:1:"5";s:12:"boxed_layout";s:5:"boxed";s:12:"sidebar_side";s:5:"right";s:12:"header_style";s:8:"standard";s:13:"header_height";s:3:"120";s:22:"side_header_menu_width";s:9:"33.333333";s:13:"sticky_header";s:1:"0";s:20:"shrink_center_header";s:1:"0";s:27:"shrink_center_header_height";s:3:"120";s:22:"m_center_sticky_header";s:1:"0";s:15:"m_sticky_header";s:1:"0";s:11:"logo_layout";s:8:"logoleft";s:14:"primary_sticky";s:1:"0";s:21:"x1_virtue_logo_upload";a:9:{s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/logo-1.jpg";s:2:"id";s:1:"9";s:6:"height";s:3:"279";s:5:"width";s:3:"562";s:9:"thumbnail";s:64:"http://eakmali.com/wp-content/uploads/2018/10/logo-1-150x150.jpg";s:5:"title";s:4:"logo";s:7:"caption";s:0:"";s:3:"alt";s:8:"eak logo";s:11:"description";s:8:"esk logo";}s:10:"logo_width";s:0:"";s:21:"x2_virtue_logo_upload";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:15:"font_logo_style";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"32px";s:11:"line-height";s:4:"40px";s:5:"color";s:0:"";}s:15:"logo_below_text";s:0:"";s:18:"font_tagline_style";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"14px";s:11:"line-height";s:4:"20px";s:5:"color";s:7:"#444444";}s:16:"logo_padding_top";s:1:"7";s:19:"logo_padding_bottom";s:1:"6";s:17:"logo_padding_left";s:1:"0";s:18:"logo_padding_right";s:1:"0";s:15:"menu_margin_top";s:2:"40";s:18:"menu_margin_bottom";s:2:"10";s:20:"virtue_banner_upload";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:18:"virtue_banner_link";s:0:"";s:37:"sitewide_after_header_shortcode_input";s:0:"";s:13:"mobile_header";s:1:"0";s:25:"mobile_header_tablet_show";s:1:"0";s:18:"mobile_header_logo";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:20:"mobile_header_height";s:2:"60";s:20:"mobile_header_sticky";s:1:"0";s:21:"mobile_header_account";s:1:"0";s:18:"mobile_header_cart";s:1:"0";s:20:"mobile_header_search";s:1:"0";s:24:"mobile_header_search_woo";s:1:"0";s:6:"topbar";s:1:"1";s:17:"topbar_off_mobile";s:1:"0";s:13:"topbar_mobile";s:1:"0";s:12:"topbar_icons";s:1:"1";s:16:"topbar_icon_menu";a:2:{i:0;a:12:{s:6:"icon_o";s:14:"icon-facebook2";s:3:"url";s:0:"";s:5:"title";s:8:"Facebook";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:1:"0";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:12:{s:6:"icon_o";s:12:"icon-twitter";s:3:"url";s:0:"";s:5:"title";s:7:"Twitter";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:1:"1";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}s:14:"show_cartcount";s:1:"1";s:13:"topbar_search";s:1:"1";s:13:"topbar_widget";s:1:"0";s:13:"topbar_layout";s:1:"1";s:13:"footer_layout";s:6:"threec";s:21:"sitewide_calltoaction";s:1:"0";s:20:"sitewide_action_text";s:0:"";s:21:"sitewide_action_color";s:0:"";s:24:"sitewide_action_text_btn";s:0:"";s:20:"sitewide_action_link";s:0:"";s:25:"sitewide_action_btn_color";s:0:"";s:24:"sitewide_action_bg_color";s:0:"";s:31:"sitewide_action_btn_color_hover";s:0:"";s:30:"sitewide_action_bg_color_hover";s:0:"";s:23:"sitewide_action_padding";s:2:"20";s:26:"sitewide_action_background";a:7:{s:16:"background-color";s:0:"";s:17:"background-repeat";s:0:"";s:15:"background-size";s:0:"";s:21:"background-attachment";s:0:"";s:19:"background-position";s:0:"";s:16:"background-image";s:0:"";s:5:"media";a:4:{s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";}}s:31:"sitewide_footer_shortcode_input";s:0:"";s:13:"choose_slider";s:6:"thumbs";s:19:"above_header_slider";s:1:"0";s:25:"above_header_slider_arrow";s:1:"0";s:19:"home_cyclone_slider";s:0:"";s:11:"home_slider";a:16:{i:0;a:11:{s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/logo-1.jpg";s:5:"title";s:12:"Our Products";s:11:"description";s:0:"";s:4:"link";s:28:"http://eakmali.com/boutique/";s:4:"sort";s:1:"2";s:13:"attachment_id";s:1:"9";s:5:"thumb";s:0:"";s:5:"image";s:56:"http://eakmali.com/wp-content/uploads/2018/10/logo-1.jpg";s:6:"height";s:3:"279";s:5:"width";s:3:"562";s:6:"target";s:1:"0";}i:14;a:10:{s:3:"url";s:69:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0036.jpg";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:39:"http://eakmali.com/location-de-voiture/";s:4:"sort";s:2:"24";s:13:"attachment_id";s:4:"1377";s:5:"thumb";s:77:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0036-150x150.jpg";s:5:"image";s:69:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0036.jpg";s:6:"height";s:3:"607";s:5:"width";s:4:"1080";}i:15;a:10:{s:3:"url";s:86:"http://eakmali.com/wp-content/uploads/2018/10/New-high-power-LED-miner-lamp-helmet.jpg";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:44:"http://eakmali.com/categorie-produit/safety/";s:4:"sort";s:2:"20";s:13:"attachment_id";s:4:"1396";s:5:"thumb";s:94:"http://eakmali.com/wp-content/uploads/2018/10/New-high-power-LED-miner-lamp-helmet-150x150.jpg";s:5:"image";s:86:"http://eakmali.com/wp-content/uploads/2018/10/New-high-power-LED-miner-lamp-helmet.jpg";s:6:"height";s:3:"447";s:5:"width";s:3:"419";}i:1;a:11:{s:3:"url";s:52:"http://eakmali.com/wp-content/uploads/2018/10/ou.jpg";s:5:"title";s:14:"Ordering Tools";s:11:"description";s:0:"";s:4:"link";s:48:"http://eakmali.com/categorie-produit/outillages/";s:4:"sort";s:1:"5";s:13:"attachment_id";s:3:"907";s:5:"thumb";s:60:"http://eakmali.com/wp-content/uploads/2018/10/ou-150x150.jpg";s:5:"image";s:52:"http://eakmali.com/wp-content/uploads/2018/10/ou.jpg";s:6:"height";s:3:"159";s:5:"width";s:3:"318";s:6:"target";s:1:"0";}i:13;a:10:{s:3:"url";s:69:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0044.jpg";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:39:"http://eakmali.com/location-de-voiture/";s:4:"sort";s:2:"22";s:13:"attachment_id";s:4:"1385";s:5:"thumb";s:77:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0044-150x150.jpg";s:5:"image";s:69:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0044.jpg";s:6:"height";s:3:"480";s:5:"width";s:3:"640";}i:2;a:11:{s:3:"url";s:69:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0027.jpg";s:5:"title";s:18:"Check GREASE PUMPS";s:11:"description";s:0:"";s:4:"link";s:52:"http://eakmali.com/categorie-produit/grease-pumps-2/";s:4:"sort";s:1:"8";s:13:"attachment_id";s:4:"1368";s:5:"thumb";s:77:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0027-150x150.jpg";s:5:"image";s:69:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0027.jpg";s:6:"height";s:3:"500";s:5:"width";s:3:"500";s:6:"target";s:1:"0";}i:3;a:11:{s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/elecc.jpg";s:5:"title";s:21:"All About Electricity";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/electrical-equipment/";s:4:"sort";s:2:"12";s:13:"attachment_id";s:3:"900";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/elecc-150x142.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/elecc.jpg";s:6:"height";s:3:"142";s:5:"width";s:3:"355";s:6:"target";s:1:"0";}i:4;a:11:{s:3:"url";s:54:"http://eakmali.com/wp-content/uploads/2018/10/elec.jpg";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/electrical-equipment/";s:4:"sort";s:2:"14";s:13:"attachment_id";s:3:"899";s:5:"thumb";s:62:"http://eakmali.com/wp-content/uploads/2018/10/elec-150x150.jpg";s:5:"image";s:54:"http://eakmali.com/wp-content/uploads/2018/10/elec.jpg";s:6:"height";s:3:"150";s:5:"width";s:3:"337";s:6:"target";s:1:"0";}i:5;a:11:{s:3:"url";s:53:"http://eakmali.com/wp-content/uploads/2018/10/eva.jpg";s:5:"title";s:20:"Handling and lifting";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/handling-and-lifting/";s:4:"sort";s:2:"15";s:13:"attachment_id";s:3:"901";s:5:"thumb";s:61:"http://eakmali.com/wp-content/uploads/2018/10/eva-150x150.jpg";s:5:"image";s:53:"http://eakmali.com/wp-content/uploads/2018/10/eva.jpg";s:6:"height";s:3:"160";s:5:"width";s:3:"315";s:6:"target";s:1:"0";}i:6;a:11:{s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/levag.jpg";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/handling-and-lifting/";s:4:"sort";s:2:"16";s:13:"attachment_id";s:3:"905";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/levag-150x150.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/levag.jpg";s:6:"height";s:3:"200";s:5:"width";s:3:"373";s:6:"target";s:1:"0";}i:7;a:11:{s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/safety.jpg";s:5:"title";s:6:"Safety";s:11:"description";s:0:"";s:4:"link";s:44:"http://eakmali.com/categorie-produit/safety/";s:4:"sort";s:2:"17";s:13:"attachment_id";s:3:"911";s:5:"thumb";s:64:"http://eakmali.com/wp-content/uploads/2018/10/safety-150x150.jpg";s:5:"image";s:56:"http://eakmali.com/wp-content/uploads/2018/10/safety.jpg";s:6:"height";s:3:"183";s:5:"width";s:3:"275";s:6:"target";s:1:"0";}i:9;a:11:{s:3:"url";s:69:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181029-WA0024.jpg";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"28";s:13:"attachment_id";s:4:"1342";s:5:"thumb";s:77:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181029-WA0024-150x150.jpg";s:5:"image";s:69:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181029-WA0024.jpg";s:6:"height";s:3:"744";s:5:"width";s:3:"992";s:6:"target";s:1:"0";}i:11;a:11:{s:3:"url";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-4.png";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:39:"http://eakmali.com/location-de-voiture/";s:4:"sort";s:2:"23";s:13:"attachment_id";s:4:"1271";s:5:"thumb";s:68:"http://eakmali.com/wp-content/uploads/2018/10/Location-4-150x150.png";s:5:"image";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-4.png";s:6:"height";s:3:"201";s:5:"width";s:3:"300";s:6:"target";s:1:"0";}i:10;a:11:{s:3:"url";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-1.png";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"25";s:13:"attachment_id";s:4:"1269";s:5:"thumb";s:68:"http://eakmali.com/wp-content/uploads/2018/10/Location-1-150x150.png";s:5:"image";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-1.png";s:6:"height";s:3:"302";s:5:"width";s:3:"488";s:6:"target";s:1:"0";}i:12;a:11:{s:3:"url";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-5.png";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:39:"http://eakmali.com/location-de-voiture/";s:4:"sort";s:2:"26";s:13:"attachment_id";s:4:"1273";s:5:"thumb";s:68:"http://eakmali.com/wp-content/uploads/2018/10/Location-5-150x150.png";s:5:"image";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-5.png";s:6:"height";s:3:"343";s:5:"width";s:3:"524";s:6:"target";s:1:"0";}i:8;a:11:{s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/outil.jpg";s:5:"title";s:28:"Various Tools for your needs";s:11:"description";s:0:"";s:4:"link";s:45:"http://eakmali.com/categorie-produit/various/";s:4:"sort";s:2:"27";s:13:"attachment_id";s:3:"908";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/outil-150x145.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/outil.jpg";s:6:"height";s:3:"145";s:5:"width";s:3:"348";s:6:"target";s:1:"0";}}s:11:"slider_size";s:3:"550";s:17:"slider_size_width";s:3:"995";s:15:"slider_autoplay";s:1:"1";s:16:"slider_pausetime";s:4:"5000";s:10:"trans_type";s:4:"fade";s:16:"slider_transtime";s:3:"500";s:15:"slider_captions";s:1:"1";s:11:"video_embed";s:0:"";s:13:"mobile_switch";s:1:"0";s:18:"mobile_tablet_show";s:1:"0";s:20:"choose_mobile_slider";s:4:"none";s:21:"mobile_cyclone_slider";s:0:"";s:18:"home_mobile_slider";a:2:{i:0;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"29";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"30";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}s:18:"mobile_slider_size";s:3:"300";s:24:"mobile_slider_size_width";s:3:"480";s:22:"mobile_slider_autoplay";s:1:"1";s:23:"mobile_slider_pausetime";s:4:"7000";s:17:"mobile_trans_type";s:4:"fade";s:23:"mobile_slider_transtime";s:3:"600";s:22:"mobile_slider_captions";s:1:"0";s:18:"mobile_video_embed";s:0:"";s:19:"home_sidebar_layout";s:7:"sidebar";s:12:"home_sidebar";s:8:"sidebar1";s:15:"homepage_layout";a:2:{s:8:"disabled";a:9:{s:7:"placebo";s:7:"placebo";s:10:"block_four";s:15:"Contenu de page";s:10:"block_nine";s:18:"Produits à vendre";s:9:"block_six";s:20:"Portfolio carrousel ";s:11:"block_three";s:23:"Produits sélectionnés";s:9:"block_one";s:13:"Titre de page";s:10:"block_five";s:24:"Derniers billets de blog";s:11:"block_eight";s:17:"Portfolio complet";s:12:"block_eleven";s:23:"Carrousel personnalisé";}s:7:"enabled";a:5:{s:7:"placebo";s:7:"placebo";s:11:"block_seven";s:17:"Menu avec icônes";s:9:"block_ten";s:21:"Produits best sellers";s:9:"block_two";s:12:"Menu d\'image";s:12:"block_twelve";s:31:"Espace pour le widget d\'accueil";}}s:15:"home_image_menu";a:2:{i:0;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"31";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"32";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}s:22:"home_image_menu_column";s:1:"3";s:15:"img_menu_height";s:3:"110";s:23:"img_menu_height_setting";s:6:"normal";s:13:"product_title";s:0:"";s:24:"home_product_feat_column";s:1:"4";s:18:"home_product_count";s:1:"6";s:24:"home_product_feat_scroll";s:7:"oneitem";s:23:"home_product_feat_speed";s:1:"9";s:18:"product_sale_title";s:0:"";s:24:"home_product_sale_column";s:1:"4";s:23:"home_product_sale_count";s:1:"6";s:24:"home_product_sale_scroll";s:3:"all";s:23:"home_product_sale_speed";s:1:"7";s:18:"product_best_title";s:0:"";s:24:"home_product_best_column";s:1:"4";s:23:"home_product_best_count";s:1:"6";s:24:"home_product_best_scroll";s:7:"oneitem";s:23:"home_product_best_speed";s:1:"9";s:10:"blog_title";s:0:"";s:15:"home_post_count";s:1:"2";s:16:"home_post_column";s:1:"2";s:14:"home_post_type";s:0:"";s:20:"home_post_word_count";s:2:"34";s:15:"portfolio_title";s:12:"Nos Produits";s:14:"portfolio_type";s:0:"";s:30:"home_portfolio_carousel_column";s:1:"4";s:30:"home_portfolio_carousel_height";s:0:"";s:29:"home_portfolio_carousel_count";s:1:"6";s:29:"home_portfolio_carousel_speed";s:1:"9";s:30:"home_portfolio_carousel_scroll";s:7:"oneitem";s:20:"home_portfolio_order";s:10:"menu_order";s:19:"portfolio_show_type";s:1:"0";s:22:"portfolio_show_excerpt";s:1:"0";s:21:"custom_carousel_title";s:0:"";s:26:"home_custom_carousel_items";a:2:{i:0;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"33";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"34";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}s:27:"home_custom_carousel_column";s:1:"4";s:27:"home_custom_carousel_scroll";s:7:"oneitem";s:17:"home_custom_speed";s:1:"9";s:31:"home_custom_carousel_imageratio";s:1:"0";s:9:"icon_menu";a:13:{i:0;a:12:{s:6:"icon_o";s:12:"icon-basket2";s:3:"url";s:0:"";s:5:"title";s:12:"How to Order";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"35";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:12:{s:6:"icon_o";s:10:"icon-cart4";s:3:"url";s:0:"";s:5:"title";s:13:"Best Products";s:11:"description";s:0:"";s:4:"link";s:28:"http://eakmali.com/boutique/";s:4:"sort";s:2:"36";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:2;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/logo-1.jpg";s:5:"title";s:11:"Place Order";s:11:"description";s:0:"";s:4:"link";s:28:"http://eakmali.com/boutique/";s:4:"sort";s:2:"37";s:13:"attachment_id";s:1:"9";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:3:"279";s:5:"width";s:3:"562";s:6:"target";s:1:"0";}i:3;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/k32-01.jpg";s:5:"title";s:12:"GREASE PUMPS";s:11:"description";s:0:"";s:4:"link";s:77:"http://eakmali.com/categorie-produit/macnaught/grease-equipment/grease-pumps/";s:4:"sort";s:2:"38";s:13:"attachment_id";s:4:"1068";s:5:"thumb";s:64:"http://eakmali.com/wp-content/uploads/2018/10/k32-01-150x150.jpg";s:5:"image";s:56:"http://eakmali.com/wp-content/uploads/2018/10/k32-01.jpg";s:6:"height";s:3:"500";s:5:"width";s:3:"500";s:6:"target";s:1:"0";}i:4;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:52:"http://eakmali.com/wp-content/uploads/2018/10/KY.png";s:5:"title";s:18:"GREASE ACCESSORIES";s:11:"description";s:0:"";s:4:"link";s:93:"http://eakmali.com/categorie-produit/macnaught/grease-equipment/accessories-grease-equipment/";s:4:"sort";s:2:"39";s:13:"attachment_id";s:4:"1103";s:5:"thumb";s:60:"http://eakmali.com/wp-content/uploads/2018/10/KY-150x150.png";s:5:"image";s:52:"http://eakmali.com/wp-content/uploads/2018/10/KY.png";s:6:"height";s:3:"250";s:5:"width";s:3:"250";s:6:"target";s:1:"0";}i:5;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/levaa.jpg";s:5:"title";s:21:" Handling and lifting";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/handling-and-lifting/";s:4:"sort";s:2:"40";s:13:"attachment_id";s:3:"904";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/levaa-150x150.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/levaa.jpg";s:6:"height";s:3:"163";s:5:"width";s:3:"309";s:6:"target";s:1:"0";}i:6;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/outil.jpg";s:5:"title";s:7:"Tooling";s:11:"description";s:0:"";s:4:"link";s:45:"http://eakmali.com/categorie-produit/tooling/";s:4:"sort";s:2:"41";s:13:"attachment_id";s:3:"908";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/outil-150x145.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/outil.jpg";s:6:"height";s:3:"145";s:5:"width";s:3:"348";s:6:"target";s:1:"0";}i:7;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:65:"http://eakmali.com/wp-content/uploads/2018/10/Electricites-15.png";s:5:"title";s:20:"Electrical equipment";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/electrical-equipment/";s:4:"sort";s:2:"42";s:13:"attachment_id";s:4:"1257";s:5:"thumb";s:73:"http://eakmali.com/wp-content/uploads/2018/10/Electricites-15-150x150.png";s:5:"image";s:65:"http://eakmali.com/wp-content/uploads/2018/10/Electricites-15.png";s:6:"height";s:3:"500";s:5:"width";s:3:"500";s:6:"target";s:1:"0";}i:8;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:57:"http://eakmali.com/wp-content/uploads/2018/10/safetyy.jpg";s:5:"title";s:6:"Safety";s:11:"description";s:0:"";s:4:"link";s:44:"http://eakmali.com/categorie-produit/safety/";s:4:"sort";s:2:"43";s:13:"attachment_id";s:3:"912";s:5:"thumb";s:65:"http://eakmali.com/wp-content/uploads/2018/10/safetyy-150x150.jpg";s:5:"image";s:57:"http://eakmali.com/wp-content/uploads/2018/10/safetyy.jpg";s:6:"height";s:3:"267";s:5:"width";s:3:"189";s:6:"target";s:1:"0";}i:9;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:58:"http://eakmali.com/wp-content/uploads/2018/10/Divers-1.png";s:5:"title";s:7:"Various";s:11:"description";s:0:"";s:4:"link";s:45:"http://eakmali.com/categorie-produit/various/";s:4:"sort";s:2:"44";s:13:"attachment_id";s:4:"1214";s:5:"thumb";s:66:"http://eakmali.com/wp-content/uploads/2018/10/Divers-1-150x150.png";s:5:"image";s:58:"http://eakmali.com/wp-content/uploads/2018/10/Divers-1.png";s:6:"height";s:3:"588";s:5:"width";s:3:"730";s:6:"target";s:1:"0";}i:10;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/hydroo.jpg";s:5:"title";s:20:"Hydraulic equipement";s:11:"description";s:0:"";s:4:"link";s:50:"http://eakmali.com/categorie-produit/hydrauliques/";s:4:"sort";s:2:"45";s:13:"attachment_id";s:3:"903";s:5:"thumb";s:64:"http://eakmali.com/wp-content/uploads/2018/10/hydroo-150x150.jpg";s:5:"image";s:56:"http://eakmali.com/wp-content/uploads/2018/10/hydroo.jpg";s:6:"height";s:3:"161";s:5:"width";s:3:"313";s:6:"target";s:1:"0";}i:11;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:69:"http://eakmali.com/wp-content/uploads/2018/10/Unite-de-Mesures-16.png";s:5:"title";s:19:"measure  equipement";s:11:"description";s:0:"";s:4:"link";s:56:"http://eakmali.com/categorie-produit/measure-equipement/";s:4:"sort";s:2:"46";s:13:"attachment_id";s:4:"1265";s:5:"thumb";s:77:"http://eakmali.com/wp-content/uploads/2018/10/Unite-de-Mesures-16-150x150.png";s:5:"image";s:69:"http://eakmali.com/wp-content/uploads/2018/10/Unite-de-Mesures-16.png";s:6:"height";s:3:"373";s:5:"width";s:3:"420";s:6:"target";s:1:"0";}i:12;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/hydro.jpg";s:5:"title";s:17:"Parker Enterprise";s:11:"description";s:0:"";s:4:"link";s:44:"http://eakmali.com/categorie-produit/parker/";s:4:"sort";s:2:"47";s:13:"attachment_id";s:3:"902";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/hydro-150x125.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/hydro.jpg";s:6:"height";s:3:"125";s:5:"width";s:3:"402";s:6:"target";s:1:"0";}}s:21:"home_icon_menu_column";s:1:"3";s:13:"icon_bg_color";s:11:"transparent";s:15:"icon_font_color";s:7:"#000000";s:20:"portfolio_full_title";s:0:"";s:19:"portfolio_full_type";s:0:"";s:26:"portfolio_full_show_filter";s:1:"0";s:15:"home_port_count";s:1:"8";s:25:"home_portfolio_full_order";s:10:"menu_order";s:26:"home_portfolio_full_layout";s:6:"normal";s:17:"home_port_columns";s:1:"4";s:26:"home_portfolio_full_height";s:0:"";s:22:"portfolio_full_masonry";s:1:"0";s:24:"portfolio_full_show_type";s:1:"0";s:27:"portfolio_full_show_excerpt";s:1:"1";s:23:"home_portfolio_lightbox";s:1:"1";s:17:"home_post_summery";s:7:"summery";s:14:"home_post_grid";s:1:"0";s:22:"home_post_grid_columns";s:10:"fourcolumn";s:19:"product_shop_layout";s:1:"4";s:11:"shop_layout";s:7:"sidebar";s:12:"shop_sidebar";s:15:"sidebar-primary";s:15:"shop_cat_layout";s:4:"full";s:16:"shop_cat_sidebar";s:15:"sidebar-primary";s:17:"products_per_page";s:2:"12";s:15:"product_fitrows";s:1:"1";s:11:"shop_filter";s:1:"0";s:10:"cat_filter";s:1:"0";s:14:"infinitescroll";s:1:"0";s:11:"shop_toggle";s:1:"0";s:12:"shop_excerpt";s:1:"0";s:11:"shop_rating";s:1:"1";s:13:"outofstocktag";s:1:"0";s:16:"shop_hide_action";s:1:"1";s:16:"product_img_flip";s:1:"0";s:22:"product_quantity_input";s:1:"1";s:18:"product_cat_layout";s:1:"4";s:21:"product_cat_img_ratio";s:13:"widelandscape";s:15:"font_shop_title";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"700";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"16px";s:11:"line-height";s:4:"20px";s:5:"color";s:0:"";}s:20:"shop_title_uppercase";s:1:"0";s:21:"shop_title_min_height";s:2:"40";s:14:"shop_img_ratio";s:6:"square";s:18:"product_img_resize";s:1:"1";s:19:"product_simg_resize";s:1:"1";s:11:"shop_slider";s:1:"0";s:18:"choose_shop_slider";s:4:"none";s:19:"shop_cyclone_slider";s:0:"";s:18:"shop_slider_images";a:2:{i:0;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"48";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"49";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}s:16:"shop_slider_size";s:3:"400";s:22:"shop_slider_size_width";s:4:"1140";s:20:"shop_slider_autoplay";s:1:"1";s:21:"shop_slider_pausetime";s:4:"7000";s:15:"shop_trans_type";s:4:"fade";s:21:"shop_slider_transtime";s:3:"600";s:20:"shop_slider_captions";s:1:"0";s:20:"singleproduct_layout";s:6:"normal";s:22:"product_gallery_slider";s:1:"0";s:20:"product_gallery_zoom";s:1:"0";s:23:"product_sidebar_default";s:2:"no";s:31:"product_sidebar_default_sidebar";s:15:"sidebar-primary";s:13:"product_radio";s:1:"0";s:11:"product_nav";s:1:"0";s:12:"product_tabs";s:1:"1";s:19:"product_tabs_scroll";s:1:"0";s:16:"ptab_description";s:2:"10";s:15:"ptab_additional";s:2:"20";s:12:"ptab_reviews";s:2:"30";s:10:"ptab_video";s:2:"40";s:13:"custom_tab_01";s:1:"0";s:13:"custom_tab_02";s:1:"0";s:13:"custom_tab_03";s:1:"0";s:16:"related_products";s:1:"1";s:19:"related_item_column";s:1:"4";s:19:"portfolio_permalink";s:0:"";s:18:"portfolio_comments";s:1:"0";s:36:"portfolio_header_single_image_height";s:1:"0";s:14:"portfolio_link";s:0:"";s:19:"portfolio_arrow_nav";s:3:"all";s:20:"portfolio_tax_column";s:1:"4";s:19:"portfolio_tax_items";s:2:"12";s:19:"portfolio_tax_order";s:10:"menu_order";s:20:"portfolio_tax_height";s:0:"";s:21:"portfolio_tax_masonry";s:1:"0";s:22:"portfolio_tax_lightbox";s:1:"1";s:26:"portfolio_type_under_title";s:1:"1";s:26:"portfolio_tax_show_excerpt";s:1:"0";s:27:"portfolio_recent_car_column";s:1:"4";s:31:"portfolio_recent_carousel_speed";s:1:"9";s:26:"portfolio_recent_car_items";s:1:"8";s:32:"portfolio_recent_carousel_scroll";s:7:"oneitem";s:15:"post_word_count";s:2:"40";s:23:"custom_excerpt_readmore";s:1:"0";s:14:"close_comments";s:1:"0";s:11:"hide_author";s:1:"1";s:13:"hide_postedin";s:1:"1";s:16:"hide_commenticon";s:1:"1";s:13:"hide_postdate";s:1:"1";s:14:"show_postlinks";s:1:"0";s:16:"postlinks_in_cat";s:3:"all";s:19:"blog_infinitescroll";s:1:"0";s:23:"blog_cat_infinitescroll";s:1:"0";s:24:"blog_grid_display_height";s:1:"0";s:24:"blogpost_sidebar_default";s:3:"yes";s:27:"blogpost_sidebar_id_default";s:15:"sidebar-primary";s:20:"post_summery_default";s:4:"text";s:26:"post_summery_default_image";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:17:"post_head_default";s:4:"none";s:31:"post_header_single_image_height";s:1:"0";s:19:"post_author_default";s:2:"no";s:21:"post_carousel_default";s:2:"no";s:25:"blog_similar_random_order";s:1:"0";s:21:"post_carousel_columns";s:1:"3";s:21:"category_post_summary";s:7:"summary";s:25:"category_post_grid_column";s:1:"3";s:15:"blog_cat_layout";s:7:"sidebar";s:16:"blog_cat_sidebar";s:15:"sidebar-primary";s:15:"skin_stylesheet";s:9:"blush.css";s:13:"primary_color";s:0:"";s:15:"primary20_color";s:0:"";s:15:"gray_font_color";s:0:"";s:16:"footerfont_color";s:0:"";s:16:"content_bg_color";s:0:"";s:17:"bg_content_bg_img";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:17:"content_bg_repeat";s:0:"";s:21:"content_bg_placementx";s:0:"";s:21:"content_bg_placementy";s:0:"";s:15:"topbar_bg_color";s:0:"";s:16:"bg_topbar_bg_img";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:16:"topbar_bg_repeat";s:0:"";s:20:"topbar_bg_placementx";s:0:"";s:20:"topbar_bg_placementy";s:0:"";s:15:"header_bg_color";s:0:"";s:16:"bg_header_bg_img";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:16:"header_bg_repeat";s:0:"";s:20:"header_bg_placementx";s:0:"";s:20:"header_bg_placementy";s:0:"";s:13:"menu_bg_color";s:0:"";s:14:"bg_menu_bg_img";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:14:"menu_bg_repeat";s:0:"";s:18:"menu_bg_placementx";s:0:"";s:18:"menu_bg_placementy";s:0:"";s:15:"mobile_bg_color";s:0:"";s:16:"bg_mobile_bg_img";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:16:"mobile_bg_repeat";s:0:"";s:20:"mobile_bg_placementx";s:0:"";s:20:"mobile_bg_placementy";s:0:"";s:16:"feature_bg_color";s:0:"";s:17:"bg_feature_bg_img";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:17:"feature_bg_repeat";s:0:"";s:21:"feature_bg_placementx";s:0:"";s:21:"feature_bg_placementy";s:0:"";s:15:"footer_bg_color";s:0:"";s:16:"bg_footer_bg_img";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:16:"footer_bg_repeat";s:0:"";s:20:"footer_bg_placementx";s:0:"";s:20:"footer_bg_placementy";s:0:"";s:14:"boxed_bg_color";s:0:"";s:15:"bg_boxed_bg_img";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:15:"boxed_bg_repeat";s:0:"";s:19:"boxed_bg_placementx";s:0:"";s:19:"boxed_bg_placementy";s:0:"";s:14:"boxed_bg_fixed";s:0:"";s:13:"boxed_bg_size";s:0:"";s:7:"font_h1";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"38px";s:11:"line-height";s:4:"40px";s:5:"color";s:0:"";}s:7:"font_h2";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"32px";s:11:"line-height";s:4:"40px";s:5:"color";s:0:"";}s:7:"font_h3";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"28px";s:11:"line-height";s:4:"40px";s:5:"color";s:0:"";}s:7:"font_h4";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"24px";s:11:"line-height";s:4:"40px";s:5:"color";s:0:"";}s:7:"font_h5";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:0:"";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"18px";s:11:"line-height";s:4:"24px";s:5:"color";s:0:"";}s:6:"font_p";a:9:{s:11:"font-family";s:0:"";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"14px";s:11:"line-height";s:4:"20px";s:5:"color";s:0:"";}s:17:"show_subindicator";s:1:"0";s:11:"menu_search";s:1:"0";s:15:"menu_search_woo";s:1:"0";s:12:"menu_account";s:1:"0";s:9:"menu_cart";s:1:"1";s:17:"font_primary_menu";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"18px";s:11:"line-height";s:4:"20px";s:5:"color";s:0:"";}s:23:"primarymenu_hover_color";s:0:"";s:26:"primarymenu_hover_bg_color";s:0:"";s:19:"font_secondary_menu";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"18px";s:11:"line-height";s:4:"22px";s:5:"color";s:0:"";}s:25:"secondarymenu_hover_color";s:0:"";s:28:"secondarymenu_hover_bg_color";s:0:"";s:19:"secondary_menu_size";s:5:"16.5%";s:19:"dropdown_font_color";s:0:"";s:25:"dropdown_background_color";s:0:"";s:21:"dropdown_border_color";s:0:"";s:23:"dropdown_menu_font_size";a:2:{s:9:"font-size";s:4:"12px";s:11:"line-height";s:9:"inheritpx";}s:25:"dropdown_font_hover_color";s:0:"";s:15:"show_mobile_btn";s:1:"0";s:23:"mobile_submenu_collapse";s:1:"0";s:16:"font_mobile_menu";a:9:{s:11:"font-family";s:4:"Lato";s:12:"font-options";s:0:"";s:6:"google";s:1:"1";s:11:"font-weight";s:3:"400";s:10:"font-style";s:0:"";s:7:"subsets";s:0:"";s:9:"font-size";s:4:"16px";s:11:"line-height";s:4:"20px";s:5:"color";s:0:"";}s:22:"mobilemenu_hover_color";s:0:"";s:25:"mobilemenu_hover_bg_color";s:0:"";s:16:"mobile_menu_text";s:0:"";s:23:"search_placeholder_text";s:0:"";s:21:"cart_placeholder_text";s:0:"";s:21:"sold_placeholder_text";s:0:"";s:21:"sale_placeholder_text";s:0:"";s:25:"wc_clear_placeholder_text";s:0:"";s:29:"notavailable_placeholder_text";s:0:"";s:12:"post_by_text";s:0:"";s:15:"post_incat_text";s:0:"";s:15:"filter_all_text";s:0:"";s:16:"shop_filter_text";s:0:"";s:21:"portfolio_filter_text";s:0:"";s:20:"description_tab_text";s:0:"";s:23:"description_header_text";s:0:"";s:18:"post_readmore_text";s:0:"";s:31:"additional_information_tab_text";s:0:"";s:34:"additional_information_header_text";s:0:"";s:14:"video_tab_text";s:0:"";s:16:"video_title_text";s:0:"";s:16:"reviews_tab_text";s:0:"";s:21:"related_products_text";s:0:"";s:23:"wc_upsell_products_text";s:0:"";s:21:"lightbox_loading_text";s:0:"";s:16:"lightbox_of_text";s:0:"";s:19:"lightbox_error_text";s:0:"";s:15:"contact_consent";s:0:"";s:21:"show_breadcrumbs_shop";s:1:"0";s:24:"show_breadcrumbs_product";s:1:"0";s:21:"show_breadcrumbs_post";s:1:"0";s:26:"show_breadcrumbs_portfolio";s:1:"0";s:22:"show_breadcrumbs_staff";s:1:"0";s:10:"staff_link";s:0:"";s:21:"show_breadcrumbs_page";s:1:"0";s:20:"home_breadcrumb_text";s:0:"";s:9:"blog_link";s:0:"";s:16:"shop_breadcrumbs";s:1:"0";s:23:"paragraph_margin_bottom";s:2:"16";s:13:"page_comments";s:1:"0";s:15:"page_title_show";s:1:"1";s:26:"default_page_content_width";s:9:"contained";s:25:"default_page_show_sidebar";s:3:"yes";s:22:"testimonial_single_nav";s:1:"0";s:16:"testimonial_page";s:0:"";s:17:"hide_image_border";s:1:"1";s:20:"remove_image_padding";s:1:"0";s:14:"select2_select";s:1:"1";s:13:"minimal_icons";s:1:"0";s:21:"virtue_custom_favicon";a:9:{s:3:"url";s:0:"";s:2:"id";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:9:"thumbnail";s:0:"";s:5:"title";s:0:"";s:7:"caption";s:0:"";s:3:"alt";s:0:"";s:11:"description";s:0:"";}s:13:"contact_email";s:17:"sales@eakmali.com";s:11:"footer_text";s:55:"[copyright] [the-year] [site-name] by Beyond Technology";s:18:"search_page_layout";s:7:"sidebar";s:14:"search_sidebar";s:15:"sidebar-primary";s:13:"search_layout";s:4:"grid";s:26:"search_results_show_search";s:5:"false";s:13:"cust_sidebars";a:1:{i:0;s:0:"";}s:14:"page_max_width";s:1:"0";s:16:"smooth_scrolling";s:1:"0";s:21:"smooth_scrolling_hide";s:1:"0";s:27:"smooth_scrolling_background";s:1:"0";s:14:"virtue_gallery";s:1:"1";s:22:"virtue_gallery_masonry";s:1:"1";s:16:"gallery_captions";s:1:"0";s:17:"virtue_animate_in";s:1:"1";s:16:"kadence_lightbox";s:1:"0";s:25:"load_google_fonts_locally";s:1:"0";s:14:"google_map_api";s:0:"";s:16:"google_analytics";s:14:"UA-127875993-1";s:22:"google_analytics_anony";s:1:"0";s:10:"seo_switch";s:1:"0";s:13:"seo_sitetitle";s:0:"";s:19:"seo_sitedescription";s:0:"";s:10:"custom_css";s:0:"";s:21:"kadence_woo_extension";s:1:"1";s:27:"kadence_portfolio_extension";s:1:"1";s:23:"kadence_staff_extension";s:1:"1";s:29:"kadence_testimonial_extension";s:1:"1";s:31:"kadence_header_footer_extension";s:1:"0";s:17:"enable_custom_404";s:1:"0";s:15:"custom_404_page";s:0:"";s:26:"hide_rev_activation_notice";s:1:"1";s:23:"kt_cycloneslider_notice";s:1:"0";s:10:"rev_slider";s:6:"select";s:9:"kt_slider";s:6:"select";s:10:"ksp_slider";s:6:"select";s:10:"mobile_ksp";s:6:"select";s:8:"shop_ksp";s:6:"select";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('523', 'virtue_premium-transients', 'a:2:{s:14:"changed_values";a:6:{s:11:"home_slider";a:15:{i:0;a:11:{s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/logo-1.jpg";s:5:"title";s:12:"Our Products";s:11:"description";s:0:"";s:4:"link";s:28:"http://eakmali.com/boutique/";s:4:"sort";s:1:"2";s:13:"attachment_id";s:1:"9";s:5:"thumb";s:0:"";s:5:"image";s:56:"http://eakmali.com/wp-content/uploads/2018/10/logo-1.jpg";s:6:"height";s:3:"279";s:5:"width";s:3:"562";s:6:"target";s:1:"0";}i:1;a:11:{s:3:"url";s:52:"http://eakmali.com/wp-content/uploads/2018/10/ou.jpg";s:5:"title";s:14:"Ordering Tools";s:11:"description";s:0:"";s:4:"link";s:48:"http://eakmali.com/categorie-produit/outillages/";s:4:"sort";s:1:"3";s:13:"attachment_id";s:3:"907";s:5:"thumb";s:60:"http://eakmali.com/wp-content/uploads/2018/10/ou-150x150.jpg";s:5:"image";s:52:"http://eakmali.com/wp-content/uploads/2018/10/ou.jpg";s:6:"height";s:3:"159";s:5:"width";s:3:"318";s:6:"target";s:1:"0";}i:2;a:11:{s:3:"url";s:69:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0027.jpg";s:5:"title";s:18:"Check GREASE PUMPS";s:11:"description";s:0:"";s:4:"link";s:52:"http://eakmali.com/categorie-produit/grease-pumps-2/";s:4:"sort";s:1:"4";s:13:"attachment_id";s:4:"1368";s:5:"thumb";s:77:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0027-150x150.jpg";s:5:"image";s:69:"http://eakmali.com/wp-content/uploads/2018/10/IMG-20181030-WA0027.jpg";s:6:"height";s:3:"500";s:5:"width";s:3:"500";s:6:"target";s:1:"0";}i:13;a:10:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:1:"7";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";}i:14;a:10:{s:3:"url";s:18:"Check GREASE PUMPS";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:1:"6";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";}i:3;a:11:{s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/elecc.jpg";s:5:"title";s:21:"All About Electricity";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/electrical-equipment/";s:4:"sort";s:1:"8";s:13:"attachment_id";s:3:"900";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/elecc-150x142.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/elecc.jpg";s:6:"height";s:3:"142";s:5:"width";s:3:"355";s:6:"target";s:1:"0";}i:4;a:11:{s:3:"url";s:54:"http://eakmali.com/wp-content/uploads/2018/10/elec.jpg";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/electrical-equipment/";s:4:"sort";s:1:"9";s:13:"attachment_id";s:3:"899";s:5:"thumb";s:62:"http://eakmali.com/wp-content/uploads/2018/10/elec-150x150.jpg";s:5:"image";s:54:"http://eakmali.com/wp-content/uploads/2018/10/elec.jpg";s:6:"height";s:3:"150";s:5:"width";s:3:"337";s:6:"target";s:1:"0";}i:5;a:11:{s:3:"url";s:53:"http://eakmali.com/wp-content/uploads/2018/10/eva.jpg";s:5:"title";s:20:"Handling and lifting";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/handling-and-lifting/";s:4:"sort";s:2:"10";s:13:"attachment_id";s:3:"901";s:5:"thumb";s:61:"http://eakmali.com/wp-content/uploads/2018/10/eva-150x150.jpg";s:5:"image";s:53:"http://eakmali.com/wp-content/uploads/2018/10/eva.jpg";s:6:"height";s:3:"160";s:5:"width";s:3:"315";s:6:"target";s:1:"0";}i:6;a:11:{s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/levag.jpg";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/handling-and-lifting/";s:4:"sort";s:2:"11";s:13:"attachment_id";s:3:"905";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/levag-150x150.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/levag.jpg";s:6:"height";s:3:"200";s:5:"width";s:3:"373";s:6:"target";s:1:"0";}i:7;a:11:{s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/safety.jpg";s:5:"title";s:6:"Safety";s:11:"description";s:0:"";s:4:"link";s:44:"http://eakmali.com/categorie-produit/safety/";s:4:"sort";s:2:"12";s:13:"attachment_id";s:3:"911";s:5:"thumb";s:64:"http://eakmali.com/wp-content/uploads/2018/10/safety-150x150.jpg";s:5:"image";s:56:"http://eakmali.com/wp-content/uploads/2018/10/safety.jpg";s:6:"height";s:3:"183";s:5:"width";s:3:"275";s:6:"target";s:1:"0";}i:8;a:11:{s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/outil.jpg";s:5:"title";s:28:"Various Tools for your needs";s:11:"description";s:0:"";s:4:"link";s:45:"http://eakmali.com/categorie-produit/various/";s:4:"sort";s:2:"13";s:13:"attachment_id";s:3:"908";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/outil-150x145.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/outil.jpg";s:6:"height";s:3:"145";s:5:"width";s:3:"348";s:6:"target";s:1:"0";}i:9;a:11:{s:3:"url";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-2.png";s:5:"title";s:10:"Car Rental";s:11:"description";s:0:"";s:4:"link";s:39:"http://eakmali.com/location-de-voiture/";s:4:"sort";s:2:"14";s:13:"attachment_id";s:4:"1270";s:5:"thumb";s:68:"http://eakmali.com/wp-content/uploads/2018/10/Location-2-150x150.png";s:5:"image";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-2.png";s:6:"height";s:3:"279";s:5:"width";s:3:"444";s:6:"target";s:1:"0";}i:10;a:11:{s:3:"url";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-1.png";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"15";s:13:"attachment_id";s:4:"1269";s:5:"thumb";s:68:"http://eakmali.com/wp-content/uploads/2018/10/Location-1-150x150.png";s:5:"image";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-1.png";s:6:"height";s:3:"302";s:5:"width";s:3:"488";s:6:"target";s:1:"0";}i:11;a:11:{s:3:"url";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-4.png";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:39:"http://eakmali.com/location-de-voiture/";s:4:"sort";s:2:"16";s:13:"attachment_id";s:4:"1271";s:5:"thumb";s:68:"http://eakmali.com/wp-content/uploads/2018/10/Location-4-150x150.png";s:5:"image";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-4.png";s:6:"height";s:3:"201";s:5:"width";s:3:"300";s:6:"target";s:1:"0";}i:12;a:11:{s:3:"url";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-5.png";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:39:"http://eakmali.com/location-de-voiture/";s:4:"sort";s:2:"17";s:13:"attachment_id";s:4:"1273";s:5:"thumb";s:68:"http://eakmali.com/wp-content/uploads/2018/10/Location-5-150x150.png";s:5:"image";s:60:"http://eakmali.com/wp-content/uploads/2018/10/Location-5.png";s:6:"height";s:3:"343";s:5:"width";s:3:"524";s:6:"target";s:1:"0";}}s:18:"home_mobile_slider";a:2:{i:0;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"18";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"19";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}s:15:"home_image_menu";a:2:{i:0;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"20";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"21";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}s:26:"home_custom_carousel_items";a:2:{i:0;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"22";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"23";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}s:9:"icon_menu";a:13:{i:0;a:12:{s:6:"icon_o";s:12:"icon-basket2";s:3:"url";s:0:"";s:5:"title";s:12:"How to Order";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"24";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:12:{s:6:"icon_o";s:10:"icon-cart4";s:3:"url";s:0:"";s:5:"title";s:13:"Best Products";s:11:"description";s:0:"";s:4:"link";s:28:"http://eakmali.com/boutique/";s:4:"sort";s:2:"25";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:2;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/logo-1.jpg";s:5:"title";s:11:"Place Order";s:11:"description";s:0:"";s:4:"link";s:28:"http://eakmali.com/boutique/";s:4:"sort";s:2:"26";s:13:"attachment_id";s:1:"9";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:3:"279";s:5:"width";s:3:"562";s:6:"target";s:1:"0";}i:3;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/k32-01.jpg";s:5:"title";s:12:"GREASE PUMPS";s:11:"description";s:0:"";s:4:"link";s:77:"http://eakmali.com/categorie-produit/macnaught/grease-equipment/grease-pumps/";s:4:"sort";s:2:"27";s:13:"attachment_id";s:4:"1068";s:5:"thumb";s:64:"http://eakmali.com/wp-content/uploads/2018/10/k32-01-150x150.jpg";s:5:"image";s:56:"http://eakmali.com/wp-content/uploads/2018/10/k32-01.jpg";s:6:"height";s:3:"500";s:5:"width";s:3:"500";s:6:"target";s:1:"0";}i:4;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:52:"http://eakmali.com/wp-content/uploads/2018/10/KY.png";s:5:"title";s:18:"GREASE ACCESSORIES";s:11:"description";s:0:"";s:4:"link";s:93:"http://eakmali.com/categorie-produit/macnaught/grease-equipment/accessories-grease-equipment/";s:4:"sort";s:2:"28";s:13:"attachment_id";s:4:"1103";s:5:"thumb";s:60:"http://eakmali.com/wp-content/uploads/2018/10/KY-150x150.png";s:5:"image";s:52:"http://eakmali.com/wp-content/uploads/2018/10/KY.png";s:6:"height";s:3:"250";s:5:"width";s:3:"250";s:6:"target";s:1:"0";}i:5;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/levaa.jpg";s:5:"title";s:21:" Handling and lifting";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/handling-and-lifting/";s:4:"sort";s:2:"29";s:13:"attachment_id";s:3:"904";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/levaa-150x150.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/levaa.jpg";s:6:"height";s:3:"163";s:5:"width";s:3:"309";s:6:"target";s:1:"0";}i:6;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/outil.jpg";s:5:"title";s:7:"Tooling";s:11:"description";s:0:"";s:4:"link";s:45:"http://eakmali.com/categorie-produit/tooling/";s:4:"sort";s:2:"30";s:13:"attachment_id";s:3:"908";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/outil-150x145.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/outil.jpg";s:6:"height";s:3:"145";s:5:"width";s:3:"348";s:6:"target";s:1:"0";}i:7;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:65:"http://eakmali.com/wp-content/uploads/2018/10/Electricites-15.png";s:5:"title";s:20:"Electrical equipment";s:11:"description";s:0:"";s:4:"link";s:58:"http://eakmali.com/categorie-produit/electrical-equipment/";s:4:"sort";s:2:"31";s:13:"attachment_id";s:4:"1257";s:5:"thumb";s:73:"http://eakmali.com/wp-content/uploads/2018/10/Electricites-15-150x150.png";s:5:"image";s:65:"http://eakmali.com/wp-content/uploads/2018/10/Electricites-15.png";s:6:"height";s:3:"500";s:5:"width";s:3:"500";s:6:"target";s:1:"0";}i:8;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:57:"http://eakmali.com/wp-content/uploads/2018/10/safetyy.jpg";s:5:"title";s:6:"Safety";s:11:"description";s:0:"";s:4:"link";s:44:"http://eakmali.com/categorie-produit/safety/";s:4:"sort";s:2:"32";s:13:"attachment_id";s:3:"912";s:5:"thumb";s:65:"http://eakmali.com/wp-content/uploads/2018/10/safetyy-150x150.jpg";s:5:"image";s:57:"http://eakmali.com/wp-content/uploads/2018/10/safetyy.jpg";s:6:"height";s:3:"267";s:5:"width";s:3:"189";s:6:"target";s:1:"0";}i:9;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:58:"http://eakmali.com/wp-content/uploads/2018/10/Divers-1.png";s:5:"title";s:7:"Various";s:11:"description";s:0:"";s:4:"link";s:45:"http://eakmali.com/categorie-produit/various/";s:4:"sort";s:2:"33";s:13:"attachment_id";s:4:"1214";s:5:"thumb";s:66:"http://eakmali.com/wp-content/uploads/2018/10/Divers-1-150x150.png";s:5:"image";s:58:"http://eakmali.com/wp-content/uploads/2018/10/Divers-1.png";s:6:"height";s:3:"588";s:5:"width";s:3:"730";s:6:"target";s:1:"0";}i:10;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:56:"http://eakmali.com/wp-content/uploads/2018/10/hydroo.jpg";s:5:"title";s:20:"Hydraulic equipement";s:11:"description";s:0:"";s:4:"link";s:50:"http://eakmali.com/categorie-produit/hydrauliques/";s:4:"sort";s:2:"34";s:13:"attachment_id";s:3:"903";s:5:"thumb";s:64:"http://eakmali.com/wp-content/uploads/2018/10/hydroo-150x150.jpg";s:5:"image";s:56:"http://eakmali.com/wp-content/uploads/2018/10/hydroo.jpg";s:6:"height";s:3:"161";s:5:"width";s:3:"313";s:6:"target";s:1:"0";}i:11;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:69:"http://eakmali.com/wp-content/uploads/2018/10/Unite-de-Mesures-16.png";s:5:"title";s:19:"measure  equipement";s:11:"description";s:0:"";s:4:"link";s:56:"http://eakmali.com/categorie-produit/measure-equipement/";s:4:"sort";s:2:"35";s:13:"attachment_id";s:4:"1265";s:5:"thumb";s:77:"http://eakmali.com/wp-content/uploads/2018/10/Unite-de-Mesures-16-150x150.png";s:5:"image";s:69:"http://eakmali.com/wp-content/uploads/2018/10/Unite-de-Mesures-16.png";s:6:"height";s:3:"373";s:5:"width";s:3:"420";s:6:"target";s:1:"0";}i:12;a:12:{s:6:"icon_o";s:0:"";s:3:"url";s:55:"http://eakmali.com/wp-content/uploads/2018/10/hydro.jpg";s:5:"title";s:17:"Parker Enterprise";s:11:"description";s:0:"";s:4:"link";s:44:"http://eakmali.com/categorie-produit/parker/";s:4:"sort";s:2:"36";s:13:"attachment_id";s:3:"902";s:5:"thumb";s:63:"http://eakmali.com/wp-content/uploads/2018/10/hydro-150x125.jpg";s:5:"image";s:55:"http://eakmali.com/wp-content/uploads/2018/10/hydro.jpg";s:6:"height";s:3:"125";s:5:"width";s:3:"402";s:6:"target";s:1:"0";}}s:18:"shop_slider_images";a:2:{i:0;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"37";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}i:1;a:11:{s:3:"url";s:0:"";s:5:"title";s:0:"";s:11:"description";s:0:"";s:4:"link";s:0:"";s:4:"sort";s:2:"38";s:13:"attachment_id";s:0:"";s:5:"thumb";s:0:"";s:5:"image";s:0:"";s:6:"height";s:0:"";s:5:"width";s:0:"";s:6:"target";s:1:"0";}}}s:9:"last_save";i:1541002820;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('536', 'kt_api_active_order', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('541', 'widget_akismet_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('549', 'external_updates-kadence-custom-fonts', 'O:8:"stdClass":3:{s:9:"lastCheck";i:1541021149;s:14:"checkedVersion";s:5:"1.0.1";s:6:"update";O:8:"stdClass":9:{s:2:"id";i:0;s:4:"slug";s:20:"kadence-custom-fonts";s:7:"version";s:5:"1.0.1";s:8:"homepage";s:59:"https://www.kadencethemes.com/product/kadence-custom-fonts/";s:12:"download_url";s:66:"https://kernl.us/api/v1/updates/5af519082deb0942d04555ef/download/";s:14:"upgrade_notice";s:54:"Upgrade this plugin for the latest features and fixes.";s:5:"icons";O:8:"stdClass":1:{s:7:"default";s:89:"https://kernl-file-uploads.s3.amazonaws.com/uploads/10-05-2018/10-16-06/icons/logo_kt.jpg";}s:8:"filename";s:45:"kadence-custom-fonts/kadence-custom-fonts.php";s:6:"tested";s:3:"4.9";}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('552', 'ksp_version', '2.2.8', 'yes'); 
INSERT INTO `mod63_options` VALUES ('554', 'external_updates-kadence-slider', 'O:8:"stdClass":3:{s:9:"lastCheck";i:1541021149;s:14:"checkedVersion";s:5:"2.2.8";s:6:"update";O:8:"stdClass":9:{s:2:"id";i:0;s:4:"slug";s:14:"kadence-slider";s:7:"version";s:5:"2.2.8";s:8:"homepage";s:0:"";s:12:"download_url";s:66:"https://kernl.us/api/v1/updates/5679e8dd6f276b6452e41eb4/download/";s:14:"upgrade_notice";s:54:"Upgrade this plugin for the latest features and fixes.";s:5:"icons";O:8:"stdClass":1:{s:7:"default";s:89:"https://kernl-file-uploads.s3.amazonaws.com/uploads/19-03-2018/06-22-58/icons/logo_kt.jpg";}s:8:"filename";s:33:"kadence-slider/kadence-slider.php";s:6:"tested";s:3:"4.0";}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('555', 'kadence_slider', 'a:6:{s:15:"font_option_one";a:2:{s:11:"font-family";s:7:"Raleway";s:11:"font-weight";s:3:"800";}s:15:"font_option_two";a:2:{s:11:"font-family";s:7:"Raleway";s:11:"font-weight";s:3:"600";}s:17:"font_option_three";a:2:{s:11:"font-family";s:7:"Raleway";s:11:"font-weight";s:3:"400";}s:16:"font_option_four";a:2:{s:11:"font-family";s:7:"Raleway";s:11:"font-weight";s:3:"300";}s:16:"font_option_five";a:2:{s:11:"font-family";s:7:"Raleway";s:11:"font-weight";s:3:"200";}s:14:"ksp_load_fonts";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('556', 'kadence_slider-transients', 'a:2:{s:14:"changed_values";a:0:{}s:9:"last_save";i:1538700599;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('565', 'external_updates-kadence-recaptcha', 'O:8:"stdClass":3:{s:9:"lastCheck";i:1541021149;s:14:"checkedVersion";s:5:"1.0.5";s:6:"update";O:8:"stdClass":9:{s:2:"id";i:0;s:4:"slug";s:17:"kadence-recaptcha";s:7:"version";s:5:"1.0.5";s:8:"homepage";s:64:"https://www.kadencethemes.com/products/kadence-google-recaptcha/";s:12:"download_url";s:66:"https://kernl.us/api/v1/updates/5b187815df649755e65c98d8/download/";s:14:"upgrade_notice";s:54:"Upgrade this plugin for the latest features and fixes.";s:5:"icons";N;s:8:"filename";s:39:"kadence-recaptcha/kadence-recaptcha.php";s:6:"tested";s:3:"4.0";}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('566', 'kt_recaptcha', 'a:10:{s:19:"enable_for_comments";i:1;s:16:"enable_for_login";i:0;s:22:"enable_for_woocommerce";i:1;s:11:"kt_re_theme";s:5:"light";s:10:"kt_re_size";s:6:"normal";s:10:"kt_re_type";s:5:"image";s:11:"kt_re_align";s:4:"left";s:17:"enable_permission";i:0;s:18:"enable_for_contact";i:0;s:22:"enable_for_testimonial";i:0;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('567', 'kt_recaptcha-transients', 'a:2:{s:14:"changed_values";a:0:{}s:9:"last_save";i:1538701314;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('581', 'product_cat_slider', 'a:12:{i:0;b:0;i:17;a:0:{}i:27;a:0:{}i:31;a:0:{}i:32;a:0:{}i:30;a:0:{}i:89;a:0:{}i:90;a:0:{}i:87;a:0:{}i:93;a:0:{}i:88;a:0:{}i:91;a:0:{}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('582', 'portfolio_cat_image', 'a:12:{i:0;b:0;i:17;a:0:{}i:27;a:0:{}i:31;a:0:{}i:32;a:0:{}i:30;a:0:{}i:89;a:0:{}i:90;a:0:{}i:87;a:0:{}i:93;a:0:{}i:88;a:0:{}i:91;a:0:{}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('583', 'kad_cat_title', 'a:12:{i:0;b:0;i:17;a:0:{}i:27;a:0:{}i:31;a:1:{s:18:"archive_show_title";s:7:"default";}i:32;a:1:{s:18:"archive_show_title";s:7:"default";}i:30;a:1:{s:18:"archive_show_title";s:7:"default";}i:89;a:1:{s:18:"archive_show_title";s:7:"default";}i:90;a:1:{s:18:"archive_show_title";s:7:"default";}i:87;a:1:{s:18:"archive_show_title";s:7:"default";}i:93;a:1:{s:18:"archive_show_title";s:7:"default";}i:88;a:1:{s:18:"archive_show_title";s:7:"default";}i:91;a:1:{s:18:"archive_show_title";s:7:"default";}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('584', 'nav_menu_options', 'a:2:{i:0;b:0;s:8:"auto_add";a:1:{i:0;i:17;}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('622', 'aioseop_options', 'a:94:{s:16:"aiosp_home_title";s:8:"Eak Mali";s:22:"aiosp_home_description";s:157:"Pour tous vos besoin en Quincaillerie Outillages, Hydrauliques, Electricites, Manutentions et levages, Mesures, Safety,Pompes de Craissages et divers



";s:20:"aiosp_togglekeywords";s:1:"1";s:19:"aiosp_home_keywords";s:0:"";s:26:"aiosp_use_static_home_info";s:1:"0";s:9:"aiosp_can";s:2:"on";s:30:"aiosp_no_paged_canonical_links";s:0:"";s:31:"aiosp_customize_canonical_links";s:2:"on";s:20:"aiosp_rewrite_titles";s:1:"1";s:20:"aiosp_force_rewrites";s:1:"1";s:24:"aiosp_use_original_title";s:1:"0";s:28:"aiosp_home_page_title_format";s:12:"%page_title%";s:23:"aiosp_page_title_format";s:27:"%page_title% | %blog_title%";s:23:"aiosp_post_title_format";s:27:"%post_title% | %blog_title%";s:27:"aiosp_category_title_format";s:31:"%category_title% | %blog_title%";s:26:"aiosp_archive_title_format";s:30:"%archive_title% | %blog_title%";s:23:"aiosp_date_title_format";s:21:"%date% | %blog_title%";s:25:"aiosp_author_title_format";s:23:"%author% | %blog_title%";s:22:"aiosp_tag_title_format";s:20:"%tag% | %blog_title%";s:25:"aiosp_search_title_format";s:23:"%search% | %blog_title%";s:24:"aiosp_description_format";s:13:"%description%";s:22:"aiosp_404_title_format";s:45:"Rien n’a été trouvé pour %request_words%";s:18:"aiosp_paged_format";s:14:" - Part %page%";s:17:"aiosp_enablecpost";s:2:"on";s:17:"aiosp_cpostactive";a:4:{i:0;s:4:"post";i:1;s:4:"page";i:2;s:7:"product";i:3;s:10:"shop_order";}s:19:"aiosp_cpostadvanced";s:2:"on";s:18:"aiosp_cpostnoindex";s:0:"";s:19:"aiosp_cpostnofollow";s:0:"";s:17:"aiosp_cposttitles";s:0:"";s:21:"aiosp_posttypecolumns";a:3:{i:0;s:4:"post";i:1;s:4:"page";i:2;s:7:"product";}s:19:"aiosp_google_verify";s:43:"21_jmb_GIGuRll0b1Ss2c7opfvezypLwkYMDnUTnMEM";s:17:"aiosp_bing_verify";s:32:"B06AA59091BE54761B110CE4827064CA";s:22:"aiosp_pinterest_verify";s:0:"";s:22:"aiosp_google_publisher";s:0:"";s:28:"aiosp_google_disable_profile";s:0:"";s:29:"aiosp_google_sitelinks_search";s:0:"";s:26:"aiosp_google_set_site_name";s:0:"";s:30:"aiosp_google_specify_site_name";s:0:"";s:28:"aiosp_google_author_advanced";s:1:"0";s:28:"aiosp_google_author_location";a:1:{i:0;s:3:"all";}s:29:"aiosp_google_enable_publisher";s:2:"on";s:30:"aiosp_google_specify_publisher";s:0:"";s:25:"aiosp_google_analytics_id";s:0:"";s:25:"aiosp_ga_advanced_options";s:2:"on";s:15:"aiosp_ga_domain";s:0:"";s:21:"aiosp_ga_multi_domain";s:0:"";s:21:"aiosp_ga_addl_domains";s:0:"";s:21:"aiosp_ga_anonymize_ip";s:0:"";s:28:"aiosp_ga_display_advertising";s:0:"";s:22:"aiosp_ga_exclude_users";s:0:"";s:29:"aiosp_ga_track_outbound_links";s:0:"";s:25:"aiosp_ga_link_attribution";s:0:"";s:27:"aiosp_ga_enhanced_ecommerce";s:0:"";s:20:"aiosp_use_categories";s:0:"";s:26:"aiosp_use_tags_as_keywords";s:2:"on";s:32:"aiosp_dynamic_postspage_keywords";s:2:"on";s:22:"aiosp_category_noindex";s:2:"on";s:26:"aiosp_archive_date_noindex";s:2:"on";s:28:"aiosp_archive_author_noindex";s:2:"on";s:18:"aiosp_tags_noindex";s:0:"";s:20:"aiosp_search_noindex";s:0:"";s:17:"aiosp_404_noindex";s:0:"";s:17:"aiosp_tax_noindex";s:0:"";s:23:"aiosp_paginated_noindex";s:0:"";s:24:"aiosp_paginated_nofollow";s:0:"";s:27:"aiosp_generate_descriptions";s:0:"";s:18:"aiosp_skip_excerpt";s:0:"";s:20:"aiosp_run_shortcodes";s:0:"";s:33:"aiosp_hide_paginated_descriptions";s:0:"";s:32:"aiosp_dont_truncate_descriptions";s:0:"";s:19:"aiosp_schema_markup";s:2:"on";s:20:"aiosp_unprotect_meta";s:0:"";s:33:"aiosp_redirect_attachement_parent";s:0:"";s:14:"aiosp_ex_pages";s:0:"";s:20:"aiosp_post_meta_tags";s:0:"";s:20:"aiosp_page_meta_tags";s:0:"";s:21:"aiosp_front_meta_tags";s:0:"";s:20:"aiosp_home_meta_tags";s:0:"";s:12:"aiosp_do_log";s:0:"";s:19:"last_active_version";s:5:"2.9.1";s:29:"aiosp_attachment_title_format";s:27:"%post_title% | %blog_title%";s:31:"aiosp_oembed_cache_title_format";s:27:"%post_title% | %blog_title%";s:31:"aiosp_user_request_title_format";s:27:"%post_title% | %blog_title%";s:28:"aiosp_portfolio_title_format";s:27:"%post_title% | %blog_title%";s:26:"aiosp_product_title_format";s:27:"%post_title% | %blog_title%";s:36:"aiosp_product_variation_title_format";s:27:"%post_title% | %blog_title%";s:29:"aiosp_shop_order_title_format";s:27:"%post_title% | %blog_title%";s:36:"aiosp_shop_order_refund_title_format";s:27:"%post_title% | %blog_title%";s:30:"aiosp_shop_coupon_title_format";s:27:"%post_title% | %blog_title%";s:26:"aiosp_kt_font_title_format";s:27:"%post_title% | %blog_title%";s:28:"aiosp_kadslider_title_format";s:27:"%post_title% | %blog_title%";s:30:"aiosp_testimonial_title_format";s:27:"%post_title% | %blog_title%";s:24:"aiosp_staff_title_format";s:27:"%post_title% | %blog_title%";s:7:"modules";a:3:{s:29:"aiosp_feature_manager_options";a:7:{s:36:"aiosp_feature_manager_enable_sitemap";s:2:"on";s:38:"aiosp_feature_manager_enable_opengraph";s:2:"on";s:35:"aiosp_feature_manager_enable_robots";s:2:"on";s:40:"aiosp_feature_manager_enable_file_editor";s:0:"";s:46:"aiosp_feature_manager_enable_importer_exporter";s:2:"on";s:39:"aiosp_feature_manager_enable_bad_robots";s:2:"on";s:40:"aiosp_feature_manager_enable_performance";s:2:"on";}s:21:"aiosp_sitemap_options";a:58:{s:24:"aiosp_sitemap_daily_cron";s:5:"daily";s:21:"aiosp_sitemap_indexes";s:0:"";s:23:"aiosp_sitemap_max_posts";s:5:"50000";s:23:"aiosp_sitemap_posttypes";a:8:{i:0;s:3:"all";i:1;s:4:"post";i:2;s:4:"page";i:3;s:10:"attachment";i:4;s:9:"portfolio";i:5;s:7:"product";i:6;s:11:"testimonial";i:7;s:5:"staff";}s:24:"aiosp_sitemap_taxonomies";a:11:{i:0;s:3:"all";i:1;s:8:"category";i:2;s:8:"post_tag";i:3;s:11:"post_format";i:4;s:14:"portfolio-type";i:5;s:13:"portfolio-tag";i:6;s:11:"product_cat";i:7;s:11:"product_tag";i:8;s:22:"product_shipping_class";i:9;s:17:"testimonial-group";i:10;s:11:"staff-group";}s:21:"aiosp_sitemap_archive";s:0:"";s:20:"aiosp_sitemap_author";s:0:"";s:20:"aiosp_sitemap_images";s:0:"";s:21:"aiosp_sitemap_gzipped";s:2:"on";s:20:"aiosp_sitemap_robots";s:2:"on";s:21:"aiosp_sitemap_rewrite";s:2:"on";s:24:"aiosp_sitemap_addl_pages";a:0:{}s:29:"aiosp_sitemap_excl_categories";s:0:"";s:24:"aiosp_sitemap_excl_pages";s:0:"";s:27:"aiosp_sitemap_prio_homepage";s:2:"no";s:23:"aiosp_sitemap_prio_post";s:2:"no";s:29:"aiosp_sitemap_prio_post_staff";s:2:"no";s:35:"aiosp_sitemap_prio_post_testimonial";s:2:"no";s:31:"aiosp_sitemap_prio_post_product";s:2:"no";s:33:"aiosp_sitemap_prio_post_portfolio";s:2:"no";s:34:"aiosp_sitemap_prio_post_attachment";s:2:"no";s:28:"aiosp_sitemap_prio_post_page";s:2:"no";s:28:"aiosp_sitemap_prio_post_post";s:2:"no";s:29:"aiosp_sitemap_prio_taxonomies";s:2:"no";s:41:"aiosp_sitemap_prio_taxonomies_staff-group";s:2:"no";s:47:"aiosp_sitemap_prio_taxonomies_testimonial-group";s:2:"no";s:52:"aiosp_sitemap_prio_taxonomies_product_shipping_class";s:2:"no";s:41:"aiosp_sitemap_prio_taxonomies_product_tag";s:2:"no";s:41:"aiosp_sitemap_prio_taxonomies_product_cat";s:2:"no";s:43:"aiosp_sitemap_prio_taxonomies_portfolio-tag";s:2:"no";s:44:"aiosp_sitemap_prio_taxonomies_portfolio-type";s:2:"no";s:41:"aiosp_sitemap_prio_taxonomies_post_format";s:2:"no";s:38:"aiosp_sitemap_prio_taxonomies_post_tag";s:2:"no";s:38:"aiosp_sitemap_prio_taxonomies_category";s:2:"no";s:26:"aiosp_sitemap_prio_archive";s:2:"no";s:25:"aiosp_sitemap_prio_author";s:2:"no";s:27:"aiosp_sitemap_freq_homepage";s:6:"always";s:23:"aiosp_sitemap_freq_post";s:6:"always";s:29:"aiosp_sitemap_freq_post_staff";s:2:"no";s:35:"aiosp_sitemap_freq_post_testimonial";s:2:"no";s:31:"aiosp_sitemap_freq_post_product";s:2:"no";s:33:"aiosp_sitemap_freq_post_portfolio";s:2:"no";s:34:"aiosp_sitemap_freq_post_attachment";s:2:"no";s:28:"aiosp_sitemap_freq_post_page";s:2:"no";s:28:"aiosp_sitemap_freq_post_post";s:2:"no";s:29:"aiosp_sitemap_freq_taxonomies";s:6:"always";s:41:"aiosp_sitemap_freq_taxonomies_staff-group";s:2:"no";s:47:"aiosp_sitemap_freq_taxonomies_testimonial-group";s:2:"no";s:52:"aiosp_sitemap_freq_taxonomies_product_shipping_class";s:2:"no";s:41:"aiosp_sitemap_freq_taxonomies_product_tag";s:2:"no";s:41:"aiosp_sitemap_freq_taxonomies_product_cat";s:2:"no";s:43:"aiosp_sitemap_freq_taxonomies_portfolio-tag";s:2:"no";s:44:"aiosp_sitemap_freq_taxonomies_portfolio-type";s:2:"no";s:41:"aiosp_sitemap_freq_taxonomies_post_format";s:2:"no";s:38:"aiosp_sitemap_freq_taxonomies_post_tag";s:2:"no";s:38:"aiosp_sitemap_freq_taxonomies_category";s:2:"no";s:26:"aiosp_sitemap_freq_archive";s:2:"no";s:25:"aiosp_sitemap_freq_author";s:2:"no";}s:24:"aiosp_bad_robots_options";a:7:{s:27:"aiosp_bad_robots_block_bots";s:2:"on";s:28:"aiosp_bad_robots_block_refer";s:2:"on";s:29:"aiosp_bad_robots_track_blocks";s:2:"on";s:28:"aiosp_bad_robots_edit_blocks";s:0:"";s:26:"aiosp_bad_robots_blocklist";s:1587:"Abonti
aggregator
AhrefsBot
asterias
BDCbot
BLEXBot
BuiltBotTough
Bullseye
BunnySlippers
ca-crawler
CCBot
Cegbfeieh
CheeseBot
CherryPicker
CopyRightCheck
cosmos
Crescent
discobot
DittoSpyder
DotBot
Download Ninja
EasouSpider
EmailCollector
EmailSiphon
EmailWolf
EroCrawler
Exabot
ExtractorPro
Fasterfox
FeedBooster
Foobot
Genieo
grub-client
Harvest
hloader
httplib
HTTrack
humanlinks
ieautodiscovery
InfoNaviRobot
IstellaBot
Java/1.
JennyBot
k2spider
Kenjin Spider
Keyword Density/0.9
larbin
LexiBot
libWeb
libwww
LinkextractorPro
linko
LinkScan/8.1a Unix
LinkWalker
LNSpiderguy
lwp-trivial
magpie
Mata Hari
MaxPointCrawler
MegaIndex
Microsoft URL Control
MIIxpc
Mippin
Missigua Locator
Mister PiX
MJ12bot
moget
MSIECrawler
NetAnts
NICErsPRO
Niki-Bot
NPBot
Nutch
Offline Explorer
Openfind
panscient.com
PHP/5.{
ProPowerBot/2.14
ProWebWalker
Python-urllib
QueryN Metasearch
RepoMonkey
SISTRIX
sitecheck.Internetseer.com
SiteSnagger
SnapPreviewBot
Sogou
SpankBot
spanner
spbot
Spinn3r
suzuran
Szukacz/1.4
Teleport
Telesoft
The Intraformant
TheNomad
TightTwatBot
Titan
toCrawl/UrlDispatcher
True_Robot
turingos
TurnitinBot
UbiCrawler
UnisterBot
URLy Warning
VCI
WBSearchBot
Web Downloader/6.9
Web Image Collector
WebAuto
WebBandit
WebCopier
WebEnhancer
WebmasterWorldForumBot
WebReaper
WebSauger
Website Quester
Webster Pro
WebStripper
WebZip
Wotbox
wsr-agent
WWW-Collector-E
Xenu
Zao
Zeus
ZyBORG
coccoc
Incutio
lmspider
memoryBot
serf
Unknown
uptime files";s:26:"aiosp_bad_robots_referlist";s:469:"semalt.com
kambasoft.com
savetubevideo.com
buttons-for-website.com
sharebutton.net
soundfrost.org
srecorder.com
softomix.com
softomix.net
myprintscreen.com
joinandplay.me
fbfreegifts.com
openmediasoft.com
zazagames.org
extener.org
openfrost.com
openfrost.net
googlsucks.com
best-seo-offer.com
buttons-for-your-website.com
www.Get-Free-Traffic-Now.com
best-seo-solution.com
buy-cheap-online.info
site3.free-share-buttons.com
webmaster-traffic.com";s:28:"aiosp_bad_robots_blocked_log";s:1040:"2018-10-29 20:32:36 Robot avec IP 185.244.39.4 bloqué - correspondance avec l’agent utilisateur Python-urllib/3.6 trouvé dans la liste de blocage.
2018-10-22 15:03:12 Robot avec IP 200.0.60.173 bloqué - correspondance avec l’agent utilisateur Mozilla/5.0 (Unknown; Linux x86_64) AppleWebKit/538.1 (KHTML, like Gecko) PhantomJS/2.1.1 Safari/538.1 trouvé dans la liste de blocage.
2018-10-21 01:56:10 Robot avec IP 198.199.77.34 bloqué - correspondance avec l’agent utilisateur Java/1.8.0_45 trouvé dans la liste de blocage.
2018-10-18 15:27:13 Robot avec IP 118.219.252.198 bloqué - correspondance avec l’agent utilisateur Python-urllib/2.7 trouvé dans la liste de blocage.
2018-10-14 15:24:43 Robot avec IP 5.196.76.206 bloqué - correspondance avec l’agent utilisateur Apache-HttpClient/4.5.5 (Java/1.8.0_181) trouvé dans la liste de blocage.
2018-10-06 10:07:32 Robot avec IP 182.228.197.133 bloqué - correspondance avec l’agent utilisateur Apache-HttpClient/4.5.3 (Java/1.8.0_171) trouvé dans la liste de blocage.
";}}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('634', '_transient_timeout_wc_shipping_method_count_1_1538662053', '1541328774', 'no'); 
INSERT INTO `mod63_options` VALUES ('635', '_transient_wc_shipping_method_count_1_1538662053', '2', 'no'); 
INSERT INTO `mod63_options` VALUES ('693', 'sm_rewrite_done', '$Id: sitemap-loader.php 937300 2014-06-23 18:04:11Z arnee $', 'yes'); 
INSERT INTO `mod63_options` VALUES ('694', 'sm_options', 'a:52:{s:18:"sm_b_prio_provider";s:41:"GoogleSitemapGeneratorPrioByCountProvider";s:9:"sm_b_ping";b:1;s:10:"sm_b_stats";b:0;s:12:"sm_b_pingmsn";b:1;s:12:"sm_b_autozip";b:1;s:11:"sm_b_memory";s:0:"";s:9:"sm_b_time";i:-1;s:18:"sm_b_style_default";b:1;s:10:"sm_b_style";s:0:"";s:12:"sm_b_baseurl";s:0:"";s:11:"sm_b_robots";b:1;s:9:"sm_b_html";b:1;s:12:"sm_b_exclude";a:0:{}s:17:"sm_b_exclude_cats";a:0:{}s:10:"sm_in_home";b:1;s:11:"sm_in_posts";b:1;s:15:"sm_in_posts_sub";b:0;s:11:"sm_in_pages";b:1;s:10:"sm_in_cats";b:1;s:10:"sm_in_arch";b:0;s:10:"sm_in_auth";b:0;s:10:"sm_in_tags";b:0;s:9:"sm_in_tax";a:1:{i:0;s:11:"product_cat";}s:17:"sm_in_customtypes";a:0:{}s:13:"sm_in_lastmod";b:1;s:10:"sm_cf_home";s:5:"daily";s:11:"sm_cf_posts";s:6:"weekly";s:11:"sm_cf_pages";s:6:"weekly";s:10:"sm_cf_cats";s:5:"daily";s:10:"sm_cf_auth";s:6:"weekly";s:15:"sm_cf_arch_curr";s:5:"daily";s:14:"sm_cf_arch_old";s:6:"yearly";s:10:"sm_cf_tags";s:6:"weekly";s:10:"sm_pr_home";d:1;s:11:"sm_pr_posts";d:0.59999999999999998;s:15:"sm_pr_posts_min";d:0.20000000000000001;s:11:"sm_pr_pages";d:0.59999999999999998;s:10:"sm_pr_cats";d:0.29999999999999999;s:10:"sm_pr_arch";d:0.29999999999999999;s:10:"sm_pr_auth";d:0.29999999999999999;s:10:"sm_pr_tags";d:0.29999999999999999;s:12:"sm_i_donated";b:0;s:17:"sm_i_hide_donated";b:0;s:17:"sm_i_install_date";i:1538745710;s:16:"sm_i_hide_survey";b:0;s:14:"sm_i_hide_note";b:0;s:15:"sm_i_hide_works";b:0;s:16:"sm_i_hide_donors";b:0;s:9:"sm_i_hash";s:20:"c12d067b2bb2c17ed1cf";s:13:"sm_i_lastping";i:1541011985;s:16:"sm_i_supportfeed";b:1;s:22:"sm_i_supportfeed_cache";i:1540650572;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('706', 'sm_status', 'O:28:"GoogleSitemapGeneratorStatus":4:{s:39:" GoogleSitemapGeneratorStatus startTime";d:1541011985.130533;s:37:" GoogleSitemapGeneratorStatus endTime";d:1541011985.452148;s:41:" GoogleSitemapGeneratorStatus pingResults";a:2:{s:6:"google";a:5:{s:9:"startTime";d:1541011985.135608;s:7:"endTime";d:1541011985.202101;s:7:"success";b:1;s:3:"url";s:93:"http://www.google.com/webmasters/sitemaps/ping?sitemap=http%3A%2F%2Feakmali.com%2Fsitemap.xml";s:4:"name";s:6:"Google";}s:4:"bing";a:5:{s:9:"startTime";d:1541011985.2059419;s:7:"endTime";d:1541011985.44309;s:7:"success";b:1;s:3:"url";s:86:"http://www.bing.com/webmaster/ping.aspx?siteMap=http%3A%2F%2Feakmali.com%2Fsitemap.xml";s:4:"name";s:4:"Bing";}}s:38:" GoogleSitemapGeneratorStatus autoSave";b:1;}', 'no'); 
INSERT INTO `mod63_options` VALUES ('761', 'gmwd_created_tables', '1', 'no'); 
INSERT INTO `mod63_options` VALUES ('762', 'widget_gmwd_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('767', 'aiosp_sitemap_cron_last_run', '1541020638', 'yes'); 
INSERT INTO `mod63_options` VALUES ('768', 'gmwd_admin_notice', 'a:1:{s:15:"two_week_review";a:2:{s:5:"start";s:10:"10/19/2018";s:3:"int";i:14;}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('780', 'widget_srmgmap_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('781', 'wpgmap_api_key', 'AIzaSyC_6HPbjW3II0yGkp8H37nhswBmoPn1AB0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('787', 'woocommerce_checkout_address_2_field', 'optional', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1041', 'woocommerce_tracker_ua', 'a:3:{i:0;s:115:"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/69.0.3497.100 safari/537.36";i:1;s:114:"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/51.0.2704.79 safari/537.36";i:2;s:114:"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/70.0.3538.77 safari/537.36";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1110', 'dc_wech_activate', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1111', 'dc_wech_email_list_cc', 'ousmane@eakmali.com', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1112', 'dc_wech_email_list_bcc', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1113', 'dc_wech_new_order', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1114', 'dc_wech_cancelled_order', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1115', 'dc_wech_failed_order', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1116', 'dc_wech_processing_order', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1117', 'dc_wech_completed_order', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1118', 'dc_wech_refunded_order', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1119', 'dc_wech_customer_new_account', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1120', 'dc_wech_customer_on_hold', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1121', 'dc_wech_customer_invoice', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1122', 'dc_wech_activate_bookings', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1123', 'dc_wech_new_booking', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1124', 'dc_wech_booking_reminder', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1125', 'dc_wech_booking_confirmed', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1126', 'dc_wech_booking_notification', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1127', 'dc_wech_booking_cancelled', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1128', 'dc_wech_admin_booking_cancelled', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1140', 'GTranslate', 'a:21:{s:11:"pro_version";s:0:"";s:18:"enterprise_version";s:0:"";s:15:"url_translation";s:0:"";s:17:"add_hreflang_tags";s:0:"";s:10:"new_window";s:0:"";s:12:"show_in_menu";s:18:"primary_navigation";s:26:"floating_language_selector";s:2:"no";s:21:"native_language_names";s:0:"";s:9:"analytics";i:1;s:23:"detect_browser_language";i:1;s:12:"add_new_line";i:1;s:16:"default_language";s:2:"en";s:18:"translation_method";s:5:"onfly";s:11:"widget_look";s:10:"flags_code";s:9:"flag_size";i:24;s:11:"widget_code";s:2686:"<!-- GTranslate: https://gtranslate.io/ -->
<a href="#" onclick="doGTranslate(\'en|en\');return false;" title="English" class="glink nturl notranslate"><img src="//eakmali.com/wp-content/plugins/gtranslate/flags/24/en.png" height="24" width="24" alt="English" /> <span>EN</span></a> <a href="#" onclick="doGTranslate(\'en|fr\');return false;" title="French" class="glink nturl notranslate"><img src="//eakmali.com/wp-content/plugins/gtranslate/flags/24/fr.png" height="24" width="24" alt="French" /> <span>FR</span></a> <style type="text/css">
#goog-gt-tt {display:none !important;}
.goog-te-banner-frame {display:none !important;}
.goog-te-menu-value:hover {text-decoration:none !important;}
.goog-text-highlight {background-color:transparent !important;box-shadow:none !important;}
body {top:0 !important;}
#google_translate_element2 {display:none!important;}
</style>

<div id="google_translate_element2"></div>
<script type="text/javascript">
function googleTranslateElementInit2() {new google.translate.TranslateElement({pageLanguage: \'en\',autoDisplay: false}, \'google_translate_element2\');}
</script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit2"></script>


<script type="text/javascript">
function GTranslateGetCurrentLang() {var keyValue = document[\'cookie\'].match(\'(^|;) ?googtrans=([^;]*)(;|$)\');return keyValue ? keyValue[2].split(\'/\')[2] : null;}
function GTranslateFireEvent(element,event){try{if(document.createEventObject){var evt=document.createEventObject();element.fireEvent(\'on\'+event,evt)}else{var evt=document.createEvent(\'HTMLEvents\');evt.initEvent(event,true,true);element.dispatchEvent(evt)}}catch(e){}}
function doGTranslate(lang_pair){if(lang_pair.value)lang_pair=lang_pair.value;if(lang_pair==\'\')return;var lang=lang_pair.split(\'|\')[1];if(GTranslateGetCurrentLang() == null && lang == lang_pair.split(\'|\')[0])return;if(typeof ga!=\'undefined\'){ga(\'send\', \'event\', \'GTranslate\', lang, location.hostname+location.pathname+location.search);}else{if(typeof _gaq!=\'undefined\')_gaq.push([\'_trackEvent\', \'GTranslate\', lang, location.hostname+location.pathname+location.search]);}var teCombo;var sel=document.getElementsByTagName(\'select\');for(var i=0;i<sel.length;i++)if(/goog-te-combo/.test(sel[i].className)){teCombo=sel[i];break;}if(document.getElementById(\'google_translate_element2\')==null||document.getElementById(\'google_translate_element2\').innerHTML.length==0||teCombo.length==0||teCombo.innerHTML.length==0){setTimeout(function(){doGTranslate(lang_pair)},500)}else{teCombo.value=lang;GTranslateFireEvent(teCombo,\'change\');GTranslateFireEvent(teCombo,\'change\')}}
</script>
";s:10:"incl_langs";a:10:{i:0;s:2:"ar";i:1;s:5:"zh-CN";i:2;s:2:"nl";i:3;s:2:"en";i:4;s:2:"fr";i:5;s:2:"de";i:6;s:2:"it";i:7;s:2:"pt";i:8;s:2:"ru";i:9;s:2:"es";}s:11:"fincl_langs";a:2:{i:0;s:2:"en";i:1;s:2:"fr";}s:9:"alt_flags";a:0:{}s:14:"language_codes";s:320:"af,sq,am,ar,hy,az,eu,be,bn,bs,bg,ca,ceb,ny,zh-CN,zh-TW,co,hr,cs,da,nl,en,eo,et,tl,fi,fr,fy,gl,ka,de,el,gu,ht,ha,haw,iw,hi,hmn,hu,is,ig,id,ga,it,ja,jw,kn,kk,km,ko,ku,ky,lo,la,lv,lt,lb,mk,mg,ms,ml,mt,mi,mr,mn,my,ne,no,ps,fa,pl,pt,pa,ro,ru,sm,gd,sr,st,sn,sd,si,sk,sl,so,es,su,sw,sv,tg,ta,te,th,tr,uk,ur,uz,vi,cy,xh,yi,yo,zu";s:15:"language_codes2";s:320:"af,sq,am,ar,hy,az,eu,be,bn,bs,bg,ca,ceb,ny,zh-CN,zh-TW,co,hr,cs,da,nl,en,eo,et,tl,fi,fr,fy,gl,ka,de,el,gu,ht,ha,haw,iw,hi,hmn,hu,is,ig,id,ga,it,ja,jw,kn,kk,km,ko,ku,ky,lo,la,lv,lt,lb,mk,mg,ms,ml,mt,mi,mr,mn,my,ne,no,ps,fa,pl,pt,pa,ro,ru,sm,gd,sr,st,sn,sd,si,sk,sl,so,es,su,sw,sv,tg,ta,te,th,tr,uk,ur,uz,vi,cy,xh,yi,yo,zu";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1141', 'widget_gtranslate', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1142', 'gtranslate_admin_notice', 'a:3:{s:15:"two_week_review";a:3:{s:5:"start";s:10:"10/16/2018";s:3:"int";i:5;s:9:"dismissed";i:1;}s:12:"upgrade_tips";a:3:{s:5:"start";s:10:"10/13/2018";s:3:"int";i:2;s:9:"dismissed";i:1;}s:42:"deactivate_plugin_googlelanguagetranslator";a:2:{s:5:"start";s:10:"10/21/2018";s:3:"int";i:0;}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1823', 'ipages_flipbook_db_version', '1.0.0', 'no'); 
INSERT INTO `mod63_options` VALUES ('1824', 'ipages_flipbook_activated', '1539391336', 'no'); 
INSERT INTO `mod63_options` VALUES ('1960', 's_pdf_options', 'a:3:{s:17:"doc_width_percent";s:1:"1";s:10:"doc_height";s:0:"";s:9:"bttn_text";s:24:"Download (Télécharger)";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1967', 'pdf-light-viewer-show-post-type', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1968', 'pdf-light-viewer-pointers-viewed', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('1982', 'mod63_fb3d_pages_version', '1.1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('2357', 'portfolio-type_children', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('2368', '_transient_timeout_wc_shipping_method_count_0_1538662053', '1542304555', 'no'); 
INSERT INTO `mod63_options` VALUES ('2369', '_transient_wc_shipping_method_count_0_1538662053', '2', 'no'); 
INSERT INTO `mod63_options` VALUES ('2885', 'woocommerce_db_version', '3.4.7', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3088', '_transient_wc_attribute_taxonomies', 'a:1:{i:0;O:8:"stdClass":6:{s:12:"attribute_id";s:1:"1";s:14:"attribute_name";s:5:"poids";s:15:"attribute_label";s:5:"Poids";s:14:"attribute_type";s:6:"select";s:17:"attribute_orderby";s:10:"menu_order";s:16:"attribute_public";s:1:"0";}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3273', '_transient_timeout_wc_product_children_1092', '1542553524', 'no'); 
INSERT INTO `mod63_options` VALUES ('3274', '_transient_wc_product_children_1092', 'a:2:{s:3:"all";a:10:{i:0;i:1118;i:1;i:1109;i:2;i:1110;i:3;i:1111;i:4;i:1112;i:5;i:1113;i:6;i:1114;i:7;i:1115;i:8;i:1116;i:9;i:1117;}s:7:"visible";a:10:{i:0;i:1118;i:1;i:1109;i:2;i:1110;i:3;i:1111;i:4;i:1112;i:5;i:1113;i:6;i:1114;i:7;i:1115;i:8;i:1116;i:9;i:1117;}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('3275', '_transient_timeout_wc_var_prices_1092', '1542701391', 'no'); 
INSERT INTO `mod63_options` VALUES ('3276', '_transient_wc_var_prices_1092', '{"version":"1540084707","a3847c1e86986982a33e7c39f445d565":{"price":{"1118":"0","1109":"0","1110":"0","1111":"0","1112":"0","1113":"0","1114":"0","1115":"0","1116":"0","1117":"0"},"regular_price":{"1118":"0","1109":"0","1110":"0","1111":"0","1112":"0","1113":"0","1114":"0","1115":"0","1116":"0","1117":"0"},"sale_price":{"1118":"0","1109":"0","1110":"0","1111":"0","1112":"0","1113":"0","1114":"0","1115":"0","1116":"0","1117":"0"}}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('3277', '_transient_timeout_wc_child_has_weight_1092', '1542553524', 'no'); 
INSERT INTO `mod63_options` VALUES ('3278', '_transient_wc_child_has_weight_1092', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('3279', '_transient_timeout_wc_child_has_dimensions_1092', '1542553524', 'no'); 
INSERT INTO `mod63_options` VALUES ('3280', '_transient_wc_child_has_dimensions_1092', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('3406', 'mtouchquiz_leftdelimit', '\\(\\displaystyle{', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3407', 'mtouchquiz_rightdelimit', '}\\)', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3408', 'mtouchquiz_showalerts', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3409', 'mtouchquiz_show_support', 'true', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3410', 'mtouchquiz_ordering_set', '0', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3411', 'mtouchquiz_color', 'blue', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3412', 'mtouchquiz_db_version', '1.6.5.4', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3941', '_transient_orders-transient-version', '1540067998', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3942', '_transient_timeout_wc_cbp_e8e4fbf894c303f11f65aaf1d0b03e3a', '1542659998', 'no'); 
INSERT INTO `mod63_options` VALUES ('3943', '_transient_wc_cbp_e8e4fbf894c303f11f65aaf1d0b03e3a', 'a:0:{}', 'no'); 
INSERT INTO `mod63_options` VALUES ('3987', '_transient_wc_count_comments', 'O:8:"stdClass":7:{s:14:"total_comments";i:2;s:3:"all";i:2;s:8:"approved";s:1:"2";s:9:"moderated";i:0;s:4:"spam";i:0;s:5:"trash";i:0;s:12:"post-trashed";i:0;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('3992', '_transient_timeout_wc_products_onsale', '1542676907', 'no'); 
INSERT INTO `mod63_options` VALUES ('3993', '_transient_wc_products_onsale', 'a:0:{}', 'no'); 
INSERT INTO `mod63_options` VALUES ('3994', '_transient_timeout_wc_term_counts', '1542858931', 'no'); 
INSERT INTO `mod63_options` VALUES ('3995', '_transient_wc_term_counts', 'a:76:{i:34;s:1:"2";i:37;s:2:"15";i:43;s:0:"";i:53;s:1:"0";i:54;s:0:"";i:93;s:0:"";i:89;s:1:"2";i:33;s:1:"6";i:31;s:2:"25";i:38;s:0:"";i:41;s:0:"";i:39;s:2:"10";i:113;s:0:"";i:90;s:2:"11";i:35;s:2:"12";i:32;s:2:"30";i:42;s:0:"";i:88;s:0:"";i:95;s:2:"55";i:91;s:0:"";i:15;s:1:"2";i:56;s:0:"";i:97;s:0:"";i:36;s:2:"10";i:40;s:0:"";i:44;s:0:"";i:30;s:0:"";i:92;s:0:"";i:87;s:0:"";i:103;s:1:"1";i:111;s:1:"1";i:108;s:1:"1";i:104;s:1:"1";i:105;s:1:"1";i:79;s:1:"1";i:71;s:1:"1";i:76;s:1:"1";i:75;s:1:"2";i:107;s:1:"2";i:112;s:1:"1";i:68;s:1:"1";i:80;s:1:"1";i:98;s:1:"1";i:99;s:1:"1";i:100;s:1:"1";i:109;s:1:"1";i:110;s:1:"1";i:102;s:1:"1";i:101;s:1:"1";i:106;s:1:"1";i:114;s:1:"1";i:63;s:1:"1";i:61;s:1:"1";i:60;s:1:"1";i:72;s:1:"1";i:59;s:1:"2";i:58;s:1:"1";i:65;s:1:"1";i:70;s:1:"1";i:78;s:1:"1";i:64;s:1:"1";i:77;s:1:"1";i:81;s:1:"1";i:115;s:1:"1";i:117;s:1:"1";i:66;s:1:"1";i:69;s:1:"1";i:73;s:1:"1";i:74;s:1:"1";i:116;s:1:"1";i:83;s:1:"1";i:82;s:1:"1";i:62;s:1:"1";i:86;s:1:"1";i:85;s:1:"1";i:84;s:1:"1";}', 'no'); 
INSERT INTO `mod63_options` VALUES ('4029', 'googlelanguagetranslator_active', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4030', 'googlelanguagetranslator_language', 'en', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4031', 'googlelanguagetranslator_flags', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4032', 'language_display_settings', 'a:2:{s:2:"en";s:1:"1";s:2:"fr";s:1:"1";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4033', 'googlelanguagetranslator_translatebox', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4034', 'googlelanguagetranslator_display', 'Vertical', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4035', 'googlelanguagetranslator_toolbar', 'Yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4036', 'googlelanguagetranslator_showbranding', 'Yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4037', 'googlelanguagetranslator_flags_alignment', 'flags_right', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4038', 'googlelanguagetranslator_analytics', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4039', 'googlelanguagetranslator_analytics_id', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4040', 'googlelanguagetranslator_css', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4041', 'googlelanguagetranslator_multilanguage', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4042', 'googlelanguagetranslator_floating_widget', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4043', 'googlelanguagetranslator_flag_size', '18', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4044', 'googlelanguagetranslator_flags_order', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4045', 'googlelanguagetranslator_english_flag_choice', 'us_flag', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4046', 'googlelanguagetranslator_spanish_flag_choice', 'spanish_flag', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4047', 'googlelanguagetranslator_portuguese_flag_choice', 'portuguese_flag', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4048', 'googlelanguagetranslator_floating_widget_text', 'Translate »', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4049', 'googlelanguagetranslator_floating_widget_text_allow_translation', '1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4050', 'widget_glt_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4051', 'glt_language_switcher_width', '100%', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4052', 'glt_language_switcher_text_color', '#32373c', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4053', 'glt_language_switcher_bg_color', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4054', 'glt_floating_widget_position', 'bottom_left', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4055', 'glt_floating_widget_text_color', '#ffffff', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4056', 'glt_floating_widget_bg_color', '#f89406', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4061', 'wpTranslateOptions', 'a:6:{s:16:"default_language";s:2:"en";s:14:"exclude_mobile";b:1;s:12:"auto_display";b:1;s:11:"tracking_id";s:0:"";s:16:"tracking_enabled";b:0;s:14:"upgrade_notice";a:2:{s:5:"count";i:0;s:4:"date";s:10:"2018-10-26";}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4062', 'widget_wp_translation_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4127', '_transient_timeout_wc_low_stock_count', '1542719698', 'no'); 
INSERT INTO `mod63_options` VALUES ('4128', '_transient_wc_low_stock_count', '0', 'no'); 
INSERT INTO `mod63_options` VALUES ('4129', '_transient_timeout_wc_outofstock_count', '1542719698', 'no'); 
INSERT INTO `mod63_options` VALUES ('4130', '_transient_wc_outofstock_count', '0', 'no'); 
INSERT INTO `mod63_options` VALUES ('4316', 'woocommerce_flat_rate_3_settings', 'a:3:{s:5:"title";s:7:"Forfait";s:10:"tax_status";s:7:"taxable";s:4:"cost";s:1:"0";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4321', 'woocommerce_google_analytics_settings', 'a:16:{s:5:"ga_id";s:14:"UA-127875993-1";s:18:"ga_set_domain_name";s:0:"";s:28:"ga_standard_tracking_enabled";s:2:"no";s:30:"ga_support_display_advertising";s:2:"no";s:36:"ga_support_enhanced_link_attribution";s:2:"no";s:26:"ga_use_universal_analytics";s:2:"no";s:20:"ga_anonymize_enabled";s:3:"yes";s:23:"ga_404_tracking_enabled";s:3:"yes";s:29:"ga_ecommerce_tracking_enabled";s:3:"yes";s:25:"ga_event_tracking_enabled";s:3:"yes";s:38:"ga_enhanced_ecommerce_tracking_enabled";s:2:"no";s:36:"ga_enhanced_remove_from_cart_enabled";s:3:"yes";s:38:"ga_enhanced_product_impression_enabled";s:3:"yes";s:33:"ga_enhanced_product_click_enabled";s:3:"yes";s:39:"ga_enhanced_product_detail_view_enabled";s:3:"yes";s:36:"ga_enhanced_checkout_process_enabled";s:3:"yes";}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4343', 'product_cat_children', 'a:4:{i:95;a:6:{i:0;i:30;i:1;i:31;i:2;i:32;i:3;i:53;i:4;i:54;i:5;i:56;}i:32;a:4:{i:0;i:33;i:1;i:34;i:2;i:35;i:3;i:36;}i:31;a:5:{i:0;i:37;i:1;i:38;i:2;i:39;i:3;i:40;i:4;i:41;}i:30;a:3:{i:0;i:42;i:1;i:43;i:2;i:44;}}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4365', 'widget_metaslider_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4366', 'ms_hide_all_ads_until', '1541441729', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4367', 'metaslider_systemcheck', 'a:2:{s:16:"wordPressVersion";b:0;s:12:"imageLibrary";b:0;}', 'no'); 
INSERT INTO `mod63_options` VALUES ('4370', 'ml-slider_children', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4488', 'siteorigin_panels_settings', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4489', 'siteorigin_panels_initial_version', '2.9.0', 'no'); 
INSERT INTO `mod63_options` VALUES ('4490', 'siteorigin_panels_active_version', '2.9.1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4491', 'widget_siteorigin-panels-post-content', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4492', 'widget_siteorigin-panels-postloop', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4493', 'widget_siteorigin-panels-builder', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4494', 'widget_kadence_tabs_content_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4500', 'widget_sow-button', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4501', 'widget_sow-google-map', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4502', 'widget_sow-image', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4503', 'widget_sow-slider', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4504', 'widget_sow-post-carousel', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4505', 'widget_sow-editor', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4506', 'siteorigin_widget_bundle_version', '1.13.2', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4507', 'siteorigin_widgets_old_widgets', '/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/accordion/accordion.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/button/button.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/cta/cta.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/contact/contact.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/editor/editor.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/features/features.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/google-map/google-map.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/headline/headline.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/hero/hero.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/icon/icon.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/image/image.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/image-grid/image-grid.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/slider/slider.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/layout-slider/layout-slider.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/post-carousel/post-carousel.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/price-table/price-table.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/simple-masonry/simple-masonry.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/social-media-buttons/social-media-buttons.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/tabs/tabs.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/taxonomy/taxonomy.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/testimonial/testimonial.php,/home/eakmalicgb/www/wp-content/plugins/so-widgets-bundle/widgets/video/video.php', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4524', 'wc_settings_simple_woocommerce_catalog_addtocart', 'display', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4525', 'wc_settings_simple_woocommerce_catalog_showprices', 'hide', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4526', 'wc_settings_simple_woocommerce_catalog_showratings', 'display', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4527', 'wc_settings_simple_woocommerce_catalog_showreviews', 'display', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4528', 'wc_settings_simple_woocommerce_catalog_pricetext', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4529', 'wc_settings_simple_woocommerce_catalog_pricetextlink', '7', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4530', 'wc_settings_simple_woocommerce_catalog_hidecart', 'display', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4531', 'wc_settings_simple_woocommerce_catalog_hidecheckout', 'display', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4534', '_transient_timeout_wc_shipping_method_count_1_1540220560', '1542844750', 'no'); 
INSERT INTO `mod63_options` VALUES ('4535', '_transient_wc_shipping_method_count_1_1540220560', '3', 'no'); 
INSERT INTO `mod63_options` VALUES ('4545', 'wc_settings_tab_visibility_title', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4546', 'wc_settings_tab_product_price_disable_product', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4547', 'wc_settings_tab_product_cart_button', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4548', 'wc_settings_tab_product_add_to_cart', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4558', 'wc_settings_checkbox_hide_add_cart', 'no', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4559', 'wc_settings_hide_add_to_cart_category', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4560', 'wc_settings_checkbox_hide_prices', 'yes', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4561', 'wc_settings_hide_prices_category', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('4562', 'wc_settings_custom_prices_text', 'Contact us for prices', 'yes'); 
INSERT INTO `mod63_options` VALUES ('5245', '_transient_timeout_feed_d21d2a68bac70d38fb7f9a7bd3d1725e', '1541255372', 'no'); 
INSERT INTO `mod63_options` VALUES ('5246', '_transient_feed_d21d2a68bac70d38fb7f9a7bd3d1725e', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:5:"

	
	";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:371:"

		
		
		
		
		
		
		

		
		
			
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

							
		
	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:53:"WordPress.org Forums » [Google XML Sitemaps] Support";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"https://wordpress.org/support/plugin/google-sitemap-generator/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 27 Oct 2018 14:20:51 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:37:"https://bbpress.org/?v=2.6-alpha-6091";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:30:{i:0;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/support/topic/how-do-i-exclude-a-webpage/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:27:"How do I exclude a webpage?";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/support/topic/how-do-i-exclude-a-webpage/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 25 Oct 2018 08:49:56 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:471:"
						
						<p>Replies: 1</p>
						<p>There is a box to include pages but where is the box to exclude pages?</p>


<ul id="bbp-topic-revision-log-10814378" class="bbp-topic-revision-log">

	<li id="bbp-topic-revision-log-10814378-item-10814379" class="bbp-topic-revision-log-item">
		This topic was modified 2 days, 5 hours ago by <a href="https://wordpress.org/support/users/a4jpcom/" title="View a4jp . com&#039;s profile">a4jp . com</a>.
	</li>

</ul>

						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"a4jp . com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:92:"https://wordpress.org/support/topic/sitemap-contains-urls-which-are-blocked-by-robots-txt-6/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"Sitemap contains urls which are blocked by robots.txt.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:92:"https://wordpress.org/support/topic/sitemap-contains-urls-which-are-blocked-by-robots-txt-6/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 23 Oct 2018 10:19:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:502:"
						
						<p>Replies: 1</p>
						<p>Hi,</p>
<p>I have this error:</p>
<p>Sitemap contains urls which are blocked by robots.txt.</p>
<p>Here is the link to sitemap:</p>
<p><a href="https://wallpaperscart.com/sitemap.xml" rel="nofollow">https://wallpaperscart.com/sitemap.xml</a></p>
<p>And here is the link to robots.txt:</p>
<p><a href="https://wallpaperscart.com/robots.txt" rel="nofollow">https://wallpaperscart.com/robots.txt</a></p>
<p>Thanks in advance,<br />
Wallpapers Cart</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"wallpaperscarts";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:71:"https://wordpress.org/support/topic/im-confused-about-notifying-google/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:45:"I&amp;#8217;m confused about notifying Google";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:71:"https://wordpress.org/support/topic/im-confused-about-notifying-google/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 19 Oct 2018 18:45:45 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:648:"
						
						<p>Replies: 0</p>
						<p>I installed an activated this plugin since I read that that&#8217;s all you had to do to get it working. Looking at the Settings page, I see &#8220;Search engines haven&#8217;t been notified yet. Write a post to let them know about your sitemap.&#8221; so apparently there IS more than what was suggested.</p>
<p>I don&#8217;t have posts on my site, just static pages. Where is this post supposed to go?</p>
<p>When I go to the Google Search Console to verify, I&#8217;m instructed to download a google*.html file. Is this something I need in addition to your plugin?</p>
<p>Please clarify.</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"davids58";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:75:"https://wordpress.org/support/topic/generated-html-page-shows-blog-content/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:39:"Generated HTML page shows blog content?";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:75:"https://wordpress.org/support/topic/generated-html-page-shows-blog-content/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 14 Oct 2018 04:29:23 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:553:"
						
						<p>Replies: 0</p>
						<p>The generated .html page shows an XML page with content from recent blog posts&#8230; but no internal links.</p>
<p>I have disabled &#8220;Include sitemap in HTML format&#8221;. </p>
<p>And the xml content starts like:</p>
<p>&lt;channel&gt;<br />
	&lt;title&gt;Page not found &#8211; Bobs Plumbing Inc.&lt;/title&gt;</p>
<p>I would rather there be no index.html page if it is going to show strange content like this. How do I disable or fix this? Or is this how it is supposed to be presenting?</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"imaginemonkey";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:51:"https://wordpress.org/support/topic/old-sitemaps-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:12:"Old Sitemaps";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"https://wordpress.org/support/topic/old-sitemaps-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 10 Oct 2018 17:19:50 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:565:"
						
						<p>Replies: 0</p>
						<p>Hi,</p>
<p>This is such a smashing plugin!</p>
<p>I have a small issue&#8230;</p>
<p>The sitemaps generated are generating sitemaps that go way back to 2014?</p>
<p>How do I delete these so they show only recent ones i.e. 2018 please?</p>
<p>It&#8217;s creating all sorts of issues with spiders and bots looking for URL&#8217;s that don&#8217;t exist anymore?</p>
<p>Many Thanks</p>
<p><em>[ <a href="https://wordpress.org/support/guidelines/#do-not-bump-posts" rel="nofollow">Please do not bump.</a> ]</em></p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Rik0399";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:52:"https://wordpress.org/support/topic/bug-with-wpml-5/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:13:"bug with WPML";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"https://wordpress.org/support/topic/bug-with-wpml-5/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 10 Oct 2018 12:18:47 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:323:"
						
						<p>Replies: 0</p>
						<p>I have WPML with 2 languages but the 2nd lang is switch off, this is the /sitemap-home.xml</p>
<p>mystite.com?lang=1<br />
mystite.com?lang=2<br />
mystite.com?lang=3<br />
mystite.com?lang=4<br />
&#8230; </p>
<p>is mad!!!</p>
<p>There is a solution?</p>
<p>Thanks</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"entest1661";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:98:"https://wordpress.org/support/topic/how-do-i-exclude-a-category-from-the-xml-sitemap-in-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"How do I exclude a category from the XML sitemap in WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:98:"https://wordpress.org/support/topic/how-do-i-exclude-a-category-from-the-xml-sitemap-in-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 03 Oct 2018 22:55:35 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:898:"
						
						<p>Replies: 0</p>
						<p>i have a lot of Draft Pages in my wordpress CMS. There are too many to go through to mark as exclude.  They are all in one category.  I want to<strong> not </strong>place a specific category (or taxonomy, which ever is easier) in my XML sitemap.  The reason is, Google will index Draft and private pages and I don&#8217;t want that because they will come up 404.</p>
<p>How do I exclude a category from the XML sitemap in WordPress with this plugin</p>
<p>What do I put in the Functions.php file ?</p>


<ul id="bbp-topic-revision-log-10747955" class="bbp-topic-revision-log">

	<li id="bbp-topic-revision-log-10747955-item-10747956" class="bbp-topic-revision-log-item">
		This topic was modified 3 weeks, 2 days ago by <a href="https://wordpress.org/support/users/rgranlund/" title="View rgranlund&#039;s profile">rgranlund</a>.
	</li>

</ul>

						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"rgranlund";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:58:"https://wordpress.org/support/topic/sitemap-index-pending/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"Sitemap Index Pending";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:58:"https://wordpress.org/support/topic/sitemap-index-pending/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 03 Oct 2018 18:31:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1564:"
						
						<p>Replies: 0</p>
						<p>I will try and be as thorough as I can be here.</p>
<p>I was using Yoast SEO&#8217;s site map for a very long time. However, I found a few bugs and issues so I decided to DEACTIVATE and go with Google XML MAPS.</p>
<p>Heres what is odd:</p>
<p>I checked and at <a href="https://www.usedpart.us/robots.txt" rel="nofollow">https://www.usedpart.us/robots.txt</a> nothing is blocked on there at all.</p>
<p>So I go to my search console as well as Bing Webmaster Tools:</p>
<p>I input &#8220;https://www.usedpart.us/sitemap.xml&#8221; for almost 8 days now just says pending.</p>
<p>I have 21,380 or so urls. So, I go and remove the usedpart.us/sitemap.xml url, and replace with all the sub folders of the sitemap. Now, it shows how many urls were submitted per each folder in the site map, but pending (I know it take a day or two)</p>
<p>Heres where I&#8217;m confused: why didn&#8217;t it even show how many urls were submitted when I just put the <a href="https://www.usedpart.us/sitemap.xml" rel="nofollow">https://www.usedpart.us/sitemap.xml</a>?</p>
<p>I did notice one of the sitemap folders had almost 14k urls, should or could I break those into other folders to reduce the amount or does that not matter?</p>
<p>I would send a screen shot of all options I have selected on my settings, but it doesnt give me the ability. The upload sitemap into virtual robots.txt is UNCHECKED because in my FTP files I have a robots.txt.</p>
<p>Should I remove and reinstall the plug in? Anyone see this this before?</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"usedpartus";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/support/topic/site-map-showing-as-plain-text-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"site map showing as plain text";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/support/topic/site-map-showing-as-plain-text-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 03 Oct 2018 16:27:15 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:119:"
						
						<p>Replies: 1</p>
						<p>hi<br />
Site map generated shows like a plain text, plz help</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"qashifbashir";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:78:"https://wordpress.org/support/topic/sitemap-html-submitted-url-marked-noindex/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:47:"sitemap.html Submitted URL marked ‘noindex’";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:78:"https://wordpress.org/support/topic/sitemap-html-submitted-url-marked-noindex/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 28 Sep 2018 03:59:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:865:"
						
						<p>Replies: 2</p>
						<p>I have face one error in Google Search Console<br />
So please provide appropriate solution for how can we solved this error message.</p>
<p>Error message is: &#8220;Submitted URL marked ‘noindex’&#8221; in sitemap.html</p>
<p>Thanks</p>


<ul id="bbp-topic-revision-log-10731399" class="bbp-topic-revision-log">

	<li id="bbp-topic-revision-log-10731399-item-10731400" class="bbp-topic-revision-log-item">
		This topic was modified 4 weeks, 1 day ago by <a href="https://wordpress.org/support/users/csem/" title="View csem&#039;s profile">csem</a>.
	</li>
	<li id="bbp-topic-revision-log-10731399-item-10731402" class="bbp-topic-revision-log-item">
		This topic was modified 4 weeks, 1 day ago by <a href="https://wordpress.org/support/users/csem/" title="View csem&#039;s profile">csem</a>.
	</li>

</ul>

						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"csem";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:59:"https://wordpress.org/support/topic/sitemap-html-not-index/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:22:"sitemap.html not index";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"https://wordpress.org/support/topic/sitemap-html-not-index/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 26 Sep 2018 09:19:58 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:328:"
						
						<p>Replies: 1</p>
						<p>I have facing one issue in sitemap.html</p>
<p>Why sitemap.html is &lt;meta name=&#8221;robots&#8221; content=&#8221;noindex,follow&#8221; /&gt;</p>
<p>I have checked your plugin file and removed this line </p>
<p>So can you please tell me it is ok or not</p>
<p>Thanks </p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"csem";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:71:"https://wordpress.org/support/topic/tag-site-map-error-no-tag-indexing/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:35:"Tag Site Map Error/ No Tag Indexing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:71:"https://wordpress.org/support/topic/tag-site-map-error-no-tag-indexing/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 24 Sep 2018 07:42:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:143:"
						
						<p>Replies: 2</p>
						<p>Dear plugin unable to create tag sitemap please do the need full as soon as possible </p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"sandeeprana51";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:66:"https://wordpress.org/support/topic/error-with-custom-mysql-ports/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:29:"Error with custom mysql ports";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:66:"https://wordpress.org/support/topic/error-with-custom-mysql-ports/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 18 Sep 2018 21:09:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:991:"
						
						<p>Replies: 0</p>
						<p>If you use custom ports for the mysql server different than 3306, the plugin will fail creating the sitemap.</p>
<p>The error can be found in the line 1881 of file sitemap-core.php in the following line:</p>
<p>$con = mysqli_connect(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);</p>
<p>Usually, if you use custom mysql ports you can add it to the global define DB_HOST like &#8216;localhost:20001&#8217; and wordpress will work fine. The problem is mysqli_connect will accept the custom port as a parameter after DB_NAME. To fix this issue I replaced this line by:</p>
<p>$db_host = DB_HOST;<br />
$db_port = 3306;<br />
if (strpos($db_host, &#8216;:&#8217;)!==false) {<br />
    $arr_host = explode(&#8216;:&#8217;,$db_host);<br />
    $db_host = $arr_host[0];<br />
    $db_port = $arr_host[1];<br />
}<br />
$con = mysqli_connect($db_host,DB_USER,DB_PASSWORD,DB_NAME,$db_port);</p>
<p>I hope this info helps someone with the same problem.</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"danielvispoblog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:79:"https://wordpress.org/support/topic/sitemap-works-with-https-but-not-https-www/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:47:"sitemap works with https:// but not https://www";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:79:"https://wordpress.org/support/topic/sitemap-works-with-https-but-not-https-www/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 17 Sep 2018 01:54:29 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:721:"
						
						<p>Replies: 1</p>
						<p>Hello!</p>
<p>This plugin always worked for me, however today, I found out the sitemap is working here:<br />
<a href="https://newmatnorcal.com/sitemap.xml" rel="nofollow">https://newmatnorcal.com/sitemap.xml</a></p>
<p>But not here:<br />
<a href="https://www.newmatnorcal.com/sitemap.xml" rel="nofollow">https://www.newmatnorcal.com/sitemap.xml</a></p>
<p>I get:<br />
&#8220;Error loading stylesheet: An unknown error has occurred (805303f4)&#8221;</p>
<p>Wordpress is installed in a sub-directory&#8230; I do not wish to Override the base URL of the sitemap, I wish to appear in both locations 🙂</p>
<p>Thanks for your help and Best Regards,<br />
Philippe</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"phdsigns";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:51:"https://wordpress.org/support/topic/html-sitemap-4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:12:"HTML Sitemap";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"https://wordpress.org/support/topic/html-sitemap-4/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 16 Sep 2018 22:04:20 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:277:"
						
						<p>Replies: 0</p>
						<p>I would like an HTML page of the sitemap as part of my site.<br />
&#8221; Include sitemap in HTML format (The required PHP XSL Module is not installed)&#8221;<br />
How do I get and install the required PHP XSL Module?</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"JuliaClark";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:15;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:54:"https://wordpress.org/support/topic/white-dashboard-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"White Dashboard";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:54:"https://wordpress.org/support/topic/white-dashboard-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 15 Sep 2018 04:19:39 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:340:"
						
						<p>Replies: 0</p>
						<p>Hi there,<br />
I have a crazy problem. I use your plugin for years on this site and many others. Only on this site, until now, my Dashboard turn complete white, there are no content if I turn on your plugin? I turned off all plugins to find out, then I turned on one by one&#8230; </p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"lindebjerg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:16;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:60:"https://wordpress.org/support/topic/adding-users-to-sitemap/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:24:"Adding users to sitemap.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"https://wordpress.org/support/topic/adding-users-to-sitemap/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 14 Sep 2018 22:18:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1177:"
						
						<p>Replies: 0</p>
						<p>We have various roles for the users of the wordpress website. Google XML Sitemaps has option for adding user to sitemap only if they are authors. But I want users with the role of “professional” be added to sitemap even if they are not authors. Google XML Sitemaps adds my professionals only if they wrote something that is if they are also author. How can I do that?</p>
<p>In my web site professionals have various categories. For example one of the categories is “psychiatrist” and a “professional” user’s url is “https://mywebsite.com/psychiatrist/john-doe/”.<br />
There are other users which are not professionals they are users with other roles and I don’t want them to be added to sitemap. For example such a user with other roles has url like this:<br />
“https://mywebsite.com/user/george-michael/” (User detail page slug is “user”). </p>
<p>“Users Sitemap &amp; Archive &#8211; WordPress Plugin” claims that it adds users to sitemap. Is it possible to use “Users Sitemap &amp; Archive &#8211; WordPress Plugin” and Google XML Sitemaps together?<br />
Thanks for your help.</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"ersoyma";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:17;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:57:"https://wordpress.org/support/topic/disable-sub-sitemaps/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"Disable sub-sitemaps?";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:57:"https://wordpress.org/support/topic/disable-sub-sitemaps/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 14 Sep 2018 08:48:42 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:961:"
						
						<p>Replies: 0</p>
						<p>Hi,<br />
currently in my sitemap.xml there are following sub items:</p>
<p>sitemap-misc.xml<br />
sitemap-pt-portfolio-2018-09.xml<br />
sitemap-pt-portfolio-2018-08.xml<br />
sitemap-pt-portfolio-2018-02.xml<br />
sitemap-pt-page-2018-06.xml</p>
<p>How can I just have all items in that one main sitemap.xml?<br />
Also, why are the portfolio items seperated in different xmls? How can I change that?<br />
Also, since there was no note whatsoever but it is correct to disable the Sitemap on Jetpack, right? Otherwise only that sitemap is displayed?</p>
<p>Thanks!</p>


<ul id="bbp-topic-revision-log-10687592" class="bbp-topic-revision-log">

	<li id="bbp-topic-revision-log-10687592-item-10687597" class="bbp-topic-revision-log-item">
		This topic was modified 1 month, 1 week ago by <a href="https://wordpress.org/support/users/kotanji/" title="View Kotanji&#039;s profile">Kotanji</a>.
	</li>

</ul>

						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Kotanji";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:18;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:61:"https://wordpress.org/support/topic/sitemap-not-showing-up-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"Sitemap Not Showing Up!";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:61:"https://wordpress.org/support/topic/sitemap-not-showing-up-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 14 Sep 2018 03:50:40 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1789:"
						
						<p>Replies: 0</p>
						<p>Hello there. I have installed the plugin on my client&#8217;s site that was recently converted to SSL. My hosting support team assures me that the permalinks have all been reset, but for some reason I am not finding an actual sitemap when I click the sitemap links. I see your screenshot examples have a sitemap as the third screenshot. Why does my site not have the actual sitemap please? What am I doing wrong here??</p>
<p>Please see my screencaps below:</p>
<p><a href="https://www.postmahomeimprovements.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-11-at-1.20.24-PM-copy.png" target="_blank" rel="noopener noreferrer" rel="nofollow">https://www.postmahomeimprovements.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-11-at-1.20.24-PM-copy.png</a></p>
<p><a href="https://www.postmahomeimprovements.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-11-at-1.19.53-PM-copy.png" rel="noopener noreferrer" target="_blank" rel="nofollow">https://www.postmahomeimprovements.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-11-at-1.19.53-PM-copy.png</a></p>
<p><a href="https://www.postmahomeimprovements.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-13-at-11.30.53-PM-copy.png" rel="noopener noreferrer" target="_blank" rel="nofollow">https://www.postmahomeimprovements.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-13-at-11.30.53-PM-copy.png</a></p>
<p>I should see a page like this&#8230; Shouldn&#8217;t I?<br />
<a href="https://www.postmahomeimprovements.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-13-at-10.46.44-PM-copy.png" rel="noopener noreferrer" target="_blank" rel="nofollow">https://www.postmahomeimprovements.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-13-at-10.46.44-PM-copy.png</a></p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"auralanoue";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:19;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:49:"https://wordpress.org/support/topic/old-sitemaps/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:12:"Old Sitemaps";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:49:"https://wordpress.org/support/topic/old-sitemaps/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 10 Sep 2018 16:05:40 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:515:"
						
						<p>Replies: 0</p>
						<p>Hi,</p>
<p>First,</p>
<p>Thanks for this plugin, far better than yoast (IMO)</p>
<p>One issue please&#8230;</p>
<p>The plugin seems to generate sitemaps from two years ago?  Since then of course, many of my links have changed etc and as a result it seems, spiders/bots are picking these up and pinging my site for them which of course are not there i.e. 404 problem.</p>
<p>How do I update the sitemaps so the old ones are dropped please?</p>
<p>Many Thanks</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Rik0399";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:20;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:79:"https://wordpress.org/support/topic/single-sitemap-for-main-site-and-subfolder/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:42:"Single sitemap for main site and subfolder";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:79:"https://wordpress.org/support/topic/single-sitemap-for-main-site-and-subfolder/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 10 Sep 2018 14:35:45 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:746:"
						
						<p>Replies: 1</p>
						<p>Hi,</p>
<p>I&#8217;m running a multisite installation with WordPress. </p>
<p>I have created a main site at the domain and a second site in a subfolder of the main site at /news.</p>
<p>For both sites I&#8217;ve used the &#8220;Google XML sitemap generator&#8221; plugin to successfully create sitemaps.</p>
<p>Is there a way to include the sitemap for the second site (the one in the subfolder, /news) in the sitemap of the main site?</p>
<p>I&#8217;ve tried to use the &#8220;Additional pages&#8221; option, by manually adding the URL /news/ to the sitemap of the main site, but it seems to be adding only one page, not the entire sitemap.</p>
<p>Thanks for your support!</p>
<p>massimo</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"mbortolotto";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:21;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:84:"https://wordpress.org/support/topic/i-cant-add-new-urls-on-additional-pages-section/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:80:"I can&amp;#8217;t add new URLs on &amp;#8220;Additional Pages&amp;#8221; section";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:84:"https://wordpress.org/support/topic/i-cant-add-new-urls-on-additional-pages-section/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 08 Sep 2018 10:00:40 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:543:"
						
						<p>Replies: 0</p>
						<p>Hello, I can&#8217;t add new URLs to &#8220;Additional Pages&#8221; section. It stopped working a few days ago. Can you help please?</p>


<ul id="bbp-topic-revision-log-10669176" class="bbp-topic-revision-log">

	<li id="bbp-topic-revision-log-10669176-item-10669177" class="bbp-topic-revision-log-item">
		This topic was modified 1 month, 2 weeks ago by <a href="https://wordpress.org/support/users/anwarhossain/" title="View anwarhossain&#039;s profile">anwarhossain</a>.
	</li>

</ul>

						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"anwarhossain";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:22;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:53:"https://wordpress.org/support/topic/no-sitemap-files/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"No sitemap files";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:53:"https://wordpress.org/support/topic/no-sitemap-files/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 06 Sep 2018 11:47:51 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:186:"
						
						<p>Replies: 1</p>
						<p>Hi, </p>
<p>I have loaded the plugin, but I am getting an empty file. </p>
<p>I&#8217;ve reset permalinks.</p>
<p>Any thoughts? </p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"gcooke";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:23;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:53:"https://wordpress.org/support/topic/ping-time-format/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"Ping time format";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:53:"https://wordpress.org/support/topic/ping-time-format/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 05 Sep 2018 12:03:19 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:184:"
						
						<p>Replies: 0</p>
						<p>New installation. Time format for ping missing colon?</p>
<p>Result of the last ping, started on 2018-09-05 18:5258 WIB. (sic)</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Malae";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:24;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:74:"https://wordpress.org/support/topic/how-can-i-create-google-news-site-map/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:38:"How can I create Google News Site Map?";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:74:"https://wordpress.org/support/topic/how-can-i-create-google-news-site-map/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 31 Aug 2018 13:40:21 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:135:"
						
						<p>Replies: 1</p>
						<p>I want to create Google News Sitemap, is it possible on your plugin to do so?</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Mantosh Pal";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:25;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/support/topic/page-sitemap-get-error-500/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:26:"Page sitemap get error 500";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/support/topic/page-sitemap-get-error-500/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 25 Aug 2018 08:52:17 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:657:"
						
						<p>Replies: 0</p>
						<p><a href="http://hdvix.com/sitemap-pt-post-2018-08.xml" rel="nofollow">http://hdvix.com/sitemap-pt-post-2018-08.xml</a></p>
<p>&#8220;http://hdvix.com/sitemap-pt-post-2018-08.xml&#8221; get error 500 and google index = 0</p>
<p>Please help me!</p>


<ul id="bbp-topic-revision-log-10623371" class="bbp-topic-revision-log">

	<li id="bbp-topic-revision-log-10623371-item-10623372" class="bbp-topic-revision-log-item">
		This topic was modified 2 months ago by <a href="https://wordpress.org/support/users/nguyentrungcuong/" title="View nguyentrungcuong&#039;s profile">nguyentrungcuong</a>.
	</li>

</ul>

						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"nguyentrungcuong";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:26;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:105:"https://wordpress.org/support/topic/url-to-my-sitemap-index-file-is-showing-my-dev-urls-not-my-live-site/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:70:"URL to my sitemap index file is showing my Dev urls. Not my live site.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:105:"https://wordpress.org/support/topic/url-to-my-sitemap-index-file-is-showing-my-dev-urls-not-my-live-site/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 24 Aug 2018 19:57:37 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:243:"
						
						<p>Replies: 2</p>
						<p>I downloaded the plugin and and clicked on url that contains my sitemap. All the urls that are listed include dev infront of the URLS, it is also stating http, when it should be https. </p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"awiggz20";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:27;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:52:"https://wordpress.org/support/topic/too-many-urls-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:13:"Too many URLs";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"https://wordpress.org/support/topic/too-many-urls-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 18 Aug 2018 17:59:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:547:"
						
						<p>Replies: 1</p>
						<p>Hi Dear Sir,</p>
<p>i hope you are doing very well, kindly check this screen short link and tell me how can i resolve this issue?</p>
<p>1:  <a href="http://myprintscreen.com/s/vs0a/1d4d13e7c6" rel="nofollow">http://myprintscreen.com/s/vs0a/1d4d13e7c6</a><br />
2:  <a href="http://myprintscreen.com/s/vs09/05a5fc8d84" rel="nofollow">http://myprintscreen.com/s/vs09/05a5fc8d84</a></p>
<p>there was a limit for 50,000 but i have many urls so how can i create multiple sitemap?</p>
<p>Thanks</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:17:"Muhammad Jahangir";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:28;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/support/topic/exclude-category-not-posts/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:27:"Exclude category, not posts";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/support/topic/exclude-category-not-posts/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 18 Aug 2018 15:20:34 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:315:"
						
						<p>Replies: 0</p>
						<p>Hello. How can I exclude only category page and not also posts from this category? Is it possible? When I click exclude category in settings, also all the posts of this category are excluded. I want only exclude the category, but not posts in this category.</p>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"ucelme";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:29;a:6:{s:4:"data";s:67:"
					
					
					
					
					

					
					

					
					
					
				";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:94:"https://wordpress.org/support/topic/from-google-xml-to-yoast-lots-of-404-due-to-google-how-to/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:80:"From Google XML to Yoast, lot&amp;#8217;s of 404 due to Google&amp;#8230;how to?";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:94:"https://wordpress.org/support/topic/from-google-xml-to-yoast-lots-of-404-due-to-google-how-to/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 14 Aug 2018 09:41:14 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2250:"
						
						<p>Replies: 1</p>
						<p>Hy guys,</p>
<p>i still have a huge problem after switching from Google XML to Yoast. I receive on GWT a lots of error 404 and to solve the problem i have to create every time a 301 redirect. Is there a quick and nice solution to make just on redirects for all?</p>
<p>See here:</p>
<pre><code>
Redirect 301 /sitemap-pt-page-2015-06.html https://site/page-sitemap.xml
Redirect 301 /sitemap-pt-page-2015-08.xml https://site/page-sitemap.xml
Redirect 301 /sitemap-pt-page-2015-09.html https://site/page-sitemap.xml
Redirect 301 /sitemap-pt-page-2015-09.xml https://site/page-sitemap.xml
Redirect 301 /sitemap-pt-page-2015-10.html https://site/page-sitemap.xml
Redirect 301 /sitemap-pt-page-2016-03.html https://site/page-sitemap.xml
Redirect 301 /sitemap-pt-page-2017-07.xml https://site/page-sitemap.xml
Redirect 301 /sitemap-pt-page-2017-09.xml https://site/page-sitemap.xml
Redirect 301 /sitemap-pt-page-2017-10.html https://site/page-sitemap.xml
Redirect 301 /sitemap-pt-post-2015-05.html https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2015-06.html https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2015-07.html https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2015-08.html https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2015-09.html https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2015-10.xml https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2015-11.xml https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-page-2015-12.html https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2016-02.xml https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2016-03.html https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2016-04.html https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2016-07.xml https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2016-08.xml https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2016-09.html https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2017-02.xml https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2017-04.html https://site/post-sitemap.xml
Redirect 301 /sitemap-pt-post-2017-09.html https://site/post-sitemap.xml
</code></pre>
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Jedi82";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:67:"https://wordpress.org/support/plugin/google-sitemap-generator/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:42:"Requests_Utility_CaseInsensitiveDictionary":1:{s:7:" * data";a:7:{s:6:"server";s:5:"nginx";s:4:"date";s:29:"Sat, 27 Oct 2018 14:29:32 GMT";s:12:"content-type";s:34:"application/rss+xml; charset=UTF-8";s:25:"strict-transport-security";s:11:"max-age=360";s:6:"x-olaf";s:3:"⛄";s:15:"x-frame-options";s:10:"SAMEORIGIN";s:4:"x-nc";s:9:"HIT ord 1";}}s:5:"build";s:14:"20130911040210";}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5247', '_transient_timeout_feed_mod_d21d2a68bac70d38fb7f9a7bd3d1725e', '1541255372', 'no'); 
INSERT INTO `mod63_options` VALUES ('5248', '_transient_feed_mod_d21d2a68bac70d38fb7f9a7bd3d1725e', '1540650572', 'no'); 
INSERT INTO `mod63_options` VALUES ('5622', '_transient_timeout_wc_related_1217', '1541057539', 'no'); 
INSERT INTO `mod63_options` VALUES ('5623', '_transient_wc_related_1217', 'a:2:{s:52:"limit=4&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=1217";a:10:{i:0;s:4:"1211";i:1;s:4:"1212";i:2;s:4:"1218";i:3;s:4:"1219";i:4;s:4:"1221";i:5;s:4:"1222";i:6;s:4:"1223";i:7;s:4:"1224";i:8;s:4:"1225";i:9;s:4:"1227";}s:53:"limit=12&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=1217";a:10:{i:0;s:4:"1211";i:1;s:4:"1212";i:2;s:4:"1218";i:3;s:4:"1219";i:4;s:4:"1221";i:5;s:4:"1222";i:6;s:4:"1223";i:7;s:4:"1224";i:8;s:4:"1225";i:9;s:4:"1227";}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5646', '_transient_timeout_wc_related_1189', '1541073014', 'no'); 
INSERT INTO `mod63_options` VALUES ('5647', '_transient_wc_related_1189', 'a:2:{s:52:"limit=4&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=1189";a:24:{i:0;s:4:"1067";i:1;s:4:"1070";i:2;s:4:"1076";i:3;s:4:"1077";i:4;s:4:"1078";i:5;s:4:"1079";i:6;s:4:"1080";i:7;s:4:"1086";i:8;s:4:"1087";i:9;s:4:"1089";i:10;s:4:"1092";i:11;s:4:"1119";i:12;s:4:"1120";i:13;s:4:"1133";i:14;s:4:"1134";i:15;s:4:"1135";i:16;s:4:"1136";i:17;s:4:"1137";i:18;s:4:"1138";i:19;s:4:"1139";i:20;s:4:"1149";i:21;s:4:"1166";i:22;s:4:"1167";i:23;s:4:"1175";}s:53:"limit=12&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=1189";a:24:{i:0;s:4:"1067";i:1;s:4:"1070";i:2;s:4:"1076";i:3;s:4:"1077";i:4;s:4:"1078";i:5;s:4:"1079";i:6;s:4:"1080";i:7;s:4:"1086";i:8;s:4:"1087";i:9;s:4:"1089";i:10;s:4:"1092";i:11;s:4:"1119";i:12;s:4:"1120";i:13;s:4:"1133";i:14;s:4:"1134";i:15;s:4:"1135";i:16;s:4:"1136";i:17;s:4:"1137";i:18;s:4:"1138";i:19;s:4:"1139";i:20;s:4:"1149";i:21;s:4:"1166";i:22;s:4:"1167";i:23;s:4:"1175";}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5662', '_transient_timeout_sow:cleared', '1541598391', 'no'); 
INSERT INTO `mod63_options` VALUES ('5663', '_transient_sow:cleared', '1', 'no'); 
INSERT INTO `mod63_options` VALUES ('5680', '_site_transient_timeout_browser_90ff8ae6231a43c42b418e1765751722', '1541604114', 'no'); 
INSERT INTO `mod63_options` VALUES ('5681', '_site_transient_browser_90ff8ae6231a43c42b418e1765751722', 'a:10:{s:4:"name";s:6:"Chrome";s:7:"version";s:12:"70.0.3538.77";s:8:"platform";s:7:"Windows";s:10:"update_url";s:29:"https://www.google.com/chrome";s:7:"img_src";s:43:"http://s.w.org/images/browsers/chrome.png?1";s:11:"img_src_ssl";s:44:"https://s.w.org/images/browsers/chrome.png?1";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;s:6:"mobile";b:0;}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5682', '_transient_timeout_feed_2dd0202377a060f0df35cceaacc2c13c', '1541042515', 'no'); 
INSERT INTO `mod63_options` VALUES ('5683', '_transient_feed_2dd0202377a060f0df35cceaacc2c13c', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"


";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:49:"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:3:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:10:"SiteOrigin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:22:"https://siteorigin.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:21:"Free WordPress Themes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 31 Oct 2018 11:13:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:30:"https://wordpress.org/?v=4.9.8";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:42:"
		
		
		
		
		
				

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"Create a Team Page with the SiteOrigin Features Widget";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:78:"https://siteorigin.com/create-a-team-page-with-the-siteorigin-features-widget/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:87:"https://siteorigin.com/create-a-team-page-with-the-siteorigin-features-widget/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 24 Oct 2018 10:05:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:8:"Tutorial";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://siteorigin.com/?p=133084";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:494:"<p>In this tutorial, we\'ll create a simple and engaging "Meet the Team" page using Page Builder by SiteOrigin and the SiteOrigin Headline and Features Widget. Read the complete tutorial or jump ahead and use the prebuilt layout.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/create-a-team-page-with-the-siteorigin-features-widget/">Create a Team Page with the SiteOrigin Features Widget</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Andrew Misplon";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:11896:"<p>In this tutorial, we&#8217;ll create a simple and engaging &#8220;Meet the Team&#8221; page using Page Builder by SiteOrigin and the SiteOrigin Widget Bundle.</p>
<p><a href="https://demo.siteorigin.com/corp/meet-the-team/">View the demo</a><br />
<a href="#prebuilt">Jump to the prebuilt layout</a></p>
<h3>Required Plugins</h3>
<p><a href="https://wordpress.org/plugins/siteorigin-panels/">Page Builder by SiteOrigin</a><br />
<a href="https://wordpress.org/plugins/so-widgets-bundle/">SiteOrigin Widgets Bundle</a></p>
<p>Once Page Builder and the Widgets Bundle plugins are activated, go to <span class="adminized-section"><span class="adminized-part">Plugins</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">SiteOrigin Widgets</span></span> and make sure that the <strong>Headline</strong> and <strong>Features</strong> widgets are activated.</p>
<h3>Getting Started</h3>
<p>Go to Pages and edit the page you&#8217;d like to use as your team page. If you haven&#8217;t created this page yet, go to <span class="adminized-section"><span class="adminized-part">Pages</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Add New</span></span> to get started. Once editing the page, if you&#8217;re using a SiteOrigin theme, scroll to the Page Settings meta box in the right column. For our <a href="https://demo.siteorigin.com/corp/meet-the-team/">demo layout</a> we&#8217;ve set Page Layout to No Sidebar and disabled the Page Title. Adjusting page settings is optional, you&#8217;re free to set up your page as best suits your site design.</p>
<p>If you haven&#8217;t activated Page Builder on this page yet, click on the Page Builder tab and then in the Page Builder toolbar, click the Add Row button and add a single column row to your page. Repeat the process to add a second row.</p>
<h3>Adding the Widgets</h3>
<p><img class="alignnone wp-image-135011" src="https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets-699x382.jpg" alt="" width="400" height="219" srcset="https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets-699x382.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets-300x164.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets-768x420.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets-313x171.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets.jpg 927w" sizes="(max-width: 400px) 100vw, 400px" /></p>
<p>We&#8217;ve started our demo layout off with a Headline widget. To add a Headline widget, click in the first row you&#8217;ve created then click Add Widget. Once the Add Widget modal window appears, use the search field on the left to search for &#8220;headline&#8221;. Click the SiteOrigin Headline widget to insert it into the first row.</p>
<p>In the second row, we&#8217;ll be inserting the SiteOrigin Features widget. Click the second row to select it, then Add Widget. Use the search field to search for &#8220;features&#8221;. Click the SiteOrigin Features widget to insert it.</p>
<h3>Adding the Content</h3>
<h4>SiteOrigin Headline Widget</h4>
<p><img class="alignnone wp-image-135017" src="https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-headline-widget-238x300.jpg" alt="" width="400" height="504" srcset="https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-headline-widget-238x300.jpg 238w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-headline-widget-555x699.jpg 555w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-headline-widget-313x394.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-headline-widget.jpg 734w" sizes="(max-width: 400px) 100vw, 400px" /></p>
<p>We&#8217;ll start out by editing the Headline widget and then move onto the Features widget. To edit the Headline widget, hover over it and click the Edit link. We&#8217;ve used the following settings:</p>
<p><strong>Headline:</strong><br />
Text: Meet the Team<br />
HTML Tag: H1<br />
Font: Use theme font<br />
Font Size: 32px<br />
Alignment: Center</p>
<p><strong>Subheadline:</strong><br />
Text: Lorem ipsum dolor sit amet, consectetur adipiscing elit. (This is placeholder text, replace it with a sub-headline that fits your team page)<br />
HTML Tag: H2<br />
Font: Use theme font<br />
Font Size: 23px<br />
Alignment: Center</p>
<p><strong>Divider</strong><br />
Style: Solid<br />
Color: #EEEEEE<br />
Thickness: 1<br />
Alignment: Center<br />
Divider Width: 80%</p>
<p>Use FitText: Enabled<br />
FitText Compressor Strength: 0,85</p>
<p>The Headline widget isn&#8217;t necessary, you could also use the regular page title, it&#8217;s up to you.</p>
<h4>SiteOrigin Features Widget</h4>
<p><img class="alignnone wp-image-135026 size-large" src="https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-699x378.jpg" alt="" width="699" height="378" srcset="https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-699x378.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-300x162.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-768x415.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-1050x568.jpg 1050w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-313x169.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members.jpg 1345w" sizes="(max-width: 699px) 100vw, 699px" /></p>
<p>Next, we&#8217;ll add our team members using the Features widget. Hover over the widget and click Edit to get started.</p>
<p>Before adding team members, let&#8217;s take a look at the general settings used in our demo.</p>
<p><strong>Font Design</strong><br />
All settings were left at default values.</p>
<p><strong>Other Settings</strong><br />
Container shape: None<br />
Container size: 150px<br />
Icon Size: We&#8217;ve cleared this field and left it blank<br />
Features per row: 3<br />
Responsive layout: Enabled<br />
Link feature title to more URL: Disabled<br />
Link icon to more URL: Disabled<br />
Open more URL in new window: Disabled</p>
<p>You&#8217;re now ready to add your team. Click the Add link in the Features section to add your first team member. Each feature can be opened, duplicated or deleted using the icons on the right. Features can also be dragged to re-order. The settings we&#8217;ve used in each feature are as follows:</p>
<p>Container position: Top<br />
Icon image: Used for the team member&#8217;s photo. Our photos were manually resized to 300px x 300px before uploading to the Media Library.<br />
Icon image size: Full<br />
Title text: Used for the team member&#8217;s name.<br />
Text: Used for the team member description.</p>
<h3>Rounding the Profile Images Using Custom CSS</h3>
<p>Our team profile images are square. We&#8217;ve used Custom CSS to transform them into round images. Custom CSS can be added to our useful <a href="https://wordpress.org/plugins/so-css/">SiteOrigin CSS plugin</a>. To round your profile images, follow these steps:</p>
<p>1. Edit the row containing the SiteOrigin Features widget and open the Attributes section in the right column. Insert the following class name into the Row Class field:</p>
<pre class="prettyprint ">meet-the-team</pre>
<p>If you&#8217;re using the prebuilt layout provided later in this tutorial, this step isn&#8217;t necessary as the class name will already be added to the row containing the SiteOrigin Features widget.</p>
<p><img class="alignnone wp-image-135022 size-medium" src="https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name-298x300.jpg" alt="" width="298" height="300" srcset="https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name-298x300.jpg 298w, https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name-150x150.jpg 150w, https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name-313x315.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name-128x128.jpg 128w, https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name.jpg 518w" sizes="(max-width: 298px) 100vw, 298px" /></p>
<p>2. Go to <span class="adminized-section"><span class="adminized-part">Appearance</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Custom CSS</span></span> if you&#8217;re using SiteOrigin CSS plugin and insert the following rule:</p>
<pre class="prettyprint ">.meet-the-team .sow-features-feature .sow-icon-image {
border-radius: 50%;
}</pre>
<p><strong>This step is necessary even if you&#8217;re using the prebuilt layout.</strong></p>
<p><img class="alignnone wp-image-135019" src="https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule-300x122.jpg" alt="" width="400" height="163" srcset="https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule-300x122.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule-768x313.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule-699x285.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule-313x127.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule.jpg 975w" sizes="(max-width: 400px) 100vw, 400px" /></p>
<h3>Additional Features and a Helping Hand with SiteOrigin Premium</h3>
<p><a href="https://siteorigin.com/downloads/premium/">SiteOrigin Premium</a> is a plugin that adds additional settings and functionality to SiteOrigin widgets, Page Builder and SiteOrign themes. SiteOrigin Premium also includes our next level email support service. If you need expert advice and quick replies, consider SiteOrigin Premium.</p>
<h3 id="prebuilt">Using the Demo Layout</h3>
<p><a href="https://demo.siteorigin.com/corp/meet-the-team/">View the Demo</a>.<br />
<a href="https://siteorigin.com/wp-content/uploads/2018/10/meet-the-team.json">Download the demo layout (JSON file)</a>.</p>
<p>If you&#8217;d like to make use of the demo layout, follow these steps:</p>
<p>1. Download the above JSON file to your desktop.<br />
2. Go to the page you&#8217;d like to use, if you haven&#8217;t activated Page Builder on this page yet, click on the Page Builder tab and then in the Page Builder toolbar, click <span class="adminized-section"><span class="adminized-part">Layouts</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Import/Export</span></span>.<br />
3. Upload the layout file either by dragging and dropping or selecting it using the select button.<br />
4. Click the Insert button bottom right.<br />
5. To round your team images, add the following to <span class="adminized-section"><span class="adminized-part">Appearance</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Custom CSS</span></span>:</p>
<pre class="prettyprint ">.meet-the-team .sow-features-feature .sow-icon-image {
border-radius: 50%;
}</pre>
<p>* Unfortunately, the Features widget doesn&#8217;t have the option of using external image URL&#8217;s. This means that the images from the demo layout won&#8217;t be imported.</p>
<p>If you have any questions or comments, please let us know below, we&#8217;d love to hear from you.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/create-a-team-page-with-the-siteorigin-features-widget/">Create a Team Page with the SiteOrigin Features Widget</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:83:"https://siteorigin.com/create-a-team-page-with-the-siteorigin-features-widget/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:42:"
		
		
		
		
		
				

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:39:"Introducing the Toggle Visibility Addon";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://siteorigin.com/introducing-the-toggle-visibility-addon/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:72:"https://siteorigin.com/introducing-the-toggle-visibility-addon/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 15 Oct 2018 09:01:25 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"Announcements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://siteorigin.com/?p=132899";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:485:"<p>We\'re excited to announce the long-awaited Toggle Visibility addon for <a href="https://siteorigin.com/downloads/premium/">SiteOrigin Premium</a>. Toggle Visibility allows you to hide Page Builder rows and widgets based on the user\'s screen size.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/introducing-the-toggle-visibility-addon/">Introducing the Toggle Visibility Addon</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Andrew Misplon";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3373:"<p>We&#8217;re excited to announce the long-awaited Toggle Visibility addon for <a href="https://siteorigin.com/downloads/premium/">SiteOrigin Premium</a>. Once activated at <span class="adminized-section"><span class="adminized-part">SiteOrigin</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Premium Addons</span></span> you&#8217;ll see the Toggle Visibility section under Row Styles when editing a row and under Widget Styles when editing a widget. Toggle Visibility allows you to hide Page Builder rows and widgets based on the user&#8217;s screen size. </p>
<p>The following options are available:</p>
<p><strong>Hide Row/Widget</strong><br />
Enabling this option will hide the row or widget on all devices. There are a few possible applications for this setting. Perhaps you have content on a page that you’d only like published at certain times of the year. Or perhaps you’re busy adding a new row to an existing page and don’t want it published just yet.</p>
<p><strong>Hide on Desktop</strong><br />
Enabling this option will hide the row or widget on desktop.</p>
<p><strong>Hide on Tablet</strong><br />
Enabling this option will hide the row or widget on tablet.</p>
<p><strong>Hide on Mobile</strong><br />
Enabling this option will hide the row or widget on mobile.</p>
<p>By default, Page Builder sets the tablet breakpoint to <code>1024px</code> and the mobile breakpoint to <code>780px</code> These can be easily changed at <span class="adminized-section"><span class="adminized-part">Settings</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Page Builder</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Layout</span></span> using the Tablet Width and Mobile Width fields.</p>
<p><a href="https://siteorigin.com/premium-documentation/plugin-addons/toggle-visibility/">View the documentation</a>.</p>
<p>The Toggle Visibility addon is available as part of <a href="https://siteorigin.com/downloads/premium/">SiteOrigin Premium</a>, a single plugin that adds additional settings and functionality to SiteOrigin widgets, Page Builder and SiteOrign themes. SiteOrigin Premium also includes our next level email support service.</p>
<p><img src="https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon.jpg" alt="" width="2248" height="1094" class="alignnone size-full wp-image-133055" srcset="https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon.jpg 2248w, https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon-300x146.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon-768x374.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon-699x340.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon-1050x511.jpg 1050w, https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon-313x152.jpg 313w" sizes="(max-width: 2248px) 100vw, 2248px" /></p>
<p>If you have any questions, please comment below. We look forward to hearing from you.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/introducing-the-toggle-visibility-addon/">Introducing the Toggle Visibility Addon</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:68:"https://siteorigin.com/introducing-the-toggle-visibility-addon/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"7";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:42:"
		
		
		
		
		
				

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:31:"SiteOrigin Widgets in Gutenberg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"https://siteorigin.com/siteorigin-widgets-in-gutenberg/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:64:"https://siteorigin.com/siteorigin-widgets-in-gutenberg/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 09 Oct 2018 09:21:30 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"Announcements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://siteorigin.com/?p=131660";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:512:"<p>If you\'ve been giving Gutenberg a try, you might have already used the SiteOrigin Layout block which offers a full instance of Page Builder in Gutenberg. We\'re really excited to announce that from version <code>1.13.0</code>, the SiteOrigin Widgets Bundle is now also available as a block.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/siteorigin-widgets-in-gutenberg/">SiteOrigin Widgets in Gutenberg</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Andrew Misplon";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5632:"<p>Gutenberg will be the new WordPress editor from version 5.0; it&#8217;s currently being tested in plugin form. If you&#8217;ve been giving Gutenberg a try, you might have already used the SiteOrigin Layout block which offers a full instance of Page Builder in Gutenberg. We&#8217;re really excited to announce that from version <code>1.13.0</code>, the SiteOrigin Widgets Bundle is now also available as a block. The new Widgets Bundle block allows you to directly add SiteOrigin widgets to your Gutenberg pages.</p>
<p><strong>Please, keep in mind that Gutenberg is in beta, we don&#8217;t recommend testing on production (live) sites.</strong></p>
<h3>A Quick Recap: Adding a SiteOrigin Layout</h3>
<p>If you&#8217;re testing Gutenberg and haven&#8217;t yet tried the SiteOrigin Layout block, it&#8217;s easy to add. On a Gutenberg page, click the plus icon and search for <em>siteorigin</em>. Click on the SiteOrigin Layout block to insert. If you&#8217;re browsing the available blocks, you&#8217;ll find the SiteOrigin Layout block in the Layout Elements section.</p>
<div id="attachment_131918" style="width: 709px" class="wp-caption aligncenter"><img class="size-large wp-image-131918" src="https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block-699x481.png" alt="" width="699" height="481" srcset="https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block-699x481.png 699w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block-300x206.png 300w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block-768x528.png 768w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block-313x215.png 313w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block.png 904w" sizes="(max-width: 699px) 100vw, 699px" /></p>
<p class="wp-caption-text">Add a SiteOrigin Layout via the add block button.</p>
</div>
<p>Once you&#8217;ve used the SiteOrigin Layout block a few times, a shortcut icon will be available on the right.</p>
<div id="attachment_131919" style="width: 1926px" class="wp-caption aligncenter"><img class="wp-image-131919 size-full" src="https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block.png" alt="" width="1916" height="232" srcset="https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block.png 1916w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block-300x36.png 300w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block-768x93.png 768w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block-699x85.png 699w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block-1050x127.png 1050w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block-313x38.png 313w" sizes="(max-width: 1916px) 100vw, 1916px" /></p>
<p class="wp-caption-text">Once available, you can use the SiteOrigin Layout shortcut icon on the right to add a SiteOrigin Layout block.</p>
</div>
<h3>New Functionality: Adding a SiteOrigin Widget Block</h3>
<p>There might be times when you&#8217;d like to add a SiteOrigin Widget to a Gutenberg page without first adding a SiteOrigin Layout block. To add a SiteOrigin Widget block, click the plus icon and search for <em>siteorigin</em>. Click on the SiteOrigin Widget block to insert. If you&#8217;re browsing the available blocks, you&#8217;ll find the SiteOrigin Widget block in the Widgets section.</p>
<div id="attachment_132008" style="width: 709px" class="wp-caption alignnone"><img src="https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-699x632.jpg" alt="" width="699" height="632" class="size-large wp-image-132008" srcset="https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-699x632.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-300x271.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-768x694.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-1050x949.jpg 1050w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-313x283.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block.jpg 1120w" sizes="(max-width: 699px) 100vw, 699px" /></p>
<p class="wp-caption-text">Add a SiteOrigin Widget via the add block button.</p>
</div>
<h3>Common Questions</h3>
<p>Once WordPress 5.0 is released, existing Page Builder pages will remain in Page Builder. An option to migrate existing Page Builder pages to Gutenberg will be provided in the future for users that would like to do so. If you&#8217;d prefer to keep your Page Builder interface looking as it looks now (pre WP 5.0) we recommend installing the <a href="https://wordpress.org/plugins/classic-editor/">Classic Editor</a> plugin. This is a useful option for a wide range of users.</p>
<h3>A Helping Hand with SiteOrigin Premium</h3>
<p><a href="https://siteorigin.com/downloads/premium/">SiteOrigin Premium</a> is a plugin that adds additional settings and functionality to SiteOrigin widgets, Page Builder and SiteOrign themes. SiteOrigin Premium also includes our next level email support service. If you need expert advice and quick replies, consider SiteOrigin Premium.</p>
<p>If you have any questions, please comment below. We look forward to hearing from you.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/siteorigin-widgets-in-gutenberg/">SiteOrigin Widgets in Gutenberg</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:60:"https://siteorigin.com/siteorigin-widgets-in-gutenberg/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:45:"
		
		
		
		
		
				
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:29:"Adding a Form to a Hero Image";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:46:"https://siteorigin.com/adding-form-hero-image/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:55:"https://siteorigin.com/adding-form-hero-image/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 12 Sep 2018 12:24:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:8:"Tutorial";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"tutorial";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://siteorigin.com/?p=126657";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:483:"<p>Adding a form to your hero image is a great way to turn user attention into action. In this tutorial, we\'ll cover how to use Page Builder by SiteOrigin and the SiteOrigin Widgets Bundle to add a hero image (using the Layout Slider widget) and a contact form to your page.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/adding-form-hero-image/">Adding a Form to a Hero Image</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Andrew Misplon";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:11643:"<p>Adding a form to your hero image is a great way to turn user attention into action. In this tutorial, we&#8217;ll cover how to use Page Builder by SiteOrigin and the SiteOrigin Widgets Bundle to add a hero image (using the Layout Slider widget) and a contact form to your page.</p>
<p><a href="https://demo.siteorigin.com/corp/hero-with-form-right/">View the demo</a>.</p>
<h3>Required Plugins</h3>
<p><a href="https://wordpress.org/plugins/siteorigin-panels/">Page Builder by SiteOrigin</a><br />
<a href="https://wordpress.org/plugins/so-widgets-bundle/">SiteOrigin Widgets Bundle</a></p>
<p>Once Page Builder and the Widgets Bundle are activated, go to <span class="adminized-section"><span class="adminized-part">Plugins</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">SiteOrigin Widgets</span></span> and make sure that the <strong>Layout Slider</strong>, <strong>Headline</strong> and <strong>Contact Form</strong> widgets are activated.</p>
<h3>Getting Started</h3>
<p>Go to Pages and edit the page you&#8217;d like to insert your hero into. If you haven&#8217;t activated Page Builder on this page yet, click on the Page Builder tab and then in the Page Builder toolbar, click the Add Row button and add a single column row to your page. While editing the row, click the Layout tab on the right and set the Row Layout to Full Width Stretched.</p>
<p>Next, select the row you&#8217;ve just created and click the Add Widget button. Because we need a Layout Builder within our hero we&#8217;re going to use the SiteOrigin Layout Slider widget. After clicking Add Widget, use the search bar at the top left to search for the SiteOrigin Layout Slider widget and insert it.</p>
<p><img src="https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget.png" alt="" width="2398" height="402" class="alignnone size-full wp-image-127584" srcset="https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget.png 2398w, https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget-300x50.png 300w, https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget-768x129.png 768w, https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget-699x117.png 699w, https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget-1050x176.png 1050w, https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget-313x52.png 313w" sizes="(max-width: 2398px) 100vw, 2398px" /></p>
<h3>Setting up the Layout Slider</h3>
<p>Click on the SiteOrigin Layout Slider widget and then the edit link to open it. Before adding a frame, click on the Design and Layout tab to enter a few basic setup settings. For our <a href="https://demo.siteorigin.com/corp/hero-with-form-right/">demo</a>, we&#8217;ve used the following:</p>
<p><strong>Height:</strong> <code>780px</code><br />
<strong>Top and bottom padding:</strong> <code>140px</code><br />
<strong>Extra top padding:</strong> <em>Not populated</em><br />
<strong>Side padding:</strong> <code>20px</code><br />
<strong>Maximum container Width:</strong> <code>80%</code><br />
<strong>Heading color:</strong> <code>#fff</code><br />
<strong>Heading size:</strong> <code>54px</code><br />
<strong>Heading shadow intensity:</strong> <code>50</code><br />
<strong>Text size:</strong> <code>22px</code><br />
<strong>Text color:</strong> <code>#fff</code></p>
<p><img src="https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-574x699.png" alt="" width="574" height="699" class="alignnone size-large wp-image-127587" srcset="https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-574x699.png 574w, https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-246x300.png 246w, https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-768x936.png 768w, https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-862x1050.png 862w, https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-313x381.png 313w, https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout.png 1244w" sizes="(max-width: 574px) 100vw, 574px" /></p>
<h4>Adding a Frame and Contents</h4>
<p>As with all SiteOrigin slider widgets, multiple frames (slides) can be added. In this example, we&#8217;ll just be adding a single frame. Click the Add link in the Slider Frames section to add a frame. Start out by opening the Background section and adding a background image. In our demo we&#8217;ve used:</p>
<p><strong>Background image type:</strong> <code>Cover</code><br />
<strong>Background image opacity:</strong> <code>20</code><br />
<strong>Background color:</strong> <code>#000</code></p>
<p>Our demo background images were sourced from <a href="https://unsplash.com/">Unsplash</a>.</p>
<p>With our frame background added, it&#8217;s time to add a headline and contact form. Click the Open Builder button, this will open a mini-instance of Page Builder. To set up your content, follow these steps:</p>
<div id="attachment_127443" style="width: 159px" class="wp-caption alignright"><img class="wp-image-127443 size-medium" src="https://siteorigin.com/wp-content/uploads/2018/09/edit-row-149x300.png" alt="" width="149" height="300" srcset="https://siteorigin.com/wp-content/uploads/2018/09/edit-row-149x300.png 149w, https://siteorigin.com/wp-content/uploads/2018/09/edit-row-348x699.png 348w, https://siteorigin.com/wp-content/uploads/2018/09/edit-row-522x1050.png 522w, https://siteorigin.com/wp-content/uploads/2018/09/edit-row-313x629.png 313w, https://siteorigin.com/wp-content/uploads/2018/09/edit-row.png 614w" sizes="(max-width: 149px) 100vw, 149px" /></p>
<p class="wp-caption-text">Set row top padding to 100 and mobile padding to 0.</p>
</div>
<p>1. Click the Add Row button. For our demo we added a single row with two columns. Click and drag the column divider to change the widths. We&#8217;ve used <code>60%</code> for the left column and <code>40%</code> for the right. While editing the row, click the Layout tab on the right and set <code>100</code> for the top padding and <code>0</code> for right, bottom and left. Set Mobile Padding to <code>0</code>.</p>
<p>2. Insert your widgets. Click on the left cell, then click the Add Widget button, use the search form at the top left to search for the SiteOrigin Headline widget. Repeat the same process for the right cell and insert the SiteOrigin Contact Form widget.</p>
<p>3. Edit the Headline widget. Open the Headline section and insert your headline text, we&#8217;ve used <code>H1</code> for the headline HTML tag. For SEO your page should only contain one <code>H1</code> tag. If you&#8217;re using a <code>H1</code> tag anywhere else on your page then it&#8217;s best to make this <code>H2</code> or <code>H3</code> depending on your content structure. Next, open the Sub headline section and insert your sub headline. We&#8217;ve used <code>Paragraph</code> for the HTML tag. Finally, open the Divider section. We&#8217;ve set the Style setting <code>None</code> as we aren&#8217;t using the divider in this example. Click Done to save your changes.</p>
<p>4. Edit the Contact Form widget. The Contact Form widget is quite settings rich so it might take a few moments to set up. Open the Settings section to set up your form basics such as email addresses, subject, success message and send button text. Next, add form fields as required. In our example, we&#8217;ve used a text field for name and an email address field. Finally, open the Design section and style your form as required. Once complete, click Done to save the Contact Form widget and then Done again to save the Layout Builder, lastly, click Done to save and exit the Layout Slider widget and then publish or update your page.</p>
<div id="attachment_127593" style="width: 3220px" class="wp-caption alignnone"><img src="https://siteorigin.com/wp-content/uploads/2018/09/layout-builder.png" alt="" width="3210" height="424" class="size-full wp-image-127593" srcset="https://siteorigin.com/wp-content/uploads/2018/09/layout-builder.png 3210w, https://siteorigin.com/wp-content/uploads/2018/09/layout-builder-300x40.png 300w, https://siteorigin.com/wp-content/uploads/2018/09/layout-builder-768x101.png 768w, https://siteorigin.com/wp-content/uploads/2018/09/layout-builder-699x92.png 699w, https://siteorigin.com/wp-content/uploads/2018/09/layout-builder-1050x139.png 1050w, https://siteorigin.com/wp-content/uploads/2018/09/layout-builder-313x41.png 313w" sizes="(max-width: 3210px) 100vw, 3210px" /></p>
<p class="wp-caption-text">Layout Builder contents</p>
</div>
<h3>Enhanced by SiteOrigin Premium</h3>
<p><a href="https://siteorigin.com/downloads/premium/">SiteOrigin Premium</a> is a plugin that adds additional settings and functionality to SiteOrigin widgets, Page Builder and SiteOrign themes. It also includes our quick and helpful email support service. The following SiteOrigin Premium addons could be applied to engage users and provide additional functionality:</p>
<p><strong>Block Animations</strong><br />
The Block Animations addon offers animation settings for rows and widgets. We&#8217;ve created a <a href="https://demo.siteorigin.com/corp/hero-with-form-right-block-animations/">demo</a> showing a simple widget fade in with a slight delay. Read more about the settings available in the SiteOrigin Premium Block Animations addon it the <a href="https://siteorigin.com/premium-documentation/plugin-addons/block-animations/">documentation</a>.</p>
<p><strong>Parallax Sliders</strong><br />
The Parallax Sliders addon offers parallax scrolling for the SiteOrigin Slider, Hero, and Layout Slider widget. We&#8217;ve created a <a href="https://demo.siteorigin.com/corp/hero-with-form-right-parallax-sliders/">demo</a> showing the Layout Slider with a parallax scrolling effect. Read more about the settings available in the SiteOrigin Premium Parallax Sliders addon it the <a href="https://siteorigin.com/premium-documentation/plugin-addons/parallax-sliders/">documentation</a>.</p>
<p><strong>Autoresponder</strong><br />
The SiteOrigin Premium Contact Form addon provides an autoresponder. Let users know you&#8217;ve received their email and provide a timeframe for response. Read more about the settings available in the SiteOrigin Contact Form addon in the <a href="https://siteorigin.com/premium-documentation/plugin-addons/contact-form-fields/">documentation</a>. </p>
<h3>Using the Demo Layout</h3>
<p><a href="https://demo.siteorigin.com/corp/hero-with-form-right/">View the demo</a>.<br />
<a href="https://siteorigin.com/wp-content/uploads/2018/09/hero-with-form-right.json">Download the demo layout (JSON file)</a>.</p>
<p>If you&#8217;d like to make use of the demo layout, follow these steps:</p>
<p>1. Download the above JSON file to your desktop.<br />
2. Go to the page you&#8217;d like to use, if you haven&#8217;t activated Page Builder on this page yet, click on the Page Builder tab and then in the Page Builder toolbar, click <span class="adminized-section"><span class="adminized-part">Layouts</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Import/Export</span></span>.<br />
3. Upload the layout either by dragging and dropping or selecting it using the select button.<br />
4. Finally, click the Insert button bottom right.</p>
<p>If you have any questions or comments, please let us know below, we&#8217;d love to hear from you.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/adding-form-hero-image/">Adding a Form to a Hero Image</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:51:"https://siteorigin.com/adding-form-hero-image/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"10";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:45:"
		
		
		
		
		
				
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:46:"One Page Navigation with Page Builder and Corp";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:66:"https://siteorigin.com/one-page-navigation-with-page-builder-corp/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:75:"https://siteorigin.com/one-page-navigation-with-page-builder-corp/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 25 Jul 2018 08:20:34 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:8:"Tutorial";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"tutorial";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://siteorigin.com/?p=119494";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:570:"<p>One-page navigation allows users to easily access content in long landing pages or one-page websites. SiteOrigin Corp offers integrated one-page navigation with menu highlighting and smooth scroll. In this tutorial, we\'ll explain how to set up a one-page website or landing page using Page Builder by SiteOrigin and Corp.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/one-page-navigation-with-page-builder-corp/">One Page Navigation with Page Builder and Corp</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Andrew Misplon";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:7720:"<p>One-page navigation allows users to easily access content in long landing pages or one-page websites. SiteOrigin Corp offers integrated one-page navigation with menu highlighting and smooth scroll. In this tutorial, we&#8217;ll explain how to set up a one-page website or landing page using Page Builder by SiteOrigin and Corp.</p>
<p><a href="https://demo.siteorigin.com/corp/one-page-demo/">View the demo</a>.</p>
<h3>Create Your Page</h3>
<p>In this tutorial, we&#8217;ll be using the WordPress plugin <a href="https://wordpress.org/plugins/siteorigin-panels/">Page Builder by SiteOrigin</a> and theme, <a href="https://wordpress.org/themes/siteorigin-corp/">SiteOrigin Corp</a>.</p>
<p>If you haven&#8217;t already created a page, go to <span class="adminized-section"><span class="adminized-part">Pages</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Add New</span></span>, create a new page and click on the Page Builder tab to get started. </p>
<p>If you&#8217;d like to use the demo page content, you can <a href="https://siteorigin.com/wp-content/uploads/2018/07/one-page-demo-export.json">download it here</a> (right click and save as). Import the JSON file from <span class="adminized-section"><span class="adminized-part">Layouts</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Import/Export</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Select Import File</span></span>.</p>
<h3>Adding Row ID&#8217;s</h3>
<p>One you have a populated page, either with your own content or with the demo content listed above, it&#8217;s time to insert our row ID&#8217;s. Row ID&#8217;s will be used to link to each section of the page. Edit the first row you&#8217;d like your menu to link to and click the Attributes tab on the right, use the Row ID field to insert an ID that&#8217;ll be used later in your menu. For example, in our demo, the first row we&#8217;re linking to is the Services row. The ID used is <code>services</code>. You can insert any name or number.</p>
<p><img src="https://siteorigin.com/wp-content/uploads/2018/07/row-id.png" alt="" width="754" height="474" class="alignnone size-full wp-image-119817" style="max-width:50%;" srcset="https://siteorigin.com/wp-content/uploads/2018/07/row-id.png 754w, https://siteorigin.com/wp-content/uploads/2018/07/row-id-300x189.png 300w, https://siteorigin.com/wp-content/uploads/2018/07/row-id-699x439.png 699w, https://siteorigin.com/wp-content/uploads/2018/07/row-id-313x197.png 313w" sizes="(max-width: 754px) 100vw, 754px" /></p>
<p>Add a row ID for every row in your page that you&#8217;d like to link to.</p>
<h3>Create Your Menu</h3>
<p>Go to <span class="adminized-section"><span class="adminized-part">Appearance</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Menus</span></span>, click the &#8220;create a new menu&#8221; link if you don&#8217;t already have a menu added. Once named, save your menu to the Header Menu theme location. Next, add your anchor links, these will direct users to the various sections of your one-page website. Click the Custom Links tab on the left to add a link. In the URL field, add the name of your first section ID with a hash before it. For example, if the first row you&#8217;d like to link to has the ID <code>services</code>, you&#8217;d add <code>#services</code> to the URL field. The Link Text field is the text your users will see, insert the link text for the anchor you&#8217;re linking to.</p>
<p><img src="https://siteorigin.com/wp-content/uploads/2018/07/custom-link.png" alt="" width="944" height="1162" class="alignnone size-full wp-image-119847" style="max-width:50%;" srcset="https://siteorigin.com/wp-content/uploads/2018/07/custom-link.png 944w, https://siteorigin.com/wp-content/uploads/2018/07/custom-link-244x300.png 244w, https://siteorigin.com/wp-content/uploads/2018/07/custom-link-768x945.png 768w, https://siteorigin.com/wp-content/uploads/2018/07/custom-link-568x699.png 568w, https://siteorigin.com/wp-content/uploads/2018/07/custom-link-853x1050.png 853w, https://siteorigin.com/wp-content/uploads/2018/07/custom-link-313x385.png 313w" sizes="(max-width: 944px) 100vw, 944px" /></p>
<h3>Creating One-Page Navigation in Multi-Page Website</h3>
<p>Creating an anchor menu as we&#8217;ve described in the above paragraph is quite simple for a one-page website. But what if your one-pager is part of a larger website? In that case, you&#8217;d need a separate menu. In our Corp demo, we&#8217;ve done exactly that, the one-page demo has one menu and the rest of the website has another. If you&#8217;d like to know how this was done, read on. </p>
<p>The plugin we&#8217;ve used for this is called <a href="https://wordpress.org/plugins/menu-items-visibility-control/">Menu Items Visibility Control</a>. Once installed and activated, it adds a Visibility field to each menu item. In each menu item at <span class="adminized-section"><span class="adminized-part">Appearance</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Menus</span></span> we&#8217;ve set the visibility to either show or be hidden on the one-pager. To do this, you&#8217;ll need to know the ID of your one-pager. Go to Pages, edit the page concerned and check the URL, within the URL is a number, that&#8217;s the page ID. In the case of our demo, the ID is <code>288</code>. The below conditional statements can be used in your menu, simply replace our page ID (288), with yours.</p>
<p><strong>Show this item on page ID 288</strong><br />
<code>is_page( 288 )</code></p>
<p><strong>Hide this item on page ID 288</strong><br />
<code>! is_page( 288 )</code></p>
<p><img src="https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility.png" alt="" width="1346" height="828" class="alignnone size-full wp-image-119852" style="width:75%" srcset="https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility.png 1346w, https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility-300x185.png 300w, https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility-768x472.png 768w, https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility-699x430.png 699w, https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility-1050x646.png 1050w, https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility-313x193.png 313w" sizes="(max-width: 1346px) 100vw, 1346px" /></p>
<p>If you&#8217;d prefer to have your one-page links visible throughout your site then there is no need to use Menu Item Visibility. An additional consideration is that users might access your one-page links from another page. To ensure your anchor links work, use absolute URLs when adding Custom Links to your menu. This means that instead of adding anchor links such as <code>#services</code>, you&#8217;ll need to add the page URL in addition to the anchor link. Using our Services example from earlier in this post, we&#8217;d add <code>http://demo.siteorigin.com/corp/one-page-demo/#services</code>.</p>
<p><strong>Page URL:</strong> http://demo.siteorigin.com/corp/one-page-demo/<br />
<strong>Anchor Link:</strong> #services<br />
<strong>Combined URL:</strong> http://demo.siteorigin.com/corp/one-page-demo/#services</p>
<p>Hopefully, you&#8217;ve found this post useful. Please, let us know if you have any questions below, we&#8217;ll do our best to assist.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/one-page-navigation-with-page-builder-corp/">One Page Navigation with Page Builder and Corp</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:71:"https://siteorigin.com/one-page-navigation-with-page-builder-corp/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"17";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:45:"
		
		
		
		
		
				
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:28:"Announcing the Tooltip Addon";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"https://siteorigin.com/announcing-the-tooltip-addon/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:61:"https://siteorigin.com/announcing-the-tooltip-addon/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 17 Jul 2018 07:28:21 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:13:"Announcements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://siteorigin.com/?p=118318";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:624:"<p>The Tooltip addon for <a href="https://siteorigin.com/downloads/premium/">SiteOrigin Premium</a> is here! Tooltips appear on hover or mouse click and are a great way to display additional image information without taking up space. To see the Tooltip addon in use, <a href="https://demo.siteorigin.com/premium/tooltip-addon/" target="_blank" rel="nofollow">view the demo</a> and hover over any of the images.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/announcing-the-tooltip-addon/">Announcing the Tooltip Addon</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Andrew Misplon";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1546:"<p>The Tooltip addon for <a href="https://siteorigin.com/downloads/premium/">SiteOrigin Premium</a> is here! Tooltips appear on hover or mouse click and are a great way to display additional image information without taking up space. To see the Tooltip addon in use, <a href="https://demo.siteorigin.com/premium/tooltip-addon/" target="_blank" rel="nofollow">view the demo</a> and hover over any of the images.</p>
<p>We first had the idea for a tooltip addon while building a portfolio website as part of a SiteOrigin <a href="https://siteorigin.com/pack/">Site Pack</a>. Tooltips are an awesome addition for designers and photographers displaying their work or any image that needs a credit or additional information added on hover or click. The Tooltip addon is available for the SiteOrigin Image, Image Grid, and Simple Masonry widgets.</p>
<p>If you&#8217;re already using SiteOrigin Premium and have updated to version 1.4.1, you can go to <span class="adminized-section"><span class="adminized-part">SiteOrigin</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Premium Addons</span></span> to activate and adjust the global settings. Find out more about how to use the Tooltip addon in the <a href="https://siteorigin.com/premium-documentation/plugin-addons/tooltip/">documentation</a>.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/announcing-the-tooltip-addon/">Announcing the Tooltip Addon</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:57:"https://siteorigin.com/announcing-the-tooltip-addon/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"4";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:45:"
		
		
		
		
		
				
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:41:"Four New Blog Layouts Added to Corp Theme";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:65:"https://siteorigin.com/four-new-blog-layouts-added-to-corp-theme/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:74:"https://siteorigin.com/four-new-blog-layouts-added-to-corp-theme/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 27 Jun 2018 17:08:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:13:"Announcements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:6:"Themes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://siteorigin.com/?p=115595";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:524:"<p>We\'re excited to announce four new blog layouts for our Corp theme. This brings the total available blog layouts to five. Choose between the following for your posts page, Standard, Grid, Offset, Alternate or Masonry. We\'ve also included a new search results layout in this update.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/four-new-blog-layouts-added-to-corp-theme/">Four New Blog Layouts Added to Corp Theme</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Andrew Misplon";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:6940:"<p>We&#8217;re excited to announce four new blog layouts for our latest theme, <a href="https://siteorigin.com/theme/corp">Corp</a>. Choose the layout that&#8217;s the best fit for your blog and archive pages.</p>
<p><a href="https://wordpress.org/themes/siteorigin-corp/">Download Corp</a>, a fully featured free WordPress theme.<br />
<a href="https://demo.siteorigin.com/corp/">View the Corp demo</a>.</p>
<h3>Standard Layout</h3>
<p><a href="https://demo.siteorigin.com/corp/standard-blog-layout/">View the demo</a>.</p>
<p>The Standard layout features a classic blog look with a large featured image followed by a title, post meta, and content.</p>
<p><a href="https://demo.siteorigin.com/corp/standard-blog-layout/"><img class="alignnone size-large wp-image-115786" src="https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard-633x699.jpg" alt="" width="633" height="699" srcset="https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard-633x699.jpg 633w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard-272x300.jpg 272w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard-768x848.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard-313x346.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard.jpg 770w" sizes="(max-width: 633px) 100vw, 633px" /></a></p>
<h3>Grid Layout</h3>
<p><a href="https://demo.siteorigin.com/corp/grid-blog-layout/">View the demo</a>.</p>
<p>This is the blog layout Corp launched with, it offers a structured grid pattern, great for blogs with lots of content.</p>
<p><a href="https://demo.siteorigin.com/corp/grid-blog-layout/"><img class="alignnone size-large wp-image-115787" src="https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid-699x441.jpg" alt="" width="699" height="441" srcset="https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid-699x441.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid-300x189.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid-768x485.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid-313x198.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid.jpg 800w" sizes="(max-width: 699px) 100vw, 699px" /></a></p>
<h3>Offset Layout</h3>
<p><a href="https://demo.siteorigin.com/corp/offset-blog-layout/">View the demo</a>.</p>
<p>The Offset layout features the post author, categories and comment count in an offset left column, great for highlighting post author contributions.</p>
<p><a href="https://demo.siteorigin.com/corp/offset-blog-layout/"><img src="https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout-676x699.jpg" alt="" width="676" height="699" class="alignnone size-large wp-image-115801" srcset="https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout-676x699.jpg 676w, https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout-290x300.jpg 290w, https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout-768x794.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout-313x324.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout.jpg 800w" sizes="(max-width: 676px) 100vw, 676px" /></a></p>
<h3>Alternate Layout</h3>
<p><a href="https://demo.siteorigin.com/corp/alternate-blog-layout/">View the demo</a>.</p>
<p>This layout displays your post in horizontal containers, alternating the side the featured image is positioned on. Like the Grid layout, it&#8217;s also useful for active sites, looking to display more content on each page of their blog.</p>
<p><a href="https://demo.siteorigin.com/corp/alternate-blog-layout/"><img class="alignnone size-large wp-image-115783" src="https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate-699x489.jpg" alt="" width="699" height="489" srcset="https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate-699x489.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate-300x210.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate-768x538.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate-313x219.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate.jpg 800w" sizes="(max-width: 699px) 100vw, 699px" /></a></p>
<h3>Masonry Layout</h3>
<p><a href="https://demo.siteorigin.com/corp/masonry-blog-layout/">View the demo</a>.</p>
<p>The Masonry layout offers a more creative take on the grid layout. The post category is displayed on the featured image, the featured images aren&#8217;t uniform in height and when resizing the screen, the grid layout cascades into place.</p>
<p><a href="https://demo.siteorigin.com/corp/masonry-blog-layout/"><img src="https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp-699x544.jpg" alt="" width="699" height="544" class="alignnone size-large wp-image-115806" srcset="https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp-699x544.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp-300x234.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp-768x598.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp-313x244.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp.jpg 800w" sizes="(max-width: 699px) 100vw, 699px" /></a></p>
<h3>Search Results</h3>
<p>We&#8217;ve also improved Corp&#8217;s search results page. Search results now make use of a very similar layout to the Alternate post loop, just without the alternating featured image.</p>
<p><img src="https://siteorigin.com/wp-content/uploads/2018/06/new-search-699x311.jpg" alt="" width="699" height="311" class="alignnone size-large wp-image-115803" srcset="https://siteorigin.com/wp-content/uploads/2018/06/new-search-699x311.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/06/new-search-300x134.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/06/new-search-768x342.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/new-search-313x139.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/new-search.jpg 800w" sizes="(max-width: 699px) 100vw, 699px" /></p>
<h3>SiteOrigin Premium</h3>
<p>If you&#8217;d like to remove the footer attribution, add Ajax comments and enjoy quick email support, SiteOrigin Premium is for you. <a href="https://siteorigin.com/downloads/premium/">Find out more</a>.</p>
<p>Corp is now a fully featured theme, complete with multiple blog loops and a completely customized WooCommerce design. If you have any questions or requests, please let us know below.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/four-new-blog-layouts-added-to-corp-theme/">Four New Blog Layouts Added to Corp Theme</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:70:"https://siteorigin.com/four-new-blog-layouts-added-to-corp-theme/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"8";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:45:"
		
		
		
		
		
				
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:58:"Create a Fullscreen Slider with the SiteOrigin Hero Widget";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:71:"https://siteorigin.com/create-fullscreen-slider-siteorigin-hero-widget/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:80:"https://siteorigin.com/create-fullscreen-slider-siteorigin-hero-widget/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 08 Jun 2018 10:59:48 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:8:"Tutorial";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"tutorial";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"http://siteorigin.com/?p=113044";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:442:"<p>This guide will outline how to create a fullscreen slider with the SiteOrigin Hero widget and how you can take your fullscreen slider to the next level with SiteOrigin Premium.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/create-fullscreen-slider-siteorigin-hero-widget/">Create a Fullscreen Slider with the SiteOrigin Hero Widget</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Alex S";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:11224:"<p>This guide will outline how to create a fullscreen slider with the SiteOrigin Hero widget and how you can take your fullscreen slider to the next level with <a href="https://siteorigin.com/downloads/premium/">SiteOrigin Premium</a>.</p>
<h3>Let&#8217;s Get Started</h3>
<p>We&#8217;ll be using <a href="https://wordpress.org/plugins/siteorigin-panels/">Page Builder by SiteOrigin</a> and the <a href="https://wordpress.org/plugins/so-widgets-bundle/">SiteOrigin Widgets Bundle</a> plugins. You can check these plugins are activated from the Plugins menu item. Go to <span class="adminized-section"><span class="adminized-part">Plugins</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">SiteOrigin Widgets</span></span> and ensure the Hero widget is activated.<span id="more-113044"></span></p>
<p>Create a new page and enable Page Builder, or open an existing page. Add a new row and SiteOrigin Hero Image widget to that row. We need to set the row you&#8217;re using is set to Full Width Stretch, which will allow for the Hero widget to be the full width of the page. To do this, open the row containing the newly added Hero widget by clicking the wrench button above the row.</p>
<p><img class="wp-image-113480 size-large aligncenter" src="https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-699x142.png" alt="image with row wrench icon hovered on" width="699" height="142" srcset="https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-699x142.png 699w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-300x61.png 300w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-768x156.png 768w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-1050x213.png 1050w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-313x64.png 313w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-600x122.png 600w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-1200x244.png 1200w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1.png 1486w" sizes="(max-width: 699px) 100vw, 699px" /></p>
<p>Go to the Row Styles Sidebar on the right and open the Layout settings group. Set the <span class="adminized-section"><span class="adminized-part">Row Layout</span></span> to <span class="adminized-section"><span class="adminized-part">Full Width Stretched</span></span>. For reference, here&#8217;s what each row Layout does:</p>
<p><img class="wp-image-113481 size-medium alignright" src="https://siteorigin.com/wp-content/uploads/2018/06/Zgsowcb-1-1-300x208.png" alt="Image of cursor on on the Row Layout drop-down" width="300" height="208" srcset="https://siteorigin.com/wp-content/uploads/2018/06/Zgsowcb-1-1-300x208.png 300w, https://siteorigin.com/wp-content/uploads/2018/06/Zgsowcb-1-1-313x217.png 313w, https://siteorigin.com/wp-content/uploads/2018/06/Zgsowcb-1-1-600x415.png 600w, https://siteorigin.com/wp-content/uploads/2018/06/Zgsowcb-1-1.png 662w" sizes="(max-width: 300px) 100vw, 300px" /></p>
<p><strong>Standard:</strong> The standard layout provided by your theme.</p>
<p><strong>Full Width:</strong> This row layout will stretch the row to the full width of the browser, and add a content container that&#8217;s sized based on the standard container. This row layout is perfect for making full-width backgrounds while still allowing the widgets within the row to maintain the consistent placement of the rest of the page.</p>
<p><strong>Full Width Stretched:</strong> This row layout is the full width of the page. It&#8217;s perfect for making widgets (such as the Hero widget) full width rather than just the row background.</p>
<p>Close the row and open the SiteOrigin Hero widget by hovering on top of the Hero widget and clicking edit.</p>
<p><img class="wp-image-113483 size-large aligncenter" src="https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-699x112.png" alt="image of hero widget with edit hovered on" width="699" height="112" srcset="https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-699x112.png 699w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-300x48.png 300w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-768x123.png 768w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-1050x168.png 1050w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-313x50.png 313w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-600x96.png 600w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-1200x192.png 1200w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1.png 1488w" sizes="(max-width: 699px) 100vw, 699px" /></p>
<p>Open the Design and Layout settings group and set the Height to <span class="adminized-section"><span class="adminized-part">100vh</span></span>. The <span class="adminized-section"><span class="adminized-part">V</span></span> in <span class="adminized-section"><span class="adminized-part">VH</span></span> stands for <a href="https://developer.mozilla.org/en-US/docs/Web/CSS/length#Viewport-percentage_lengths">Viewport Percentage Length</a> and <span class="adminized-section"><span class="adminized-part">H</span></span> means height. Basically, <span class="adminized-section"><span class="adminized-part">100vh</span></span> is the entire height of the browser regardless of device so it&#8217;s exactly what you&#8217;re after for a fullscreen slider.</p>
<p>That&#8217;s all the setup required to build fullscreen sliders with the SiteOrigin Hero widget. Now you simply need to set up the rest of the slider as desired &#8211; add content, tweak spacing, etc. As a point reference, for fullscreen sliders, we recommend using slide background images that are at least <span class="adminized-section"><span class="adminized-part">1920 x 1080</span></span> in dimensions. <span class="adminized-section"><span class="adminized-part">1920 x 1080</span></span> is an extremely popular resolution so it&#8217;ll cover the vast majority of use cases.</p>
<h3>SiteOrigin Premium Enhancements</h3>
<p><a href="https://siteorigin.com/downloads/premium/">SiteOrigin Premium</a> adds a number of enhancements to your website and the Hero widget benefits greatly from these enhancements. You&#8217;re able to create a fullscreen slider with parallax with <a href="https://siteorigin.com/premium-documentation/plugin-addons/parallax-sliders/">the Parallax Sliders plugin addon</a> and add transitional Content Animations with the <a href="https://siteorigin.com/premium-documentation/plugin-addons/hero/">Hero plugin addon</a>. If you have SiteOrigin Premium, please ensure you&#8217;ve activated relevant functionality by navigating to <span class="adminized-section"><span class="adminized-part">SiteOrigin</span><span class="adminized-arrow icon-arrow-right"></span><span class="adminized-part">Premium Addons</span></span> and activating <a href="https://siteorigin.com/premium-documentation/plugin-addons/parallax-sliders/">Parallax Sliders</a> and <a href="https://siteorigin.com/premium-documentation/plugin-addons/hero/">Hero Addon</a>.</p>
<h4>Fullscreen Parallax Sliders</h4>
<p>SiteOrigin Premium adds the ability to allow your slide backgrounds to <a href="https://siteorigin.com/fixed-vs-parallax-background-images/">parallax</a>. Before proceeding, it&#8217;s worth noting that parallax images require a vertically larger image than normal so ensure your image is vertically larger than you would normally use or the parallax effect may be very minor. We recommend using an image that&#8217;s more than <span class="adminized-section"><span class="adminized-part">1440px</span></span> in height. If your images result in blank spacing beneath the image, your image is too small to for a fullscreen Parallax. If the parallax isn&#8217;t very noticeable, that means the image isn&#8217;t large enough.</p>
<p>To set a slider background as parallax, please open your hero widget and open a frame you would like to apply a parallax too. Open the Background settings group and set <span class="adminized-section"><span class="adminized-part">Background Type</span></span> to <span class="adminized-section"><span class="adminized-part">Parallax</span></span>. Repeat this process for the rest of the slides you wish to parallax.</p>
<p>You can <a href="https://demo.siteorigin.com/premium/hero-addon/">preview this functionality here</a>.</p>
<h3>Hero Content Animations</h3>
<p>To allow you to make really beautiful sliders that stand out, we recently released an update for the SiteOrigin Premium which adds transitional Content Animations for the SiteOrigin Hero widget. This functionality will allow you to add transitional effects for the text of your slider.</p>
<p>To give your slide a context animation, please open your hero widget and open a frame you would like to apply a content animation too. Open the Content Animation settings group. You have access to all of the standard <a href="https://siteorigin.com/premium-documentation/plugin-addons/block-animations/">Block Animation</a> options but the key difference is there&#8217;s a new Animation Event &#8211; Frame Display. This event is triggered every time the slide changes so the animation will continually animate.</p>
<p>You can <a href="https://demo.siteorigin.com/premium/hero-addon/#parallax-sliders">preview this functionality here</a>.</p>
<h3>Responsive Notes</h3>
<p>To ensure setup is as easy as possible, we use <span class="adminized-section"><span class="adminized-part">background-size: cover;</span></span> to allow for all images to fill the entire area of the hero widget. This prevents having to resize images manually. This functionality works by ensuring the image is always the same height of the area/slide its been applied to and to ensure this the browser can (and will) clip the sides of the image off. This can be problematic on mobile because if you use a height that&#8217;s too large, or add too much text it may result in parts of your image being hidden on mobile.</p>
<p>To lower the impact of the slides being clipped off, you should use an image with a central focus, which is an image where the focus of the image is in the middle (or at least towards the middle). Alternatively, you could apply a <span class="adminized-section"><span class="adminized-part">Responsive Height</span></span> that works better for your image than the Height setting does. We&#8217;re unable to recommend a <span class="adminized-section"><span class="adminized-part">Responsive Height</span></span> as it depends solely on the image you&#8217;re using so you&#8217;ll need to try a number of different values to see what works for you and your image.</p>
<p>Alternatively, give <a href="https://smartslider3.com/?source=siteorigin">Smart Slider 3</a> a try as it handles slides in a different manner.</p>
<p>If you have any questions or run into any issues, please feel free to leave a comment and we&#8217;ll lend a hand.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/create-fullscreen-slider-siteorigin-hero-widget/">Create a Fullscreen Slider with the SiteOrigin Hero Widget</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:76:"https://siteorigin.com/create-fullscreen-slider-siteorigin-hero-widget/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"10";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:42:"
		
		
		
		
		
				

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:28:"GDPR and SiteOrigin Products";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"https://siteorigin.com/gdpr-and-siteorigin-products/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:61:"https://siteorigin.com/gdpr-and-siteorigin-products/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 21 May 2018 12:32:01 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:13:"Announcements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:31:"http://siteorigin.com/?p=109960";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:580:"<p>General Data Protection Regulation (GDPR) is European Union law on data protection and privacy for all individuals within the European Union. It addresses the export of personal data outside the EU. We\'ve assembled a brief guide on what sort of information you might need to add to your privacy policy to comply with GDPR when using SiteOrigin themes and plugins.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/gdpr-and-siteorigin-products/">GDPR and SiteOrigin Products</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Alex S";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5829:"<p>General Data Protection Regulation (GDPR) is European Union law on data protection and privacy for all individuals within the European Union. It addresses the export of personal data outside the EU. We&#8217;ve assembled a brief guide on what sort of information you might need to add to your privacy policy to comply with GDPR when using SiteOrigin themes and plugins.</p>
<p><strong>Disclaimer:</strong> this post is by no means legal advice. If unsure, please seek professional consultation.</p>
<h3>What is GDPR?</h3>
<p>The General Data Protection Regulation (GDPR) is a legal framework that sets guidelines for the collection and processing of personal information of individuals within the European Union (EU).</p>
<p>Read the full definition on <a href="https://en.wikipedia.org/wiki/General_Data_Protection_Regulation">Wikipedia</a>.</p>
<h3>Does GDPR Affect Me and My Website?</h3>
<p>If your company is based in the European Union (EU), or you do business with EU citizens, the GDPR does affect you and your website so you need to comply. With that said, it would be a good idea comply with the regulations regardless, as it&#8217;s possible countries outside of the EU will implement similar legislation in the future.</p>
<p><span id="more-109960"></span></p>
<h4>SiteOrigin CSS Plugin and SiteOrigin Themes</h4>
<p>Good News! SiteOrigin CSS and SiteOrigin themes comply with the GDPR as none of them collect, store or transmit any user information. However, if you&#8217;re making use of Google Fonts in SiteOrigin CSS or SiteOrigin themes, you&#8217;ll need to make a note of this in your privacy policy. Google is GDPR compliant, <a href="https://privacy.google.com/businesses/compliance/">find out more</a>.</p>
<p>(Google Fonts can only be added from within SiteOrigin CSS using the Web Font Selector in SiteOrigin Premium.)</p>
<h4>SiteOrigin Page Builder: Layouts Directory</h4>
<p>The only GDPR concern in SiteOrigin Page Builder is the Layouts Directory. By default, all images in prebuilt layouts are hosted on layouts.siteorigin.com. We recommend changing these images as soon as possible. If you decide not to, you&#8217;ll need to make mention of these images in your privacy policy.</p>
<h4>SiteOrigin Widgets Bundle</h4>
<p>Certain widgets include Google Fonts if you decide to use any of those fonts you&#8217;ll need to mention that in your privacy policy. Google is GDPR compliant, <a href="https://privacy.google.com/businesses/compliance/">find out more</a>.</p>
<h4>SiteOrigin Contact Form Widget</h4>
<p>While the SiteOrigin Contact Form widget doesn&#8217;t store data, it does handle user submitted data. As such, it&#8217;s a good idea to ask for consent before transmitting this data.</p>
<p>To ask for consent, add a checkbox to your contact form and use the following values:</p>
<p><strong>Field Type:</strong> Checkboxes<br />
<strong>Required Field:</strong> Required (This field must be required)<br />
<strong>Add an Option and set the Value to:</strong><br />
Please tick to consent to your data being stored temporarily, as per our privacy policy.</p>
<p><img class="alignnone size-full wp-image-109968" src="https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup.png" alt="" width="1604" height="1024" srcset="https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup.png 1604w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-300x192.png 300w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-768x490.png 768w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-699x446.png 699w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-1050x670.png 1050w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-313x200.png 313w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-600x383.png 600w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-1200x766.png 1200w" sizes="(max-width: 1604px) 100vw, 1604px" /></p>
<p>If you choose to <strong>Log IP Address</strong>, you&#8217;ll need to mention this in your privacy policy. Logging the user&#8217;s IP Address simply includes the IP in the email, you&#8217;ll need to mention that it&#8217;s included, but not stored anywhere.</p>
<p>If you&#8217;re using SiteOrigin Premium, the Contact From plugin addon allows you to add autoresponder functionality to email the user on form submission. If you use this functionality you&#8217;ll need to mention this in your privacy policy alongside your contact form information.</p>
<h4>SiteOrigin Google Maps Widget</h4>
<p>If you use the SiteOrigin Google Maps widget, you&#8217;ll need to mention that you use Google Maps in your privacy policy and that while you don&#8217;t personally collect this data, Google may. Google is GDPR compliant, <a href="https://privacy.google.com/businesses/compliance/">find out more</a>.</p>
<h4>SiteOrigin Video Player</h4>
<p>If you embed any external video, such as from YouTube or Vimeo, you&#8217;ll need to mention this in your privacy policy. Be sure to check if the video you&#8217;re embedding is hosted on a service that is GDPR compliant.</p>
<h3>Summary</h3>
<p>Hopefully, this gives you a better idea of what GDPR is and how SiteOrigin themes and plugins might influence the creation of your website&#8217;s data management and privacy policy.</p>
<p>If you have any questions or concerns, please feel free to leave a comment.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/gdpr-and-siteorigin-products/">GDPR and SiteOrigin Products</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:57:"https://siteorigin.com/gdpr-and-siteorigin-products/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"50";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:45:"
		
		
		
		
		
				
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:50:"Gutenberg Compatibility in SiteOrigin Page Builder";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"https://siteorigin.com/gutenberg-compatibility-page-builder/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:69:"https://siteorigin.com/gutenberg-compatibility-page-builder/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 22 Feb 2018 08:14:02 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:13:"Announcements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:30:"http://siteorigin.com/?p=93803";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:608:"<p>Gutenberg has made massive strides in 2018. It continues to evolve into what we hope will be a worthy core editor later this year with the release of WordPress 5.0. We’re doing our bit for the Gutenberg future of WordPress by adding compatibility to all our products. This will be available as a free update before Gutenberg is merged into the WordPress core.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/gutenberg-compatibility-page-builder/">Gutenberg Compatibility in SiteOrigin Page Builder</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Greg Priday";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3713:"<p><iframe width="840" height="473" src="https://www.youtube.com/embed/UC05MXR6LMg?feature=oembed&#038;vq=hd1080" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe></p>
<p><a href="https://wordpress.org/plugins/gutenberg/">Gutenberg</a> has made massive strides in 2018. It continues to evolve into what we hope will be a worthy core editor later this year with the release of <a href="https://make.wordpress.org/core/5-0/">WordPress 5.0</a>.</p>
<p>We&#8217;re doing our bit for the Gutenberg future of WordPress by adding compatibility to all our products. This will be available as a free update before Gutenberg is merged into the WordPress core.</p>
<p>Just like we made our Widgets Bundle widgets available to <a href="https://siteorigin.com/widgets-beaver-builder-elementor/">other page builder plugins</a>, we&#8217;re making all our widgets Gutenberg compatible. So you can add our buttons, tabbed layout, maps, etc. to your Gutenberg pages.</p>
<p><span id="more-93803"></span></p>
<p>The thing we&#8217;re most excited about though, is that we&#8217;re making our Layout widget available as a Gutenberg block. The SiteOrigin Layout block gives you the full power of SiteOrigin Page Builder, so you&#8217;ll be able to create fully nested, columnized, widgetized content, with advanced row, column and widget styling right inside Gutenberg.</p>
<p>Why are we doing this? Gutenberg is taking a more conservative approach to page building, which means there are designs and layouts that you just won&#8217;t be able to achieve. The SiteOrigin Layout block fills all those gaps, by allowing you to create advanced sections inside your Gutenberg pages.</p>
<p>This is just the beginning, we&#8217;re planning on adding a lot more features by the time Gutenberg becomes the core WordPress editor. For example, we&#8217;ll give you a migration tool that&#8217;ll let you convert your existing Page Builder pages into Gutenberg pages.</p>
<p>We&#8217;re excited to bring Page Builder and Widgets Bundle plugins, with over 2 million combined installs, into the future of WordPress. It&#8217;s our way of guaranteeing that your content is safe, as WordPress evolves into a more modern content creation platform.</p>
<h4>Editing Options for Existing Page Builder Content</h4>
<p>Once WordPress 5.0 is released you can rest assured that your Page Builder content will be safe and editable. Existing Page Builder content will be editable in one of two ways. If you&#8217;d prefer not to switch over to Gutenberg you can install the <a href="https://wordpress.org/plugins/classic-editor/">Classic Editor</a> plugin provided by WordPress. Once activated, your existing Page Builder pages will remain exactly as they were pre WordPress 5.0. Alternatively, if you&#8217;d like to move over to Gutenberg, existing Page Builder pages will offer the option to migrate Page Builder content into a single Layout Builder block.</p>
<h4>Editing Options for New Pages</h4>
<p>If you have the Classic Editor plugin installed and add a new page, you&#8217;ll be able to choose between a classic page with the familiar Visual, Text and Page Builder tabs or a Gutenberg page. If you don&#8217;t have the Classic Editor plugin installed, your new pages will be Gutenberg pages.</p>
<p>Once Gutenberg is integrated into the WordPress core there will be much more certainty. The above update and roadmap is based on the information that&#8217;s currently available.</p>
<p>The post <a rel="nofollow" href="https://siteorigin.com/gutenberg-compatibility-page-builder/">Gutenberg Compatibility in SiteOrigin Page Builder</a> appeared first on <a rel="nofollow" href="https://siteorigin.com">SiteOrigin</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:65:"https://siteorigin.com/gutenberg-compatibility-page-builder/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"88";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:28:"https://siteorigin.com/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:42:"Requests_Utility_CaseInsensitiveDictionary":1:{s:7:" * data";a:16:{s:4:"date";s:29:"Wed, 31 Oct 2018 15:21:55 GMT";s:12:"content-type";s:34:"application/rss+xml; charset=UTF-8";s:10:"set-cookie";s:131:"__cfduid=d0f1ef355f73da03cb4edc6505690c6551540999315; expires=Thu, 31-Oct-19 15:21:55 GMT; path=/; domain=.siteorigin.com; HttpOnly";s:13:"cache-control";s:22:"public, max-age=432000";s:7:"expires";s:29:"Mon, 05 Nov 2018 15:21:55 GMT";s:12:"x-robots-tag";s:15:"noindex, follow";s:4:"link";s:59:"<https://siteorigin.com/wp-json/>; rel="https://api.w.org/"";s:13:"last-modified";s:29:"Wed, 31 Oct 2018 11:13:28 GMT";s:4:"etag";s:39:""654ab5ea36ae585d2a19bbb921db0977-gzip"";s:4:"vary";s:15:"Accept-Encoding";s:16:"content-encoding";s:4:"gzip";s:7:"x-cache";s:4:"MISS";s:15:"cf-cache-status";s:3:"HIT";s:9:"expect-ct";s:87:"max-age=604800, report-uri="https://report-uri.cloudflare.com/cdn-cgi/beacon/expect-ct"";s:6:"server";s:10:"cloudflare";s:6:"cf-ray";s:20:"47271d36cda2a8b1-CDG";}}s:5:"build";s:14:"20130911040210";}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5684', '_transient_timeout_feed_mod_2dd0202377a060f0df35cceaacc2c13c', '1541042515', 'no'); 
INSERT INTO `mod63_options` VALUES ('5685', '_transient_feed_mod_2dd0202377a060f0df35cceaacc2c13c', '1540999315', 'no'); 
INSERT INTO `mod63_options` VALUES ('5686', '_transient_timeout_feed_54af7cb0f50a8f4f8cdb30f2d9b4f50c', '1541042517', 'no'); 
INSERT INTO `mod63_options` VALUES ('5687', '_transient_feed_54af7cb0f50a8f4f8cdb30f2d9b4f50c', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"


";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:52:"
	
	
	
	
	
	
	
	
	

 
	
		
		
		
		
		
		
		
		
		
	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:3:{s:0:"";a:8:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Semper Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:25:"https://semperplugins.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:25:"Premium WordPress Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 30 Oct 2018 17:50:22 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:30:"https://wordpress.org/?v=4.9.8";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"image";a:1:{i:0;a:6:{s:4:"data";s:11:"
	
	
	
	
	
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:3:"url";a:1:{i:0;a:5:{s:4:"data";s:88:"https://semperplugins.com/wp-content/uploads/2016/06/cropped-AIOSEOP-Gear-Blue-32x32.png";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Semper Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:25:"https://semperplugins.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"width";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"height";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:42:"
		
		
		
		
		
				

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:72:"Upgrading to 2.9.x made your SEO meta section disappear? Read this post!";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:62:"https://semperplugins.com/upgrading-to-2-9-seo-meta-disappear/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:70:"https://semperplugins.com/upgrading-to-2-9-seo-meta-disappear/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 25 Oct 2018 13:53:17 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://semperplugins.com/?p=4464";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:409:"Hi friends, In 2.9, several users reported in the community forums that the SEO section disappeared from their source code or back-end. There was a similar issue when we fixed a bug in 2.6, described here. See if that fixes<span class="ellipsis">&#8230;</span><div class="read-more"><a href="https://semperplugins.com/upgrading-to-2-9-seo-meta-disappear/">Read more &#8250;</a></div><!-- end of .read-more -->";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Michael Torbert";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1301:"<p>Hi friends,</p>
<p>In 2.9, several users reported in the community forums that the SEO section disappeared from their source code or back-end. There was a similar issue when we fixed a bug in 2.6, <a href="https://semperplugins.com/missing-all-in-one-seo-pack-2-6-post-and-page-meta/">described here</a>. See if that fixes it for you, if not, read on.</p>
<p>Some are reporting that their issue is unrelated to the one from 2.6. If that&#8217;s the case with you, we need your help to fix this pesky issue. Five developers worked for hours and hours trying to reproduce this problem, without being able to. All in One SEO Pack is used on millions of websites across the planet, so unfortunately we simply can not reproduce every single environment, configuration, and mix of plugins and themes out there.</p>
<p>You can help us by <a href="https://semperplugins.com/contact/">contacting us here</a> with the details of your issue and website so that we can investigate your site and determine the cause, and then quickly thereafter, a solution. As a special Thank You from us to anyone who reports a bug and our investigation of their site leads to a fix, you&#8217;ll receive a free license for <a href="https://semperplugins.com/all-in-one-seo-pack-pro-version/">All in One SEO Pack Pro</a>!</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:67:"https://semperplugins.com/upgrading-to-2-9-seo-meta-disappear/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:48:"
		
		
		
		
		
				
		
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:52:"New Robots.txt module with Multisite Network support";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:48:"https://semperplugins.com/new-robots-txt-module/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:57:"https://semperplugins.com/new-robots-txt-module/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 17 Sep 2018 12:22:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:19:"All in One SEO Pack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://semperplugins.com/?p=4352";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:417:"Missed the release notes for All in One SEO Pack v2.7? Then you may not be aware that we&#8217;ve completely overhauled the Robots.txt module.  Here&#8217;s what&#8217;s new! Prior to All in One SEO Pack v2.7, the robots.txt file was output as<span class="ellipsis">&#8230;</span><div class="read-more"><a href="https://semperplugins.com/new-robots-txt-module/">Read more &#8250;</a></div><!-- end of .read-more -->";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Steve Mortiboy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4838:"<p>Missed the <a href="https://semperfiwebdesign.com/all-in-one-seo-pack-release-history/">release notes</a> for All in One SEO Pack v2.7? Then you may not be aware that we&#8217;ve completely overhauled the <a href="https://semperplugins.com/documentation/robots-txt-module/">Robots.txt module</a>.  Here&#8217;s what&#8217;s new!</p>
<p>Prior to All in One SEO Pack v2.7, the robots.txt file was output as a physical file on your web server.  However, WordPress creates a dynamic virtual robots.txt file, which is always preferred over a physical file.  The overhaul of the Robots.txt module meant that we could remove support for physical files entirely and instead use the dynamic virtual file that WordPress creates.  This has two benefits:</p>
<ol>
<li>Rules that are added to the robots.txt file are stored in the database.</li>
<li>The default rules created by WordPress are used by All in One SEO Pack.</li>
</ol>
<p>In addition to switching from a physical file to a virtual file, we also overhauled the user interface.  We kept the easy-to-use rule builder and added a table that displays your custom rules.</p>
<p><img class="aligncenter wp-image-4215" src="https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule.png" alt="Adding a rule to your robots.txt" width="500" height="496" srcset="https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule.png 1384w, https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule-150x149.png 150w, https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule-300x298.png 300w, https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule-768x762.png 768w, https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule-1024x1017.png 1024w, https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule-252x250.png 252w, https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule-100x99.png 100w, https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule-200x199.png 200w, https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule-450x447.png 450w, https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule-600x596.png 600w, https://semperplugins.com/wp-content/uploads/2014/01/adding-a-rule-900x893.png 900w" sizes="(max-width: 500px) 100vw, 500px" /></p>
<p>The new Robots.txt module now also supports WordPress Multisite Networks.  There&#8217;s a new <a href="https://semperplugins.com/documentation/robots-txt-editor-for-multisite-networks/">Robots.txt Editor</a> in the Network Admin panel that enables Network Administrators to set global rules.  These global rules are used by all sites in the network and cannot be overridden at site level.</p>
<p><img class="aligncenter wp-image-4329" src="https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin.png" alt="Robots.txt Editor in Network Admin" width="500" height="396" srcset="https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin.png 1896w, https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin-300x238.png 300w, https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin-768x608.png 768w, https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin-1024x811.png 1024w, https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin-316x250.png 316w, https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin-100x79.png 100w, https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin-150x119.png 150w, https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin-200x158.png 200w, https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin-450x356.png 450w, https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin-600x475.png 600w, https://semperplugins.com/wp-content/uploads/2018/08/Robots.txt-Editor-in-Network-Admin-900x713.png 900w" sizes="(max-width: 500px) 100vw, 500px" /></p>
<p>The new Robots.txt module is a big improvement for both site administrators and network administrators of large multisite installations.  It continues our commitment to deliver the best possible SEO tools to you so you can effectively manage your own SEO.</p>
<p>If you&#8217;d like to learn more, then we highly recommend you to check out our documentation on the new Robots.txt module and Network Admin Robots.txt Editor:</p>
<ul>
<li class="icon-bg"><a href="https://semperplugins.com/documentation/robots-txt-module/">Robots.txt Module</a></li>
<li class="icon-bg"><a href="https://semperplugins.com/documentation/robots-txt-editor-for-multisite-networks/">Robots.txt Editor for Multisite Networks</a></li>
</ul>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:53:"https://semperplugins.com/new-robots-txt-module/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"11";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:48:"
		
		
		
		
		
				
		
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"All in One SEO Pack v2.8 released";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"https://semperplugins.com/all-in-one-seo-pack-v2-8-released/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:69:"https://semperplugins.com/all-in-one-seo-pack-v2-8-released/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 12 Sep 2018 13:23:51 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:19:"All in One SEO Pack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://semperplugins.com/?p=4347";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:427:"Earlier this week, we released All in One SEO Pack v2.8.  This major release includes both enhancements to existing features of the plugin as well as improvements to the codebase, performance optimizations and a number of bug fixes. In total,<span class="ellipsis">&#8230;</span><div class="read-more"><a href="https://semperplugins.com/all-in-one-seo-pack-v2-8-released/">Read more &#8250;</a></div><!-- end of .read-more -->";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Steve Mortiboy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:2057:"<p>Earlier this week, we released All in One SEO Pack v2.8.  This major release includes both enhancements to existing features of the plugin as well as improvements to the codebase, performance optimizations and a number of bug fixes.</p>
<p>In total, 23 improvements and bug fixes were included in this release. Here are the highlights:</p>
<ul>
<li>Video XML Sitemap (All in One SEO Pack Pro exclusive) &#8211; Added column for video count to sitemap</li>
<li>XML Sitemap &#8211; Fixed a bug where <a href="https://github.com/semperfiwebdesign/all-in-one-seo-pack/pull/1887" target="_blank" rel="noopener">custom XML Sitemap filenames could be deleted</a> on updating to v2.7.3.</li>
<li>XML Sitemap &#8211; Added <a href="https://github.com/semperfiwebdesign/all-in-one-seo-pack/issues/155" target="_blank" rel="noopener">support for post type archive pages</a></li>
<li>XML Sitemap &#8211; The Additional Pages section now <a href="https://github.com/semperfiwebdesign/all-in-one-seo-pack/issues/1554" target="_blank" rel="noopener">requires properly formed absolute URLs</a></li>
<li>XML Sitemap &#8211; We no longer <a href="https://github.com/semperfiwebdesign/all-in-one-seo-pack/issues/1423" target="_blank" rel="noopener">include images from trashed content</a></li>
<li>XML Sitemap &#8211; We now <a href="https://semperplugins.com/documentation/support-for-jetpack-galleries-and-image-cdn/" target="_blank" rel="noopener">include images from Jetpack galleries</a></li>
<li>Performance &#8211; <a href="https://github.com/semperfiwebdesign/all-in-one-seo-pack/issues/1832" target="_blank" rel="noopener">Massive optimizations to the performance of the XML Sitemap</a></li>
<li>WooCommerce &#8211; <a href="https://github.com/semperfiwebdesign/aioseop-pro/issues/366" target="_blank" rel="noopener">Product gallery images are now included in the XML Sitemap</a></li>
</ul>
<p>Interested in getting the newest features of All in One SEO Pack Pro? <a href="https://semperplugins.com/all-in-one-seo-pack-pro-version/">Upgrade to Premium!</a></p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:65:"https://semperplugins.com/all-in-one-seo-pack-v2-8-released/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"6";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:42:"
		
		
		
		
		
				

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:50:"Missing All in One SEO Pack 2.6 post and page meta";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:77:"https://semperplugins.com/missing-all-in-one-seo-pack-2-6-post-and-page-meta/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:86:"https://semperplugins.com/missing-all-in-one-seo-pack-2-6-post-and-page-meta/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 29 May 2018 21:20:54 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:19:"All in One SEO Pack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://semperplugins.com/?p=4154";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:424:"If you updated to the latest version of All in One SEO Pack (2.6) for WordPress recently, you may have noticed what appears to be an alarming change. Let&#8217;s back up a bit. Previously, we had a somewhat minor bug where<span class="ellipsis">&#8230;</span><div class="read-more"><a href="https://semperplugins.com/missing-all-in-one-seo-pack-2-6-post-and-page-meta/">Read more &#8250;</a></div><!-- end of .read-more -->";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Michael Torbert";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3714:"<p>If you updated to the <a href="https://semperfiwebdesign.com/all-in-one-seo-pack-release-history/">latest version</a> of <a href="https://semperplugins.com/all-in-one-seo-pack-pro-version/">All in One SEO Pack</a> (2.6) for WordPress recently, you may have noticed what appears to be an alarming change. Let&#8217;s back up a bit.</p>
<p>Previously, we had a <a href="https://github.com/semperfiwebdesign/all-in-one-seo-pack/issues/1067">somewhat minor bug</a> where if you had <a href="https://semperplugins.com/documentation/custom-post-type-settings/#seo-on-only-these-post-types">SEO on only these post types</a> <em>all unchecked</em>, the meta entry fields would still show up.</p>
<p><a href="https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types.png"><img class="size-large wp-image-4158 aligncenter" src="https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-1024x396.png" alt="" width="605" height="234" srcset="https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-1024x396.png 1024w, https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-300x116.png 300w, https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-768x297.png 768w, https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-646x250.png 646w, https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-100x39.png 100w, https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-150x58.png 150w, https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-200x77.png 200w, https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-450x174.png 450w, https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-600x232.png 600w, https://semperplugins.com/wp-content/uploads/2018/05/all-in-one-seo-pack-custom-post-types-900x348.png 900w" sizes="(max-width: 605px) 100vw, 605px" /></a></p>
<p>In version 2.6, we fixed this issue.</p>
<p>That means for some users who inadvertently had all these checkboxes unchecked and didn&#8217;t know it, updating gives the appearance of your SEO meta entry fields disappearing.</p>
<p><em>If this happens, don&#8217;t be alarmed. No data is missing.</em></p>
<p>Simply go to wp-admin-&gt;All in One SEO Pack-&gt;General Settings and scroll down to <a href="https://semperplugins.com/documentation/custom-post-type-settings/">SEO for Custom Post Types</a> and enable this setting then check the boxes you&#8217;d like under <a href="https://semperplugins.com/documentation/custom-post-type-settings/#seo-on-only-these-post-types">SEO on only these post types</a> (Posts and pages are checked by default on new installs.)</p>
<p>Users also report not seeing the Display Settings section, this is because that section will not be populated with options until you enable <a href="https://semperplugins.com/documentation/custom-post-type-settings/">SEO for Custom Post Types</a>. If your Display Settings section is empty then make sure you enable <a href="https://semperplugins.com/documentation/custom-post-type-settings/">SEO for Custom Post Types</a>.</p>
<p>Changelog- <a href="https://semperfiwebdesign.com/all-in-one-seo-pack-release-history/" rel="nofollow">https://semperfiwebdesign.com/all-in-one-seo-pack-release-history/</a><br />
Github issue- <a href="https://github.com/semperfiwebdesign/all-in-one-seo-pack/issues/1067" rel="nofollow">https://github.com/semperfiwebdesign/all-in-one-seo-pack/issues/1067</a></p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:82:"https://semperplugins.com/missing-all-in-one-seo-pack-2-6-post-and-page-meta/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"35";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:45:"
		
		
		
		
		
				
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:44:"5 Reasons Why Your Website Is Not Converting";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:71:"https://semperplugins.com/5-reasons-why-your-website-is-not-converting/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:80:"https://semperplugins.com/5-reasons-why-your-website-is-not-converting/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 07 Nov 2017 13:58:39 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:15:"site conversion";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"https://semperplugins.com/?p=3552/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:421:"How do you measure the success of a site? Conversion. You could have a lot of traffic going to your site, but those visits don’t really matter if you aren’t converting them into customers. The only visitors that matter are<span class="ellipsis">&#8230;</span><div class="read-more"><a href="https://semperplugins.com/5-reasons-why-your-website-is-not-converting/">Read more &#8250;</a></div><!-- end of .read-more -->";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Arnaud";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:8338:"<p><img class="aligncenter wp-image-3698 size-full" src="https://semperplugins.com/wp-content/uploads/2017/07/5-reasons-why-your-site-is-not-converting-featured.jpg" alt="Faced with a website that isn\'t converting? Here are five reasons why your conversion rate is underwhelming." width="850" height="250" srcset="https://semperplugins.com/wp-content/uploads/2017/07/5-reasons-why-your-site-is-not-converting-featured.jpg 850w, https://semperplugins.com/wp-content/uploads/2017/07/5-reasons-why-your-site-is-not-converting-featured-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2017/07/5-reasons-why-your-site-is-not-converting-featured-768x226.jpg 768w, https://semperplugins.com/wp-content/uploads/2017/07/5-reasons-why-your-site-is-not-converting-featured-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2017/07/5-reasons-why-your-site-is-not-converting-featured-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2017/07/5-reasons-why-your-site-is-not-converting-featured-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2017/07/5-reasons-why-your-site-is-not-converting-featured-450x132.jpg 450w, https://semperplugins.com/wp-content/uploads/2017/07/5-reasons-why-your-site-is-not-converting-featured-600x176.jpg 600w" sizes="(max-width: 850px) 100vw, 850px" /></p>
<p>How do you measure the success of a site? Conversion.</p>
<p>You could have a lot of traffic going to your site, but those visits don’t really matter if you aren’t converting them into customers. The only visitors that matter are those that are adding to your bottom-line. All other traffic is essentially wasted.</p>
<p>Are you finding yourself with a lot of traffic, selling the right products at competitive prices, yet not with many paying customers? Then read on to find out why your site isn’t converting and what you can do about it.</p>
<h2>Check Your Current Conversion Rate</h2>
<p>First things first, you should know your current conversion rate. Whether you measure your conversions by product purchases, brochure downloads or email newsletter signups: you need to be measuring and tracking those conversions regularly. You can track your conversion rate using Goals in <a href="https://analytics.google.com/analytics/web/" target="_blank" rel="noopener">Google Analytics,</a> or through any other analytics platform of your choosing.</p>
<p>So what&#8217;s considered a good conversion rate? The ideal rate is between 2 to 3 percent. This rate could be higher or lower based on the value of the conversion (e.g. you’d have more difficulty converting customers if you’re selling products or services worth $10,000+). But if you’re having less than 2 percent conversion and your conversion value isn’t very high, then you might have a problem on your hands.</p>
<p>Here are five reasons why your site may be underperforming.</p>
<h2>#1. You’re Providing a Bad Mobile Experience</h2>
<p>If your website isn’t mobile-friendly, there is no way it will survive in these times. It isn&#8217;t enough for your site to be responsive, it has to be designed specifically for mobile in terms of content and structure. Failure to do so would mean marginalizing a substantial portion of your customer base and in turn decreasing your conversion rate.</p>
<p>But what does designing for mobile entail?</p>
<ul>
<li>Using large and easily legible text</li>
<li>Using short paragraphs</li>
<li>Making sure that every key feature is just a tap away</li>
<li>Having just a single call-to-action</li>
</ul>
<p>The key is to keep testing your mobile site. Perhaps you should even ask customers and family members for feedback on your site’s mobile experience. Afterwards, you should review what is working and what is not &#8211; and address those issues.</p>
<p>As long as you do not ignore the importance of having a good mobile experience for your site, you can easily hone in on the reason(s) your site is not converting.</p>
<h2>#2. No Call to Action</h2>
<p>Your website could be user-friendly with engaging and quality content, but without a clear and concise call-to-action, you simply won’t convert. Users may want to convert but just don&#8217;t have the opportunity or means to do so. Because you haven’t provided it.</p>
<p>Make your call-to-action clear, concise, prominent, specific and compelling. Provide all the information users need so they know exactly what you want them to do next. Create calls-to-action that are relevant and specific; and place them in a prominent place on every page of your site.</p>
<p>Whatever you do, make sure it is very easy for the user to convert when they are ready to.</p>
<h2>#3. Your Users Are Annoyed with Your Website</h2>
<p>You may be missing out on conversion opportunities if there is something off-putting about your site. Look at your bounce rate: if it is high, then you know there is something that is not appealing to users.</p>
<p>In such a case, you need to find out what the problem is &#8211; directly from the user. You may use heat maps and look at your user journeys via Google Analytics, but perhaps it will make your job easier to ask users directly (e.g. via a quick survey).</p>
<p>A few common annoyances on websites:</p>
<ul>
<li>You do not offer any useful information</li>
<li>Navigation is too difficult</li>
<li>You have too many ads or popups</li>
<li>Your site doesn’t look good</li>
</ul>
<p>These are all problems with a rather easy fix. Take your time investigating them and fix the errors as soon as you can.</p>
<h2>#4. You’re Off-Target</h2>
<p>Your website should be anything but general. A lot of website owners aim to please everyone – but they can’t – and end up isolating their entire audience.</p>
<p>Perhaps you’re writing for the wrong audience, perhaps you’re writing for a larger demographic than you should be; whatever the case, inaccurate targeting could negatively impact your conversion rate. Your copy, branding, marketing and site design should speak directly to a niche demographic.</p>
<p>Conduct market research to properly define and know your audience.</p>
<h2>#5. You Have a Slow Site</h2>
<p>We previously covered the importance of website load speed and provided <a href="https://semperplugins.com/10-quick-easy-ways-to-speed-up-your-site/">tips on to speed up your site</a>. When your website doesn’t load fast, your visitors leave and are unlikely to visit again in the near future.</p>
<p>There are many factors that can slow down your site, such as:</p>
<ul>
<li>A site that isn’t optimized for mobile</li>
<li>Broken links</li>
<li>Not using caching</li>
<li>Messy code</li>
<li>Images that aren’t optimized</li>
<li>Flash and Java</li>
<li>Average web hosting</li>
</ul>
<p>You can <a href="https://developers.google.com/speed/pagespeed/insights/" target="_blank" rel="noopener">check your current site speed via Page Speed Insights</a>. If your site is taking longer than 3 seconds to load, you need to work on it. Studies show that most users quickly exit sites that take longer than 3 seconds to load.</p>
<h2>Measure, Measure and Measure</h2>
<p>This is actually a sixth reason why your site may not be converting. Measure, measure and keep measuring. If you’re not measuring, you’re guessing, and in turn, not really making any strides.</p>
<p>The problem most website owners encounter is that they are either not tracking their website traffic or that they are tracking but not reviewing their metrics. Some do know they should be tracking, but just aren’t sure what to look for or what to make of the results.</p>
<p>Well, you should always start with your goals in mind. Then you can identify which key metrics will help you to measure your progress towards those goals.</p>
<p>Once you start measuring, you can improve on those metrics; figure out what is working, what isn’t, and then fine-tune and optimize.</p>
<h2>Wrapping Up</h2>
<p>These five reasons are just a starting point to help boost your conversion rates. There are many other reasons why your site may not be converting. However, these are fairly common in under-converting sites.</p>
<p>If you find that any of these reasons apply to your business, simply make the changes and you’ll see a big difference or improvement in your conversion rates and bottom line.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:76:"https://semperplugins.com/5-reasons-why-your-website-is-not-converting/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"69";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:51:"
		
		
		
		
		
				
		
		
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:38:"Choosing the Right Domain Name for SEO";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:65:"https://semperplugins.com/choosing-the-right-domain-name-for-seo/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:74:"https://semperplugins.com/choosing-the-right-domain-name-for-seo/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 12 Sep 2017 14:51:02 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:4:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"SEO Tips";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:12:"domain names";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:8:"SEO tips";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"https://semperplugins.com/?p=3443/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:398:"Back in the day, way way back, your website domain could have had a major impact on your site’s rankings. That changed a few years ago (2012 to be exact) when Google wanted to weed out websites that may have<span class="ellipsis">&#8230;</span><div class="read-more"><a href="https://semperplugins.com/choosing-the-right-domain-name-for-seo/">Read more &#8250;</a></div><!-- end of .read-more -->";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Arnaud";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:7445:"<p><img class="size-full wp-image-3702 aligncenter" src="https://semperplugins.com/wp-content/uploads/2017/06/choosing-a-domain-name-for-seo-featured.jpg" alt="" width="850" height="250" srcset="https://semperplugins.com/wp-content/uploads/2017/06/choosing-a-domain-name-for-seo-featured.jpg 850w, https://semperplugins.com/wp-content/uploads/2017/06/choosing-a-domain-name-for-seo-featured-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2017/06/choosing-a-domain-name-for-seo-featured-768x226.jpg 768w, https://semperplugins.com/wp-content/uploads/2017/06/choosing-a-domain-name-for-seo-featured-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2017/06/choosing-a-domain-name-for-seo-featured-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2017/06/choosing-a-domain-name-for-seo-featured-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2017/06/choosing-a-domain-name-for-seo-featured-450x132.jpg 450w, https://semperplugins.com/wp-content/uploads/2017/06/choosing-a-domain-name-for-seo-featured-600x176.jpg 600w" sizes="(max-width: 850px) 100vw, 850px" /></p>
<p>Back in the day, way way back, your website domain could have had a major impact on your site’s rankings. That changed a few years ago (2012 to be exact) when Google wanted to weed out websites that may have good domain names but very little “substance”.</p>
<p>Exact Match Domains (EMD) is where the problem started. Businesses would essentially purchase keyword domains to rank for a particular keyword. And the EMD was enough for them to rank: they barely focused on quality content and relevance (two things that matter greatly for SEO nowadays). That strategy no longer works.</p>
<p>That’s not to say that domain names no longer affect SEO. They still do (and studies have proven that), but how?</p>
<p>Let’s find out.</p>
<h2>How Domain Names Impact SEO</h2>
<p>There have been a lot of changes to SEO, particularly from the largest search engine: Google. But one thing that hasn’t changed, but has been emphasized more, is original quality content, relevance and always aligning with search engine best practices. A component of this is your domain name &#8211; it’s unique, only you can have it.</p>
<p>Even though it may not directly impact your rankings anymore, a good domain name will get you more brand recognition, trust and higher click-through-rates (CTR).</p>
<p>However, the definition of a good domain name has changed, at least according to Google. We see this in how the search engine treats certain types of domains.</p>
<h2>Exact Match Domains (EMD)</h2>
<p>EMDs are domain names that include keyword phrases. For example, let’s say you are selling hair products and want to rank for “quality hair products.” The EMD you would most likely use is qualityhairproducts.com. Just purchasing that domain would have gotten you the first page ranking a while ago.</p>
<p>Yup! You wouldn’t have needed original content or backlinks. You would simply rank for it with your domain name. That all changed after Google released the Exact Match Domain Update.</p>
<p>The update essentially made EMDs obsolete in search engine rankings. In fact, a study by High Position showed that the average EMD ranking went from position 13.4 to 26.6 (yikes!) after Google’s update. The average top 10 EMD also dropped in rankings: from 3.2 down to 11.9. So now we know that choosing an exact match domain in 2017 is quite pointless, a bad idea even.</p>
<p>So how should you decide on a domain name to maximize SEO? You need only do two things: choose a memorable brand name (to make your domain name) and pick a .com extension.</p>
<p>Let’s go into more detail.</p>
<h2>Your Brand Name Should Be Your Domain Name</h2>
<p>We can all agree that your brand is important. Your brand name is how your customers recognize and find you in search engines and social media platforms. So think of your domain name as the foothold of your online brand.</p>
<p>In fact, the more customers are using your brand name to search for you online, the more your SEO and rankings will improve. This is referred to as brand signalling (any reference of your business online). Matt Cutts, former Head of Web Spam at Google, claimed that Google “actually came up with a classifier to say, okay, IRS or Wikipedia or New York Times is over on this side, and the low-quality sites are over on this side.”</p>
<p>That’s right, Google now cares more about brands for SEO than it does about keywords and links. For that reason, using your brand name is more important than keywords. You’re probably scratching your head at this point, wondering how Google would associate your brand with certain keywords&#8230;</p>
<p>Well, Google will associate keywords with your brand as your brand becomes more popular; and as you produce more relevant and high quality content. Let’s take a look at Bitly as an example. It’s a URL shortener and link management platform yet their brand name does not match those keywords. It however ranks at the top for those keywords in Google.</p>
<p>That’s because of its popularity. As long as people recognize it and are searching for it, Google will measure that brand signal and rank it accordingly. For this reason, it is important to have a memorable brand name and consequently, a memorable domain name.</p>
<p>Don’t worry if your brand name contains a keyword, or in other words, is a PMD (partial match domain). That’s because Google is only searching for spam sites with EMDs and PMDs &#8211; the actual problem isn’t the keywords, but rather the content and quality of the site. A PMD or EMD with bad user experience and low quality content would experience a steep downgrade in rankings. Whereas, a PMD or EMD with great user experience and content would not be greatly affected.</p>
<p><em>However</em>, if you are just starting out, you should go with a memorable brand name domain and avoid using keywords.</p>
<h2>Opt For a .com Extension</h2>
<p>You probably already know that .com is the most popular domain extension. That is because most other domain extensions like .biz and .us are viewed as spam. Although choosing it may not directly impact your rankings, you may be viewed as a low-ranking site which could affect your SEO.</p>
<p>.com is simply the most convenient and safest choice to go with. When in doubt, go with it.</p>
<h2>Tips for Choosing the Perfect Domain Name</h2>
<p>Now let’s recap and go over the tips on picking the best domain name:</p>
<ul>
<li>Use your brand name</li>
<li>Don’t use exact match domains. Partial match domains are OK but a brand name is always more effective</li>
<li>Choose a .com extension</li>
<li>Make it memorable so users can easily remember it</li>
<li>Keep it short, 15 characters at most</li>
<li>Avoid numbers, hyphens and special characters</li>
<li>Avoid misspelling words on purpose. It’s a no-no for branding</li>
<li>Make it easy to spell</li>
</ul>
<h2>Wrapping Up</h2>
<p>We hope you now have a good understanding of how domain names affect SEO in 2017. If you’re starting a new business or changing to a better domain name, the tips above should help you pick out the best one for your business.</p>
<p>Remember: As long as you have great content and a good SEO strategy, a strong and unique domain name may rank you higher. Choose one wisely, use it correctly and start reaping the value.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:70:"https://semperplugins.com/choosing-the-right-domain-name-for-seo/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"48";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:48:"
		
		
		
		
		
				
		
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:39:"How to Come up with Great Content Ideas";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:66:"https://semperplugins.com/how-to-come-up-with-great-content-ideas/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:75:"https://semperplugins.com/how-to-come-up-with-great-content-ideas/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 29 Aug 2017 13:00:30 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"SEO Tips";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:17:"content marketing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"http://semperplugins.com/?p=2375";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:423:"Do you spend hours staring at a blank computer screen or piece of paper, desperately racking your brain for just one great content idea? Well, the sad reality is that you cannot afford to wait for inspiration to strike: your readers<span class="ellipsis">&#8230;</span><div class="read-more"><a href="https://semperplugins.com/how-to-come-up-with-great-content-ideas/">Read more &#8250;</a></div><!-- end of .read-more -->";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Arnaud";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:12701:"<p><img class="size-full wp-image-3674 aligncenter" src="https://semperplugins.com/wp-content/uploads/2017/09/great-content-ideas-featured.jpg" alt="Looking for some great ideas to produce new content? Here are a few tips to get you started." width="850" height="250" srcset="https://semperplugins.com/wp-content/uploads/2017/09/great-content-ideas-featured.jpg 850w, https://semperplugins.com/wp-content/uploads/2017/09/great-content-ideas-featured-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2017/09/great-content-ideas-featured-768x226.jpg 768w, https://semperplugins.com/wp-content/uploads/2017/09/great-content-ideas-featured-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2017/09/great-content-ideas-featured-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2017/09/great-content-ideas-featured-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2017/09/great-content-ideas-featured-450x132.jpg 450w, https://semperplugins.com/wp-content/uploads/2017/09/great-content-ideas-featured-600x176.jpg 600w" sizes="(max-width: 850px) 100vw, 850px" /></p>
<p>Do you spend hours staring at a blank computer screen or piece of paper, desperately racking your brain for just one great content idea? Well, the sad reality is that you cannot afford to wait for inspiration to strike: your readers are waiting for yet another one of your great posts to enjoy and share.</p>
<p>This article is your reference for tips and tricks to find inspiration and create great content to grow your WordPress site.</p>
<p>We’ll cover the following topics:</p>
<ul>
<li>How to source inspiration directly from your readers</li>
<li>How to get great topic ideas from your social media channels</li>
<li>Useful tools you may already be using, but not as effectively</li>
<li>How to overcome writer&#8217;s block</li>
</ul>
<h2>Know Your Readers and Their Concerns</h2>
<p>This is arguably the starting point to creating great content: knowing your reader and their concerns.</p>
<p>To gain and maintain a steady stream of followers, you must produce consistently good content that your blog visitors are interested in. Since your content is ideally centered around the needs and interests of your readers, it is therefore very important to know who they are.  But how would you know what your readers are interested in?</p>
<p>First, put yourself in your reader&#8217;s shoes. Then ask and answer the following questions:</p>
<ol>
<li>What issues do your readers struggle with most?</li>
<li>What would better enable them to understand and solve those issues?</li>
<li>What would a reader enter in search engines to find content in your niche?</li>
</ol>
<p>Creating valuable content boils down to problem solving. You can start writing winning content more easily once you know what your readers are looking for and what their pain points are.</p>
<p>A key thing to remember, however, is that some of your readers may be beginners who are trying to come to grips with your subject area. So create content that is clear &amp; appealing to beginners and which does not exclusively focus on advanced readers.</p>
<h3>Look at Your Analytics</h3>
<p>Your website analytics will provide you with a lot of insight regarding where your readers are coming from and how they&#8217;re interacting with your site. Check <a href="https://analytics.google.com/analytics/web/" target="_blank" rel="noopener">Google Analytics</a> for keywords that users are searching for to get to your site, and then create engaging content about those topics.</p>
<p>You can also use those insights to update and keep existing posts relevant; or to create new posts with detailed information on the problems your target audience is trying to solve.</p>
<h3>Go Through Your Blog Comments</h3>
<p>Your blog comments can be extremely helpful to you in a number of ways.</p>
<p>First of all, they provide you with great insight into what readers think of the content you have written. This may include positive or negative feedback on the style and clarity of your writing, questions for more information on areas you can expand on, wide-spread problems being discussed and/or solutions to those problems.</p>
<p>Note them down and come up with post ideas to help your readers.</p>
<p>If your readers take the time to report a problem they are having, or to give you feedback, you need to listen. It usually means that it&#8217;s a significant challenge they, and other users, are facing.</p>
<h3>Sift Through Your FAQs</h3>
<p>You can actively engage with your readers by answering their most frequently asked questions in blog posts. This will show readers that you have carefully considered their responses to your content, and also helps other readers who may also have similar questions.</p>
<p>And as a nice bonus, you may attract some more visitors that wouldn&#8217;t have found your WordPress site otherwise.</p>
<h2>Use Social Media</h2>
<p>Social media channels are arguably the best place to source inspiration. Take <a href="https://www.buzzfeed.com/" target="_blank" rel="noopener">BuzzFeed</a> for example. They constantly browse the web for fun ideas &#8211; typically small trends or trending topics in niche areas &#8211; and make them more mainstream.</p>
<div id="attachment_3026" style="width: 510px" class="wp-caption aligncenter"><img class="wp-image-3026" src="https://semperplugins.com/wp-content/uploads/2016/12/twitter-trends.jpg" alt="At the time of writing, Twitter show us, for example, that growth hacking and content marketing tips are trending among bloggers." width="500" height="380" srcset="https://semperplugins.com/wp-content/uploads/2016/12/twitter-trends.jpg 754w, https://semperplugins.com/wp-content/uploads/2016/12/twitter-trends-300x228.jpg 300w, https://semperplugins.com/wp-content/uploads/2016/12/twitter-trends-328x250.jpg 328w, https://semperplugins.com/wp-content/uploads/2016/12/twitter-trends-100x76.jpg 100w, https://semperplugins.com/wp-content/uploads/2016/12/twitter-trends-150x114.jpg 150w, https://semperplugins.com/wp-content/uploads/2016/12/twitter-trends-200x152.jpg 200w, https://semperplugins.com/wp-content/uploads/2016/12/twitter-trends-450x343.jpg 450w, https://semperplugins.com/wp-content/uploads/2016/12/twitter-trends-600x457.jpg 600w" sizes="(max-width: 500px) 100vw, 500px" /><p class="wp-caption-text">At the time of writing, Twitter show us that growth hacking and content marketing tips are now trending among bloggers.</p></div>
<p>You can also use social media to stay on top of industry trends; and to monitor the new keywords created by these trends. Use tools like <a href="https://www.google.com/trends/" target="_blank" rel="noopener">Google Trends</a>, Twitter Trends, <a href="https://www.reddit.com/" target="_blank" rel="noopener">Reddit</a>, etc. to keep up with the conversation and take it to your blog.</p>
<h2><b>Questionnaires </b>and Polls</h2>
<p>Another useful way to engage with readers is to put out short surveys or polls on your blog, social media or your mailing list. Ask them any questions they may have or for their opinion on certain topics that you covered. This is also a fantastic way to keep them engaged with your content.</p>
<p>Make it clear to your mailing list that you welcome questions. One way to do this is to offer some sort of incentive: perhaps a product discount, a coupon, or free mentoring to anyone who is willing to give a short interview. Interviewing in particular is a great way to find out a host of questions or issues your audience may have with your topic or industry that may never have even crossed your mind. This strategy may seem daunting, but is an effective way of coming up with content that is higher quality and more relevant to your audience.</p>
<h2>Recycle and Transform</h2>
<p>The fastest way for you to generate content ideas is by reading through existing content and expanding and improving on it. This means looking though what your competitors are writing about, and using that as a beacon to light your own blog posts. It is about taking already existing material, not copying it, but using it as a starting point for your own inspiration.</p>
<p>An important thing to consistently keep in mind when expanding and improving existing material is to not limit yourself to the original piece; to consider what else readers would benefit from knowing. Perhaps you could make the piece more personal and relatable by referencing your personal experiences.</p>
<div id="attachment_3639" style="width: 515px" class="wp-caption aligncenter"><img class="wp-image-3639" src="https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot.png" alt="Using Feedly, you can quickly find out what your competitors are writing about and use their content as a source of inspiration for your own." width="505" height="369" srcset="https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot.png 1280w, https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot-300x219.png 300w, https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot-768x561.png 768w, https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot-1024x748.png 1024w, https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot-342x250.png 342w, https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot-100x73.png 100w, https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot-150x110.png 150w, https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot-200x146.png 200w, https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot-450x329.png 450w, https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot-600x438.png 600w, https://semperplugins.com/wp-content/uploads/2016/12/feedly-screenshot-900x657.png 900w" sizes="(max-width: 505px) 100vw, 505px" /><p class="wp-caption-text">Using Feedly, you can quickly find out what your competitors are writing about and use their content as a source of inspiration for your own.</p></div>
<p>So how can you discover other content in your niche? Use tools such as <a href="https://feedly.com/" target="_blank" rel="noopener">Feedly</a> which shows you a list of publications that have been produced about a certain topic. Once you create an account, you can simply enter in specific keywords, URLs, or browse through existing categories.</p>
<h2>Read Every Day</h2>
<p>Reading every day actually means reading something relevant to your niche every single day. By doing so, you will find that over time, not only will your knowledge of the subject matter improve substantially, but that new sources of inspiration will spring up as well.</p>
<p>Reading content written by others in your field and the comments left behind by their users is also a good way to find inspiration. When reading through other peoples content, you may notice that similar problems keep cropping up but have remained unanswered. You can subsequently try to answer those questions in depth and address those issues in your own blog.</p>
<p>Visit popular blogs and websites, and observe the different ways in which they operate. Pay close attention to their writing style, and the topics that they are covering. You will slowly begin to pick up fresh ideas, and gain exposure to different viewpoints.</p>
<p>Reading stimulates the brain, thus making it that much easier for you to generate great content ideas.</p>
<h2>How to Tackle Writer’s Block</h2>
<p>So you&#8217;ve found inspiration and are now struggling with writer&#8217;s block. One of the best techniques to overcome it is simply to write! Write something down every single day, no matter how small, or jumbled. The point is to get all your ideas down on paper, which you can later revise and expand on.</p>
<p>Keep your work well organized, and easy to refer back to. You can use online note applications such as <a href="http://evernote.com/" target="_blank" rel="noopener">Evernote</a> or Google Docs to keep your work backed up and easily accessible.</p>
<p>Having something to start with makes that blank page much less intimidating.</p>
<h2>In a Nutshell</h2>
<p>Once you get started using these tips and tricks, you will find that generating good content ideas is not as difficult as it may have initially seemed. So we hope this post has helped you to find inspiration for your next engaging blog post. The truth is, you really never know when your next source of inspiration may strike, so best of luck to you!</p>
<p>Do you have any special tricks to come up with great content ideas? Share them with your fellow readers below in the comment section!</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:71:"https://semperplugins.com/how-to-come-up-with-great-content-ideas/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"29";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:51:"
		
		
		
		
		
				
		
		
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:40:"How to Build a Landing Page in WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:64:"https://semperplugins.com/how-to-build-a-wordpress-landing-page/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:73:"https://semperplugins.com/how-to-build-a-wordpress-landing-page/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 07 Jul 2017 13:00:33 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:4:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:13:"landing pages";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:17:"WordPress plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:16:"WordPress themes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"https://semperplugins.com/?p=3441/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:419:"What a lot of people don&#8217;t know is that you can build great landing pages for your WordPress site without having to break the bank by hiring services from lead generation and marketing companies. You can even create a landing<span class="ellipsis">&#8230;</span><div class="read-more"><a href="https://semperplugins.com/how-to-build-a-wordpress-landing-page/">Read more &#8250;</a></div><!-- end of .read-more -->";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Arnaud";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:14070:"<p><img class="size-full wp-image-3668 aligncenter" src="https://semperplugins.com/wp-content/uploads/2017/09/how-to-build-a-landing-page-featured.jpg" alt="You can either build a WordPress landing page yourself using a customized page template or by installing a specialized landing page builder plugin." width="850" height="250" srcset="https://semperplugins.com/wp-content/uploads/2017/09/how-to-build-a-landing-page-featured.jpg 850w, https://semperplugins.com/wp-content/uploads/2017/09/how-to-build-a-landing-page-featured-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2017/09/how-to-build-a-landing-page-featured-768x226.jpg 768w, https://semperplugins.com/wp-content/uploads/2017/09/how-to-build-a-landing-page-featured-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2017/09/how-to-build-a-landing-page-featured-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2017/09/how-to-build-a-landing-page-featured-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2017/09/how-to-build-a-landing-page-featured-450x132.jpg 450w, https://semperplugins.com/wp-content/uploads/2017/09/how-to-build-a-landing-page-featured-600x176.jpg 600w" sizes="(max-width: 850px) 100vw, 850px" /></p>
<p>What a lot of people don&#8217;t know is that you can build great landing pages for your WordPress site without having to break the bank by hiring services from lead generation and marketing companies.</p>
<p>You can even <strong>create a landing page yourself in less than 10 minutes</strong>. We’ll show you how.</p>
<p>First things first, let&#8217;s cover the basics of landing pages.</p>
<h2>Why Should I Build a Landing Page?</h2>
<p>Because they convert. A landing page is essentially the entry point to your site. A great landing page will <strong>grab a visitor’s attention and persuade them to take a desired action</strong>: perhaps you want them to sign up for your email list, download a brochure, buy a product, etc. Whatever the goal, a good landing page is always focused towards that goal.</p>
<p>Just to make sure that you understand, let’s look at the difference between a landing page and the homepage of a site: <strong>a landing page is focused on a specific goal or objective</strong> while your main homepage has a broad objective. The aim of a landing page is to take your visitors through a specific marketing journey while the main homepage allows visitors to decide on their own journey through your site.</p>
<p>Anyone can tell you that you don&#8217;t really need a landing page to get a visitor to take a specific action. You can actually make them take the desired action on your homepage.</p>
<p>BUT, <strong>with a good landing page you will achieve a higher conversion rate</strong> because it is very specific in its goal. A homepage has a lot of information and elements that may distract a user from taking the desired action.</p>
<p>So, are you ready to build one? Here are several ways to build landing pages in WordPress.</p>
<h2>Building a Custom Page</h2>
<p>Building a custom page within WordPress is the old-fashioned approach. You would simply just build a custom page template on any theme you have; and do whatever you need to in the template.</p>
<p>The easiest way to build a custom page template in WordPress is to copy the default page PHP template and edit CSS and HTML components to get the desired design or structure.</p>
<h2>Using Plugins to Build Landing Pages</h2>
<p>Plugins are the best way to go if you do not want to worry about dealing with code.</p>
<p>Unfortunately, there aren’t many free landing page builder plugins out there. And the few free ones often have in-plugin purchases or limited features. There is, however, one free plugin that has all the features you need to build a functional landing page in WordPress. It’s among the top landing page plugins (see below).</p>
<h3>WordPress Landing Pages</h3>
<p><a href="https://wordpress.org/plugins/landing-pages/" target="_blank" rel="noopener">WordPress Landing Pages</a> is an easy-to-use plugin that has <strong>all the basic features you need to build a functional landing page</strong>. It has a fair selection of templates, allows you to split test (a/b testing) your landing pages, as well as to track and measure conversions.</p>
<div id="attachment_3482" style="width: 723px" class="wp-caption aligncenter"><img class="wp-image-3482" src="https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages.png" alt="The WordPress Landing Pages plugin is fully integrated in the Theme Builder and allows you to quickly customize any elements you like." width="713" height="373" srcset="https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages.png 1920w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-300x157.png 300w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-768x402.png 768w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-1024x537.png 1024w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-477x250.png 477w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-100x52.png 100w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-150x79.png 150w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-200x105.png 200w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-450x236.png 450w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-600x314.png 600w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-900x472.png 900w, https://semperplugins.com/wp-content/uploads/2017/06/wordpress-landing-pages-1200x630.png 1200w" sizes="(max-width: 713px) 100vw, 713px" /><p class="wp-caption-text">The WordPress Landing Pages plugin is fully integrated in the Theme Builder and allows you to quickly customize any elements you like.</p></div>
<p>All in all, it is a good option if you are on a budget and don’t want to invest in a more functional landing page plugin at the moment.</p>
<h3>Thrive Landing Pages</h3>
<p><a href="https://thrivethemes.com/landingpages/" target="_blank" rel="noopener">Thrive Landing Pages</a> has a drag &amp; drop editor that makes it extremely easy to create and edit landing pages. It<strong> comes with over 140 templates</strong> (some themed) for you to choose from. The great thing about the plugin is that the landing pages are combined in sets to provide a consistent user experience. That means that the opt-in page, &#8220;thank you&#8221; page and confirmation pages in a particular set have the same feel and don’t provide random experiences.</p>
<h3>Leadpages</h3>
<p>Leadpages is actually an online landing page builder &#8211; we’ll be addressing it more thoroughly down below &#8211; with a plugin for WordPress. It has a centralized editor and your <strong>landing pages are hosted on Leadpages servers</strong>. The best thing about Leadpages is that you can easily and quickly create or publish a landing page. All you need to do is choose a template, customize it (through the drag &amp; drop page builder) and add it to your site.</p>
<h3>Beaver Builder</h3>
<p><a href="https://www.wpbeaverbuilder.com/" target="_blank" rel="noopener">Beaver Builder</a> is simply a drag &amp; drop page theme builder (another option covered below) that also comes as a plugin. You can easily and quickly create custom layouts and designs &#8211; you have around 30 landing pages to choose from.</p>
<div id="attachment_3483" style="width: 734px" class="wp-caption aligncenter"><img class="wp-image-3483" src="https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder.jpg" alt="You can try out the Beaver Builder plugin for yourself at http://demo.wpbeaverbuilder.com/." width="724" height="361" srcset="https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder.jpg 1917w, https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder-300x150.jpg 300w, https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder-768x383.jpg 768w, https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder-1024x511.jpg 1024w, https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder-501x250.jpg 501w, https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder-100x50.jpg 100w, https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder-150x75.jpg 150w, https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder-200x100.jpg 200w, https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder-450x225.jpg 450w, https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder-600x300.jpg 600w, https://semperplugins.com/wp-content/uploads/2017/06/beaver-builder-900x449.jpg 900w" sizes="(max-width: 724px) 100vw, 724px" /><p class="wp-caption-text">You can try out the Beaver Builder plugin for yourself at <a href="http://demo.wpbeaverbuilder.com/" target="_blank" rel="noopener">demo.wpbeaverbuilder.com</a>.</p></div>
<p>The great thing about Beaver Builder is that <strong>you can use your WordPress widgets to add more functionality</strong> and bring elements in from your site to your landing pages.</p>
<h3>OptimizePress</h3>
<p>You’ve probably heard of <a href="https://www.optimizepress.com/" target="_blank" rel="noopener">OptimizePress</a> before &#8211; it has been <strong>one of the most popular plugins</strong> to build landing pages for quite some time. That’s because it offers a wide range of templates and a powerful drag &amp; drop editor to quickly create the landing page you need. Note: the size of the plugin is quite large (29MB).</p>
<h2>Theme Builders</h2>
<p>As we mentioned earlier, <strong>most WordPress themes are quite restrictive when it comes to design and structure</strong>. For example, you can customize the primary content block of a page in most themes but you cannot amend the design of anything outside the block. So, if you aim to create a landing page from a theme page template, you would just end up with a new page with the same design as your website &#8211; the opposite of a landing page. Unless you build a custom page template (mentioned earlier) or use advanced theme builders.</p>
<p>What advanced theme builders offer are drag and drop builders. They essentially enable you to customize every and any design aspect of any page. The interface is also very easy to use.<br />
There are plenty of great drag &amp; drop theme builders available. A few off the top of my head: <a href="https://www.elegantthemes.com/gallery/divi/" target="_blank" rel="noopener">Divi</a>, <a href="https://wpexplorer-themes.com/total/" target="_blank" rel="noopener">Total</a>, Beaver Builder (its plugin version is recommended above) and <a href="http://demo.qodeinteractive.com/strata/" target="_blank" rel="noopener">Strata</a>.</p>
<p>If you need a variety of landing page templates, it is highly recommended you use this method instead of creating custom theme templates. It will save you time and make your work much easier.</p>
<h2>Leadpages</h2>
<p><a href="https://www.leadpages.net/" target="_blank" rel="noopener">Leadpages is known for creating stunning and functional landing pages</a>. It offers dozens of integrations to help make your WordPress landing page user friendly and attractive. The downside is that it isn’t free: plans start at $36.99 per month.</p>
<div id="attachment_3484" style="width: 743px" class="wp-caption aligncenter"><img class="wp-image-3484" src="https://semperplugins.com/wp-content/uploads/2017/06/leadpages.jpg" alt="Leadpages has more than a hundred of templates to choose from that can be added to your site within minutes." width="733" height="362" srcset="https://semperplugins.com/wp-content/uploads/2017/06/leadpages.jpg 1877w, https://semperplugins.com/wp-content/uploads/2017/06/leadpages-300x148.jpg 300w, https://semperplugins.com/wp-content/uploads/2017/06/leadpages-768x379.jpg 768w, https://semperplugins.com/wp-content/uploads/2017/06/leadpages-1024x506.jpg 1024w, https://semperplugins.com/wp-content/uploads/2017/06/leadpages-506x250.jpg 506w, https://semperplugins.com/wp-content/uploads/2017/06/leadpages-100x49.jpg 100w, https://semperplugins.com/wp-content/uploads/2017/06/leadpages-150x74.jpg 150w, https://semperplugins.com/wp-content/uploads/2017/06/leadpages-200x99.jpg 200w, https://semperplugins.com/wp-content/uploads/2017/06/leadpages-450x222.jpg 450w, https://semperplugins.com/wp-content/uploads/2017/06/leadpages-600x296.jpg 600w, https://semperplugins.com/wp-content/uploads/2017/06/leadpages-900x444.jpg 900w" sizes="(max-width: 733px) 100vw, 733px" /><p class="wp-caption-text">Leadpages has more than a hundred of templates to choose from that can be added to your site within minutes.</p></div>
<p>What you get is <strong>144+ well-designed templates</strong>, a simple editor that enables you to create and <strong>publish a stunning landing page in 10 minutes</strong> or less and the ability to split test your landing pages.</p>
<p>It’s not a stretch to say that Leadpages is the most popular landing page option. It is actually hard to find a popular blog online that doesn’t use it. Two of the many reasons for it’s popularity is that you do not need to be a designer to use it and all their templates have been tested as effective and high converting templates.</p>
<p>The price may be worth it to you if you want to save time, as the platform is incredibly easy to use.</p>
<h2>Wrapping Up</h2>
<p>Although WordPress may not be designed to handle landing pages, you can easily create one using either the old-fashioned method of building a custom page template or by using a plugin. Above we mentioned some of the best plugins you can use to build highly functional and attractive landing pages, developer or not.</p>
<p>Choose the method that works best for your business and start collecting, cultivating and converting leads!</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:69:"https://semperplugins.com/how-to-build-a-wordpress-landing-page/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"38";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:51:"
		
		
		
		
		
				
		
		
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:52:"WordPress Will Require Users to Have HTTPS This Year";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:64:"https://semperplugins.com/wordpress-requires-sites-to-use-https/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:73:"https://semperplugins.com/wordpress-requires-sites-to-use-https/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 06 Jun 2017 18:32:54 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:4:{i:0;a:5:{s:4:"data";s:8:"Security";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:14:"WordPress News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:5:"HTTPS";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:18:"WordPress security";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"https://semperplugins.com/?p=3129/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:471:"WordPress founder, Matt Mullenweg, recently announced that the software will require all hosts to have HTTPS for certain WordPress features to function. Don’t panic just yet. If you already have HTTPS, this shouldn’t affect you. But if you’re still using HTTP, you’ll need<span class="ellipsis">&#8230;</span><div class="read-more"><a href="https://semperplugins.com/wordpress-requires-sites-to-use-https/">Read more &#8250;</a></div><!-- end of .read-more -->";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:6:"Arnaud";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:12957:"<p><img class="size-full wp-image-3666 aligncenter" src="https://semperplugins.com/wp-content/uploads/2017/09/wordpress-requires-https-featured.jpg" alt="HTTPS will not only be an important ranking factor in the future for search machines, but also required for both existing and new WordPress installations." width="850" height="250" srcset="https://semperplugins.com/wp-content/uploads/2017/09/wordpress-requires-https-featured.jpg 850w, https://semperplugins.com/wp-content/uploads/2017/09/wordpress-requires-https-featured-300x88.jpg 300w, https://semperplugins.com/wp-content/uploads/2017/09/wordpress-requires-https-featured-768x226.jpg 768w, https://semperplugins.com/wp-content/uploads/2017/09/wordpress-requires-https-featured-100x29.jpg 100w, https://semperplugins.com/wp-content/uploads/2017/09/wordpress-requires-https-featured-150x44.jpg 150w, https://semperplugins.com/wp-content/uploads/2017/09/wordpress-requires-https-featured-200x59.jpg 200w, https://semperplugins.com/wp-content/uploads/2017/09/wordpress-requires-https-featured-450x132.jpg 450w, https://semperplugins.com/wp-content/uploads/2017/09/wordpress-requires-https-featured-600x176.jpg 600w" sizes="(max-width: 850px) 100vw, 850px" /></p>
<p>WordPress founder, Matt Mullenweg, <a href="https://wordpress.org/news/2016/12/moving-toward-ssl/">recently announced that the software will require all hosts to have HTTPS for certain WordPress features</a> to function.</p>
<p>Don’t panic just yet. If you already have HTTPS, this shouldn’t affect you. <strong>But if you’re still using HTTP, you’ll need to upgrade soon.</strong> The good news is that the transition is not as difficult as you think it is and the benefits outweigh the assumed disadvantages.</p>
<p>This article will go over what the WordPress HTTPS mandate means for you as a site owner; the advantages; as well as how to upgrade to HTTPS if you haven’t already done so.</p>
<h2>What is HTTPS?</h2>
<p>HTTPS adds a security layer to HTTP (Hypertext Transfer Protocol). <strong>HTTPS essentially encrypts data</strong> (using SSL or TSL) that is communicated between servers and clients until it reaches the intended recipient.</p>
<p>This<strong> prevents cybercriminals from accessing sensitive user information</strong> and also reduces the risk of tapping and modification of sensitive data. Although HTTPS is not completely foolproof, it undoubtedly has major security advantages.</p>
<p>HTTPS sites can be easily identified, as they have a locked padlock icon located on the link bar in most common browsers.</p>
<h2>Why is WordPress Pushing HTTPS?</h2>
<p>There&#8217;s mainly two reasons for this, so let&#8217;s quickly dive into them.</p>
<h3>Google Prefers It</h3>
<p>It is no secret that greater encryption and cyber security has made the Internet a safer place for users. As usual, a Google update signaled the necessity of HTTPS for user experience, SEO and internet security.</p>
<p>In 2014, Google suggested that <strong>enabling HTTPS on your site could result in higher search rankings</strong>. Although it still isn’t the only important factor in raising your site rankings, you shouldn’t underestimate its value. For example, if two sites are equal in all ways, but one site has HTTPS, that site would get a boost in rankings.</p>
<div id="attachment_3342" style="width: 511px" class="wp-caption aligncenter"><img class="wp-image-3342" src="https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock.png" alt="Chrome will display a green padlock in the link bar when a site is using HTTPS, assuring users it\'s using the latest security protocol." width="501" height="217" srcset="https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock.png 1138w, https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock-300x130.png 300w, https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock-768x333.png 768w, https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock-1024x444.png 1024w, https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock-577x250.png 577w, https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock-100x43.png 100w, https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock-150x65.png 150w, https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock-200x87.png 200w, https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock-450x195.png 450w, https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock-600x260.png 600w, https://semperplugins.com/wp-content/uploads/2017/03/https-green-padlock-900x390.png 900w" sizes="(max-width: 501px) 100vw, 501px" /><p class="wp-caption-text">Chrome will display a green padlock in the link bar when a site is using HTTPS, assuring users it&#8217;s using the latest security protocol.</p></div>
<p>In January of this year, Google released version 56 of Google Chrome. This new release brought about some changes, notably with how Google Chrome treats HTTPS vs. HTTP sites. The browser now clearly identifies sites that are not operating HTTPS on their systems. For example, <strong>a “Not Secure” message now appears on pages without HTTPS that try to collect passwords or sensitive information</strong>. You can expect that, eventually, all pages not using HTTPS will clearly be labeled as having insecure connections.</p>
<p>We can reasonably assume that Google’s preference for HTTPS has been a contributing factor for the changes implemented by WordPress.</p>
<h3>Users Prefer HTTPS Too</h3>
<p>A secure connection can make all the difference from a user&#8217;s perspective. Users see HTTPS as a positive signal that you are taking your site security seriously, for their benefit. So, having <strong>HTTPS could mean more traffic and longer usage times</strong> on your site.</p>
<p>HTTPS is particularly important if you are operating an e-commerce site. Simply seeing the padlock icon could make users more comfortable in entering their payment details and other personal information. Particularly with the new Chrome update (mentioned earlier) which shows a “Not Secure” label on e-commerce sites or sites that require a user login or credit card information, but don’t have HTTPS.</p>
<p>Both Google and user preference should be enough reason for you to upgrade your site to HTTPS. It is simply necessary to ensure watertight security for your users and to protect your online business reputation.</p>
<div id="attachment_3343" style="width: 510px" class="wp-caption aligncenter"><img class=" wp-image-3343" src="https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure.png" alt="Sites that require users to login or enter credit card information are now displayed as &quot;Not secure&quot; in Chrome when they haven\'t switched to HTTPS yet." width="500" height="196" srcset="https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure.png 1600w, https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure-300x118.png 300w, https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure-768x301.png 768w, https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure-1024x401.png 1024w, https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure-638x250.png 638w, https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure-100x39.png 100w, https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure-150x59.png 150w, https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure-200x78.png 200w, https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure-450x176.png 450w, https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure-600x235.png 600w, https://semperplugins.com/wp-content/uploads/2017/03/https-not-secure-900x353.png 900w" sizes="(max-width: 500px) 100vw, 500px" /><p class="wp-caption-text">Sites that require users to login or enter credit card information are now displayed as &#8220;Not secure&#8221; in Chrome when they haven&#8217;t switched to HTTPS yet.</p></div>
<p>Remember when JavaScript was first introduced and quickly embraced by users and webmasters? Looking back, we can see now that JavaScript was essential for smoother and better user experience. HTTPS similarly, presents a number of unique advantages for user experience and security that we should all quickly embrace.</p>
<p>We know that you may be overwhelmed switching from HTTP to HTTPS. After all, change does takes time to get used to, but in this instance, you may need to quickly get on board. At this point, <strong>the advantages of HTTPS have greatly outnumbered the disadvantages</strong>. Plus, upgrading to HTTPS is no longer the costly, time consuming, and difficult process that it once was. In fact, getting an SSL certificate in 2017 is fast, sometimes free, and quite easy to implement.</p>
<h2>How to Get HTTPS</h2>
<p><a href="https://wordpress.org/hosting/" target="_blank" rel="noopener noreferrer">WordPress hosting partners</a> should now provide an SSL certificate for all accounts. (It is required that they all do so as early as the first quarter of this year.)</p>
<p>Your hosting provider may already provide a free SSL certificate, so check with them first before you make any third-party purchase. If they do not offer a free one, you could ask them if they sell third party SSL certificates. Once purchased, you can ask your provider to install the certificate for you on your server.</p>
<div id="attachment_3344" style="width: 510px" class="wp-caption aligncenter"><img class=" wp-image-3344" src="https://semperplugins.com/wp-content/uploads/2017/03/lets-encrypt-sponsors.png" alt="Dozens of major companies are already backing Lets Encrypt, including Automattic (known for WooCommerce, Jetpack, Akismet and WordPress.com)" width="500" height="395" srcset="https://semperplugins.com/wp-content/uploads/2017/03/lets-encrypt-sponsors.png 546w, https://semperplugins.com/wp-content/uploads/2017/03/lets-encrypt-sponsors-300x237.png 300w, https://semperplugins.com/wp-content/uploads/2017/03/lets-encrypt-sponsors-317x250.png 317w, https://semperplugins.com/wp-content/uploads/2017/03/lets-encrypt-sponsors-100x79.png 100w, https://semperplugins.com/wp-content/uploads/2017/03/lets-encrypt-sponsors-150x118.png 150w, https://semperplugins.com/wp-content/uploads/2017/03/lets-encrypt-sponsors-200x158.png 200w, https://semperplugins.com/wp-content/uploads/2017/03/lets-encrypt-sponsors-450x355.png 450w" sizes="(max-width: 500px) 100vw, 500px" /><p class="wp-caption-text">Dozens of major companies are already backing Lets Encrypt, including Automattic (known for WooCommerce, Akismet and WordPress.com)</p></div>
<p>Another option is to explore the free alternatives, independent of your hosting provider. There are projects such as “Let’s Encrypt” which have now made it easy and quick to <a href="https://letsencrypt.org/" target="_blank" rel="noopener noreferrer">secure a free HTTPS certificate for your website</a>.</p>
<p>Let’s Encrypt is an authorized open Certificate Authority with millions of active certificates in place. There are other comparable projects out there that can help by guiding you step-by-step through the installation process or who have been authorized to deliver certificates.</p>
<p>Remember that SSL certificates upgrade the website, but not the content itself. That means that the content on your page will also need to be updated so as to avoid 404 errors. Google may interpret the error as a mismatch in the security level of your site. The only way to avoid this is by encrypting the content of your website to match your SSL certificate.</p>
<p>To track and resolve any 404 errors on your site, you may want to use a specialised plugin such as Redirection to do so.</p>
<h2>What if You Just Don’t Want to Upgrade to HTTPS?</h2>
<p>You could see a number of things happening to your site over time if you do not upgrade to HTTPS. The first may be facing the consequences set out by Google, i.e: <strong>lower rankings </strong>and having your users staring at a “Not Secure” warning when they try to access your site via Google Chrome.</p>
<p>The second is that you could <strong>struggle with WordPress updates and lose some or all functionality</strong> on specific WordPress plugins.</p>
<p>Third, your site may be <strong>an easier target for hacking</strong>.</p>
<p>Those are three consequences that require you to seriously reconsider if you really want to take the risk of not upgrading to HTTPS.</p>
<h2>Wrapping Up</h2>
<p>Let’s put it this way: you will simply have nothing to lose by adopting HTTPS. Yet, if you do not use HTTPS, you could risk leaving your site in the “dark ages” of the Internet.</p>
<p>But then again, if you’re a WordPress site owner, you have no choice. Take the plunge and let us know how it worked out for you!</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:69:"https://semperplugins.com/wordpress-requires-sites-to-use-https/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"56";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:51:"
		
		
		
		
		
				
		
		
		

		
		
				
			
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:44:"All in One SEO Pack at WordCamp Raleigh 2017";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:71:"https://semperplugins.com/all-in-one-seo-pack-at-wordcamp-raleigh-2017/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:80:"https://semperplugins.com/all-in-one-seo-pack-at-wordcamp-raleigh-2017/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 30 May 2017 15:42:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:4:{i:0;a:5:{s:4:"data";s:19:"All in One SEO Pack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:16:"WordCamp Raleigh";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:13:"WordPress SEO";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"https://semperplugins.com/?p=3426/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:417:"Last month, the team from All in One SEO Pack were in attendance at WordCamp Raleigh 2017.  We were not only there are organizers of the event but also as sponsors and speakers. If you didn&#8217;t get a chance to attend<span class="ellipsis">&#8230;</span><div class="read-more"><a href="https://semperplugins.com/all-in-one-seo-pack-at-wordcamp-raleigh-2017/">Read more &#8250;</a></div><!-- end of .read-more -->";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Steve Mortiboy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:3680:"<p>Last month, the team from All in One SEO Pack were in attendance at <a href="https://2017.raleigh.wordcamp.org/" target="_blank" rel="noopener noreferrer">WordCamp Raleigh 2017</a>.  We were not only there are organizers of the event but also as sponsors and speakers.</p>
<p>If you didn&#8217;t get a chance to attend WordCamp Raleigh then here&#8217;s a recap of the event.</p>
<p>WordCamp Raleigh is a conference all about WordPress.  The event has been held each year since 2010.  This year was the best attended yet, with over 300 attendees.  This year we had four tracks &#8211; Beginner, Business, Power User and Developer. We also added workshops in addition to the tracks.  There were three workshops &#8211; Beginners Guide to WordPress, WordPress REST API and Beginners Guide to WordPress SEO.  All three were extremely popular.</p>
<h2>Local SEO presentation by Steve Mortiboy</h2>
<p>I spoke on the topic of Local SEO &#8211; How to get your business listed on Google&#8217;s local search results.  Here are my slides from this presentation:</p>
<p><iframe src="https://www.slideshare.net/slideshow/embed_code/key/4Ssk3Lm2vq2l18" width="427" height="356" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #CCC; border-width:1px; margin-bottom:5px; max-width: 100%;" allowfullscreen> </iframe> </p>
<div style="margin-bottom:5px"> <strong> <a href="https://www.slideshare.net/dismort/local-seo-getting-your-local-business-on-google" title="Local SEO - Getting your local business on google" target="_blank">Local SEO &#8211; Getting your local business on google</a> </strong> from <strong><a href="https://www.slideshare.net/dismort" target="_blank">Steve Mortiboy</a></strong> </div>
<p>Here is the video from my presentation on WordPress.tv:</p>
<p><iframe width=\'605\' height=\'340\' src=\'https://videopress.com/embed/u6Rx29m9?hd=0\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>
<h2>Social Meta Optimization by Tony Zeoli</h2>
<p>In addition to my session, Tony Zeoli also gave a presentation on Social Meta Optimization where he used All in One SEO Pack to demonstrate how you can improve you social media presence.  You can find more about Tony&#8217;s presentation on his <a href="https://tonyzeoli.com/2017/05/28/social-meta-optimization-presentation-at-wordcamp-raleigh-2017/2062/" target="_blank" rel="noopener noreferrer">website</a>.  The video from his presentation is also on WordPress.tv here:</p>
<p><iframe width=\'605\' height=\'340\' src=\'https://videopress.com/embed/rG2jN5os?hd=0\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>
<h2>Beginners Guide to SEO by Tony Zeoli</h2>
<p>Finally, Tony Zeoli also presented the Beginners Guide to WordPress SEO workshop which was held on the Sunday at WordCamp Raleigh.  This workshop was not recorded on video but you can find a write by Tony and links to his slides on his <a href="https://tonyzeoli.com/2017/05/20/wordcamp-raleigh-2017-wordpress-seo-for-beginners-workshop/1998/" target="_blank" rel="noopener noreferrer">website</a>.</p>
<p>If you didn&#8217;t get a chance to attend WordCamp Raleigh this year, keep a watch on the <a href="https://2017.raleigh.wordcamp.org/" target="_blank" rel="noopener noreferrer">website</a> for announcements regarding WordCamp Raleigh 2018.  Or you can find a WordCamp in your city or country by checking out the central <a href="https://central.wordcamp.org/schedule/" target="_blank" rel="noopener noreferrer">WordCamp schedule</a>.</p>
";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:76:"https://semperplugins.com/all-in-one-seo-pack-at-wordcamp-raleigh-2017/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"4";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:31:"https://semperplugins.com/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:42:"Requests_Utility_CaseInsensitiveDictionary":1:{s:7:" * data";a:15:{s:6:"server";s:5:"nginx";s:4:"date";s:29:"Wed, 31 Oct 2018 15:21:56 GMT";s:12:"content-type";s:34:"application/rss+xml; charset=UTF-8";s:14:"content-length";s:5:"22305";s:7:"expires";s:29:"Thu, 19 Nov 1981 08:52:00 GMT";s:13:"cache-control";s:35:"no-store, no-cache, must-revalidate";s:6:"pragma";s:8:"no-cache";s:3:"p3p";s:69:"CP="IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT"";s:12:"x-robots-tag";s:15:"noindex, follow";s:4:"link";s:62:"<https://semperplugins.com/wp-json/>; rel="https://api.w.org/"";s:10:"set-cookie";a:2:{i:0;s:44:"PHPSESSID=l53b5ti2f9u3tjsnfi995ms0j0; path=/";i:1;s:70:"Cart66DBSID=1N6543Y75BE4YRRQ2OJ6A7K633KABJKBPFV8LWYM; path=/; HttpOnly";}s:13:"last-modified";s:29:"Tue, 30 Oct 2018 17:50:22 GMT";s:4:"etag";s:39:""259a434ed7b541bcf45980afd44d0906-gzip"";s:4:"vary";s:15:"Accept-Encoding";s:16:"content-encoding";s:4:"gzip";}}s:5:"build";s:14:"20130911040210";}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5688', '_transient_timeout_feed_mod_54af7cb0f50a8f4f8cdb30f2d9b4f50c', '1541042517', 'no'); 
INSERT INTO `mod63_options` VALUES ('5689', '_transient_feed_mod_54af7cb0f50a8f4f8cdb30f2d9b4f50c', '1540999317', 'no'); 
INSERT INTO `mod63_options` VALUES ('5692', '_transient_timeout_wc_report_sales_by_date', '1541086329', 'no'); 
INSERT INTO `mod63_options` VALUES ('5693', '_transient_wc_report_sales_by_date', 'a:16:{s:32:"a1f164a72771f8b44aecb4c209c65c90";a:0:{}s:32:"6b6904090c86167424cd0a287919f343";a:0:{}s:32:"81d7b33a0c82abe3adc4ad46cd216237";a:0:{}s:32:"ffaf3c17ca42a16efa64073c1bca8a72";N;s:32:"50a3a785ae12c8bcb65857d6747552ff";a:0:{}s:32:"72b8e3fcc17adae037ae0881c0da5236";a:0:{}s:32:"0883a645ceb6ec8a09f883bc6e3f1eab";a:0:{}s:32:"4499bf8a412ffb45fe2224723a596a75";a:0:{}s:32:"ae2b97aa7b165e505c41abbbb1e6a436";a:0:{}s:32:"384209735eb157cea635071baec4c8d1";a:0:{}s:32:"53b19e7bc3901a4381f57ae650b5e2f1";a:0:{}s:32:"624f284872348b2e026c776ce4c48bfd";N;s:32:"5decfbdd454e6c435da68c7f2bbdcb56";a:0:{}s:32:"3f8da024df0c59ef727077abfc8d05d9";a:0:{}s:32:"1f7860f48460dd32f6cc4f8f5a7bd99d";a:0:{}s:32:"44d00570a55df9159f4d425079646c98";a:0:{}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5694', '_transient_timeout_wc_admin_report', '1541085717', 'no'); 
INSERT INTO `mod63_options` VALUES ('5695', '_transient_wc_admin_report', 'a:1:{s:32:"434d56d56fc999e852b7f4909fb52ffb";a:0:{}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5696', '_transient_timeout_feed_3ca2a73478cc83bbe37e39039b345a78', '1541042707', 'no'); 
INSERT INTO `mod63_options` VALUES ('5697', '_transient_feed_3ca2a73478cc83bbe37e39039b345a78', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"


";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:49:"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:4:"WPFR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:16:"https://wpfr.net";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:31:"Site officiel de la communauté";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 31 Oct 2018 15:21:33 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"fr-FR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:39:"
		
		
		
		
		
				
		

		
		
		
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:52:"WP BootCamp 2018 : retours sur la deuxième édition";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/73jXJKLX5xI/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:74:"https://wpfr.net/wp-bootcamp-2018-retours-sur-la-deuxieme-edition/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 23 Oct 2018 06:05:16 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:16:"Association WPFR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:27:"https://wpfr.net/?p=2215483";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1449:"Qu&#8217;est ce que le WP BootCamp ? Le WP BootCamp est un événement réunissant des passionnés de WordPress et du web en général sur un week-end de 3 jours. L&#8217;édition 2018, portée par Rémi Corson, Aurélien Denis et Benjamin Denis, se déroula au château de Ker Nelly à Trébeurden en Bretagne, du 21 au 24<div class="btn btn-default read-more text-uppercase">Lire la suite <span class="meta-nav"><i class="fa fa-caret-right"></i></span></div><div class="feedflare">
<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=73jXJKLX5xI:kXAjLDU4P-c:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=73jXJKLX5xI:kXAjLDU4P-c:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=73jXJKLX5xI:kXAjLDU4P-c:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=73jXJKLX5xI:kXAjLDU4P-c:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=73jXJKLX5xI:kXAjLDU4P-c:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=73jXJKLX5xI:kXAjLDU4P-c:gIN9vFwOqvQ" border="0"></img></a>
</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/73jXJKLX5xI" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Benjamin Denis";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:71:"https://wpfr.net/wp-bootcamp-2018-retours-sur-la-deuxieme-edition/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:66:"https://wpfr.net/wp-bootcamp-2018-retours-sur-la-deuxieme-edition/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:45:"
		
		
		
		
		
				
		
		
		

		
		
		
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:71:"Tout savoir sur l’arrivée de Gutenberg en quelques points essentiels";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/i6NQjnc9uiQ/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:46:"https://wpfr.net/wordpress-gutenberg/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 23 Apr 2018 09:00:07 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:4:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:15:"éditeur visuel";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:9:"Gutenberg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:27:"https://wpfr.net/?p=2117903";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1474:"Gutenberg arrive à grand pas, alors voici un résumé de tout ce qu&#8217;il faut savoir sur le nouvel éditeur visuel de WordPress au travers de questions / réponses ! Difficile de marcher tranquillement dans le quartier WordPress sans entendre parler de ce fameux Gutenberg ! C&#8217;est un nouvel éditeur ? C&#8217;est un nouveau page builder<div class="btn btn-default read-more text-uppercase">Lire la suite <span class="meta-nav"><i class="fa fa-caret-right"></i></span></div><div class="feedflare">
<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i6NQjnc9uiQ:TQYicJ8IHdE:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i6NQjnc9uiQ:TQYicJ8IHdE:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=i6NQjnc9uiQ:TQYicJ8IHdE:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i6NQjnc9uiQ:TQYicJ8IHdE:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i6NQjnc9uiQ:TQYicJ8IHdE:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=i6NQjnc9uiQ:TQYicJ8IHdE:gIN9vFwOqvQ" border="0"></img></a>
</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/i6NQjnc9uiQ" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"maximebj";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:42:"https://wpfr.net/wordpress-gutenberg/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"13";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:37:"https://wpfr.net/wordpress-gutenberg/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:39:"
		
		
		
		
		
				
		

		
		
		
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:40:"Résultats des élections du bureau 2018";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/qvTDw6NqY5Q/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:58:"https://wpfr.net/resultats-elections-bureau-2018/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 05 Mar 2018 08:00:52 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:16:"Association WPFR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:27:"https://wpfr.net/?p=2107099";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1521:"Suite à la votation électronique qui s&#8217;est déroulée du 24 février au 3 mars 2018, nous vous communiquons les résultats pour l&#8217;élection du bureau 2018. Vous avez été 40% des adhérents à participer au vote, soit 85 suffrages exprimés. C&#8217;est pratiquement autant de votants que l&#8217;an passé avec un nombre d&#8217;adhérents moins élevé, l&#8217;abstention reste<div class="btn btn-default read-more text-uppercase">Lire la suite <span class="meta-nav"><i class="fa fa-caret-right"></i></span></div><div class="feedflare">
<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=qvTDw6NqY5Q:LD0dZBWRJa4:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=qvTDw6NqY5Q:LD0dZBWRJa4:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=qvTDw6NqY5Q:LD0dZBWRJa4:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=qvTDw6NqY5Q:LD0dZBWRJa4:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=qvTDw6NqY5Q:LD0dZBWRJa4:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=qvTDw6NqY5Q:LD0dZBWRJa4:gIN9vFwOqvQ" border="0"></img></a>
</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/qvTDw6NqY5Q" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Aurélien Denis";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:54:"https://wpfr.net/resultats-elections-bureau-2018/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"13";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:49:"https://wpfr.net/resultats-elections-bureau-2018/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:39:"
		
		
		
		
		
				
		

		
		
		
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:34:"Liste des candidats au bureau 2018";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/mYCnwrPtTAY/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:54:"https://wpfr.net/liste-candidats-bureau-2018/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 16 Feb 2018 11:45:20 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:16:"Association WPFR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:27:"https://wpfr.net/?p=2092699";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1508:"Les élections pour le renouvellement du bureau auront lieu du 24 février au 3 mars 2018 par voie électronique. Nous vous communiquons dès à présent la liste des candidats validée par l&#8217;actuel bureau, classés par ordre alphabétique. Les candidats Willy Bahuaud Présentation Je suis développeur full-stack. Après quelques années passées en agence à Nantes, j’ai<div class="btn btn-default read-more text-uppercase">Lire la suite <span class="meta-nav"><i class="fa fa-caret-right"></i></span></div><div class="feedflare">
<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=mYCnwrPtTAY:g4F7i0PDxEQ:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=mYCnwrPtTAY:g4F7i0PDxEQ:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=mYCnwrPtTAY:g4F7i0PDxEQ:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=mYCnwrPtTAY:g4F7i0PDxEQ:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=mYCnwrPtTAY:g4F7i0PDxEQ:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=mYCnwrPtTAY:g4F7i0PDxEQ:gIN9vFwOqvQ" border="0"></img></a>
</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/mYCnwrPtTAY" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Aurélien Denis";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:50:"https://wpfr.net/liste-candidats-bureau-2018/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:45:"https://wpfr.net/liste-candidats-bureau-2018/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:39:"
		
		
		
		
		
				
		

		
		
		
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"WPFR sponsor du WP Tech Lyon !";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/kVgok7MJrJM/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:51:"https://wpfr.net/wpfr-sponsor-wptech-lyon/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 12 Feb 2018 07:00:30 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:11:"Evènements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:27:"https://wpfr.net/?p=2082223";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1507:"L’association WPFR est fière de vous annoncer qu’elle sponsorise WP Tech 2018 qui aura lieu le 28 avril à Lyon. Le WP Tech est une journée de conférences et d’ateliers exclusivement consacrée aux aspects techniques de WordPress. Vous y découvrirez des outils pour améliorer vos méthodes de travail, apprendrez de nouvelles méthodes de développements d’extensions,<div class="btn btn-default read-more text-uppercase">Lire la suite <span class="meta-nav"><i class="fa fa-caret-right"></i></span></div><div class="feedflare">
<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kVgok7MJrJM:wfMH9NuDwps:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kVgok7MJrJM:wfMH9NuDwps:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=kVgok7MJrJM:wfMH9NuDwps:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kVgok7MJrJM:wfMH9NuDwps:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kVgok7MJrJM:wfMH9NuDwps:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=kVgok7MJrJM:wfMH9NuDwps:gIN9vFwOqvQ" border="0"></img></a>
</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/kVgok7MJrJM" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Aurélien Denis";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:47:"https://wpfr.net/wpfr-sponsor-wptech-lyon/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:42:"https://wpfr.net/wpfr-sponsor-wptech-lyon/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:45:"
		
		
		
		
		
				
		
		
		

		
		
		
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:64:"Loi anti-fraude et l’e-commerce : les informations officielles";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/KBb85wMEo0g/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:86:"https://wpfr.net/loi-anti-fraude-et-le-commerce-les-informations-officielles/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 31 Jan 2018 14:51:34 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:4:{i:0;a:5:{s:4:"data";s:10:"Extensions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:21:"WordPress Francophone";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:15:"Loi anti-fraude";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:11:"WooCommerce";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:27:"https://wpfr.net/?p=2072415";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1503:"Cette nouvelle loi a fait couler pas mal d&#8217;encre ces derniers temps et afin d&#8217;apporter des réponses concrètes et officielles, nous nous sommes penchés sur le sujet en profondeur. Voici donc ce qu&#8217;il en ressort officiellement : Les plateformes e-commerce open source sont bien concernées par la loi anti-fraude Que ce soit WooCommerce, Magento, Prestashop,<div class="btn btn-default read-more text-uppercase">Lire la suite <span class="meta-nav"><i class="fa fa-caret-right"></i></span></div><div class="feedflare">
<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KBb85wMEo0g:NZq1YCx1Y5E:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KBb85wMEo0g:NZq1YCx1Y5E:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KBb85wMEo0g:NZq1YCx1Y5E:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KBb85wMEo0g:NZq1YCx1Y5E:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KBb85wMEo0g:NZq1YCx1Y5E:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KBb85wMEo0g:NZq1YCx1Y5E:gIN9vFwOqvQ" border="0"></img></a>
</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/KBb85wMEo0g" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"maximebj";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:82:"https://wpfr.net/loi-anti-fraude-et-le-commerce-les-informations-officielles/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"39";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:77:"https://wpfr.net/loi-anti-fraude-et-le-commerce-les-informations-officielles/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:39:"
		
		
		
		
		
				
		

		
		
		
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"L’élection du bureau WPFR 2018";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/BC2q8usn6uA/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:52:"https://wpfr.net/election-bureau-wpfr-2018/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 15 Jan 2018 11:30:54 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:16:"Association WPFR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:27:"https://wpfr.net/?p=2041252";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1530:"Comme annoncé lors de l’assemblée générale du 12 décembre 2017, l&#8217;heure des élections a sonné. Le bureau actuellement en place voit son mandat terminé, de nouvelles élections doivent donc avoir lieu afin de le renouveler  Ces élections sont prévues pour le 26 février 2018 et nous invitons les membres l&#8217;association désireux d&#8217;occuper des responsabilités nationales à<div class="btn btn-default read-more text-uppercase">Lire la suite <span class="meta-nav"><i class="fa fa-caret-right"></i></span></div><div class="feedflare">
<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BC2q8usn6uA:rovaWM-7xzU:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BC2q8usn6uA:rovaWM-7xzU:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BC2q8usn6uA:rovaWM-7xzU:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BC2q8usn6uA:rovaWM-7xzU:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BC2q8usn6uA:rovaWM-7xzU:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BC2q8usn6uA:rovaWM-7xzU:gIN9vFwOqvQ" border="0"></img></a>
</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/BC2q8usn6uA" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Aurélien Denis";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wpfr.net/election-bureau-wpfr-2018/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:43:"https://wpfr.net/election-bureau-wpfr-2018/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:30:"
		
		
		
		
				
		

		
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:3:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:49:"PHP Tour Montpellier 2018 : WPFR est partenaire !";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/i_ty7z2Kg6A/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 11 Jan 2018 10:12:56 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:16:"Association WPFR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:27:"https://wpfr.net/?p=2035309";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1489:"WPFR est fière d&#8217;être partenaire du PHP Tour Montpellier 2018 qui se tiendra les 17 et 18 mai. Cet évènement porté par l&#8217;AFUP (Association Française des Utilisateurs de PHP) rassemble une sélection d&#8217;orateurs reconnus du monde PHP. Et comme vous le savez, WordPress repose en grande partie sur le langage PHP. Si vous êtes développeurs,<div class="btn btn-default read-more text-uppercase">Lire la suite <span class="meta-nav"><i class="fa fa-caret-right"></i></span></div><div class="feedflare">
<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i_ty7z2Kg6A:5FE8vgrgZLs:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i_ty7z2Kg6A:5FE8vgrgZLs:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=i_ty7z2Kg6A:5FE8vgrgZLs:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i_ty7z2Kg6A:5FE8vgrgZLs:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i_ty7z2Kg6A:5FE8vgrgZLs:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=i_ty7z2Kg6A:5FE8vgrgZLs:gIN9vFwOqvQ" border="0"></img></a>
</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/i_ty7z2Kg6A" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Aurélien Denis";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:59:"https://wpfr.net/php-tour-montpellier-2018-wpfr-partenaire/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:39:"
		
		
		
		
		
				
		

		
		
		
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:41:"Le point sur les certifications WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/SbTm014V92I/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:57:"https://wpfr.net/point-certifications-wordpress/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 11 Dec 2017 17:15:46 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:16:"Association WPFR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:27:"https://wpfr.net/?p=2001761";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1552:"Le sujet des certifications WordPress est de retour en cette fin d&#8217;année pour faire un point de situation. L&#8217;association s&#8217;est penchée dessus et voici les conclusions actuelles. Pour rappel, j&#8217;avais émis l&#8217;idée en 2016 de faire certifier les formations WordPress. D&#8217;autres idées ont ensuite suivi, dont notamment celle d&#8217;inscrire WordPress au Registre National des Certifications<div class="btn btn-default read-more text-uppercase">Lire la suite <span class="meta-nav"><i class="fa fa-caret-right"></i></span></div><div class="feedflare">
<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=SbTm014V92I:Cd3SuKi-siI:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=SbTm014V92I:Cd3SuKi-siI:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=SbTm014V92I:Cd3SuKi-siI:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=SbTm014V92I:Cd3SuKi-siI:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=SbTm014V92I:Cd3SuKi-siI:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=SbTm014V92I:Cd3SuKi-siI:gIN9vFwOqvQ" border="0"></img></a>
</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/SbTm014V92I" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"maximebj";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:53:"https://wpfr.net/point-certifications-wordpress/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:2:"11";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wpfr.net/point-certifications-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:39:"
		
		
		
		
		
				
		

		
		
		
		
		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:56:"Certification WordPress par WPFR, appel à contributions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"http://feedproxy.google.com/~r/WordpressFrancophone/~3/UUGDJmDzVjE/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:75:"https://wpfr.net/certification-wordpress-wpfr-appel-contributions/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 19 Oct 2017 06:46:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:16:"Association WPFR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:27:"https://wpfr.net/?p=1931227";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1508:"Le chantier lié à la mise en place d&#8217;une certification WordPress accessible via le Compte Personnel de Formation (CPF) et enregistré auprès du Registre National des Certifications Professionnelles (RNCP) est en marche. Ce dernier est mené par Maxime Bernard-Jacquet avec nous l&#8217;espérons des résultats concrets pour 2018. Cette mission a été relancée lors de la<div class="btn btn-default read-more text-uppercase">Lire la suite <span class="meta-nav"><i class="fa fa-caret-right"></i></span></div><div class="feedflare">
<a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=UUGDJmDzVjE:jTMHK5CfDEs:yIl2AUoC8zA"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=UUGDJmDzVjE:jTMHK5CfDEs:V_sGLiPBpWU"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=UUGDJmDzVjE:jTMHK5CfDEs:V_sGLiPBpWU" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=UUGDJmDzVjE:jTMHK5CfDEs:qj6IDK7rITs"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs" border="0"></img></a> <a href="http://feeds.feedburner.com/~ff/WordpressFrancophone?a=UUGDJmDzVjE:jTMHK5CfDEs:gIN9vFwOqvQ"><img src="http://feeds.feedburner.com/~ff/WordpressFrancophone?i=UUGDJmDzVjE:jTMHK5CfDEs:gIN9vFwOqvQ" border="0"></img></a>
</div><img src="http://feeds.feedburner.com/~r/WordpressFrancophone/~4/UUGDJmDzVjE" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"Aurélien Denis";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:71:"https://wpfr.net/certification-wordpress-wpfr-appel-contributions/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"5";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:66:"https://wpfr.net/certification-wordpress-wpfr-appel-contributions/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:2:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";s:4:"href";s:48:"http://feeds.feedburner.com/WordpressFrancophone";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:3:"hub";s:4:"href";s:32:"http://pubsubhubbub.appspot.com/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:4:{s:4:"info";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:1:{s:3:"uri";s:20:"wordpressfrancophone";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:14:"emailServiceId";a:1:{i:0;a:5:{s:4:"data";s:20:"WordpressFrancophone";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:18:"feedburnerHostname";a:1:{i:0;a:5:{s:4:"data";s:29:"https://feedburner.google.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"feedFlare";a:9:{i:0;a:5:{s:4:"data";s:24:"Subscribe with NewsGator";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:112:"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:42:"http://www.newsgator.com/images/ngsub1.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:24:"Subscribe with Bloglines";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:77:"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone";s:3:"src";s:48:"http://www.bloglines.com/images/sub_modern11.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:23:"Subscribe with Netvibes";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:98:"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:39:"//www.netvibes.com/img/add2netvibes.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:21:"Subscribe with Google";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:93:"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:51:"http://buttons.googlesyndication.com/fusion/add.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:25:"Subscribe with Pageflakes";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:101:"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:87:"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:21:"Subscribe with Plusmo";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:86:"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:43:"http://plusmo.com/res/graphics/fbplusmo.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:23:"Subscribe with Live.com";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:81:"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:141:"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:7;a:5:{s:4:"data";s:25:"Subscribe with Mon Yahoo!";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:99:"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:60:"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:8;a:5:{s:4:"data";s:25:"Subscribe with Excite MIX";s:7:"attribs";a:1:{s:0:"";a:2:{s:4:"href";s:89:"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone";s:3:"src";s:42:"http://image.excite.co.uk/mix/addtomix.gif";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:52:"http://backend.userland.com/creativeCommonsRssModule";a:1:{s:7:"license";a:1:{i:0;a:5:{s:4:"data";s:49:"http://creativecommons.org/licenses/by-nc-sa/3.0/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:42:"Requests_Utility_CaseInsensitiveDictionary":1:{s:7:" * data";a:11:{s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:4:"etag";s:27:"q3zoUyDSsSsZNj0cE4v9aPLsuRM";s:13:"last-modified";s:29:"Wed, 31 Oct 2018 15:17:50 GMT";s:16:"content-encoding";s:4:"gzip";s:4:"date";s:29:"Wed, 31 Oct 2018 15:25:07 GMT";s:7:"expires";s:29:"Wed, 31 Oct 2018 15:25:07 GMT";s:13:"cache-control";s:18:"private, max-age=0";s:22:"x-content-type-options";s:7:"nosniff";s:16:"x-xss-protection";s:13:"1; mode=block";s:6:"server";s:3:"GSE";s:7:"alt-svc";s:40:"quic=":443"; ma=2592000; v="44,43,39,35"";}}s:5:"build";s:14:"20130911040210";}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5698', '_transient_timeout_feed_mod_3ca2a73478cc83bbe37e39039b345a78', '1541042707', 'no'); 
INSERT INTO `mod63_options` VALUES ('5699', '_transient_feed_mod_3ca2a73478cc83bbe37e39039b345a78', '1540999507', 'no'); 
INSERT INTO `mod63_options` VALUES ('5700', '_transient_timeout_feed_76f8d9281c01f21e505004d0986f50c6', '1541042707', 'no'); 
INSERT INTO `mod63_options` VALUES ('5701', '_transient_feed_76f8d9281c01f21e505004d0986f50c6', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:5:"
		
	";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:79:"
		
		
		
		
		
		
					
						
						
						
						
						
						
						
					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"Planète WordPress Francophone";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:17:"https://wpfr.net/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:49:"Toute l’actualité de WordPress en français !";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"fr-FR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:8:{i:0;a:6:{s:4:"data";s:84:"
		        
		        
		        
		        
		        
		        
		        
		    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:47:"Mises à jour de sécurité chez Elegant Themes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpfr/~3/-28hI3w2h0Q/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:60:"https://wpformation.com/mise-a-jour-securite-elegant-themes/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 30 Oct 2018 21:53:43 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:610:"
		        Aujourd&#8217;hui mardi 30 octobre 2018, les produits Divi, Extra et Divi Builder ont été mis à jour pour améliorer la sécurité globale et résoudre des problèmes de sécurité identifiés par l&#8217;équipe Elegant Themes et un chercheur indépendant en sécurité. La mise à jour de ces produits vers leurs dernières versions appliquera le correctif, ce qui sécurisera [&#8230;]

L’article Mises à jour de sécurité chez Elegant Themes est apparu en premier sur WPFormation. Tutoriels WordPress, Formation WordPress, Woocommerce, SEO. Abonnez-vous pour ne rien manquer !
		        ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"WP Formation";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:1482:"<p><img width="1541" height="814" src="https://wpformation.com/wp-content/uploads/2018/10/mise-a-jour-securite-Elegant-themes.jpg" class="attachment-Large size-Large wp-post-image" alt="mise a jour securite Elegant themes" style="margin-left: 0px;margin-right: auto;margin-top:10px;margin-bottom:10px;max-width: 640px;max-height: 400px" />Aujourd&#8217;hui mardi 30 octobre 2018, les produits Divi, Extra et Divi Builder ont été mis à jour pour améliorer la sécurité globale et résoudre des problèmes de sécurité identifiés par l&#8217;équipe Elegant Themes et un chercheur indépendant en sécurité. La mise à jour de ces produits vers leurs dernières versions appliquera le correctif, ce qui sécurisera [&#8230;]</p>
<hr />
L’article <a rel="nofollow" href="https://wpformation.com/mise-a-jour-securite-elegant-themes/">Mises à jour de sécurité chez Elegant Themes</a> est apparu en premier sur <a href="https://wpformation.com/">WPFormation</a>.<br /> <a href="https://wpformation.com/wordpress/">Tutoriels WordPress</a>, <a href="https://wpformation.com/formation-wordpress/">Formation WordPress</a>, <a href="https://wpformation.com/formation-woocommerce-e-commerce/">Woocommerce</a>, <a href="https://wpformation.com/formation-wordpress-pro/">SEO</a>. <a href="https://wpformation.com/abonnement-newsletter-wpf/">Abonnez-vous</a> pour ne rien manquer !</p>
<hr /><img src="http://feeds.feedburner.com/~r/wpfr/~4/-28hI3w2h0Q" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:60:"https://wpformation.com/mise-a-jour-securite-elegant-themes/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:84:"
		        
		        
		        
		        
		        
		        
		        
		    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:83:"Afficher les sous catégories (termes) d’une taxonomie dans un menu personnalisé";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpfr/~3/-RAy2hPtJ8Y/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:107:"https://wpchannel.com/wordpress/tutoriels-wordpress/afficher-categories-termes-taxonomie-menu-personnalise/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 28 Oct 2018 08:36:22 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:507:"
		        La fonction get_term_children de WordPress nous permet de créer une liste de termes enfants en se basant sur l&#8217;élément parent en cours de visite. C&#8217;est une méthode efficace pour créer un menu de navigation interne à vos différents pages d&#8217;archives de termes (catégories, étiquettes ou taxonomie personnalisée). Rappelons tout d&#8217;abord quelques bases d&#8217;architecture sous WordPress. Nous avons des types de contenus que sont les articles, [&#8230;]		        ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"WP Channel";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:783:"<div class="post-thumbnail"><img width="356" height="327" src="https://wpchannel.com/images/2018/10/wordpress-menu-personnalise-356x327.jpg" class="attachment-large size-large wp-post-image" alt="" /></div>La fonction get_term_children de WordPress nous permet de créer une liste de termes enfants en se basant sur l&#8217;élément parent en cours de visite. C&#8217;est une méthode efficace pour créer un menu de navigation interne à vos différents pages d&#8217;archives de termes (catégories, étiquettes ou taxonomie personnalisée). Rappelons tout d&#8217;abord quelques bases d&#8217;architecture sous WordPress. Nous avons des types de contenus que sont les articles, [&#8230;]<img src="http://feeds.feedburner.com/~r/wpfr/~4/-RAy2hPtJ8Y" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:107:"https://wpchannel.com/wordpress/tutoriels-wordpress/afficher-categories-termes-taxonomie-menu-personnalise/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:84:"
		        
		        
		        
		        
		        
		        
		        
		    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:84:"Le guide des erreurs WordPress : comment les résoudre sans s’arracher les cheveux";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpfr/~3/B1qMJFytlzU/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:113:"https://wpmarmite.com/erreurs-wordpress/?utm_source=rss&#038;utm_medium=rss&%23038;utm_campaign=erreurs-wordpress";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 24 Oct 2018 06:00:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:355:"
		        
Sueurs froides, hurlements, et même envies de meurtre : les erreurs WordPress nous rendent zinzins, tout en nous filant encore plus les pétoches que Jack Nicholson dans Shining. “Écran blanc...
L’article Le guide des erreurs WordPress : comment les résoudre sans s’arracher les cheveux est apparu en premier sur WP Marmite.		        ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"WP Marmite";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:725:"<p><img width="1500" height="750" src="https://wpmarmite.com/wp-content/uploads/2018/10/erreurs-wp.jpg" class="attachment-full size-full wp-post-image" alt="" /></p>
<p>Sueurs froides, hurlements, et même envies de meurtre : les erreurs WordPress nous rendent zinzins, tout en nous filant encore plus les pétoches que Jack Nicholson dans Shining. “Écran blanc...</p>
<p>L’article <a rel="nofollow" href="https://wpmarmite.com/erreurs-wordpress/">Le guide des erreurs WordPress : comment les résoudre sans s’arracher les cheveux</a> est apparu en premier sur <a rel="nofollow" href="https://wpmarmite.com">WP Marmite</a>.</p><img src="http://feeds.feedburner.com/~r/wpfr/~4/B1qMJFytlzU" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:113:"https://wpmarmite.com/erreurs-wordpress/?utm_source=rss&#038;utm_medium=rss&%23038;utm_campaign=erreurs-wordpress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:84:"
		        
		        
		        
		        
		        
		        
		        
		    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:32:"Mes Slides du WordCamp Nice 2018";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpfr/~3/9_F1ryiv97A/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:63:"https://www.thivinfo.com/blog/mes-slides-du-wordcamp-nice-2018/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 19 Oct 2018 13:00:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:123:"
		        Et voilà les slides de ma 1ère conférence en tant qu&#8217;orateur qui a eu lieu au WordCamp Nice !		        ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:193:"Et voilà les slides de ma 1ère conférence en tant qu&#8217;orateur qui a eu lieu au WordCamp Nice !<img src="http://feeds.feedburner.com/~r/wpfr/~4/9_F1ryiv97A" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:63:"https://www.thivinfo.com/blog/mes-slides-du-wordcamp-nice-2018/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:84:"
		        
		        
		        
		        
		        
		        
		        
		    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"L’éditeur moderne de WordPress avec Grid Layout CSS";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpfr/~3/ebgzzaadrzg/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:84:"https://www.gregoirenoyelle.com/editeur-moderne-wordpress-gutenberg-grid-layout-css/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 19 Oct 2018 11:36:36 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:558:"
		        Dans ce tutoriel, nous verrons comment utiliser l&#8217;éditeur moderne de WordPress pour créer des pages qui repose sur Grid CSS. Si vous connaissez mal cette nouvelle propriété, je vous recommande ma série dédiée sur Grid Layout. Utilisation du nouvel éditeur de WordPress Avec la version 5 de WordPress, l&#8217;éditeur moderne va remplacer le bon vieux ...Cet article a été publié le 19 octobre 2018 par Grégoire Noyelle. Pour le lire en ligne, suivre le lien: L&rsquo;éditeur moderne de WordPress avec Grid Layout CSS.		        ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:780:"Dans ce tutoriel, nous verrons comment utiliser l&#8217;éditeur moderne de WordPress pour créer des pages qui repose sur Grid CSS. Si vous connaissez mal cette nouvelle propriété, je vous recommande ma série dédiée sur Grid Layout. Utilisation du nouvel éditeur de WordPress Avec la version 5 de WordPress, l&#8217;éditeur moderne va remplacer le bon vieux ...<p>Cet article a été publié le 19 octobre 2018 par <a href="https://www.gregoirenoyelle.com">Grégoire Noyelle</a>. Pour le lire en ligne, suivre le lien: <a href="https://www.gregoirenoyelle.com/editeur-moderne-wordpress-gutenberg-grid-layout-css/">L&rsquo;éditeur moderne de WordPress avec Grid Layout CSS</a>.</p><img src="http://feeds.feedburner.com/~r/wpfr/~4/ebgzzaadrzg" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:84:"https://www.gregoirenoyelle.com/editeur-moderne-wordpress-gutenberg-grid-layout-css/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:84:"
		        
		        
		        
		        
		        
		        
		        
		    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:56:"Comment trouver un bon thème WordPress pour photographe";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpfr/~3/1tEOjpi1_ec/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:121:"https://wpmarmite.com/theme-wordpress-photo/?utm_source=rss&#038;utm_medium=rss&%23038;utm_campaign=theme-wordpress-photo";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 17 Oct 2018 06:00:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:332:"
		        
Lorsque je visite certains sites de photographes, je suis souvent surpris par leur complexité. Photos de couples, de mariages, de bébés, de familles, d&rsquo;événements : la plupart du temps, les...
L’article Comment trouver un bon thème WordPress pour photographe est apparu en premier sur WP Marmite.		        ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"WP Marmite";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:713:"<p><img width="1500" height="750" src="https://wpmarmite.com/wp-content/uploads/2018/06/theme-photographe.jpg" class="attachment-full size-full wp-post-image" alt="" /></p>
<p>Lorsque je visite certains sites de photographes, je suis souvent surpris par leur complexité. Photos de couples, de mariages, de bébés, de familles, d&rsquo;événements : la plupart du temps, les...</p>
<p>L’article <a rel="nofollow" href="https://wpmarmite.com/theme-wordpress-photo/">Comment trouver un bon thème WordPress pour photographe</a> est apparu en premier sur <a rel="nofollow" href="https://wpmarmite.com">WP Marmite</a>.</p><img src="http://feeds.feedburner.com/~r/wpfr/~4/1tEOjpi1_ec" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:121:"https://wpmarmite.com/theme-wordpress-photo/?utm_source=rss&#038;utm_medium=rss&%23038;utm_campaign=theme-wordpress-photo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:84:"
		        
		        
		        
		        
		        
		        
		        
		    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:28:"Retour sur le WP BootCamp #2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpfr/~3/cqQx3fhLxOU/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:57:"https://wpchannel.com/actualites-wordpress/wp-bootcamp-2/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 11 Oct 2018 09:51:58 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:491:"
		        La seconde édition du WP BootCamp s&#8217;est déroulée avec succès du 21 au 24 septembre 2018 du côté de Trébeurden en Bretagne. Pour l&#8217;occasion, nous avions loué le château de Ker Nelly, une demeure néo-médiévale capable d&#8217;accueillir 16 participants de la communauté WordPress. Échanges professionnels, partage et moments de détente ont rythmé ce weekend au programme bien chargé. Un mélange de conférences et d&#8217;activités [&#8230;]		        ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"WP Channel";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:765:"<div class="post-thumbnail"><img width="356" height="327" src="https://wpchannel.com/images/2018/10/team-wp-bootcamp-bretagne-356x327.jpg" class="attachment-large size-large wp-post-image" alt="" /></div>La seconde édition du WP BootCamp s&#8217;est déroulée avec succès du 21 au 24 septembre 2018 du côté de Trébeurden en Bretagne. Pour l&#8217;occasion, nous avions loué le château de Ker Nelly, une demeure néo-médiévale capable d&#8217;accueillir 16 participants de la communauté WordPress. Échanges professionnels, partage et moments de détente ont rythmé ce weekend au programme bien chargé. Un mélange de conférences et d&#8217;activités [&#8230;]<img src="http://feeds.feedburner.com/~r/wpfr/~4/cqQx3fhLxOU" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:57:"https://wpchannel.com/actualites-wordpress/wp-bootcamp-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:84:"
		        
		        
		        
		        
		        
		        
		        
		    ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:11:"Bulk Delete";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"http://feedproxy.google.com/~r/wpfr/~3/PCEA76D1mkU/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:56:"https://www.echodesplugins.li-an.fr/plugins/bulk-delete/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 10 Oct 2018 14:26:24 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:79:"
		        Supprimer une liste de pages, d’articles plus rapidement		        ";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:149:"Supprimer une liste de pages, d’articles plus rapidement<img src="http://feeds.feedburner.com/~r/wpfr/~4/PCEA76D1mkU" height="1" width="1" alt=""/>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:8:"origLink";a:1:{i:0;a:5:{s:4:"data";s:56:"https://www.echodesplugins.li-an.fr/plugins/bulk-delete/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:52:"http://backend.userland.com/creativeCommonsRssModule";a:1:{s:7:"license";a:1:{i:0;a:5:{s:4:"data";s:49:"http://creativecommons.org/licenses/by-nc-sa/3.0/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:2:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";s:4:"href";s:32:"http://feeds.feedburner.com/wpfr";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:2:{s:3:"rel";s:3:"hub";s:4:"href";s:32:"http://pubsubhubbub.appspot.com/";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:42:"http://rssnamespace.org/feedburner/ext/1.0";a:1:{s:4:"info";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:1:{s:3:"uri";s:4:"wpfr";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:42:"Requests_Utility_CaseInsensitiveDictionary":1:{s:7:" * data";a:11:{s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:4:"etag";s:27:"KAVPSQvegdGWu4qkDQDyqYpqtms";s:13:"last-modified";s:29:"Wed, 31 Oct 2018 14:59:26 GMT";s:16:"content-encoding";s:4:"gzip";s:4:"date";s:29:"Wed, 31 Oct 2018 15:25:07 GMT";s:7:"expires";s:29:"Wed, 31 Oct 2018 15:25:07 GMT";s:13:"cache-control";s:18:"private, max-age=0";s:22:"x-content-type-options";s:7:"nosniff";s:16:"x-xss-protection";s:13:"1; mode=block";s:6:"server";s:3:"GSE";s:7:"alt-svc";s:40:"quic=":443"; ma=2592000; v="44,43,39,35"";}}s:5:"build";s:14:"20130911040210";}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5702', '_transient_timeout_feed_mod_76f8d9281c01f21e505004d0986f50c6', '1541042707', 'no'); 
INSERT INTO `mod63_options` VALUES ('5703', '_transient_feed_mod_76f8d9281c01f21e505004d0986f50c6', '1540999507', 'no'); 
INSERT INTO `mod63_options` VALUES ('5704', '_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af', '1541042707', 'no'); 
INSERT INTO `mod63_options` VALUES ('5705', '_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af', '<div class="rss-widget"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/WordpressFrancophone/~3/73jXJKLX5xI/\'>WP BootCamp 2018 : retours sur la deuxième édition</a></li></ul></div><div class="rss-widget"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/wpfr/~3/-28hI3w2h0Q/\'>Mises à jour de sécurité chez Elegant Themes</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/wpfr/~3/-RAy2hPtJ8Y/\'>Afficher les sous catégories (termes) d’une taxonomie dans un menu personnalisé</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/wpfr/~3/B1qMJFytlzU/\'>Le guide des erreurs WordPress : comment les résoudre sans s’arracher les cheveux</a></li></ul></div>', 'no'); 
INSERT INTO `mod63_options` VALUES ('5706', '_site_transient_timeout_community-events-7cca50062359cb4732805ec13813dc10', '1541042708', 'no'); 
INSERT INTO `mod63_options` VALUES ('5707', '_site_transient_community-events-7cca50062359cb4732805ec13813dc10', 'a:2:{s:8:"location";a:1:{s:2:"ip";s:13:"197.155.143.0";}s:6:"events";a:0:{}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5713', '_transient_timeout__woocommerce_helper_updates', '1541043169', 'no'); 
INSERT INTO `mod63_options` VALUES ('5714', '_transient__woocommerce_helper_updates', 'a:4:{s:4:"hash";s:32:"d751713988987e9331980363e24189ce";s:7:"updated";i:1540999969;s:8:"products";a:0:{}s:6:"errors";a:1:{i:0;s:10:"http-error";}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5715', '_transient_timeout_plugin_slugs', '1541107565', 'no'); 
INSERT INTO `mod63_options` VALUES ('5716', '_transient_plugin_slugs', 'a:27:{i:0;s:19:"akismet/akismet.php";i:1;s:43:"all-in-one-seo-pack/all_in_one_seo_pack.php";i:2;s:35:"backup-database/backup-database.php";i:3;s:53:"cc-bcc-for-woocommerce-order-emails/dc-cc-bcc-woe.php";i:4;s:35:"fourteen-colors/fourteen-colors.php";i:5;s:29:"gmap-embed/srm_gmap_embed.php";i:6;s:36:"google-sitemap-generator/sitemap.php";i:7;s:25:"gtranslate/gtranslate.php";i:8;s:9:"hello.php";i:9;s:95:"ic-hide-add-to-cart-and-prices-in-woocommerce/IC-Hide-add-to-cart-and-prices-in-WooCommerce.php";i:10;s:45:"kadence-custom-fonts/kadence-custom-fonts.php";i:11;s:37:"kadence-importer/kadence-importer.php";i:12;s:39:"kadence-recaptcha/kadence-recaptcha.php";i:13;s:33:"kadence-slider/kadence-slider.php";i:14;s:33:"virtue-toolkit/virtue_toolkit.php";i:15;s:23:"ml-slider/ml-slider.php";i:16;s:39:"siteorigin-panels/siteorigin-panels.php";i:17;s:49:"simple-file-downloader/simple-file-downloader.php";i:18;s:39:"simple-pdf-viewer/simple-pdf-viewer.php";i:19;s:39:"so-widgets-bundle/so-widgets-bundle.php";i:20;s:33:"wd-google-maps/wd-google-maps.php";i:21;s:27:"woocommerce/woocommerce.php";i:22;s:43:"woocommerce-colors-1/woocommerce-colors.php";i:23;s:87:"woocommerce-google-analytics-integration-1/woocommerce-google-analytics-integration.php";i:24;s:41:"wordpress-importer/wordpress-importer.php";i:25;s:45:"wp-notification-bars/wp-notification-bars.php";i:26;s:21:"wp-reset/wp-reset.php";}', 'no'); 
INSERT INTO `mod63_options` VALUES ('5717', '_transient_timeout_wc_upgrade_notice_3.5.0', '1541086370', 'no'); 
INSERT INTO `mod63_options` VALUES ('5718', '_transient_wc_upgrade_notice_3.5.0', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('5742', 'woocommerce_placeholder_image', '', 'yes'); 
INSERT INTO `mod63_options` VALUES ('5757', '_transient_as_comment_count', 'O:8:"stdClass":7:{s:8:"approved";s:1:"2";s:14:"total_comments";i:2;s:3:"all";i:2;s:9:"moderated";i:0;s:4:"spam";i:0;s:5:"trash";i:0;s:12:"post-trashed";i:0;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('5830', 'category_children', 'a:0:{}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('5992', '_site_transient_timeout_aioseop_update_check_time', '1541031616', 'no'); 
INSERT INTO `mod63_options` VALUES ('5993', '_site_transient_aioseop_update_check_time', '1541010016', 'no'); 
INSERT INTO `mod63_options` VALUES ('6039', '_site_transient_timeout_available_translations', '1541023550', 'no'); 
INSERT INTO `mod63_options` VALUES ('6040', '_site_transient_available_translations', 'a:113:{s:2:"af";a:8:{s:8:"language";s:2:"af";s:7:"version";s:5:"4.9.4";s:7:"updated";s:19:"2018-02-06 13:56:09";s:12:"english_name";s:9:"Afrikaans";s:11:"native_name";s:9:"Afrikaans";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.4/af.zip";s:3:"iso";a:2:{i:1;s:2:"af";i:2;s:3:"afr";}s:7:"strings";a:1:{s:8:"continue";s:10:"Gaan voort";}}s:2:"ar";a:8:{s:8:"language";s:2:"ar";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-22 00:11:36";s:12:"english_name";s:6:"Arabic";s:11:"native_name";s:14:"العربية";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/ar.zip";s:3:"iso";a:2:{i:1;s:2:"ar";i:2;s:3:"ara";}s:7:"strings";a:1:{s:8:"continue";s:16:"المتابعة";}}s:3:"ary";a:8:{s:8:"language";s:3:"ary";s:7:"version";s:5:"4.7.7";s:7:"updated";s:19:"2017-01-26 15:42:35";s:12:"english_name";s:15:"Moroccan Arabic";s:11:"native_name";s:31:"العربية المغربية";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.7/ary.zip";s:3:"iso";a:2:{i:1;s:2:"ar";i:3;s:3:"ary";}s:7:"strings";a:1:{s:8:"continue";s:16:"المتابعة";}}s:2:"as";a:8:{s:8:"language";s:2:"as";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-22 18:59:07";s:12:"english_name";s:8:"Assamese";s:11:"native_name";s:21:"অসমীয়া";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/as.zip";s:3:"iso";a:3:{i:1;s:2:"as";i:2;s:3:"asm";i:3;s:3:"asm";}s:7:"strings";a:1:{s:8:"continue";s:0:"";}}s:3:"azb";a:8:{s:8:"language";s:3:"azb";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-12 20:34:31";s:12:"english_name";s:17:"South Azerbaijani";s:11:"native_name";s:29:"گؤنئی آذربایجان";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip";s:3:"iso";a:2:{i:1;s:2:"az";i:3;s:3:"azb";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"az";a:8:{s:8:"language";s:2:"az";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-06 00:09:27";s:12:"english_name";s:11:"Azerbaijani";s:11:"native_name";s:16:"Azərbaycan dili";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/az.zip";s:3:"iso";a:2:{i:1;s:2:"az";i:2;s:3:"aze";}s:7:"strings";a:1:{s:8:"continue";s:5:"Davam";}}s:3:"bel";a:8:{s:8:"language";s:3:"bel";s:7:"version";s:5:"4.9.5";s:7:"updated";s:19:"2018-04-04 08:43:29";s:12:"english_name";s:10:"Belarusian";s:11:"native_name";s:29:"Беларуская мова";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.9.5/bel.zip";s:3:"iso";a:2:{i:1;s:2:"be";i:2;s:3:"bel";}s:7:"strings";a:1:{s:8:"continue";s:20:"Працягнуць";}}s:5:"bg_BG";a:8:{s:8:"language";s:5:"bg_BG";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-13 19:50:59";s:12:"english_name";s:9:"Bulgarian";s:11:"native_name";s:18:"Български";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/bg_BG.zip";s:3:"iso";a:2:{i:1;s:2:"bg";i:2;s:3:"bul";}s:7:"strings";a:1:{s:8:"continue";s:12:"Напред";}}s:5:"bn_BD";a:8:{s:8:"language";s:5:"bn_BD";s:7:"version";s:5:"4.8.6";s:7:"updated";s:19:"2017-10-01 12:57:10";s:12:"english_name";s:7:"Bengali";s:11:"native_name";s:15:"বাংলা";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.6/bn_BD.zip";s:3:"iso";a:1:{i:1;s:2:"bn";}s:7:"strings";a:1:{s:8:"continue";s:23:"এগিয়ে চল.";}}s:2:"bo";a:8:{s:8:"language";s:2:"bo";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-29 03:20:48";s:12:"english_name";s:7:"Tibetan";s:11:"native_name";s:21:"བོད་ཡིག";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/bo.zip";s:3:"iso";a:2:{i:1;s:2:"bo";i:2;s:3:"tib";}s:7:"strings";a:1:{s:8:"continue";s:24:"མུ་མཐུད།";}}s:5:"bs_BA";a:8:{s:8:"language";s:5:"bs_BA";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-04 20:20:28";s:12:"english_name";s:7:"Bosnian";s:11:"native_name";s:8:"Bosanski";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/bs_BA.zip";s:3:"iso";a:2:{i:1;s:2:"bs";i:2;s:3:"bos";}s:7:"strings";a:1:{s:8:"continue";s:7:"Nastavi";}}s:2:"ca";a:8:{s:8:"language";s:2:"ca";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-29 21:28:23";s:12:"english_name";s:7:"Catalan";s:11:"native_name";s:7:"Català";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/ca.zip";s:3:"iso";a:2:{i:1;s:2:"ca";i:2;s:3:"cat";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continua";}}s:3:"ceb";a:8:{s:8:"language";s:3:"ceb";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-02 17:25:51";s:12:"english_name";s:7:"Cebuano";s:11:"native_name";s:7:"Cebuano";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip";s:3:"iso";a:2:{i:2;s:3:"ceb";i:3;s:3:"ceb";}s:7:"strings";a:1:{s:8:"continue";s:7:"Padayun";}}s:5:"cs_CZ";a:8:{s:8:"language";s:5:"cs_CZ";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 17:08:36";s:12:"english_name";s:5:"Czech";s:11:"native_name";s:9:"Čeština";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/cs_CZ.zip";s:3:"iso";a:2:{i:1;s:2:"cs";i:2;s:3:"ces";}s:7:"strings";a:1:{s:8:"continue";s:11:"Pokračovat";}}s:2:"cy";a:8:{s:8:"language";s:2:"cy";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-19 08:22:12";s:12:"english_name";s:5:"Welsh";s:11:"native_name";s:7:"Cymraeg";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/cy.zip";s:3:"iso";a:2:{i:1;s:2:"cy";i:2;s:3:"cym";}s:7:"strings";a:1:{s:8:"continue";s:6:"Parhau";}}s:5:"da_DK";a:8:{s:8:"language";s:5:"da_DK";s:7:"version";s:5:"4.9.7";s:7:"updated";s:19:"2018-07-06 08:46:24";s:12:"english_name";s:6:"Danish";s:11:"native_name";s:5:"Dansk";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.7/da_DK.zip";s:3:"iso";a:2:{i:1;s:2:"da";i:2;s:3:"dan";}s:7:"strings";a:1:{s:8:"continue";s:8:"Fortsæt";}}s:5:"de_CH";a:8:{s:8:"language";s:5:"de_CH";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-07-28 11:47:36";s:12:"english_name";s:20:"German (Switzerland)";s:11:"native_name";s:17:"Deutsch (Schweiz)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/de_CH.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:5:"de_DE";a:8:{s:8:"language";s:5:"de_DE";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-15 10:41:04";s:12:"english_name";s:6:"German";s:11:"native_name";s:7:"Deutsch";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/de_DE.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:14:"de_CH_informal";a:8:{s:8:"language";s:14:"de_CH_informal";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-07-28 11:48:22";s:12:"english_name";s:30:"German (Switzerland, Informal)";s:11:"native_name";s:21:"Deutsch (Schweiz, Du)";s:7:"package";s:73:"https://downloads.wordpress.org/translation/core/4.9.8/de_CH_informal.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:12:"de_DE_formal";a:8:{s:8:"language";s:12:"de_DE_formal";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-15 10:39:52";s:12:"english_name";s:15:"German (Formal)";s:11:"native_name";s:13:"Deutsch (Sie)";s:7:"package";s:71:"https://downloads.wordpress.org/translation/core/4.9.8/de_DE_formal.zip";s:3:"iso";a:1:{i:1;s:2:"de";}s:7:"strings";a:1:{s:8:"continue";s:6:"Weiter";}}s:3:"dzo";a:8:{s:8:"language";s:3:"dzo";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-06-29 08:59:03";s:12:"english_name";s:8:"Dzongkha";s:11:"native_name";s:18:"རྫོང་ཁ";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip";s:3:"iso";a:2:{i:1;s:2:"dz";i:2;s:3:"dzo";}s:7:"strings";a:1:{s:8:"continue";s:0:"";}}s:2:"el";a:8:{s:8:"language";s:2:"el";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 17:20:10";s:12:"english_name";s:5:"Greek";s:11:"native_name";s:16:"Ελληνικά";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/el.zip";s:3:"iso";a:2:{i:1;s:2:"el";i:2;s:3:"ell";}s:7:"strings";a:1:{s:8:"continue";s:16:"Συνέχεια";}}s:5:"en_ZA";a:8:{s:8:"language";s:5:"en_ZA";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-04 13:34:08";s:12:"english_name";s:22:"English (South Africa)";s:11:"native_name";s:22:"English (South Africa)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/en_ZA.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_CA";a:8:{s:8:"language";s:5:"en_CA";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 17:08:21";s:12:"english_name";s:16:"English (Canada)";s:11:"native_name";s:16:"English (Canada)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/en_CA.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_NZ";a:8:{s:8:"language";s:5:"en_NZ";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-29 04:07:23";s:12:"english_name";s:21:"English (New Zealand)";s:11:"native_name";s:21:"English (New Zealand)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/en_NZ.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_GB";a:8:{s:8:"language";s:5:"en_GB";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 16:14:01";s:12:"english_name";s:12:"English (UK)";s:11:"native_name";s:12:"English (UK)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/en_GB.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:5:"en_AU";a:8:{s:8:"language";s:5:"en_AU";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 23:34:56";s:12:"english_name";s:19:"English (Australia)";s:11:"native_name";s:19:"English (Australia)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/en_AU.zip";s:3:"iso";a:3:{i:1;s:2:"en";i:2;s:3:"eng";i:3;s:3:"eng";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"eo";a:8:{s:8:"language";s:2:"eo";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-08-01 16:09:29";s:12:"english_name";s:9:"Esperanto";s:11:"native_name";s:9:"Esperanto";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/eo.zip";s:3:"iso";a:2:{i:1;s:2:"eo";i:2;s:3:"epo";}s:7:"strings";a:1:{s:8:"continue";s:8:"Daŭrigi";}}s:5:"es_ES";a:8:{s:8:"language";s:5:"es_ES";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 16:20:18";s:12:"english_name";s:15:"Spanish (Spain)";s:11:"native_name";s:8:"Español";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/es_ES.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CO";a:8:{s:8:"language";s:5:"es_CO";s:7:"version";s:5:"4.9.2";s:7:"updated";s:19:"2017-11-15 23:17:08";s:12:"english_name";s:18:"Spanish (Colombia)";s:11:"native_name";s:20:"Español de Colombia";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.2/es_CO.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_GT";a:8:{s:8:"language";s:5:"es_GT";s:7:"version";s:5:"4.9.2";s:7:"updated";s:19:"2017-11-15 15:03:42";s:12:"english_name";s:19:"Spanish (Guatemala)";s:11:"native_name";s:21:"Español de Guatemala";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.2/es_GT.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CR";a:8:{s:8:"language";s:5:"es_CR";s:7:"version";s:5:"4.8.3";s:7:"updated";s:19:"2017-10-01 17:54:52";s:12:"english_name";s:20:"Spanish (Costa Rica)";s:11:"native_name";s:22:"Español de Costa Rica";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.8.3/es_CR.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_PE";a:8:{s:8:"language";s:5:"es_PE";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-09 09:36:22";s:12:"english_name";s:14:"Spanish (Peru)";s:11:"native_name";s:17:"Español de Perú";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/es_PE.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_AR";a:8:{s:8:"language";s:5:"es_AR";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-08-03 20:43:09";s:12:"english_name";s:19:"Spanish (Argentina)";s:11:"native_name";s:21:"Español de Argentina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/es_AR.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_MX";a:8:{s:8:"language";s:5:"es_MX";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-28 16:07:01";s:12:"english_name";s:16:"Spanish (Mexico)";s:11:"native_name";s:19:"Español de México";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/es_MX.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_CL";a:8:{s:8:"language";s:5:"es_CL";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-09 15:16:30";s:12:"english_name";s:15:"Spanish (Chile)";s:11:"native_name";s:17:"Español de Chile";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/es_CL.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"es_VE";a:8:{s:8:"language";s:5:"es_VE";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-10 17:20:09";s:12:"english_name";s:19:"Spanish (Venezuela)";s:11:"native_name";s:21:"Español de Venezuela";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/es_VE.zip";s:3:"iso";a:3:{i:1;s:2:"es";i:2;s:3:"spa";i:3;s:3:"spa";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:2:"et";a:8:{s:8:"language";s:2:"et";s:7:"version";s:5:"4.9.2";s:7:"updated";s:19:"2017-11-19 14:11:29";s:12:"english_name";s:8:"Estonian";s:11:"native_name";s:5:"Eesti";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.2/et.zip";s:3:"iso";a:2:{i:1;s:2:"et";i:2;s:3:"est";}s:7:"strings";a:1:{s:8:"continue";s:6:"Jätka";}}s:2:"eu";a:8:{s:8:"language";s:2:"eu";s:7:"version";s:5:"4.9.2";s:7:"updated";s:19:"2017-12-09 21:12:23";s:12:"english_name";s:6:"Basque";s:11:"native_name";s:7:"Euskara";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.2/eu.zip";s:3:"iso";a:2:{i:1;s:2:"eu";i:2;s:3:"eus";}s:7:"strings";a:1:{s:8:"continue";s:8:"Jarraitu";}}s:5:"fa_IR";a:8:{s:8:"language";s:5:"fa_IR";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-04 08:05:41";s:12:"english_name";s:7:"Persian";s:11:"native_name";s:10:"فارسی";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/fa_IR.zip";s:3:"iso";a:2:{i:1;s:2:"fa";i:2;s:3:"fas";}s:7:"strings";a:1:{s:8:"continue";s:10:"ادامه";}}s:2:"fi";a:8:{s:8:"language";s:2:"fi";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-05 07:24:22";s:12:"english_name";s:7:"Finnish";s:11:"native_name";s:5:"Suomi";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/fi.zip";s:3:"iso";a:2:{i:1;s:2:"fi";i:2;s:3:"fin";}s:7:"strings";a:1:{s:8:"continue";s:5:"Jatka";}}s:5:"fr_FR";a:8:{s:8:"language";s:5:"fr_FR";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 16:02:42";s:12:"english_name";s:15:"French (France)";s:11:"native_name";s:9:"Français";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/fr_FR.zip";s:3:"iso";a:1:{i:1;s:2:"fr";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:5:"fr_CA";a:8:{s:8:"language";s:5:"fr_CA";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-19 19:03:27";s:12:"english_name";s:15:"French (Canada)";s:11:"native_name";s:19:"Français du Canada";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/fr_CA.zip";s:3:"iso";a:2:{i:1;s:2:"fr";i:2;s:3:"fra";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:5:"fr_BE";a:8:{s:8:"language";s:5:"fr_BE";s:7:"version";s:5:"4.9.5";s:7:"updated";s:19:"2018-01-31 11:16:06";s:12:"english_name";s:16:"French (Belgium)";s:11:"native_name";s:21:"Français de Belgique";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.5/fr_BE.zip";s:3:"iso";a:2:{i:1;s:2:"fr";i:2;s:3:"fra";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuer";}}s:3:"fur";a:8:{s:8:"language";s:3:"fur";s:7:"version";s:5:"4.8.6";s:7:"updated";s:19:"2018-01-29 17:32:35";s:12:"english_name";s:8:"Friulian";s:11:"native_name";s:8:"Friulian";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.8.6/fur.zip";s:3:"iso";a:2:{i:2;s:3:"fur";i:3;s:3:"fur";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continue";}}s:2:"gd";a:8:{s:8:"language";s:2:"gd";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-08-23 17:41:37";s:12:"english_name";s:15:"Scottish Gaelic";s:11:"native_name";s:9:"Gàidhlig";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip";s:3:"iso";a:3:{i:1;s:2:"gd";i:2;s:3:"gla";i:3;s:3:"gla";}s:7:"strings";a:1:{s:8:"continue";s:15:"Lean air adhart";}}s:5:"gl_ES";a:8:{s:8:"language";s:5:"gl_ES";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-20 00:15:02";s:12:"english_name";s:8:"Galician";s:11:"native_name";s:6:"Galego";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/gl_ES.zip";s:3:"iso";a:2:{i:1;s:2:"gl";i:2;s:3:"glg";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:2:"gu";a:8:{s:8:"language";s:2:"gu";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-14 12:33:48";s:12:"english_name";s:8:"Gujarati";s:11:"native_name";s:21:"ગુજરાતી";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/gu.zip";s:3:"iso";a:2:{i:1;s:2:"gu";i:2;s:3:"guj";}s:7:"strings";a:1:{s:8:"continue";s:31:"ચાલુ રાખવું";}}s:3:"haz";a:8:{s:8:"language";s:3:"haz";s:7:"version";s:5:"4.4.2";s:7:"updated";s:19:"2015-12-05 00:59:09";s:12:"english_name";s:8:"Hazaragi";s:11:"native_name";s:15:"هزاره گی";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip";s:3:"iso";a:1:{i:3;s:3:"haz";}s:7:"strings";a:1:{s:8:"continue";s:10:"ادامه";}}s:5:"he_IL";a:8:{s:8:"language";s:5:"he_IL";s:7:"version";s:5:"4.9.5";s:7:"updated";s:19:"2018-04-15 08:49:46";s:12:"english_name";s:6:"Hebrew";s:11:"native_name";s:16:"עִבְרִית";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.5/he_IL.zip";s:3:"iso";a:1:{i:1;s:2:"he";}s:7:"strings";a:1:{s:8:"continue";s:8:"המשך";}}s:5:"hi_IN";a:8:{s:8:"language";s:5:"hi_IN";s:7:"version";s:5:"4.9.7";s:7:"updated";s:19:"2018-06-17 09:33:44";s:12:"english_name";s:5:"Hindi";s:11:"native_name";s:18:"हिन्दी";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.7/hi_IN.zip";s:3:"iso";a:2:{i:1;s:2:"hi";i:2;s:3:"hin";}s:7:"strings";a:1:{s:8:"continue";s:12:"जारी";}}s:2:"hr";a:8:{s:8:"language";s:2:"hr";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-19 09:43:51";s:12:"english_name";s:8:"Croatian";s:11:"native_name";s:8:"Hrvatski";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/hr.zip";s:3:"iso";a:2:{i:1;s:2:"hr";i:2;s:3:"hrv";}s:7:"strings";a:1:{s:8:"continue";s:7:"Nastavi";}}s:5:"hu_HU";a:8:{s:8:"language";s:5:"hu_HU";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-08-03 10:29:39";s:12:"english_name";s:9:"Hungarian";s:11:"native_name";s:6:"Magyar";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/hu_HU.zip";s:3:"iso";a:2:{i:1;s:2:"hu";i:2;s:3:"hun";}s:7:"strings";a:1:{s:8:"continue";s:10:"Folytatás";}}s:2:"hy";a:8:{s:8:"language";s:2:"hy";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-12-03 16:21:10";s:12:"english_name";s:8:"Armenian";s:11:"native_name";s:14:"Հայերեն";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip";s:3:"iso";a:2:{i:1;s:2:"hy";i:2;s:3:"hye";}s:7:"strings";a:1:{s:8:"continue";s:20:"Շարունակել";}}s:5:"id_ID";a:8:{s:8:"language";s:5:"id_ID";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-07-28 13:16:13";s:12:"english_name";s:10:"Indonesian";s:11:"native_name";s:16:"Bahasa Indonesia";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/id_ID.zip";s:3:"iso";a:2:{i:1;s:2:"id";i:2;s:3:"ind";}s:7:"strings";a:1:{s:8:"continue";s:9:"Lanjutkan";}}s:5:"is_IS";a:8:{s:8:"language";s:5:"is_IS";s:7:"version";s:6:"4.7.11";s:7:"updated";s:19:"2018-09-20 11:13:37";s:12:"english_name";s:9:"Icelandic";s:11:"native_name";s:9:"Íslenska";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.7.11/is_IS.zip";s:3:"iso";a:2:{i:1;s:2:"is";i:2;s:3:"isl";}s:7:"strings";a:1:{s:8:"continue";s:6:"Áfram";}}s:5:"it_IT";a:8:{s:8:"language";s:5:"it_IT";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 15:33:00";s:12:"english_name";s:7:"Italian";s:11:"native_name";s:8:"Italiano";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/it_IT.zip";s:3:"iso";a:2:{i:1;s:2:"it";i:2;s:3:"ita";}s:7:"strings";a:1:{s:8:"continue";s:8:"Continua";}}s:2:"ja";a:8:{s:8:"language";s:2:"ja";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-31 08:31:15";s:12:"english_name";s:8:"Japanese";s:11:"native_name";s:9:"日本語";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/ja.zip";s:3:"iso";a:1:{i:1;s:2:"ja";}s:7:"strings";a:1:{s:8:"continue";s:9:"続ける";}}s:5:"jv_ID";a:8:{s:8:"language";s:5:"jv_ID";s:7:"version";s:5:"4.9.5";s:7:"updated";s:19:"2018-03-24 13:53:29";s:12:"english_name";s:8:"Javanese";s:11:"native_name";s:9:"Basa Jawa";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.5/jv_ID.zip";s:3:"iso";a:2:{i:1;s:2:"jv";i:2;s:3:"jav";}s:7:"strings";a:1:{s:8:"continue";s:9:"Nerusaké";}}s:5:"ka_GE";a:8:{s:8:"language";s:5:"ka_GE";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-24 04:57:34";s:12:"english_name";s:8:"Georgian";s:11:"native_name";s:21:"ქართული";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/ka_GE.zip";s:3:"iso";a:2:{i:1;s:2:"ka";i:2;s:3:"kat";}s:7:"strings";a:1:{s:8:"continue";s:30:"გაგრძელება";}}s:3:"kab";a:8:{s:8:"language";s:3:"kab";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-21 14:15:57";s:12:"english_name";s:6:"Kabyle";s:11:"native_name";s:9:"Taqbaylit";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.9.8/kab.zip";s:3:"iso";a:2:{i:2;s:3:"kab";i:3;s:3:"kab";}s:7:"strings";a:1:{s:8:"continue";s:6:"Kemmel";}}s:2:"kk";a:8:{s:8:"language";s:2:"kk";s:7:"version";s:5:"4.9.5";s:7:"updated";s:19:"2018-03-12 08:08:32";s:12:"english_name";s:6:"Kazakh";s:11:"native_name";s:19:"Қазақ тілі";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.5/kk.zip";s:3:"iso";a:2:{i:1;s:2:"kk";i:2;s:3:"kaz";}s:7:"strings";a:1:{s:8:"continue";s:20:"Жалғастыру";}}s:2:"km";a:8:{s:8:"language";s:2:"km";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-12-07 02:07:59";s:12:"english_name";s:5:"Khmer";s:11:"native_name";s:27:"ភាសាខ្មែរ";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/km.zip";s:3:"iso";a:2:{i:1;s:2:"km";i:2;s:3:"khm";}s:7:"strings";a:1:{s:8:"continue";s:12:"បន្ត";}}s:5:"ko_KR";a:8:{s:8:"language";s:5:"ko_KR";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-25 00:05:58";s:12:"english_name";s:6:"Korean";s:11:"native_name";s:9:"한국어";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/ko_KR.zip";s:3:"iso";a:2:{i:1;s:2:"ko";i:2;s:3:"kor";}s:7:"strings";a:1:{s:8:"continue";s:6:"계속";}}s:3:"ckb";a:8:{s:8:"language";s:3:"ckb";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 17:12:13";s:12:"english_name";s:16:"Kurdish (Sorani)";s:11:"native_name";s:13:"كوردی‎";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.9.8/ckb.zip";s:3:"iso";a:2:{i:1;s:2:"ku";i:3;s:3:"ckb";}s:7:"strings";a:1:{s:8:"continue";s:30:"به‌رده‌وام به‌";}}s:2:"lo";a:8:{s:8:"language";s:2:"lo";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-12 09:59:23";s:12:"english_name";s:3:"Lao";s:11:"native_name";s:21:"ພາສາລາວ";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip";s:3:"iso";a:2:{i:1;s:2:"lo";i:2;s:3:"lao";}s:7:"strings";a:1:{s:8:"continue";s:18:"ຕໍ່​ໄປ";}}s:5:"lt_LT";a:8:{s:8:"language";s:5:"lt_LT";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-27 18:41:44";s:12:"english_name";s:10:"Lithuanian";s:11:"native_name";s:15:"Lietuvių kalba";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/lt_LT.zip";s:3:"iso";a:2:{i:1;s:2:"lt";i:2;s:3:"lit";}s:7:"strings";a:1:{s:8:"continue";s:6:"Tęsti";}}s:2:"lv";a:8:{s:8:"language";s:2:"lv";s:7:"version";s:5:"4.7.7";s:7:"updated";s:19:"2017-03-17 20:40:40";s:12:"english_name";s:7:"Latvian";s:11:"native_name";s:16:"Latviešu valoda";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.7/lv.zip";s:3:"iso";a:2:{i:1;s:2:"lv";i:2;s:3:"lav";}s:7:"strings";a:1:{s:8:"continue";s:9:"Turpināt";}}s:5:"mk_MK";a:8:{s:8:"language";s:5:"mk_MK";s:7:"version";s:5:"4.7.7";s:7:"updated";s:19:"2017-01-26 15:54:41";s:12:"english_name";s:10:"Macedonian";s:11:"native_name";s:31:"Македонски јазик";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.7/mk_MK.zip";s:3:"iso";a:2:{i:1;s:2:"mk";i:2;s:3:"mkd";}s:7:"strings";a:1:{s:8:"continue";s:16:"Продолжи";}}s:5:"ml_IN";a:8:{s:8:"language";s:5:"ml_IN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-27 03:43:32";s:12:"english_name";s:9:"Malayalam";s:11:"native_name";s:18:"മലയാളം";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip";s:3:"iso";a:2:{i:1;s:2:"ml";i:2;s:3:"mal";}s:7:"strings";a:1:{s:8:"continue";s:18:"തുടരുക";}}s:2:"mn";a:8:{s:8:"language";s:2:"mn";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-12 07:29:35";s:12:"english_name";s:9:"Mongolian";s:11:"native_name";s:12:"Монгол";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip";s:3:"iso";a:2:{i:1;s:2:"mn";i:2;s:3:"mon";}s:7:"strings";a:1:{s:8:"continue";s:24:"Үргэлжлүүлэх";}}s:2:"mr";a:8:{s:8:"language";s:2:"mr";s:7:"version";s:5:"4.8.6";s:7:"updated";s:19:"2018-02-13 07:38:55";s:12:"english_name";s:7:"Marathi";s:11:"native_name";s:15:"मराठी";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.8.6/mr.zip";s:3:"iso";a:2:{i:1;s:2:"mr";i:2;s:3:"mar";}s:7:"strings";a:1:{s:8:"continue";s:25:"सुरु ठेवा";}}s:5:"ms_MY";a:8:{s:8:"language";s:5:"ms_MY";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-08-30 20:27:25";s:12:"english_name";s:5:"Malay";s:11:"native_name";s:13:"Bahasa Melayu";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/ms_MY.zip";s:3:"iso";a:2:{i:1;s:2:"ms";i:2;s:3:"msa";}s:7:"strings";a:1:{s:8:"continue";s:8:"Teruskan";}}s:5:"my_MM";a:8:{s:8:"language";s:5:"my_MM";s:7:"version";s:6:"4.1.20";s:7:"updated";s:19:"2015-03-26 15:57:42";s:12:"english_name";s:17:"Myanmar (Burmese)";s:11:"native_name";s:15:"ဗမာစာ";s:7:"package";s:65:"https://downloads.wordpress.org/translation/core/4.1.20/my_MM.zip";s:3:"iso";a:2:{i:1;s:2:"my";i:2;s:3:"mya";}s:7:"strings";a:1:{s:8:"continue";s:54:"ဆက်လက်လုပ်ဆောင်ပါ။";}}s:5:"nb_NO";a:8:{s:8:"language";s:5:"nb_NO";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-17 11:02:30";s:12:"english_name";s:19:"Norwegian (Bokmål)";s:11:"native_name";s:13:"Norsk bokmål";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/nb_NO.zip";s:3:"iso";a:2:{i:1;s:2:"nb";i:2;s:3:"nob";}s:7:"strings";a:1:{s:8:"continue";s:8:"Fortsett";}}s:5:"ne_NP";a:8:{s:8:"language";s:5:"ne_NP";s:7:"version";s:5:"4.9.5";s:7:"updated";s:19:"2018-03-27 10:30:26";s:12:"english_name";s:6:"Nepali";s:11:"native_name";s:18:"नेपाली";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.5/ne_NP.zip";s:3:"iso";a:2:{i:1;s:2:"ne";i:2;s:3:"nep";}s:7:"strings";a:1:{s:8:"continue";s:43:"जारी राख्नुहोस्";}}s:5:"nl_BE";a:8:{s:8:"language";s:5:"nl_BE";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-18 11:11:49";s:12:"english_name";s:15:"Dutch (Belgium)";s:11:"native_name";s:20:"Nederlands (België)";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/nl_BE.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:12:"nl_NL_formal";a:8:{s:8:"language";s:12:"nl_NL_formal";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-29 08:41:27";s:12:"english_name";s:14:"Dutch (Formal)";s:11:"native_name";s:20:"Nederlands (Formeel)";s:7:"package";s:71:"https://downloads.wordpress.org/translation/core/4.9.8/nl_NL_formal.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:5:"nl_NL";a:8:{s:8:"language";s:5:"nl_NL";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-29 08:41:56";s:12:"english_name";s:5:"Dutch";s:11:"native_name";s:10:"Nederlands";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/nl_NL.zip";s:3:"iso";a:2:{i:1;s:2:"nl";i:2;s:3:"nld";}s:7:"strings";a:1:{s:8:"continue";s:8:"Doorgaan";}}s:5:"nn_NO";a:8:{s:8:"language";s:5:"nn_NO";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-18 11:10:50";s:12:"english_name";s:19:"Norwegian (Nynorsk)";s:11:"native_name";s:13:"Norsk nynorsk";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/nn_NO.zip";s:3:"iso";a:2:{i:1;s:2:"nn";i:2;s:3:"nno";}s:7:"strings";a:1:{s:8:"continue";s:9:"Hald fram";}}s:3:"oci";a:8:{s:8:"language";s:3:"oci";s:7:"version";s:5:"4.8.3";s:7:"updated";s:19:"2017-08-25 10:03:08";s:12:"english_name";s:7:"Occitan";s:11:"native_name";s:7:"Occitan";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.8.3/oci.zip";s:3:"iso";a:2:{i:1;s:2:"oc";i:2;s:3:"oci";}s:7:"strings";a:1:{s:8:"continue";s:9:"Contunhar";}}s:5:"pa_IN";a:8:{s:8:"language";s:5:"pa_IN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-16 05:19:43";s:12:"english_name";s:7:"Punjabi";s:11:"native_name";s:18:"ਪੰਜਾਬੀ";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip";s:3:"iso";a:2:{i:1;s:2:"pa";i:2;s:3:"pan";}s:7:"strings";a:1:{s:8:"continue";s:25:"ਜਾਰੀ ਰੱਖੋ";}}s:5:"pl_PL";a:8:{s:8:"language";s:5:"pl_PL";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-18 05:15:17";s:12:"english_name";s:6:"Polish";s:11:"native_name";s:6:"Polski";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/pl_PL.zip";s:3:"iso";a:2:{i:1;s:2:"pl";i:2;s:3:"pol";}s:7:"strings";a:1:{s:8:"continue";s:9:"Kontynuuj";}}s:2:"ps";a:8:{s:8:"language";s:2:"ps";s:7:"version";s:6:"4.1.20";s:7:"updated";s:19:"2015-03-29 22:19:48";s:12:"english_name";s:6:"Pashto";s:11:"native_name";s:8:"پښتو";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.1.20/ps.zip";s:3:"iso";a:2:{i:1;s:2:"ps";i:2;s:3:"pus";}s:7:"strings";a:1:{s:8:"continue";s:19:"دوام ورکړه";}}s:5:"pt_PT";a:8:{s:8:"language";s:5:"pt_PT";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-09 11:50:07";s:12:"english_name";s:21:"Portuguese (Portugal)";s:11:"native_name";s:10:"Português";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/pt_PT.zip";s:3:"iso";a:1:{i:1;s:2:"pt";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:5:"pt_BR";a:8:{s:8:"language";s:5:"pt_BR";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-26 15:06:48";s:12:"english_name";s:19:"Portuguese (Brazil)";s:11:"native_name";s:20:"Português do Brasil";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/pt_BR.zip";s:3:"iso";a:2:{i:1;s:2:"pt";i:2;s:3:"por";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:10:"pt_PT_ao90";a:8:{s:8:"language";s:10:"pt_PT_ao90";s:7:"version";s:5:"4.9.5";s:7:"updated";s:19:"2018-03-09 09:30:48";s:12:"english_name";s:27:"Portuguese (Portugal, AO90)";s:11:"native_name";s:17:"Português (AO90)";s:7:"package";s:69:"https://downloads.wordpress.org/translation/core/4.9.5/pt_PT_ao90.zip";s:3:"iso";a:1:{i:1;s:2:"pt";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuar";}}s:3:"rhg";a:8:{s:8:"language";s:3:"rhg";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-16 13:03:18";s:12:"english_name";s:8:"Rohingya";s:11:"native_name";s:8:"Ruáinga";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip";s:3:"iso";a:1:{i:3;s:3:"rhg";}s:7:"strings";a:1:{s:8:"continue";s:0:"";}}s:5:"ro_RO";a:8:{s:8:"language";s:5:"ro_RO";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-29 07:22:19";s:12:"english_name";s:8:"Romanian";s:11:"native_name";s:8:"Română";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/ro_RO.zip";s:3:"iso";a:2:{i:1;s:2:"ro";i:2;s:3:"ron";}s:7:"strings";a:1:{s:8:"continue";s:9:"Continuă";}}s:5:"ru_RU";a:8:{s:8:"language";s:5:"ru_RU";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 16:21:25";s:12:"english_name";s:7:"Russian";s:11:"native_name";s:14:"Русский";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/ru_RU.zip";s:3:"iso";a:2:{i:1;s:2:"ru";i:2;s:3:"rus";}s:7:"strings";a:1:{s:8:"continue";s:20:"Продолжить";}}s:3:"sah";a:8:{s:8:"language";s:3:"sah";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-21 02:06:41";s:12:"english_name";s:5:"Sakha";s:11:"native_name";s:14:"Сахалыы";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip";s:3:"iso";a:2:{i:2;s:3:"sah";i:3;s:3:"sah";}s:7:"strings";a:1:{s:8:"continue";s:12:"Салҕаа";}}s:5:"si_LK";a:8:{s:8:"language";s:5:"si_LK";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-12 06:00:52";s:12:"english_name";s:7:"Sinhala";s:11:"native_name";s:15:"සිංහල";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip";s:3:"iso";a:2:{i:1;s:2:"si";i:2;s:3:"sin";}s:7:"strings";a:1:{s:8:"continue";s:44:"දිගටම කරගෙන යන්න";}}s:5:"sk_SK";a:8:{s:8:"language";s:5:"sk_SK";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-31 08:30:58";s:12:"english_name";s:6:"Slovak";s:11:"native_name";s:11:"Slovenčina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/sk_SK.zip";s:3:"iso";a:2:{i:1;s:2:"sk";i:2;s:3:"slk";}s:7:"strings";a:1:{s:8:"continue";s:12:"Pokračovať";}}s:5:"sl_SI";a:8:{s:8:"language";s:5:"sl_SI";s:7:"version";s:5:"4.9.2";s:7:"updated";s:19:"2018-01-04 13:33:13";s:12:"english_name";s:9:"Slovenian";s:11:"native_name";s:13:"Slovenščina";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.2/sl_SI.zip";s:3:"iso";a:2:{i:1;s:2:"sl";i:2;s:3:"slv";}s:7:"strings";a:1:{s:8:"continue";s:8:"Nadaljuj";}}s:2:"sq";a:8:{s:8:"language";s:2:"sq";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-19 07:46:08";s:12:"english_name";s:8:"Albanian";s:11:"native_name";s:5:"Shqip";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/sq.zip";s:3:"iso";a:2:{i:1;s:2:"sq";i:2;s:3:"sqi";}s:7:"strings";a:1:{s:8:"continue";s:6:"Vazhdo";}}s:5:"sr_RS";a:8:{s:8:"language";s:5:"sr_RS";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-08-02 20:59:54";s:12:"english_name";s:7:"Serbian";s:11:"native_name";s:23:"Српски језик";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/sr_RS.zip";s:3:"iso";a:2:{i:1;s:2:"sr";i:2;s:3:"srp";}s:7:"strings";a:1:{s:8:"continue";s:14:"Настави";}}s:5:"sv_SE";a:8:{s:8:"language";s:5:"sv_SE";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-28 15:35:13";s:12:"english_name";s:7:"Swedish";s:11:"native_name";s:7:"Svenska";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/sv_SE.zip";s:3:"iso";a:2:{i:1;s:2:"sv";i:2;s:3:"swe";}s:7:"strings";a:1:{s:8:"continue";s:9:"Fortsätt";}}s:3:"szl";a:8:{s:8:"language";s:3:"szl";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-09-24 19:58:14";s:12:"english_name";s:8:"Silesian";s:11:"native_name";s:17:"Ślōnskŏ gŏdka";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip";s:3:"iso";a:1:{i:3;s:3:"szl";}s:7:"strings";a:1:{s:8:"continue";s:13:"Kōntynuować";}}s:5:"ta_IN";a:8:{s:8:"language";s:5:"ta_IN";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-27 03:22:47";s:12:"english_name";s:5:"Tamil";s:11:"native_name";s:15:"தமிழ்";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip";s:3:"iso";a:2:{i:1;s:2:"ta";i:2;s:3:"tam";}s:7:"strings";a:1:{s:8:"continue";s:24:"தொடரவும்";}}s:2:"te";a:8:{s:8:"language";s:2:"te";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2017-01-26 15:47:39";s:12:"english_name";s:6:"Telugu";s:11:"native_name";s:18:"తెలుగు";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/te.zip";s:3:"iso";a:2:{i:1;s:2:"te";i:2;s:3:"tel";}s:7:"strings";a:1:{s:8:"continue";s:30:"కొనసాగించు";}}s:2:"th";a:8:{s:8:"language";s:2:"th";s:7:"version";s:5:"4.9.5";s:7:"updated";s:19:"2018-03-02 17:08:41";s:12:"english_name";s:4:"Thai";s:11:"native_name";s:9:"ไทย";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.5/th.zip";s:3:"iso";a:2:{i:1;s:2:"th";i:2;s:3:"tha";}s:7:"strings";a:1:{s:8:"continue";s:15:"ต่อไป";}}s:2:"tl";a:8:{s:8:"language";s:2:"tl";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-12-30 02:38:08";s:12:"english_name";s:7:"Tagalog";s:11:"native_name";s:7:"Tagalog";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.7.2/tl.zip";s:3:"iso";a:2:{i:1;s:2:"tl";i:2;s:3:"tgl";}s:7:"strings";a:1:{s:8:"continue";s:10:"Magpatuloy";}}s:5:"tr_TR";a:8:{s:8:"language";s:5:"tr_TR";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-08 19:05:26";s:12:"english_name";s:7:"Turkish";s:11:"native_name";s:8:"Türkçe";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/tr_TR.zip";s:3:"iso";a:2:{i:1;s:2:"tr";i:2;s:3:"tur";}s:7:"strings";a:1:{s:8:"continue";s:5:"Devam";}}s:5:"tt_RU";a:8:{s:8:"language";s:5:"tt_RU";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-11-20 20:20:50";s:12:"english_name";s:5:"Tatar";s:11:"native_name";s:19:"Татар теле";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip";s:3:"iso";a:2:{i:1;s:2:"tt";i:2;s:3:"tat";}s:7:"strings";a:1:{s:8:"continue";s:17:"дәвам итү";}}s:3:"tah";a:8:{s:8:"language";s:3:"tah";s:7:"version";s:5:"4.7.2";s:7:"updated";s:19:"2016-03-06 18:39:39";s:12:"english_name";s:8:"Tahitian";s:11:"native_name";s:10:"Reo Tahiti";s:7:"package";s:62:"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip";s:3:"iso";a:3:{i:1;s:2:"ty";i:2;s:3:"tah";i:3;s:3:"tah";}s:7:"strings";a:1:{s:8:"continue";s:0:"";}}s:5:"ug_CN";a:8:{s:8:"language";s:5:"ug_CN";s:7:"version";s:5:"4.9.5";s:7:"updated";s:19:"2018-04-12 12:31:53";s:12:"english_name";s:6:"Uighur";s:11:"native_name";s:16:"ئۇيغۇرچە";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.5/ug_CN.zip";s:3:"iso";a:2:{i:1;s:2:"ug";i:2;s:3:"uig";}s:7:"strings";a:1:{s:8:"continue";s:26:"داۋاملاشتۇرۇش";}}s:2:"uk";a:8:{s:8:"language";s:2:"uk";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-29 07:32:40";s:12:"english_name";s:9:"Ukrainian";s:11:"native_name";s:20:"Українська";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/uk.zip";s:3:"iso";a:2:{i:1;s:2:"uk";i:2;s:3:"ukr";}s:7:"strings";a:1:{s:8:"continue";s:20:"Продовжити";}}s:2:"ur";a:8:{s:8:"language";s:2:"ur";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-06 08:37:04";s:12:"english_name";s:4:"Urdu";s:11:"native_name";s:8:"اردو";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/ur.zip";s:3:"iso";a:2:{i:1;s:2:"ur";i:2;s:3:"urd";}s:7:"strings";a:1:{s:8:"continue";s:19:"جاری رکھیں";}}s:5:"uz_UZ";a:8:{s:8:"language";s:5:"uz_UZ";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-10-11 06:46:15";s:12:"english_name";s:5:"Uzbek";s:11:"native_name";s:11:"O‘zbekcha";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.8/uz_UZ.zip";s:3:"iso";a:2:{i:1;s:2:"uz";i:2;s:3:"uzb";}s:7:"strings";a:1:{s:8:"continue";s:11:"Davom etish";}}s:2:"vi";a:8:{s:8:"language";s:2:"vi";s:7:"version";s:5:"4.9.8";s:7:"updated";s:19:"2018-09-19 13:50:55";s:12:"english_name";s:10:"Vietnamese";s:11:"native_name";s:14:"Tiếng Việt";s:7:"package";s:61:"https://downloads.wordpress.org/translation/core/4.9.8/vi.zip";s:3:"iso";a:2:{i:1;s:2:"vi";i:2;s:3:"vie";}s:7:"strings";a:1:{s:8:"continue";s:12:"Tiếp tục";}}s:5:"zh_HK";a:8:{s:8:"language";s:5:"zh_HK";s:7:"version";s:5:"4.9.5";s:7:"updated";s:19:"2018-04-09 00:56:52";s:12:"english_name";s:19:"Chinese (Hong Kong)";s:11:"native_name";s:16:"香港中文版	";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.5/zh_HK.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"繼續";}}s:5:"zh_TW";a:8:{s:8:"language";s:5:"zh_TW";s:7:"version";s:5:"4.9.4";s:7:"updated";s:19:"2018-02-13 02:41:15";s:12:"english_name";s:16:"Chinese (Taiwan)";s:11:"native_name";s:12:"繁體中文";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.4/zh_TW.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"繼續";}}s:5:"zh_CN";a:8:{s:8:"language";s:5:"zh_CN";s:7:"version";s:5:"4.9.2";s:7:"updated";s:19:"2017-11-17 22:20:52";s:12:"english_name";s:15:"Chinese (China)";s:11:"native_name";s:12:"简体中文";s:7:"package";s:64:"https://downloads.wordpress.org/translation/core/4.9.2/zh_CN.zip";s:3:"iso";a:2:{i:1;s:2:"zh";i:2;s:3:"zho";}s:7:"strings";a:1:{s:8:"continue";s:6:"继续";}}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('6053', '_transient_timeout_wc_upgrade_notice_3.5.1', '1541099453', 'no'); 
INSERT INTO `mod63_options` VALUES ('6054', '_transient_wc_upgrade_notice_3.5.1', '', 'no'); 
INSERT INTO `mod63_options` VALUES ('6063', '_transient_timeout_aioseop_feed', '1541058378', 'no'); 
INSERT INTO `mod63_options` VALUES ('6064', '_transient_aioseop_feed', 'a:4:{i:0;a:4:{s:3:"url";s:62:"https://semperplugins.com/upgrading-to-2-9-seo-meta-disappear/";s:5:"title";s:72:"Upgrading to 2.9.x made your SEO meta section disappear? Read this post!";s:4:"date";s:13:"Oct 25th 2018";s:7:"content";s:131:"Hi friends,
In 2.9, several users reported in the community forums that the SEO section disappeared from their source code or ba...";}i:1;a:4:{s:3:"url";s:48:"https://semperplugins.com/new-robots-txt-module/";s:5:"title";s:52:"New Robots.txt module with Multisite Network support";s:4:"date";s:13:"Sep 17th 2018";s:7:"content";s:131:"Missed the release notes for All in One SEO Pack v2.7? Then you may not be aware that we&#8217;ve completely overhauled the Robo...";}i:2;a:4:{s:3:"url";s:60:"https://semperplugins.com/all-in-one-seo-pack-v2-8-released/";s:5:"title";s:33:"All in One SEO Pack v2.8 released";s:4:"date";s:13:"Sep 12th 2018";s:7:"content";s:131:"Earlier this week, we released All in One SEO Pack v2.8.  This major release includes both enhancements to existing features of...";}i:3;a:4:{s:3:"url";s:77:"https://semperplugins.com/missing-all-in-one-seo-pack-2-6-post-and-page-meta/";s:5:"title";s:50:"Missing All in One SEO Pack 2.6 post and page meta";s:4:"date";s:13:"May 29th 2018";s:7:"content";s:131:"If you updated to the latest version of All in One SEO Pack (2.6) for WordPress recently, you may have noticed what appears to ...";}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('6073', 'woocommerce_version', '3.5.1', 'yes'); 
INSERT INTO `mod63_options` VALUES ('6080', '_site_transient_timeout_theme_roots', '1541022500', 'no'); 
INSERT INTO `mod63_options` VALUES ('6081', '_site_transient_theme_roots', 'a:4:{s:13:"twentyfifteen";s:7:"/themes";s:15:"twentyseventeen";s:7:"/themes";s:13:"twentysixteen";s:7:"/themes";s:14:"virtue_premium";s:7:"/themes";}', 'no'); 
INSERT INTO `mod63_options` VALUES ('6082', '_transient_timeout_kt_api_status_check', '1541021901', 'no'); 
INSERT INTO `mod63_options` VALUES ('6083', '_transient_kt_api_status_check', '1', 'no'); 
INSERT INTO `mod63_options` VALUES ('6084', '_transient_timeout__woocommerce_helper_subscriptions', '1541021601', 'no'); 
INSERT INTO `mod63_options` VALUES ('6085', '_transient__woocommerce_helper_subscriptions', 'a:0:{}', 'no'); 
INSERT INTO `mod63_options` VALUES ('6088', '_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a', '1541031628', 'no'); 
INSERT INTO `mod63_options` VALUES ('6089', '_site_transient_poptags_40cd750bba9870f18aada2478b24840a', 'O:8:"stdClass":100:{s:6:"widget";a:3:{s:4:"name";s:6:"widget";s:4:"slug";s:6:"widget";s:5:"count";i:4516;}s:11:"woocommerce";a:3:{s:4:"name";s:11:"woocommerce";s:4:"slug";s:11:"woocommerce";s:5:"count";i:3092;}s:4:"post";a:3:{s:4:"name";s:4:"post";s:4:"slug";s:4:"post";s:5:"count";i:2598;}s:5:"admin";a:3:{s:4:"name";s:5:"admin";s:4:"slug";s:5:"admin";s:5:"count";i:2455;}s:5:"posts";a:3:{s:4:"name";s:5:"posts";s:4:"slug";s:5:"posts";s:5:"count";i:1888;}s:9:"shortcode";a:3:{s:4:"name";s:9:"shortcode";s:4:"slug";s:9:"shortcode";s:5:"count";i:1688;}s:8:"comments";a:3:{s:4:"name";s:8:"comments";s:4:"slug";s:8:"comments";s:5:"count";i:1683;}s:7:"twitter";a:3:{s:4:"name";s:7:"twitter";s:4:"slug";s:7:"twitter";s:5:"count";i:1461;}s:6:"images";a:3:{s:4:"name";s:6:"images";s:4:"slug";s:6:"images";s:5:"count";i:1410;}s:6:"google";a:3:{s:4:"name";s:6:"google";s:4:"slug";s:6:"google";s:5:"count";i:1407;}s:8:"facebook";a:3:{s:4:"name";s:8:"facebook";s:4:"slug";s:8:"facebook";s:5:"count";i:1405;}s:5:"image";a:3:{s:4:"name";s:5:"image";s:4:"slug";s:5:"image";s:5:"count";i:1338;}s:7:"sidebar";a:3:{s:4:"name";s:7:"sidebar";s:4:"slug";s:7:"sidebar";s:5:"count";i:1285;}s:3:"seo";a:3:{s:4:"name";s:3:"seo";s:4:"slug";s:3:"seo";s:5:"count";i:1255;}s:7:"gallery";a:3:{s:4:"name";s:7:"gallery";s:4:"slug";s:7:"gallery";s:5:"count";i:1119;}s:4:"page";a:3:{s:4:"name";s:4:"page";s:4:"slug";s:4:"page";s:5:"count";i:1079;}s:5:"email";a:3:{s:4:"name";s:5:"email";s:4:"slug";s:5:"email";s:5:"count";i:1054;}s:6:"social";a:3:{s:4:"name";s:6:"social";s:4:"slug";s:6:"social";s:5:"count";i:1041;}s:9:"ecommerce";a:3:{s:4:"name";s:9:"ecommerce";s:4:"slug";s:9:"ecommerce";s:5:"count";i:942;}s:5:"login";a:3:{s:4:"name";s:5:"login";s:4:"slug";s:5:"login";s:5:"count";i:899;}s:5:"links";a:3:{s:4:"name";s:5:"links";s:4:"slug";s:5:"links";s:5:"count";i:836;}s:7:"widgets";a:3:{s:4:"name";s:7:"widgets";s:4:"slug";s:7:"widgets";s:5:"count";i:819;}s:5:"video";a:3:{s:4:"name";s:5:"video";s:4:"slug";s:5:"video";s:5:"count";i:812;}s:8:"security";a:3:{s:4:"name";s:8:"security";s:4:"slug";s:8:"security";s:5:"count";i:742;}s:7:"content";a:3:{s:4:"name";s:7:"content";s:4:"slug";s:7:"content";s:5:"count";i:712;}s:10:"buddypress";a:3:{s:4:"name";s:10:"buddypress";s:4:"slug";s:10:"buddypress";s:5:"count";i:699;}s:4:"spam";a:3:{s:4:"name";s:4:"spam";s:4:"slug";s:4:"spam";s:5:"count";i:695;}s:3:"rss";a:3:{s:4:"name";s:3:"rss";s:4:"slug";s:3:"rss";s:5:"count";i:690;}s:6:"slider";a:3:{s:4:"name";s:6:"slider";s:4:"slug";s:6:"slider";s:5:"count";i:685;}s:10:"e-commerce";a:3:{s:4:"name";s:10:"e-commerce";s:4:"slug";s:10:"e-commerce";s:5:"count";i:670;}s:5:"pages";a:3:{s:4:"name";s:5:"pages";s:4:"slug";s:5:"pages";s:5:"count";i:669;}s:9:"analytics";a:3:{s:4:"name";s:9:"analytics";s:4:"slug";s:9:"analytics";s:5:"count";i:663;}s:5:"media";a:3:{s:4:"name";s:5:"media";s:4:"slug";s:5:"media";s:5:"count";i:651;}s:6:"jquery";a:3:{s:4:"name";s:6:"jquery";s:4:"slug";s:6:"jquery";s:5:"count";i:647;}s:4:"form";a:3:{s:4:"name";s:4:"form";s:4:"slug";s:4:"form";s:5:"count";i:625;}s:6:"search";a:3:{s:4:"name";s:6:"search";s:4:"slug";s:6:"search";s:5:"count";i:623;}s:4:"feed";a:3:{s:4:"name";s:4:"feed";s:4:"slug";s:4:"feed";s:5:"count";i:619;}s:4:"ajax";a:3:{s:4:"name";s:4:"ajax";s:4:"slug";s:4:"ajax";s:5:"count";i:608;}s:4:"menu";a:3:{s:4:"name";s:4:"menu";s:4:"slug";s:4:"menu";s:5:"count";i:603;}s:8:"category";a:3:{s:4:"name";s:8:"category";s:4:"slug";s:8:"category";s:5:"count";i:602;}s:5:"embed";a:3:{s:4:"name";s:5:"embed";s:4:"slug";s:5:"embed";s:5:"count";i:574;}s:10:"javascript";a:3:{s:4:"name";s:10:"javascript";s:4:"slug";s:10:"javascript";s:5:"count";i:556;}s:3:"css";a:3:{s:4:"name";s:3:"css";s:4:"slug";s:3:"css";s:5:"count";i:549;}s:4:"link";a:3:{s:4:"name";s:4:"link";s:4:"slug";s:4:"link";s:5:"count";i:545;}s:7:"youtube";a:3:{s:4:"name";s:7:"youtube";s:4:"slug";s:7:"youtube";s:5:"count";i:534;}s:6:"editor";a:3:{s:4:"name";s:6:"editor";s:4:"slug";s:6:"editor";s:5:"count";i:528;}s:5:"share";a:3:{s:4:"name";s:5:"share";s:4:"slug";s:5:"share";s:5:"count";i:526;}s:5:"theme";a:3:{s:4:"name";s:5:"theme";s:4:"slug";s:5:"theme";s:5:"count";i:518;}s:7:"comment";a:3:{s:4:"name";s:7:"comment";s:4:"slug";s:7:"comment";s:5:"count";i:517;}s:10:"responsive";a:3:{s:4:"name";s:10:"responsive";s:4:"slug";s:10:"responsive";s:5:"count";i:513;}s:12:"contact-form";a:3:{s:4:"name";s:12:"contact form";s:4:"slug";s:12:"contact-form";s:5:"count";i:510;}s:9:"dashboard";a:3:{s:4:"name";s:9:"dashboard";s:4:"slug";s:9:"dashboard";s:5:"count";i:500;}s:6:"custom";a:3:{s:4:"name";s:6:"custom";s:4:"slug";s:6:"custom";s:5:"count";i:493;}s:10:"categories";a:3:{s:4:"name";s:10:"categories";s:4:"slug";s:10:"categories";s:5:"count";i:490;}s:9:"affiliate";a:3:{s:4:"name";s:9:"affiliate";s:4:"slug";s:9:"affiliate";s:5:"count";i:485;}s:3:"ads";a:3:{s:4:"name";s:3:"ads";s:4:"slug";s:3:"ads";s:5:"count";i:482;}s:6:"button";a:3:{s:4:"name";s:6:"button";s:4:"slug";s:6:"button";s:5:"count";i:465;}s:4:"tags";a:3:{s:4:"name";s:4:"tags";s:4:"slug";s:4:"tags";s:5:"count";i:463;}s:4:"user";a:3:{s:4:"name";s:4:"user";s:4:"slug";s:4:"user";s:5:"count";i:457;}s:7:"contact";a:3:{s:4:"name";s:7:"contact";s:4:"slug";s:7:"contact";s:5:"count";i:452;}s:6:"mobile";a:3:{s:4:"name";s:6:"mobile";s:4:"slug";s:6:"mobile";s:5:"count";i:445;}s:3:"api";a:3:{s:4:"name";s:3:"api";s:4:"slug";s:3:"api";s:5:"count";i:438;}s:7:"payment";a:3:{s:4:"name";s:7:"payment";s:4:"slug";s:7:"payment";s:5:"count";i:431;}s:5:"photo";a:3:{s:4:"name";s:5:"photo";s:4:"slug";s:5:"photo";s:5:"count";i:426;}s:5:"users";a:3:{s:4:"name";s:5:"users";s:4:"slug";s:5:"users";s:5:"count";i:423;}s:6:"events";a:3:{s:4:"name";s:6:"events";s:4:"slug";s:6:"events";s:5:"count";i:421;}s:5:"stats";a:3:{s:4:"name";s:5:"stats";s:4:"slug";s:5:"stats";s:5:"count";i:418;}s:9:"slideshow";a:3:{s:4:"name";s:9:"slideshow";s:4:"slug";s:9:"slideshow";s:5:"count";i:418;}s:6:"photos";a:3:{s:4:"name";s:6:"photos";s:4:"slug";s:6:"photos";s:5:"count";i:411;}s:10:"navigation";a:3:{s:4:"name";s:10:"navigation";s:4:"slug";s:10:"navigation";s:5:"count";i:393;}s:10:"statistics";a:3:{s:4:"name";s:10:"statistics";s:4:"slug";s:10:"statistics";s:5:"count";i:389;}s:15:"payment-gateway";a:3:{s:4:"name";s:15:"payment gateway";s:4:"slug";s:15:"payment-gateway";s:5:"count";i:385;}s:8:"calendar";a:3:{s:4:"name";s:8:"calendar";s:4:"slug";s:8:"calendar";s:5:"count";i:374;}s:4:"news";a:3:{s:4:"name";s:4:"news";s:4:"slug";s:4:"news";s:5:"count";i:372;}s:10:"shortcodes";a:3:{s:4:"name";s:10:"shortcodes";s:4:"slug";s:10:"shortcodes";s:5:"count";i:371;}s:5:"popup";a:3:{s:4:"name";s:5:"popup";s:4:"slug";s:5:"popup";s:5:"count";i:370;}s:4:"chat";a:3:{s:4:"name";s:4:"chat";s:4:"slug";s:4:"chat";s:5:"count";i:368;}s:9:"marketing";a:3:{s:4:"name";s:9:"marketing";s:4:"slug";s:9:"marketing";s:5:"count";i:364;}s:12:"social-media";a:3:{s:4:"name";s:12:"social media";s:4:"slug";s:12:"social-media";s:5:"count";i:355;}s:7:"plugins";a:3:{s:4:"name";s:7:"plugins";s:4:"slug";s:7:"plugins";s:5:"count";i:354;}s:9:"multisite";a:3:{s:4:"name";s:9:"multisite";s:4:"slug";s:9:"multisite";s:5:"count";i:351;}s:10:"newsletter";a:3:{s:4:"name";s:10:"newsletter";s:4:"slug";s:10:"newsletter";s:5:"count";i:350;}s:4:"code";a:3:{s:4:"name";s:4:"code";s:4:"slug";s:4:"code";s:5:"count";i:345;}s:4:"meta";a:3:{s:4:"name";s:4:"meta";s:4:"slug";s:4:"meta";s:5:"count";i:342;}s:3:"url";a:3:{s:4:"name";s:3:"url";s:4:"slug";s:3:"url";s:5:"count";i:340;}s:4:"list";a:3:{s:4:"name";s:4:"list";s:4:"slug";s:4:"list";s:5:"count";i:338;}s:5:"forms";a:3:{s:4:"name";s:5:"forms";s:4:"slug";s:5:"forms";s:5:"count";i:335;}s:8:"redirect";a:3:{s:4:"name";s:8:"redirect";s:4:"slug";s:8:"redirect";s:5:"count";i:332;}s:11:"advertising";a:3:{s:4:"name";s:11:"advertising";s:4:"slug";s:11:"advertising";s:5:"count";i:315;}s:11:"performance";a:3:{s:4:"name";s:11:"performance";s:4:"slug";s:11:"performance";s:5:"count";i:313;}s:6:"simple";a:3:{s:4:"name";s:6:"simple";s:4:"slug";s:6:"simple";s:5:"count";i:310;}s:16:"custom-post-type";a:3:{s:4:"name";s:16:"custom post type";s:4:"slug";s:16:"custom-post-type";s:5:"count";i:309;}s:12:"notification";a:3:{s:4:"name";s:12:"notification";s:4:"slug";s:12:"notification";s:5:"count";i:307;}s:3:"tag";a:3:{s:4:"name";s:3:"tag";s:4:"slug";s:3:"tag";s:5:"count";i:305;}s:14:"contact-form-7";a:3:{s:4:"name";s:14:"contact form 7";s:4:"slug";s:14:"contact-form-7";s:5:"count";i:303;}s:7:"adsense";a:3:{s:4:"name";s:7:"adsense";s:4:"slug";s:7:"adsense";s:5:"count";i:303;}s:16:"google-analytics";a:3:{s:4:"name";s:16:"google analytics";s:4:"slug";s:16:"google-analytics";s:5:"count";i:303;}s:4:"html";a:3:{s:4:"name";s:4:"html";s:4:"slug";s:4:"html";s:5:"count";i:303;}s:8:"tracking";a:3:{s:4:"name";s:8:"tracking";s:4:"slug";s:8:"tracking";s:5:"count";i:302;}s:6:"author";a:3:{s:4:"name";s:6:"author";s:4:"slug";s:6:"author";s:5:"count";i:299;}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('6096', '_site_transient_update_core', 'O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.9.8.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-4.9.8.zip";s:10:"no_content";b:0;s:11:"new_bundled";b:0;s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.9.8";s:7:"version";s:5:"4.9.8";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.7";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1541021162;s:15:"version_checked";s:5:"4.9.8";s:12:"translations";a:0:{}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('6097', '_site_transient_update_plugins', 'O:8:"stdClass":5:{s:12:"last_checked";i:1541021163;s:7:"checked";a:27:{s:19:"akismet/akismet.php";s:5:"4.0.8";s:43:"all-in-one-seo-pack/all_in_one_seo_pack.php";s:5:"2.9.1";s:35:"backup-database/backup-database.php";s:3:"4.9";s:53:"cc-bcc-for-woocommerce-order-emails/dc-cc-bcc-woe.php";s:5:"1.4.1";s:35:"fourteen-colors/fourteen-colors.php";s:3:"1.5";s:29:"gmap-embed/srm_gmap_embed.php";s:5:"1.3.7";s:36:"google-sitemap-generator/sitemap.php";s:5:"4.0.9";s:25:"gtranslate/gtranslate.php";s:6:"2.8.43";s:9:"hello.php";s:3:"1.6";s:95:"ic-hide-add-to-cart-and-prices-in-woocommerce/IC-Hide-add-to-cart-and-prices-in-WooCommerce.php";s:3:"3.2";s:45:"kadence-custom-fonts/kadence-custom-fonts.php";s:5:"1.0.1";s:37:"kadence-importer/kadence-importer.php";s:5:"2.0.4";s:39:"kadence-recaptcha/kadence-recaptcha.php";s:5:"1.0.5";s:33:"kadence-slider/kadence-slider.php";s:5:"2.2.8";s:33:"virtue-toolkit/virtue_toolkit.php";s:5:"4.9.1";s:23:"ml-slider/ml-slider.php";s:6:"3.10.0";s:39:"siteorigin-panels/siteorigin-panels.php";s:5:"2.9.1";s:49:"simple-file-downloader/simple-file-downloader.php";s:5:"1.0.4";s:39:"simple-pdf-viewer/simple-pdf-viewer.php";s:3:"1.9";s:39:"so-widgets-bundle/so-widgets-bundle.php";s:6:"1.13.2";s:33:"wd-google-maps/wd-google-maps.php";s:6:"1.0.54";s:27:"woocommerce/woocommerce.php";s:5:"3.5.1";s:43:"woocommerce-colors-1/woocommerce-colors.php";s:5:"1.0.7";s:87:"woocommerce-google-analytics-integration-1/woocommerce-google-analytics-integration.php";s:5:"1.4.5";s:41:"wordpress-importer/wordpress-importer.php";s:5:"0.6.4";s:45:"wp-notification-bars/wp-notification-bars.php";s:5:"1.0.4";s:21:"wp-reset/wp-reset.php";s:4:"1.40";}s:8:"response";a:0:{}s:12:"translations";a:0:{}s:9:"no_update";a:23:{s:19:"akismet/akismet.php";O:8:"stdClass":9:{s:2:"id";s:21:"w.org/plugins/akismet";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:5:"4.0.8";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/akismet.4.0.8.zip";s:5:"icons";a:2:{s:2:"2x";s:59:"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272";s:2:"1x";s:59:"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272";}s:7:"banners";a:1:{s:2:"1x";s:61:"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904";}s:11:"banners_rtl";a:0:{}}s:43:"all-in-one-seo-pack/all_in_one_seo_pack.php";O:8:"stdClass":9:{s:2:"id";s:33:"w.org/plugins/all-in-one-seo-pack";s:4:"slug";s:19:"all-in-one-seo-pack";s:6:"plugin";s:43:"all-in-one-seo-pack/all_in_one_seo_pack.php";s:11:"new_version";s:5:"2.9.1";s:3:"url";s:50:"https://wordpress.org/plugins/all-in-one-seo-pack/";s:7:"package";s:68:"https://downloads.wordpress.org/plugin/all-in-one-seo-pack.2.9.1.zip";s:5:"icons";a:2:{s:2:"2x";s:71:"https://ps.w.org/all-in-one-seo-pack/assets/icon-256x256.png?rev=979908";s:2:"1x";s:71:"https://ps.w.org/all-in-one-seo-pack/assets/icon-128x128.png?rev=979908";}s:7:"banners";a:2:{s:2:"2x";s:75:"https://ps.w.org/all-in-one-seo-pack/assets/banner-1544x500.png?rev=1354894";s:2:"1x";s:74:"https://ps.w.org/all-in-one-seo-pack/assets/banner-772x250.png?rev=1354894";}s:11:"banners_rtl";a:0:{}}s:35:"backup-database/backup-database.php";O:8:"stdClass":9:{s:2:"id";s:29:"w.org/plugins/backup-database";s:4:"slug";s:15:"backup-database";s:6:"plugin";s:35:"backup-database/backup-database.php";s:11:"new_version";s:3:"4.9";s:3:"url";s:46:"https://wordpress.org/plugins/backup-database/";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/backup-database.zip";s:5:"icons";a:2:{s:2:"1x";s:60:"https://ps.w.org/backup-database/assets/icon.svg?rev=1854718";s:3:"svg";s:60:"https://ps.w.org/backup-database/assets/icon.svg?rev=1854718";}s:7:"banners";a:0:{}s:11:"banners_rtl";a:0:{}}s:53:"cc-bcc-for-woocommerce-order-emails/dc-cc-bcc-woe.php";O:8:"stdClass":9:{s:2:"id";s:49:"w.org/plugins/cc-bcc-for-woocommerce-order-emails";s:4:"slug";s:35:"cc-bcc-for-woocommerce-order-emails";s:6:"plugin";s:53:"cc-bcc-for-woocommerce-order-emails/dc-cc-bcc-woe.php";s:11:"new_version";s:5:"1.4.1";s:3:"url";s:66:"https://wordpress.org/plugins/cc-bcc-for-woocommerce-order-emails/";s:7:"package";s:84:"https://downloads.wordpress.org/plugin/cc-bcc-for-woocommerce-order-emails.1.4.1.zip";s:5:"icons";a:2:{s:2:"2x";s:88:"https://ps.w.org/cc-bcc-for-woocommerce-order-emails/assets/icon-256x256.png?rev=1496715";s:2:"1x";s:88:"https://ps.w.org/cc-bcc-for-woocommerce-order-emails/assets/icon-256x256.png?rev=1496715";}s:7:"banners";a:1:{s:2:"1x";s:90:"https://ps.w.org/cc-bcc-for-woocommerce-order-emails/assets/banner-772x250.png?rev=1496715";}s:11:"banners_rtl";a:0:{}}s:35:"fourteen-colors/fourteen-colors.php";O:8:"stdClass":9:{s:2:"id";s:29:"w.org/plugins/fourteen-colors";s:4:"slug";s:15:"fourteen-colors";s:6:"plugin";s:35:"fourteen-colors/fourteen-colors.php";s:11:"new_version";s:3:"1.5";s:3:"url";s:46:"https://wordpress.org/plugins/fourteen-colors/";s:7:"package";s:62:"https://downloads.wordpress.org/plugin/fourteen-colors.1.5.zip";s:5:"icons";a:2:{s:2:"1x";s:59:"https://ps.w.org/fourteen-colors/assets/icon.svg?rev=978321";s:3:"svg";s:59:"https://ps.w.org/fourteen-colors/assets/icon.svg?rev=978321";}s:7:"banners";a:2:{s:2:"2x";s:71:"https://ps.w.org/fourteen-colors/assets/banner-1544x500.png?rev=1063582";s:2:"1x";s:70:"https://ps.w.org/fourteen-colors/assets/banner-772x250.png?rev=1063582";}s:11:"banners_rtl";a:0:{}}s:29:"gmap-embed/srm_gmap_embed.php";O:8:"stdClass":9:{s:2:"id";s:24:"w.org/plugins/gmap-embed";s:4:"slug";s:10:"gmap-embed";s:6:"plugin";s:29:"gmap-embed/srm_gmap_embed.php";s:11:"new_version";s:5:"1.3.7";s:3:"url";s:41:"https://wordpress.org/plugins/gmap-embed/";s:7:"package";s:53:"https://downloads.wordpress.org/plugin/gmap-embed.zip";s:5:"icons";a:2:{s:2:"2x";s:63:"https://ps.w.org/gmap-embed/assets/icon-256x256.png?rev=1509263";s:2:"1x";s:63:"https://ps.w.org/gmap-embed/assets/icon-128x128.png?rev=1509263";}s:7:"banners";a:1:{s:2:"1x";s:65:"https://ps.w.org/gmap-embed/assets/banner-772x250.png?rev=1505473";}s:11:"banners_rtl";a:0:{}}s:36:"google-sitemap-generator/sitemap.php";O:8:"stdClass":9:{s:2:"id";s:38:"w.org/plugins/google-sitemap-generator";s:4:"slug";s:24:"google-sitemap-generator";s:6:"plugin";s:36:"google-sitemap-generator/sitemap.php";s:11:"new_version";s:5:"4.0.9";s:3:"url";s:55:"https://wordpress.org/plugins/google-sitemap-generator/";s:7:"package";s:73:"https://downloads.wordpress.org/plugin/google-sitemap-generator.4.0.9.zip";s:5:"icons";a:2:{s:2:"2x";s:77:"https://ps.w.org/google-sitemap-generator/assets/icon-256x256.png?rev=1701944";s:2:"1x";s:77:"https://ps.w.org/google-sitemap-generator/assets/icon-128x128.png?rev=1701944";}s:7:"banners";a:1:{s:2:"1x";s:79:"https://ps.w.org/google-sitemap-generator/assets/banner-772x250.png?rev=1701944";}s:11:"banners_rtl";a:0:{}}s:25:"gtranslate/gtranslate.php";O:8:"stdClass":9:{s:2:"id";s:24:"w.org/plugins/gtranslate";s:4:"slug";s:10:"gtranslate";s:6:"plugin";s:25:"gtranslate/gtranslate.php";s:11:"new_version";s:6:"2.8.43";s:3:"url";s:41:"https://wordpress.org/plugins/gtranslate/";s:7:"package";s:60:"https://downloads.wordpress.org/plugin/gtranslate.2.8.43.zip";s:5:"icons";a:2:{s:2:"2x";s:63:"https://ps.w.org/gtranslate/assets/icon-256x256.png?rev=1625219";s:2:"1x";s:63:"https://ps.w.org/gtranslate/assets/icon-128x128.png?rev=1579941";}s:7:"banners";a:1:{s:2:"1x";s:64:"https://ps.w.org/gtranslate/assets/banner-772x250.png?rev=759080";}s:11:"banners_rtl";a:0:{}}s:9:"hello.php";O:8:"stdClass":9:{s:2:"id";s:25:"w.org/plugins/hello-dolly";s:4:"slug";s:11:"hello-dolly";s:6:"plugin";s:9:"hello.php";s:11:"new_version";s:3:"1.6";s:3:"url";s:42:"https://wordpress.org/plugins/hello-dolly/";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip";s:5:"icons";a:2:{s:2:"2x";s:63:"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907";s:2:"1x";s:63:"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=969907";}s:7:"banners";a:1:{s:2:"1x";s:65:"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342";}s:11:"banners_rtl";a:0:{}}s:95:"ic-hide-add-to-cart-and-prices-in-woocommerce/IC-Hide-add-to-cart-and-prices-in-WooCommerce.php";O:8:"stdClass":9:{s:2:"id";s:59:"w.org/plugins/ic-hide-add-to-cart-and-prices-in-woocommerce";s:4:"slug";s:45:"ic-hide-add-to-cart-and-prices-in-woocommerce";s:6:"plugin";s:95:"ic-hide-add-to-cart-and-prices-in-woocommerce/IC-Hide-add-to-cart-and-prices-in-WooCommerce.php";s:11:"new_version";s:3:"3.2";s:3:"url";s:76:"https://wordpress.org/plugins/ic-hide-add-to-cart-and-prices-in-woocommerce/";s:7:"package";s:92:"https://downloads.wordpress.org/plugin/ic-hide-add-to-cart-and-prices-in-woocommerce.3.2.zip";s:5:"icons";a:2:{s:2:"2x";s:98:"https://ps.w.org/ic-hide-add-to-cart-and-prices-in-woocommerce/assets/icon-256x256.png?rev=1608186";s:2:"1x";s:98:"https://ps.w.org/ic-hide-add-to-cart-and-prices-in-woocommerce/assets/icon-128x128.png?rev=1608186";}s:7:"banners";a:1:{s:2:"1x";s:100:"https://ps.w.org/ic-hide-add-to-cart-and-prices-in-woocommerce/assets/banner-772x250.jpg?rev=1620889";}s:11:"banners_rtl";a:0:{}}s:33:"virtue-toolkit/virtue_toolkit.php";O:8:"stdClass":9:{s:2:"id";s:28:"w.org/plugins/virtue-toolkit";s:4:"slug";s:14:"virtue-toolkit";s:6:"plugin";s:33:"virtue-toolkit/virtue_toolkit.php";s:11:"new_version";s:5:"4.9.1";s:3:"url";s:45:"https://wordpress.org/plugins/virtue-toolkit/";s:7:"package";s:63:"https://downloads.wordpress.org/plugin/virtue-toolkit.4.9.1.zip";s:5:"icons";a:1:{s:7:"default";s:58:"https://s.w.org/plugins/geopattern-icon/virtue-toolkit.svg";}s:7:"banners";a:0:{}s:11:"banners_rtl";a:0:{}}s:23:"ml-slider/ml-slider.php";O:8:"stdClass":9:{s:2:"id";s:23:"w.org/plugins/ml-slider";s:4:"slug";s:9:"ml-slider";s:6:"plugin";s:23:"ml-slider/ml-slider.php";s:11:"new_version";s:6:"3.10.0";s:3:"url";s:40:"https://wordpress.org/plugins/ml-slider/";s:7:"package";s:59:"https://downloads.wordpress.org/plugin/ml-slider.3.10.0.zip";s:5:"icons";a:3:{s:2:"2x";s:62:"https://ps.w.org/ml-slider/assets/icon-256x256.png?rev=1837669";s:2:"1x";s:54:"https://ps.w.org/ml-slider/assets/icon.svg?rev=1837669";s:3:"svg";s:54:"https://ps.w.org/ml-slider/assets/icon.svg?rev=1837669";}s:7:"banners";a:2:{s:2:"2x";s:65:"https://ps.w.org/ml-slider/assets/banner-1544x500.png?rev=1837669";s:2:"1x";s:64:"https://ps.w.org/ml-slider/assets/banner-772x250.png?rev=1837669";}s:11:"banners_rtl";a:0:{}}s:39:"siteorigin-panels/siteorigin-panels.php";O:8:"stdClass":9:{s:2:"id";s:31:"w.org/plugins/siteorigin-panels";s:4:"slug";s:17:"siteorigin-panels";s:6:"plugin";s:39:"siteorigin-panels/siteorigin-panels.php";s:11:"new_version";s:5:"2.9.1";s:3:"url";s:48:"https://wordpress.org/plugins/siteorigin-panels/";s:7:"package";s:66:"https://downloads.wordpress.org/plugin/siteorigin-panels.2.9.1.zip";s:5:"icons";a:2:{s:2:"2x";s:70:"https://ps.w.org/siteorigin-panels/assets/icon-256x256.png?rev=1044755";s:2:"1x";s:70:"https://ps.w.org/siteorigin-panels/assets/icon-128x128.png?rev=1044755";}s:7:"banners";a:1:{s:2:"1x";s:72:"https://ps.w.org/siteorigin-panels/assets/banner-772x250.jpg?rev=1044755";}s:11:"banners_rtl";a:0:{}}s:49:"simple-file-downloader/simple-file-downloader.php";O:8:"stdClass":9:{s:2:"id";s:36:"w.org/plugins/simple-file-downloader";s:4:"slug";s:22:"simple-file-downloader";s:6:"plugin";s:49:"simple-file-downloader/simple-file-downloader.php";s:11:"new_version";s:5:"1.0.4";s:3:"url";s:53:"https://wordpress.org/plugins/simple-file-downloader/";s:7:"package";s:71:"https://downloads.wordpress.org/plugin/simple-file-downloader.1.0.4.zip";s:5:"icons";a:1:{s:7:"default";s:73:"https://s.w.org/plugins/geopattern-icon/simple-file-downloader_d9e9f1.svg";}s:7:"banners";a:1:{s:2:"1x";s:76:"https://ps.w.org/simple-file-downloader/assets/banner-772x250.png?rev=890351";}s:11:"banners_rtl";a:0:{}}s:39:"simple-pdf-viewer/simple-pdf-viewer.php";O:8:"stdClass":9:{s:2:"id";s:31:"w.org/plugins/simple-pdf-viewer";s:4:"slug";s:17:"simple-pdf-viewer";s:6:"plugin";s:39:"simple-pdf-viewer/simple-pdf-viewer.php";s:11:"new_version";s:3:"1.9";s:3:"url";s:48:"https://wordpress.org/plugins/simple-pdf-viewer/";s:7:"package";s:60:"https://downloads.wordpress.org/plugin/simple-pdf-viewer.zip";s:5:"icons";a:2:{s:2:"2x";s:70:"https://ps.w.org/simple-pdf-viewer/assets/icon-256x256.png?rev=1679297";s:2:"1x";s:70:"https://ps.w.org/simple-pdf-viewer/assets/icon-128x128.png?rev=1679297";}s:7:"banners";a:2:{s:2:"2x";s:73:"https://ps.w.org/simple-pdf-viewer/assets/banner-1544x500.jpg?rev=1680236";s:2:"1x";s:72:"https://ps.w.org/simple-pdf-viewer/assets/banner-772x250.jpg?rev=1680236";}s:11:"banners_rtl";a:0:{}}s:39:"so-widgets-bundle/so-widgets-bundle.php";O:8:"stdClass":9:{s:2:"id";s:31:"w.org/plugins/so-widgets-bundle";s:4:"slug";s:17:"so-widgets-bundle";s:6:"plugin";s:39:"so-widgets-bundle/so-widgets-bundle.php";s:11:"new_version";s:6:"1.13.2";s:3:"url";s:48:"https://wordpress.org/plugins/so-widgets-bundle/";s:7:"package";s:67:"https://downloads.wordpress.org/plugin/so-widgets-bundle.1.13.2.zip";s:5:"icons";a:2:{s:2:"2x";s:70:"https://ps.w.org/so-widgets-bundle/assets/icon-256x256.png?rev=1044942";s:2:"1x";s:70:"https://ps.w.org/so-widgets-bundle/assets/icon-128x128.png?rev=1044942";}s:7:"banners";a:1:{s:2:"1x";s:72:"https://ps.w.org/so-widgets-bundle/assets/banner-772x250.jpg?rev=1044942";}s:11:"banners_rtl";a:0:{}}s:33:"wd-google-maps/wd-google-maps.php";O:8:"stdClass":9:{s:2:"id";s:28:"w.org/plugins/wd-google-maps";s:4:"slug";s:14:"wd-google-maps";s:6:"plugin";s:33:"wd-google-maps/wd-google-maps.php";s:11:"new_version";s:6:"1.0.54";s:3:"url";s:45:"https://wordpress.org/plugins/wd-google-maps/";s:7:"package";s:64:"https://downloads.wordpress.org/plugin/wd-google-maps.1.0.54.zip";s:5:"icons";a:1:{s:2:"1x";s:67:"https://ps.w.org/wd-google-maps/assets/icon-128x128.png?rev=1524005";}s:7:"banners";a:1:{s:2:"1x";s:69:"https://ps.w.org/wd-google-maps/assets/banner-772x250.jpg?rev=1524005";}s:11:"banners_rtl";a:0:{}}s:27:"woocommerce/woocommerce.php";O:8:"stdClass":9:{s:2:"id";s:25:"w.org/plugins/woocommerce";s:4:"slug";s:11:"woocommerce";s:6:"plugin";s:27:"woocommerce/woocommerce.php";s:11:"new_version";s:5:"3.5.1";s:3:"url";s:42:"https://wordpress.org/plugins/woocommerce/";s:7:"package";s:60:"https://downloads.wordpress.org/plugin/woocommerce.3.5.1.zip";s:5:"icons";a:2:{s:2:"2x";s:64:"https://ps.w.org/woocommerce/assets/icon-256x256.png?rev=1440831";s:2:"1x";s:64:"https://ps.w.org/woocommerce/assets/icon-128x128.png?rev=1440831";}s:7:"banners";a:2:{s:2:"2x";s:67:"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=1629184";s:2:"1x";s:66:"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=1629184";}s:11:"banners_rtl";a:0:{}}s:43:"woocommerce-colors-1/woocommerce-colors.php";O:8:"stdClass":9:{s:2:"id";s:32:"w.org/plugins/woocommerce-colors";s:4:"slug";s:18:"woocommerce-colors";s:6:"plugin";s:43:"woocommerce-colors-1/woocommerce-colors.php";s:11:"new_version";s:5:"1.0.7";s:3:"url";s:49:"https://wordpress.org/plugins/woocommerce-colors/";s:7:"package";s:67:"https://downloads.wordpress.org/plugin/woocommerce-colors.1.0.7.zip";s:5:"icons";a:2:{s:2:"2x";s:71:"https://ps.w.org/woocommerce-colors/assets/icon-256x256.png?rev=1068048";s:2:"1x";s:71:"https://ps.w.org/woocommerce-colors/assets/icon-128x128.png?rev=1068048";}s:7:"banners";a:2:{s:2:"2x";s:74:"https://ps.w.org/woocommerce-colors/assets/banner-1544x500.png?rev=1068048";s:2:"1x";s:73:"https://ps.w.org/woocommerce-colors/assets/banner-772x250.png?rev=1068048";}s:11:"banners_rtl";a:0:{}}s:87:"woocommerce-google-analytics-integration-1/woocommerce-google-analytics-integration.php";O:8:"stdClass":9:{s:2:"id";s:54:"w.org/plugins/woocommerce-google-analytics-integration";s:4:"slug";s:40:"woocommerce-google-analytics-integration";s:6:"plugin";s:87:"woocommerce-google-analytics-integration-1/woocommerce-google-analytics-integration.php";s:11:"new_version";s:5:"1.4.5";s:3:"url";s:71:"https://wordpress.org/plugins/woocommerce-google-analytics-integration/";s:7:"package";s:89:"https://downloads.wordpress.org/plugin/woocommerce-google-analytics-integration.1.4.5.zip";s:5:"icons";a:2:{s:2:"2x";s:93:"https://ps.w.org/woocommerce-google-analytics-integration/assets/icon-256x256.png?rev=1909975";s:2:"1x";s:93:"https://ps.w.org/woocommerce-google-analytics-integration/assets/icon-128x128.png?rev=1909975";}s:7:"banners";a:2:{s:2:"2x";s:96:"https://ps.w.org/woocommerce-google-analytics-integration/assets/banner-1544x500.png?rev=1909975";s:2:"1x";s:95:"https://ps.w.org/woocommerce-google-analytics-integration/assets/banner-772x250.png?rev=1909975";}s:11:"banners_rtl";a:0:{}}s:41:"wordpress-importer/wordpress-importer.php";O:8:"stdClass":9:{s:2:"id";s:32:"w.org/plugins/wordpress-importer";s:4:"slug";s:18:"wordpress-importer";s:6:"plugin";s:41:"wordpress-importer/wordpress-importer.php";s:11:"new_version";s:5:"0.6.4";s:3:"url";s:49:"https://wordpress.org/plugins/wordpress-importer/";s:7:"package";s:67:"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.4.zip";s:5:"icons";a:3:{s:2:"2x";s:71:"https://ps.w.org/wordpress-importer/assets/icon-256x256.png?rev=1908375";s:2:"1x";s:63:"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375";s:3:"svg";s:63:"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375";}s:7:"banners";a:1:{s:2:"1x";s:72:"https://ps.w.org/wordpress-importer/assets/banner-772x250.png?rev=547654";}s:11:"banners_rtl";a:0:{}}s:45:"wp-notification-bars/wp-notification-bars.php";O:8:"stdClass":9:{s:2:"id";s:34:"w.org/plugins/wp-notification-bars";s:4:"slug";s:20:"wp-notification-bars";s:6:"plugin";s:45:"wp-notification-bars/wp-notification-bars.php";s:11:"new_version";s:5:"1.0.4";s:3:"url";s:51:"https://wordpress.org/plugins/wp-notification-bars/";s:7:"package";s:69:"https://downloads.wordpress.org/plugin/wp-notification-bars.1.0.4.zip";s:5:"icons";a:2:{s:2:"2x";s:73:"https://ps.w.org/wp-notification-bars/assets/icon-256x256.png?rev=1249179";s:2:"1x";s:73:"https://ps.w.org/wp-notification-bars/assets/icon-128x128.png?rev=1249179";}s:7:"banners";a:1:{s:2:"1x";s:75:"https://ps.w.org/wp-notification-bars/assets/banner-772x250.jpg?rev=1249179";}s:11:"banners_rtl";a:0:{}}s:21:"wp-reset/wp-reset.php";O:8:"stdClass":9:{s:2:"id";s:22:"w.org/plugins/wp-reset";s:4:"slug";s:8:"wp-reset";s:6:"plugin";s:21:"wp-reset/wp-reset.php";s:11:"new_version";s:4:"1.40";s:3:"url";s:39:"https://wordpress.org/plugins/wp-reset/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/wp-reset.1.40.zip";s:5:"icons";a:2:{s:2:"2x";s:61:"https://ps.w.org/wp-reset/assets/icon-256x256.png?rev=1906468";s:2:"1x";s:61:"https://ps.w.org/wp-reset/assets/icon-128x128.png?rev=1906468";}s:7:"banners";a:2:{s:2:"2x";s:64:"https://ps.w.org/wp-reset/assets/banner-1544x500.png?rev=1904477";s:2:"1x";s:63:"https://ps.w.org/wp-reset/assets/banner-772x250.png?rev=1904477";}s:11:"banners_rtl";a:0:{}}}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('6098', 'external_theme_updates-virtue_premium', 'O:8:"stdClass":3:{s:9:"lastCheck";i:1541021162;s:14:"checkedVersion";s:5:"4.8.4";s:6:"update";N;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('6099', '_site_transient_update_themes', 'O:8:"stdClass":4:{s:12:"last_checked";i:1541021163;s:7:"checked";a:4:{s:13:"twentyfifteen";s:3:"2.0";s:15:"twentyseventeen";s:3:"1.7";s:13:"twentysixteen";s:3:"1.5";s:14:"virtue_premium";s:5:"4.8.4";}s:8:"response";a:0:{}s:12:"translations";a:0:{}}', 'no'); 
INSERT INTO `mod63_options` VALUES ('6100', 'hmbkp_dropbox_settings', 'a:2:{s:7:"enabled";s:2:"no";s:12:"access_token";N;}', 'yes'); 
INSERT INTO `mod63_options` VALUES ('6101', '_transient_timeout_wc_related_1219', '1541107570', 'no'); 
INSERT INTO `mod63_options` VALUES ('6102', '_transient_wc_related_1219', 'a:2:{s:52:"limit=4&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=1219";a:10:{i:0;s:4:"1211";i:1;s:4:"1212";i:2;s:4:"1217";i:3;s:4:"1218";i:4;s:4:"1221";i:5;s:4:"1222";i:6;s:4:"1223";i:7;s:4:"1224";i:8;s:4:"1225";i:9;s:4:"1227";}s:53:"limit=12&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=1219";a:10:{i:0;s:4:"1211";i:1;s:4:"1212";i:2;s:4:"1217";i:3;s:4:"1218";i:4;s:4:"1221";i:5;s:4:"1222";i:6;s:4:"1223";i:7;s:4:"1224";i:8;s:4:"1225";i:9;s:4:"1227";}}', 'no'); 

UNLOCK TABLES; 

-- 
-- Table structure for table `mod63_postmeta` 
-- 

DROP TABLE IF EXISTS `mod63_postmeta`; 
CREATE TABLE `mod63_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=36786 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci; 

-- 
-- Dumping data for table `mod63_postmeta` 
-- 

LOCK TABLES `mod63_postmeta` WRITE; 
INSERT INTO `mod63_postmeta` VALUES ('1', '2', '_wp_page_template', 'default'); 
INSERT INTO `mod63_postmeta` VALUES ('2', '3', '_wp_page_template', 'default'); 
INSERT INTO `mod63_postmeta` VALUES ('3', '9', '_wp_attached_file', '2018/10/logo-1.jpg'); 
INSERT INTO `mod63_postmeta` VALUES ('4', '9', '_wp_attachment_metadata', 'a:5:{s:5:"width";i:562;s:6:"height";i:279;s:4:"file";s:18:"2018/10/logo-1.jpg";s:5:"sizes";a:10:{s:21:"woocommerce_thumbnail";a:5:{s:4:"file";s:18:"logo-1-300x279.jpg";s:5:"width";i:300;s:6:"height";i:279;s:9:"mime-type";s:10:"image/jpeg";s:9:"uncropped";b:1;}s:18:"woocommerce_single";a:4:{s:4:"file";s:18:"logo-1-350x174.jpg";s:5:"width";i:350;s:6:"height";i:174;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:18:"logo-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:18:"logo-1-300x149.jpg";s:5:"width";i:300;s:6:"height";i:149;s:9:"mime-type";s:10:"image/jpeg";}s:12:"widget-thumb";a:4:{s:4:"file";s:16:"logo-1-80x50.jpg";s:5:"width";i:80;s:6:"height";i:50;s:9:"mime-type";s:10:"image/jpeg";}s:29:"woocommerce_gallery_thumbnail";a:4:{s:4:"file";s:18:"logo-1-100x100.jpg";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}s:12:"shop_catalog";a:5:{s:4:"file";s:18:"logo-1-300x279.jpg";s:5:"width";i:300;s:6:"height";i:279;s:9:"mime-type";s:10:"image/jpeg";s:9:"uncropped";b:1;}s:14:"shop_thumbnail";a:4:{s:4:"file";s:18:"logo-1-100x100.jpg";s:5:"width";i:100;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}s:11:"kip-360x200";a:4:{s:4:"file";s:18:"logo-1-360x200.jpg";s:5:"width";i:360;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:11:"kip-180x100";a:4:{s:4:"file";s:18:"logo-1-180x100.jpg";s:5:"width";i:180;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'); 
INSERT INTO `mod63_postmeta` VALUES ('5', '9', '_wp_attachment_image_alt', 'eak logo'); 
INSERT INTO `mod63_postmeta` VALUES ('6', '10', '_wp_trash_meta_status', 'publish'); 
INSERT INTO `mod63_postmeta` VALUES ('7', '10', '_wp_trash_meta_time', '1538662691'); 
INSERT INTO `mod63_postmeta` VALUES ('10', '12', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('11', '12', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('12', '12', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('13', '12', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('14', '12', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('15', '12', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('16', '12', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('17', '12', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('18', '12', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('19', '12', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('20', '12', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('21', '12', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('22', '12', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('23', '12', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('24', '12', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('25', '12', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('26', '12', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('27', '12', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('28', '12', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('29', '12', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('30', '12', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('31', '12', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('32', '12', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('33', '12', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('34', '12', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('35', '12', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('36', '12', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('37', '12', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('38', '12', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('39', '12', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('40', '12', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('41', '12', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('42', '12', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('43', '13', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('44', '13', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('45', '13', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('46', '13', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('47', '13', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('48', '13', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('49', '13', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('50', '13', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('51', '13', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('52', '13', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('53', '13', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('54', '13', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('55', '13', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('56', '13', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('57', '13', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('58', '13', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('59', '13', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('60', '13', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('61', '13', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('62', '13', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('63', '13', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('64', '13', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('65', '13', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('66', '13', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('67', '13', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('68', '13', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('69', '13', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('70', '13', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('71', '13', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('72', '13', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('73', '13', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('74', '13', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('75', '13', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('76', '14', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('77', '14', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('78', '14', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('79', '14', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('80', '14', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('81', '14', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('82', '14', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('83', '14', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('84', '14', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('85', '14', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('86', '14', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('87', '14', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('88', '14', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('89', '14', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('90', '14', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('91', '14', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('92', '14', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('93', '14', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('94', '14', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('95', '14', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('96', '14', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('97', '14', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('98', '14', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('99', '14', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('100', '14', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('101', '14', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('102', '14', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('103', '14', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('104', '14', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('105', '14', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('106', '14', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('107', '14', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('108', '14', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('109', '15', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('110', '15', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('111', '15', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('112', '15', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('113', '15', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('114', '15', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('115', '15', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('116', '15', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('117', '15', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('118', '15', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('119', '15', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('120', '15', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('121', '15', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('122', '15', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('123', '15', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('124', '15', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('125', '15', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('126', '15', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('127', '15', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('128', '15', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('129', '15', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('130', '15', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('131', '15', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('132', '15', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('133', '15', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('134', '15', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('135', '15', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('136', '15', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('137', '15', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('138', '15', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('139', '15', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('140', '15', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('141', '15', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('142', '16', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('143', '16', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('144', '16', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('145', '16', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('146', '16', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('147', '16', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('148', '16', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('149', '16', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('150', '16', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('151', '16', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('152', '16', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('153', '16', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('154', '16', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('155', '16', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('156', '16', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('157', '16', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('158', '16', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('159', '16', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('160', '16', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('161', '16', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('162', '16', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('163', '16', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('164', '16', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('165', '16', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('166', '16', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('167', '16', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('168', '16', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('169', '16', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('170', '16', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('171', '16', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('172', '16', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('173', '16', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('174', '16', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('175', '17', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('176', '17', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('177', '17', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('178', '17', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('179', '17', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('180', '17', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('181', '17', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('182', '17', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('183', '17', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('184', '17', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('185', '17', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('186', '17', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('187', '17', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('188', '17', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('189', '17', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('190', '17', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('191', '17', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('192', '17', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('193', '17', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('194', '17', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('195', '17', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('196', '17', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('197', '17', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('198', '17', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('199', '17', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('200', '17', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('201', '17', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('202', '17', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('203', '17', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('204', '17', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('205', '17', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('206', '17', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('207', '17', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('208', '18', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('209', '18', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('210', '18', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('211', '18', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('212', '18', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('213', '18', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('214', '18', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('215', '18', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('216', '18', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('217', '18', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('218', '18', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('219', '18', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('220', '18', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('221', '18', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('222', '18', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('223', '18', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('224', '18', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('225', '18', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('226', '18', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('227', '18', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('228', '18', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('229', '18', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('230', '18', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('231', '18', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('232', '18', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('233', '18', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('234', '18', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('235', '18', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('236', '18', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('237', '18', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('238', '18', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('239', '18', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('240', '18', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('241', '19', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('242', '19', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('243', '19', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('244', '19', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('245', '19', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('246', '19', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('247', '19', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('248', '19', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('249', '19', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('250', '19', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('251', '19', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('252', '19', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('253', '19', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('254', '19', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('255', '19', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('256', '19', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('257', '19', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('258', '19', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('259', '19', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('260', '19', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('261', '19', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('262', '19', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('263', '19', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('264', '19', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('265', '19', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('266', '19', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('267', '19', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('268', '19', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('269', '19', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('270', '19', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('271', '19', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('272', '19', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('273', '19', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('274', '20', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('275', '20', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('276', '20', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('277', '20', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('278', '20', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('279', '20', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('280', '20', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('281', '20', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('282', '20', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('283', '20', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('284', '20', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('285', '20', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('286', '20', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('287', '20', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('288', '20', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('289', '20', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('290', '20', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('291', '20', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('292', '20', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('293', '20', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('294', '20', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('295', '20', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('296', '20', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('297', '20', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('298', '20', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('299', '20', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('300', '20', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('301', '20', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('302', '20', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('303', '20', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('304', '20', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('305', '20', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('306', '20', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('307', '21', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('308', '21', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('309', '21', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('310', '21', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('311', '21', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('312', '21', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('313', '21', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('314', '21', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('315', '21', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('316', '21', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('317', '21', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('318', '21', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('319', '21', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('320', '21', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('321', '21', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('322', '21', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('323', '21', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('324', '21', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('325', '21', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('326', '21', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('327', '21', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('328', '21', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('329', '21', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('330', '21', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('331', '21', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('332', '21', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('333', '21', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('334', '21', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('335', '21', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('336', '21', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('337', '21', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('338', '21', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('339', '21', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('340', '22', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('341', '22', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('342', '22', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('343', '22', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('344', '22', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('345', '22', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('346', '22', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('347', '22', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('348', '22', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('349', '22', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('350', '22', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('351', '22', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('352', '22', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('353', '22', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('354', '22', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('355', '22', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('356', '22', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('357', '22', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('358', '22', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('359', '22', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('360', '22', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('361', '22', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('362', '22', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('363', '22', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('364', '22', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('365', '22', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('366', '22', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('367', '22', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('368', '22', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('369', '22', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('370', '22', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('371', '22', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('372', '22', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('373', '23', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('374', '23', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('375', '23', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('376', '23', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('377', '23', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('378', '23', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('379', '23', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('380', '23', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('381', '23', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('382', '23', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('383', '23', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('384', '23', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('385', '23', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('386', '23', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('387', '23', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('388', '23', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('389', '23', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('390', '23', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('391', '23', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('392', '23', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('393', '23', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('394', '23', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('395', '23', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('396', '23', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('397', '23', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('398', '23', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('399', '23', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('400', '23', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('401', '23', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('402', '23', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('403', '23', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('404', '23', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('405', '23', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('406', '24', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('407', '24', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('408', '24', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('409', '24', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('410', '24', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('411', '24', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('412', '24', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('413', '24', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('414', '24', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('415', '24', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('416', '24', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('417', '24', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('418', '24', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('419', '24', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('420', '24', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('421', '24', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('422', '24', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('423', '24', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('424', '24', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('425', '24', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('426', '24', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('427', '24', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('428', '24', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('429', '24', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('430', '24', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('431', '24', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('432', '24', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('433', '24', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('434', '24', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('435', '24', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('436', '24', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('437', '24', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('438', '24', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('439', '25', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('440', '25', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('441', '25', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('442', '25', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('443', '25', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('444', '25', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('445', '25', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('446', '25', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('447', '25', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('448', '25', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('449', '25', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('450', '25', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('451', '25', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('452', '25', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('453', '25', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('454', '25', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('455', '25', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('456', '25', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('457', '25', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('458', '25', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('459', '25', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('460', '25', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('461', '25', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('462', '25', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('463', '25', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('464', '25', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('465', '25', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('466', '25', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('467', '25', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('468', '25', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('469', '25', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('470', '25', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('471', '25', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('472', '26', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('473', '26', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('474', '26', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('475', '26', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('476', '26', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('477', '26', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('478', '26', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('479', '26', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('480', '26', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('481', '26', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('482', '26', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('483', '26', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('484', '26', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('485', '26', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('486', '26', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('487', '26', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('488', '26', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('489', '26', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('490', '26', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('491', '26', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('492', '26', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('493', '26', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('494', '26', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('495', '26', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('496', '26', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('497', '26', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('498', '26', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('499', '26', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('500', '26', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('501', '26', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('502', '26', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('503', '26', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('504', '26', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('505', '27', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('506', '27', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('507', '27', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('508', '27', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('509', '27', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('510', '27', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('511', '27', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('512', '27', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('513', '27', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('514', '27', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('515', '27', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('516', '27', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('517', '27', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('518', '27', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('519', '27', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('520', '27', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('521', '27', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('522', '27', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('523', '27', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('524', '27', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('525', '27', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('526', '27', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('527', '27', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('528', '27', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('529', '27', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('530', '27', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('531', '27', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('532', '27', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('533', '27', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('534', '27', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('535', '27', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('536', '27', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('537', '27', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('538', '28', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('539', '28', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('540', '28', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('541', '28', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('542', '28', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('543', '28', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('544', '28', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('545', '28', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('546', '28', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('547', '28', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('548', '28', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('549', '28', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('550', '28', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('551', '28', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('552', '28', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('553', '28', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('554', '28', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('555', '28', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('556', '28', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('557', '28', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('558', '28', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('559', '28', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('560', '28', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('561', '28', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('562', '28', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('563', '28', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('564', '28', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('565', '28', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('566', '28', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('567', '28', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('568', '28', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('569', '28', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('570', '28', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('571', '29', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('572', '29', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('573', '29', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('574', '29', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('575', '29', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('576', '29', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('577', '29', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('578', '29', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('579', '29', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('580', '29', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('581', '29', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('582', '29', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('583', '29', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('584', '29', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('585', '29', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('586', '29', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('587', '29', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('588', '29', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('589', '29', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('590', '29', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('591', '29', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('592', '29', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('593', '29', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('594', '29', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('595', '29', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('596', '29', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('597', '29', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('598', '29', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('599', '29', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('600', '29', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('601', '29', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('602', '29', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('603', '29', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('604', '30', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('605', '30', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('606', '30', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('607', '30', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('608', '30', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('609', '30', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('610', '30', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('611', '30', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('612', '30', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('613', '30', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('614', '30', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('615', '30', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('616', '30', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('617', '30', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('618', '30', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('619', '30', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('620', '30', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('621', '30', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('622', '30', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('623', '30', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('624', '30', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('625', '30', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('626', '30', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('627', '30', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('628', '30', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('629', '30', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('630', '30', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('631', '30', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('632', '30', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('633', '30', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('634', '30', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('635', '30', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('636', '30', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('637', '31', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('638', '31', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('639', '31', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('640', '31', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('641', '31', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('642', '31', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('643', '31', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('644', '31', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('645', '31', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('646', '31', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('647', '31', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('648', '31', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('649', '31', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('650', '31', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('651', '31', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('652', '31', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('653', '31', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('654', '31', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('655', '31', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('656', '31', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('657', '31', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('658', '31', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('659', '31', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('660', '31', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('661', '31', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('662', '31', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('663', '31', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('664', '31', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('665', '31', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('666', '31', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('667', '31', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('668', '31', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('669', '31', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('670', '32', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('671', '32', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('672', '32', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('673', '32', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('674', '32', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('675', '32', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('676', '32', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('677', '32', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('678', '32', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('679', '32', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('680', '32', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('681', '32', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('682', '32', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('683', '32', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('684', '32', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('685', '32', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('686', '32', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('687', '32', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('688', '32', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('689', '32', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('690', '32', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('691', '32', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('692', '32', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('693', '32', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('694', '32', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('695', '32', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('696', '32', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('697', '32', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('698', '32', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('699', '32', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('700', '32', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('701', '32', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('702', '32', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('703', '33', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('704', '33', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('705', '33', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('706', '33', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('707', '33', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('708', '33', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('709', '33', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('710', '33', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('711', '33', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('712', '33', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('713', '33', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('714', '33', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('715', '33', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('716', '33', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('717', '33', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('718', '33', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('719', '33', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('720', '33', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('721', '33', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('722', '33', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('723', '33', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('724', '33', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('725', '33', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('726', '33', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('727', '33', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('728', '33', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('729', '33', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('730', '33', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('731', '33', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('732', '33', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('733', '33', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('734', '33', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('735', '33', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('736', '34', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('737', '34', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('738', '34', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('739', '34', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('740', '34', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('741', '34', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('742', '34', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('743', '34', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('744', '34', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('745', '34', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('746', '34', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('747', '34', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('748', '34', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('749', '34', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('750', '34', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('751', '34', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('752', '34', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('753', '34', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('754', '34', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('755', '34', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('756', '34', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('757', '34', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('758', '34', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('759', '34', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('760', '34', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('761', '34', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('762', '34', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('763', '34', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('764', '34', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('765', '34', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('766', '34', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('767', '34', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('768', '34', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('769', '35', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('770', '35', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('771', '35', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('772', '35', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('773', '35', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('774', '35', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('775', '35', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('776', '35', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('777', '35', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('778', '35', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('779', '35', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('780', '35', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('781', '35', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('782', '35', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('783', '35', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('784', '35', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('785', '35', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('786', '35', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('787', '35', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('788', '35', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('789', '35', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('790', '35', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('791', '35', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('792', '35', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('793', '35', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('794', '35', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('795', '35', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('796', '35', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('797', '35', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('798', '35', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('799', '35', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('800', '35', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('801', '35', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('802', '36', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('803', '36', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('804', '36', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('805', '36', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('806', '36', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('807', '36', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('808', '36', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('809', '36', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('810', '36', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('811', '36', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('812', '36', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('813', '36', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('814', '36', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('815', '36', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('816', '36', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('817', '36', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('818', '36', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('819', '36', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('820', '36', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('821', '36', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('822', '36', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('823', '36', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('824', '36', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('825', '36', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('826', '36', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('827', '36', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('828', '36', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('829', '36', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('830', '36', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('831', '36', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('832', '36', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('833', '36', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('834', '36', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('835', '37', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('836', '37', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('837', '37', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('838', '37', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('839', '37', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('840', '37', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('841', '37', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('842', '37', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('843', '37', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('844', '37', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('845', '37', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('846', '37', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('847', '37', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('848', '37', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('849', '37', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('850', '37', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('851', '37', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('852', '37', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('853', '37', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('854', '37', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('855', '37', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('856', '37', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('857', '37', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('858', '37', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('859', '37', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('860', '37', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('861', '37', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('862', '37', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('863', '37', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('864', '37', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('865', '37', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('866', '37', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('867', '37', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('868', '38', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('869', '38', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('870', '38', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('871', '38', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('872', '38', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('873', '38', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('874', '38', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('875', '38', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('876', '38', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('877', '38', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('878', '38', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('879', '38', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('880', '38', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('881', '38', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('882', '38', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('883', '38', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('884', '38', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('885', '38', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('886', '38', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('887', '38', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('888', '38', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('889', '38', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('890', '38', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('891', '38', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('892', '38', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('893', '38', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('894', '38', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('895', '38', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('896', '38', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('897', '38', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('898', '38', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('899', '38', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('900', '38', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('901', '39', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('902', '39', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('903', '39', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('904', '39', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('905', '39', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('906', '39', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('907', '39', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('908', '39', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('909', '39', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('910', '39', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('911', '39', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('912', '39', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('913', '39', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('914', '39', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('915', '39', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('916', '39', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('917', '39', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('918', '39', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('919', '39', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('920', '39', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('921', '39', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('922', '39', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('923', '39', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('924', '39', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('925', '39', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('926', '39', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('927', '39', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('928', '39', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('929', '39', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('930', '39', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('931', '39', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('932', '39', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('933', '39', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('934', '40', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('935', '40', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('936', '40', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('937', '40', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('938', '40', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('939', '40', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('940', '40', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('941', '40', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('942', '40', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('943', '40', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('944', '40', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('945', '40', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('946', '40', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('947', '40', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('948', '40', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('949', '40', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('950', '40', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('951', '40', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('952', '40', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('953', '40', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('954', '40', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('955', '40', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('956', '40', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('957', '40', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('958', '40', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('959', '40', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('960', '40', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('961', '40', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('962', '40', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('963', '40', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('964', '40', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('965', '40', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('966', '40', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('967', '41', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('968', '41', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('969', '41', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('970', '41', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('971', '41', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('972', '41', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('973', '41', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('974', '41', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('975', '41', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('976', '41', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('977', '41', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('978', '41', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('979', '41', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('980', '41', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('981', '41', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('982', '41', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('983', '41', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('984', '41', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('985', '41', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('986', '41', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('987', '41', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('988', '41', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('989', '41', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('990', '41', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('991', '41', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('992', '41', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('993', '41', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('994', '41', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('995', '41', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('996', '41', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('997', '41', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('998', '41', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('999', '41', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1000', '42', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1001', '42', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1002', '42', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1003', '42', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1004', '42', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1005', '42', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1006', '42', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1007', '42', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1008', '42', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1009', '42', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1010', '42', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1011', '42', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1012', '42', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1013', '42', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1014', '42', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1015', '42', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1016', '42', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1017', '42', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1018', '42', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1019', '42', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1020', '42', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1021', '42', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1022', '42', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1023', '42', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1024', '42', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1025', '42', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1026', '42', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1027', '42', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1028', '42', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1029', '42', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1030', '42', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1031', '42', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1032', '42', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1033', '43', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1034', '43', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1035', '43', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1036', '43', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1037', '43', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1038', '43', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1039', '43', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1040', '43', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1041', '43', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1042', '43', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1043', '43', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1044', '43', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1045', '43', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1046', '43', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1047', '43', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1048', '43', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1049', '43', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1050', '43', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1051', '43', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1052', '43', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1053', '43', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1054', '43', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1055', '43', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1056', '43', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1057', '43', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1058', '43', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1059', '43', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1060', '43', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1061', '43', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1062', '43', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1063', '43', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1064', '43', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1065', '43', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1066', '44', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1067', '44', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1068', '44', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1069', '44', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1070', '44', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1071', '44', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1072', '44', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1073', '44', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1074', '44', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1075', '44', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1076', '44', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1077', '44', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1078', '44', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1079', '44', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1080', '44', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1081', '44', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1082', '44', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1083', '44', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1084', '44', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1085', '44', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1086', '44', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1087', '44', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1088', '44', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1089', '44', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1090', '44', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1091', '44', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1092', '44', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1093', '44', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1094', '44', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1095', '44', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1096', '44', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1097', '44', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1098', '44', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1099', '45', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1100', '45', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1101', '45', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1102', '45', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1103', '45', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1104', '45', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1105', '45', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1106', '45', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1107', '45', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1108', '45', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1109', '45', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1110', '45', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1111', '45', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1112', '45', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1113', '45', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1114', '45', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1115', '45', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1116', '45', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1117', '45', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1118', '45', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1119', '45', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1120', '45', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1121', '45', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1122', '45', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1123', '45', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1124', '45', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1125', '45', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1126', '45', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1127', '45', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1128', '45', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1129', '45', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1130', '45', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1131', '45', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1132', '46', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1133', '46', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1134', '46', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1135', '46', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1136', '46', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1137', '46', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1138', '46', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1139', '46', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1140', '46', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1141', '46', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1142', '46', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1143', '46', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1144', '46', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1145', '46', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1146', '46', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1147', '46', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1148', '46', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1149', '46', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1150', '46', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1151', '46', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1152', '46', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1153', '46', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1154', '46', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1155', '46', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1156', '46', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1157', '46', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1158', '46', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1159', '46', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1160', '46', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1161', '46', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1162', '46', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1163', '46', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1164', '46', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1165', '47', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1166', '47', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1167', '47', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1168', '47', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1169', '47', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1170', '47', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1171', '47', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1172', '47', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1173', '47', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1174', '47', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1175', '47', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1176', '47', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1177', '47', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1178', '47', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1179', '47', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1180', '47', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1181', '47', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1182', '47', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1183', '47', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1184', '47', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1185', '47', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1186', '47', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1187', '47', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1188', '47', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1189', '47', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1190', '47', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1191', '47', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1192', '47', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1193', '47', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1194', '47', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1195', '47', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1196', '47', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1197', '47', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1198', '48', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1199', '48', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1200', '48', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1201', '48', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1202', '48', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1203', '48', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1204', '48', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1205', '48', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1206', '48', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1207', '48', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1208', '48', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1209', '48', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1210', '48', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1211', '48', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1212', '48', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1213', '48', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1214', '48', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1215', '48', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1216', '48', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1217', '48', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1218', '48', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1219', '48', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1220', '48', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1221', '48', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1222', '48', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1223', '48', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1224', '48', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1225', '48', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1226', '48', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1227', '48', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1228', '48', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1229', '48', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1230', '48', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1231', '49', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1232', '49', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1233', '49', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1234', '49', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1235', '49', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1236', '49', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1237', '49', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1238', '49', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1239', '49', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1240', '49', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1241', '49', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1242', '49', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1243', '49', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1244', '49', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1245', '49', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1246', '49', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1247', '49', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1248', '49', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1249', '49', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1250', '49', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1251', '49', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1252', '49', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1253', '49', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1254', '49', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1255', '49', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1256', '49', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1257', '49', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1258', '49', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1259', '49', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1260', '49', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1261', '49', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1262', '49', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1263', '49', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1264', '50', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1265', '50', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1266', '50', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1267', '50', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1268', '50', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1269', '50', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1270', '50', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1271', '50', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1272', '50', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1273', '50', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1274', '50', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1275', '50', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1276', '50', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1277', '50', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1278', '50', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1279', '50', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1280', '50', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1281', '50', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1282', '50', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1283', '50', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1284', '50', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1285', '50', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1286', '50', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1287', '50', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1288', '50', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1289', '50', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1290', '50', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1291', '50', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1292', '50', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1293', '50', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1294', '50', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1295', '50', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1296', '50', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1297', '51', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1298', '51', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1299', '51', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1300', '51', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1301', '51', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1302', '51', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1303', '51', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1304', '51', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1305', '51', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1306', '51', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1307', '51', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1308', '51', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1309', '51', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1310', '51', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1311', '51', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1312', '51', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1313', '51', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1314', '51', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1315', '51', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1316', '51', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1317', '51', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1318', '51', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1319', '51', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1320', '51', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1321', '51', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1322', '51', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1323', '51', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1324', '51', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1325', '51', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1326', '51', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1327', '51', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1328', '51', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1329', '51', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1330', '52', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1331', '52', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1332', '52', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1333', '52', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1334', '52', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1335', '52', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1336', '52', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1337', '52', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1338', '52', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1339', '52', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1340', '52', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1341', '52', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1342', '52', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1343', '52', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1344', '52', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1345', '52', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1346', '52', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1347', '52', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1348', '52', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1349', '52', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1350', '52', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1351', '52', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1352', '52', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1353', '52', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1354', '52', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1355', '52', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1356', '52', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1357', '52', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1358', '52', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1359', '52', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1360', '52', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1361', '52', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1362', '52', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1363', '53', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1364', '53', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1365', '53', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1366', '53', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1367', '53', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1368', '53', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1369', '53', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1370', '53', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1371', '53', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1372', '53', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1373', '53', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1374', '53', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1375', '53', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1376', '53', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1377', '53', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1378', '53', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1379', '53', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1380', '53', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1381', '53', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1382', '53', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1383', '53', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1384', '53', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1385', '53', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1386', '53', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1387', '53', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1388', '53', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1389', '53', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1390', '53', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1391', '53', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1392', '53', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1393', '53', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1394', '53', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1395', '53', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1396', '54', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1397', '54', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1398', '54', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1399', '54', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1400', '54', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1401', '54', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1402', '54', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1403', '54', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1404', '54', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1405', '54', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1406', '54', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1407', '54', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1408', '54', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1409', '54', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1410', '54', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1411', '54', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1412', '54', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1413', '54', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1414', '54', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1415', '54', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1416', '54', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1417', '54', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1418', '54', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1419', '54', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1420', '54', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1421', '54', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1422', '54', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1423', '54', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1424', '54', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1425', '54', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1426', '54', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1427', '54', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1428', '54', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1429', '55', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1430', '55', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1431', '55', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1432', '55', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1433', '55', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1434', '55', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1435', '55', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1436', '55', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1437', '55', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1438', '55', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1439', '55', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1440', '55', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1441', '55', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1442', '55', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1443', '55', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1444', '55', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1445', '55', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1446', '55', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1447', '55', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1448', '55', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1449', '55', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1450', '55', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1451', '55', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1452', '55', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1453', '55', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1454', '55', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1455', '55', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1456', '55', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1457', '55', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1458', '55', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1459', '55', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1460', '55', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1461', '55', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1462', '56', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1463', '56', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1464', '56', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1465', '56', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1466', '56', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1467', '56', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1468', '56', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1469', '56', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1470', '56', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1471', '56', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1472', '56', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1473', '56', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1474', '56', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1475', '56', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1476', '56', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1477', '56', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1478', '56', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1479', '56', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1480', '56', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1481', '56', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1482', '56', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1483', '56', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1484', '56', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1485', '56', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1486', '56', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1487', '56', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1488', '56', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1489', '56', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1490', '56', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1491', '56', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1492', '56', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1493', '56', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1494', '56', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1495', '57', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1496', '57', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1497', '57', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1498', '57', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1499', '57', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1500', '57', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1501', '57', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1502', '57', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1503', '57', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1504', '57', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1505', '57', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1506', '57', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1507', '57', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1508', '57', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1509', '57', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1510', '57', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1511', '57', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1512', '57', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1513', '57', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1514', '57', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1515', '57', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1516', '57', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1517', '57', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1518', '57', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1519', '57', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1520', '57', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1521', '57', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1522', '57', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1523', '57', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1524', '57', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1525', '57', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1526', '57', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1527', '57', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1528', '58', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1529', '58', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1530', '58', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1531', '58', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1532', '58', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1533', '58', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1534', '58', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1535', '58', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1536', '58', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1537', '58', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1538', '58', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1539', '58', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1540', '58', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1541', '58', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1542', '58', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1543', '58', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1544', '58', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1545', '58', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1546', '58', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1547', '58', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1548', '58', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1549', '58', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1550', '58', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1551', '58', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1552', '58', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1553', '58', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1554', '58', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1555', '58', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1556', '58', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1557', '58', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1558', '58', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1559', '58', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1560', '58', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1561', '59', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1562', '59', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1563', '59', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1564', '59', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1565', '59', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1566', '59', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1567', '59', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1568', '59', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1569', '59', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1570', '59', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1571', '59', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1572', '59', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1573', '59', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1574', '59', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1575', '59', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1576', '59', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1577', '59', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1578', '59', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1579', '59', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1580', '59', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1581', '59', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1582', '59', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1583', '59', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1584', '59', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1585', '59', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1586', '59', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1587', '59', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1588', '59', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1589', '59', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1590', '59', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1591', '59', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1592', '59', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1593', '59', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1594', '60', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1595', '60', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1596', '60', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1597', '60', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1598', '60', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1599', '60', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1600', '60', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1601', '60', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1602', '60', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1603', '60', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1604', '60', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1605', '60', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1606', '60', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1607', '60', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1608', '60', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1609', '60', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1610', '60', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1611', '60', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1612', '60', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1613', '60', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1614', '60', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1615', '60', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1616', '60', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1617', '60', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1618', '60', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1619', '60', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1620', '60', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1621', '60', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1622', '60', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1623', '60', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1624', '60', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1625', '60', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1626', '60', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1627', '61', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1628', '61', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1629', '61', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1630', '61', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1631', '61', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1632', '61', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1633', '61', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1634', '61', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1635', '61', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1636', '61', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1637', '61', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1638', '61', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1639', '61', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1640', '61', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1641', '61', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1642', '61', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1643', '61', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1644', '61', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1645', '61', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1646', '61', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1647', '61', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1648', '61', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1649', '61', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1650', '61', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1651', '61', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1652', '61', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1653', '61', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1654', '61', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1655', '61', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1656', '61', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1657', '61', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1658', '61', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1659', '61', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1660', '62', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1661', '62', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1662', '62', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1663', '62', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1664', '62', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1665', '62', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1666', '62', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1667', '62', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1668', '62', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1669', '62', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1670', '62', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1671', '62', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1672', '62', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1673', '62', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1674', '62', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1675', '62', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1676', '62', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1677', '62', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1678', '62', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1679', '62', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1680', '62', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1681', '62', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1682', '62', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1683', '62', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1684', '62', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1685', '62', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1686', '62', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1687', '62', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1688', '62', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1689', '62', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1690', '62', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1691', '62', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1692', '62', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1693', '63', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1694', '63', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1695', '63', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1696', '63', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1697', '63', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1698', '63', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1699', '63', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1700', '63', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1701', '63', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1702', '63', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1703', '63', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1704', '63', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1705', '63', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1706', '63', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1707', '63', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1708', '63', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1709', '63', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1710', '63', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1711', '63', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1712', '63', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1713', '63', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1714', '63', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1715', '63', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1716', '63', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1717', '63', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1718', '63', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1719', '63', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1720', '63', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1721', '63', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1722', '63', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1723', '63', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1724', '63', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1725', '63', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1726', '64', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1727', '64', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1728', '64', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1729', '64', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1730', '64', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1731', '64', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1732', '64', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1733', '64', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1734', '64', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1735', '64', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1736', '64', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1737', '64', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1738', '64', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1739', '64', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1740', '64', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1741', '64', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1742', '64', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1743', '64', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1744', '64', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1745', '64', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1746', '64', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1747', '64', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1748', '64', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1749', '64', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1750', '64', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1751', '64', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1752', '64', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1753', '64', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1754', '64', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1755', '64', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1756', '64', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1757', '64', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1758', '64', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1759', '65', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1760', '65', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1761', '65', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1762', '65', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1763', '65', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1764', '65', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1765', '65', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1766', '65', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1767', '65', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1768', '65', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1769', '65', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1770', '65', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1771', '65', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1772', '65', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1773', '65', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1774', '65', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1775', '65', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1776', '65', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1777', '65', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1778', '65', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1779', '65', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1780', '65', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1781', '65', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1782', '65', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1783', '65', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1784', '65', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1785', '65', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1786', '65', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1787', '65', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1788', '65', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1789', '65', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1790', '65', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1791', '65', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1792', '66', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1793', '66', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1794', '66', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1795', '66', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1796', '66', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1797', '66', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1798', '66', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1799', '66', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1800', '66', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1801', '66', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1802', '66', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1803', '66', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1804', '66', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1805', '66', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1806', '66', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1807', '66', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1808', '66', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1809', '66', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1810', '66', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1811', '66', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1812', '66', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1813', '66', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1814', '66', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1815', '66', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1816', '66', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1817', '66', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1818', '66', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1819', '66', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1820', '66', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1821', '66', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1822', '66', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1823', '66', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1824', '66', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1825', '67', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1826', '67', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1827', '67', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1828', '67', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1829', '67', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1830', '67', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1831', '67', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1832', '67', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1833', '67', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1834', '67', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1835', '67', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1836', '67', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1837', '67', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1838', '67', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1839', '67', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1840', '67', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1841', '67', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1842', '67', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1843', '67', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1844', '67', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1845', '67', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1846', '67', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1847', '67', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1848', '67', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1849', '67', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1850', '67', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1851', '67', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1852', '67', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1853', '67', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1854', '67', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1855', '67', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1856', '67', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1857', '67', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1858', '68', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1859', '68', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1860', '68', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1861', '68', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1862', '68', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1863', '68', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1864', '68', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1865', '68', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1866', '68', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1867', '68', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1868', '68', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1869', '68', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1870', '68', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1871', '68', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1872', '68', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1873', '68', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1874', '68', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1875', '68', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1876', '68', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1877', '68', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1878', '68', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1879', '68', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1880', '68', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1881', '68', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1882', '68', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1883', '68', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1884', '68', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1885', '68', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1886', '68', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1887', '68', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1888', '68', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1889', '68', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1890', '68', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1891', '69', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1892', '69', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1893', '69', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1894', '69', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1895', '69', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1896', '69', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1897', '69', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1898', '69', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1899', '69', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1900', '69', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1901', '69', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1902', '69', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1903', '69', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1904', '69', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1905', '69', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1906', '69', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1907', '69', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1908', '69', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1909', '69', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1910', '69', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1911', '69', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1912', '69', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1913', '69', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1914', '69', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1915', '69', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1916', '69', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1917', '69', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1918', '69', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1919', '69', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1920', '69', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1921', '69', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1922', '69', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1923', '69', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1924', '70', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1925', '70', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1926', '70', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1927', '70', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1928', '70', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1929', '70', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1930', '70', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1931', '70', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1932', '70', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1933', '70', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1934', '70', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1935', '70', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1936', '70', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1937', '70', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1938', '70', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1939', '70', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1940', '70', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1941', '70', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1942', '70', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1943', '70', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1944', '70', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1945', '70', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1946', '70', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1947', '70', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1948', '70', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1949', '70', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1950', '70', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1951', '70', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1952', '70', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1953', '70', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1954', '70', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1955', '70', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1956', '70', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1957', '71', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1958', '71', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1959', '71', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1960', '71', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1961', '71', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1962', '71', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1963', '71', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1964', '71', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1965', '71', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1966', '71', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1967', '71', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1968', '71', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1969', '71', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1970', '71', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1971', '71', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1972', '71', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1973', '71', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1974', '71', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1975', '71', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1976', '71', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1977', '71', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1978', '71', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1979', '71', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1980', '71', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('1981', '71', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1982', '71', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('1983', '71', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1984', '71', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1985', '71', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1986', '71', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1987', '71', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('1988', '71', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('1989', '71', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1990', '72', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1991', '72', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1992', '72', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1993', '72', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1994', '72', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1995', '72', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('1996', '72', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('1997', '72', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('1998', '72', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('1999', '72', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2000', '72', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2001', '72', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2002', '72', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2003', '72', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2004', '72', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2005', '72', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2006', '72', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2007', '72', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2008', '72', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2009', '72', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2010', '72', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2011', '72', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2012', '72', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2013', '72', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2014', '72', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2015', '72', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2016', '72', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2017', '72', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2018', '72', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2019', '72', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2020', '72', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2021', '72', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2022', '72', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2023', '73', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2024', '73', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2025', '73', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2026', '73', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2027', '73', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2028', '73', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2029', '73', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2030', '73', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2031', '73', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2032', '73', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2033', '73', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2034', '73', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2035', '73', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2036', '73', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2037', '73', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2038', '73', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2039', '73', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2040', '73', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2041', '73', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2042', '73', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2043', '73', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2044', '73', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2045', '73', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2046', '73', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2047', '73', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2048', '73', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2049', '73', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2050', '73', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2051', '73', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2052', '73', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2053', '73', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2054', '73', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2055', '73', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2056', '74', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2057', '74', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2058', '74', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2059', '74', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2060', '74', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2061', '74', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2062', '74', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2063', '74', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2064', '74', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2065', '74', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2066', '74', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2067', '74', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2068', '74', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2069', '74', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2070', '74', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2071', '74', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2072', '74', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2073', '74', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2074', '74', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2075', '74', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2076', '74', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2077', '74', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2078', '74', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2079', '74', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2080', '74', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2081', '74', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2082', '74', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2083', '74', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2084', '74', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2085', '74', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2086', '74', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2087', '74', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2088', '74', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2089', '75', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2090', '75', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2091', '75', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2092', '75', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2093', '75', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2094', '75', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2095', '75', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2096', '75', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2097', '75', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2098', '75', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2099', '75', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2100', '75', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2101', '75', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2102', '75', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2103', '75', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2104', '75', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2105', '75', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2106', '75', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2107', '75', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2108', '75', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2109', '75', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2110', '75', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2111', '75', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2112', '75', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2113', '75', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2114', '75', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2115', '75', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2116', '75', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2117', '75', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2118', '75', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2119', '75', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2120', '75', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2121', '75', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2122', '76', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2123', '76', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2124', '76', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2125', '76', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2126', '76', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2127', '76', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2128', '76', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2129', '76', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2130', '76', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2131', '76', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2132', '76', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2133', '76', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2134', '76', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2135', '76', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2136', '76', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2137', '76', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2138', '76', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2139', '76', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2140', '76', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2141', '76', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2142', '76', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2143', '76', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2144', '76', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2145', '76', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2146', '76', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2147', '76', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2148', '76', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2149', '76', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2150', '76', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2151', '76', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2152', '76', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2153', '76', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2154', '76', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2155', '77', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2156', '77', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2157', '77', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2158', '77', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2159', '77', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2160', '77', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2161', '77', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2162', '77', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2163', '77', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2164', '77', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2165', '77', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2166', '77', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2167', '77', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2168', '77', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2169', '77', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2170', '77', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2171', '77', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2172', '77', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2173', '77', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2174', '77', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2175', '77', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2176', '77', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2177', '77', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2178', '77', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2179', '77', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2180', '77', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2181', '77', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2182', '77', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2183', '77', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2184', '77', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2185', '77', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2186', '77', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2187', '77', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2188', '78', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2189', '78', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2190', '78', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2191', '78', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2192', '78', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2193', '78', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2194', '78', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2195', '78', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2196', '78', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2197', '78', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2198', '78', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2199', '78', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2200', '78', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2201', '78', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2202', '78', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2203', '78', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2204', '78', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2205', '78', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2206', '78', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2207', '78', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2208', '78', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2209', '78', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2210', '78', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2211', '78', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2212', '78', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2213', '78', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2214', '78', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2215', '78', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2216', '78', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2217', '78', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2218', '78', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2219', '78', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2220', '78', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2221', '79', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2222', '79', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2223', '79', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2224', '79', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2225', '79', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2226', '79', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2227', '79', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2228', '79', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2229', '79', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2230', '79', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2231', '79', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2232', '79', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2233', '79', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2234', '79', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2235', '79', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2236', '79', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2237', '79', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2238', '79', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2239', '79', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2240', '79', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2241', '79', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2242', '79', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2243', '79', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2244', '79', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2245', '79', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2246', '79', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2247', '79', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2248', '79', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2249', '79', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2250', '79', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2251', '79', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2252', '79', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2253', '79', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2254', '80', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2255', '80', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2256', '80', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2257', '80', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2258', '80', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2259', '80', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2260', '80', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2261', '80', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2262', '80', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2263', '80', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2264', '80', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2265', '80', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2266', '80', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2267', '80', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2268', '80', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2269', '80', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2270', '80', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2271', '80', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2272', '80', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2273', '80', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2274', '80', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2275', '80', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2276', '80', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2277', '80', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2278', '80', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2279', '80', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2280', '80', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2281', '80', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2282', '80', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2283', '80', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2284', '80', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2285', '80', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2286', '80', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2287', '81', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2288', '81', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2289', '81', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2290', '81', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2291', '81', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2292', '81', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2293', '81', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2294', '81', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2295', '81', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2296', '81', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2297', '81', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2298', '81', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2299', '81', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2300', '81', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2301', '81', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2302', '81', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2303', '81', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2304', '81', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2305', '81', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2306', '81', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2307', '81', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2308', '81', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2309', '81', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2310', '81', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2311', '81', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2312', '81', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2313', '81', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2314', '81', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2315', '81', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2316', '81', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2317', '81', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2318', '81', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2319', '81', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2320', '82', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2321', '82', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2322', '82', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2323', '82', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2324', '82', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2325', '82', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2326', '82', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2327', '82', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2328', '82', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2329', '82', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2330', '82', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2331', '82', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2332', '82', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2333', '82', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2334', '82', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2335', '82', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2336', '82', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2337', '82', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2338', '82', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2339', '82', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2340', '82', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2341', '82', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2342', '82', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2343', '82', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2344', '82', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2345', '82', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2346', '82', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2347', '82', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2348', '82', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2349', '82', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2350', '82', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2351', '82', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2352', '82', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2353', '83', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2354', '83', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2355', '83', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2356', '83', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2357', '83', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2358', '83', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2359', '83', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2360', '83', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2361', '83', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2362', '83', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2363', '83', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2364', '83', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2365', '83', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2366', '83', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2367', '83', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2368', '83', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2369', '83', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2370', '83', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2371', '83', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2372', '83', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2373', '83', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2374', '83', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2375', '83', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2376', '83', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2377', '83', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2378', '83', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2379', '83', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2380', '83', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2381', '83', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2382', '83', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2383', '83', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2384', '83', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2385', '83', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2386', '84', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2387', '84', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2388', '84', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2389', '84', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2390', '84', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2391', '84', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2392', '84', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2393', '84', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2394', '84', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2395', '84', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2396', '84', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2397', '84', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2398', '84', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2399', '84', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2400', '84', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2401', '84', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2402', '84', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2403', '84', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2404', '84', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2405', '84', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2406', '84', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2407', '84', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2408', '84', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2409', '84', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2410', '84', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2411', '84', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2412', '84', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2413', '84', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2414', '84', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2415', '84', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2416', '84', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2417', '84', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2418', '84', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2419', '85', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2420', '85', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2421', '85', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2422', '85', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2423', '85', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2424', '85', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2425', '85', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2426', '85', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2427', '85', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2428', '85', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2429', '85', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2430', '85', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2431', '85', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2432', '85', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2433', '85', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2434', '85', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2435', '85', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2436', '85', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2437', '85', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2438', '85', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2439', '85', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2440', '85', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2441', '85', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2442', '85', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2443', '85', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2444', '85', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2445', '85', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2446', '85', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2447', '85', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2448', '85', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2449', '85', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2450', '85', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2451', '85', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2452', '86', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2453', '86', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2454', '86', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2455', '86', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2456', '86', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2457', '86', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2458', '86', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2459', '86', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2460', '86', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2461', '86', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2462', '86', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2463', '86', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2464', '86', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2465', '86', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2466', '86', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2467', '86', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2468', '86', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2469', '86', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2470', '86', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2471', '86', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2472', '86', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2473', '86', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2474', '86', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2475', '86', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2476', '86', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2477', '86', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2478', '86', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2479', '86', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2480', '86', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2481', '86', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2482', '86', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2483', '86', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2484', '86', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2485', '87', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2486', '87', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2487', '87', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2488', '87', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2489', '87', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2490', '87', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2491', '87', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2492', '87', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2493', '87', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2494', '87', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2495', '87', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2496', '87', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2497', '87', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2498', '87', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2499', '87', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2500', '87', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2501', '87', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2502', '87', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2503', '87', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2504', '87', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2505', '87', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2506', '87', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2507', '87', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2508', '87', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2509', '87', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2510', '87', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2511', '87', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2512', '87', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2513', '87', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2514', '87', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2515', '87', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2516', '87', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2517', '87', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2518', '88', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2519', '88', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2520', '88', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2521', '88', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2522', '88', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2523', '88', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2524', '88', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2525', '88', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2526', '88', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2527', '88', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2528', '88', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2529', '88', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2530', '88', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2531', '88', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2532', '88', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2533', '88', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2534', '88', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2535', '88', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2536', '88', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2537', '88', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2538', '88', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2539', '88', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2540', '88', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2541', '88', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2542', '88', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2543', '88', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2544', '88', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2545', '88', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2546', '88', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2547', '88', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2548', '88', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2549', '88', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2550', '88', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2551', '89', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2552', '89', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2553', '89', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2554', '89', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2555', '89', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2556', '89', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2557', '89', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2558', '89', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2559', '89', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2560', '89', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2561', '89', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2562', '89', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2563', '89', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2564', '89', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2565', '89', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2566', '89', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2567', '89', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2568', '89', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2569', '89', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2570', '89', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2571', '89', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2572', '89', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2573', '89', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2574', '89', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2575', '89', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2576', '89', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2577', '89', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2578', '89', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2579', '89', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2580', '89', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2581', '89', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2582', '89', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2583', '89', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2584', '90', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2585', '90', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2586', '90', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2587', '90', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2588', '90', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2589', '90', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2590', '90', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2591', '90', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2592', '90', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2593', '90', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2594', '90', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2595', '90', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2596', '90', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2597', '90', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2598', '90', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2599', '90', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2600', '90', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2601', '90', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2602', '90', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2603', '90', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2604', '90', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2605', '90', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2606', '90', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2607', '90', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2608', '90', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2609', '90', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2610', '90', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2611', '90', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2612', '90', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2613', '90', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2614', '90', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2615', '90', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2616', '90', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2617', '91', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2618', '91', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2619', '91', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2620', '91', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2621', '91', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2622', '91', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2623', '91', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2624', '91', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2625', '91', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2626', '91', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2627', '91', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2628', '91', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2629', '91', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2630', '91', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2631', '91', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2632', '91', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2633', '91', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2634', '91', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2635', '91', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2636', '91', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2637', '91', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2638', '91', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2639', '91', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2640', '91', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2641', '91', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2642', '91', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2643', '91', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2644', '91', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2645', '91', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2646', '91', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2647', '91', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2648', '91', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2649', '91', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2650', '92', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2651', '92', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2652', '92', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2653', '92', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2654', '92', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2655', '92', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2656', '92', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2657', '92', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2658', '92', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2659', '92', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2660', '92', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2661', '92', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2662', '92', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2663', '92', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2664', '92', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2665', '92', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2666', '92', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2667', '92', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2668', '92', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2669', '92', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2670', '92', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2671', '92', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2672', '92', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2673', '92', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2674', '92', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2675', '92', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2676', '92', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2677', '92', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2678', '92', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2679', '92', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2680', '92', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2681', '92', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2682', '92', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2683', '93', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2684', '93', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2685', '93', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2686', '93', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2687', '93', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2688', '93', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2689', '93', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2690', '93', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2691', '93', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2692', '93', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2693', '93', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2694', '93', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2695', '93', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2696', '93', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2697', '93', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2698', '93', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2699', '93', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2700', '93', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2701', '93', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2702', '93', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2703', '93', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2704', '93', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2705', '93', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2706', '93', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2707', '93', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2708', '93', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2709', '93', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2710', '93', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2711', '93', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2712', '93', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2713', '93', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2714', '93', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2715', '93', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2716', '94', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2717', '94', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2718', '94', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2719', '94', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2720', '94', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2721', '94', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2722', '94', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2723', '94', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2724', '94', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2725', '94', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2726', '94', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2727', '94', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2728', '94', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2729', '94', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2730', '94', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2731', '94', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2732', '94', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2733', '94', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2734', '94', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2735', '94', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2736', '94', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2737', '94', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2738', '94', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2739', '94', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2740', '94', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2741', '94', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2742', '94', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2743', '94', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2744', '94', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2745', '94', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2746', '94', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2747', '94', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2748', '94', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2749', '95', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2750', '95', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2751', '95', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2752', '95', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2753', '95', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2754', '95', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2755', '95', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2756', '95', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2757', '95', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2758', '95', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2759', '95', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2760', '95', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2761', '95', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2762', '95', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2763', '95', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2764', '95', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2765', '95', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2766', '95', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2767', '95', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2768', '95', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2769', '95', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2770', '95', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2771', '95', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2772', '95', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2773', '95', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2774', '95', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2775', '95', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2776', '95', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2777', '95', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2778', '95', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2779', '95', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2780', '95', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2781', '95', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2782', '96', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2783', '96', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2784', '96', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2785', '96', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2786', '96', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2787', '96', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2788', '96', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2789', '96', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2790', '96', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2791', '96', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2792', '96', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2793', '96', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2794', '96', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2795', '96', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2796', '96', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2797', '96', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2798', '96', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2799', '96', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2800', '96', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2801', '96', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2802', '96', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2803', '96', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2804', '96', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2805', '96', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2806', '96', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2807', '96', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2808', '96', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2809', '96', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2810', '96', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2811', '96', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2812', '96', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2813', '96', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2814', '96', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2815', '97', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2816', '97', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2817', '97', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2818', '97', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2819', '97', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2820', '97', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2821', '97', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2822', '97', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2823', '97', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2824', '97', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2825', '97', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2826', '97', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2827', '97', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2828', '97', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2829', '97', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2830', '97', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2831', '97', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2832', '97', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2833', '97', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2834', '97', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2835', '97', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2836', '97', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2837', '97', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2838', '97', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2839', '97', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2840', '97', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2841', '97', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2842', '97', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2843', '97', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2844', '97', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2845', '97', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2846', '97', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2847', '97', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2848', '98', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2849', '98', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2850', '98', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2851', '98', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2852', '98', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2853', '98', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2854', '98', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2855', '98', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2856', '98', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2857', '98', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2858', '98', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2859', '98', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2860', '98', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2861', '98', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2862', '98', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2863', '98', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2864', '98', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2865', '98', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2866', '98', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2867', '98', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2868', '98', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2869', '98', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2870', '98', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2871', '98', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2872', '98', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2873', '98', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2874', '98', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2875', '98', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2876', '98', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2877', '98', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2878', '98', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2879', '98', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2880', '98', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2881', '99', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2882', '99', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2883', '99', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2884', '99', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2885', '99', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2886', '99', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2887', '99', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2888', '99', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2889', '99', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2890', '99', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2891', '99', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2892', '99', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2893', '99', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2894', '99', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2895', '99', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2896', '99', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2897', '99', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2898', '99', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2899', '99', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2900', '99', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2901', '99', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2902', '99', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2903', '99', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2904', '99', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2905', '99', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2906', '99', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2907', '99', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2908', '99', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2909', '99', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2910', '99', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2911', '99', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2912', '99', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2913', '99', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2914', '100', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2915', '100', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2916', '100', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2917', '100', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2918', '100', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2919', '100', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2920', '100', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2921', '100', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2922', '100', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2923', '100', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2924', '100', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2925', '100', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2926', '100', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2927', '100', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2928', '100', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2929', '100', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2930', '100', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2931', '100', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2932', '100', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2933', '100', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2934', '100', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2935', '100', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2936', '100', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2937', '100', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2938', '100', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2939', '100', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2940', '100', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2941', '100', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2942', '100', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2943', '100', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2944', '100', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2945', '100', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2946', '100', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2947', '101', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2948', '101', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2949', '101', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2950', '101', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2951', '101', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2952', '101', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2953', '101', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2954', '101', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2955', '101', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2956', '101', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2957', '101', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2958', '101', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2959', '101', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2960', '101', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2961', '101', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2962', '101', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2963', '101', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2964', '101', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2965', '101', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2966', '101', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2967', '101', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2968', '101', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2969', '101', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2970', '101', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('2971', '101', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2972', '101', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('2973', '101', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2974', '101', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2975', '101', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2976', '101', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2977', '101', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2978', '101', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('2979', '101', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2980', '102', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2981', '102', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2982', '102', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2983', '102', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2984', '102', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2985', '102', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('2986', '102', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('2987', '102', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2988', '102', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2989', '102', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2990', '102', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('2991', '102', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2992', '102', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2993', '102', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2994', '102', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2995', '102', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2996', '102', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2997', '102', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('2998', '102', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('2999', '102', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3000', '102', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3001', '102', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3002', '102', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3003', '102', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3004', '102', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3005', '102', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3006', '102', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3007', '102', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3008', '102', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3009', '102', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3010', '102', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3011', '102', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3012', '102', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3013', '103', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3014', '103', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3015', '103', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3016', '103', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3017', '103', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3018', '103', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3019', '103', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3020', '103', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3021', '103', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3022', '103', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3023', '103', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3024', '103', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3025', '103', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3026', '103', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3027', '103', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3028', '103', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3029', '103', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3030', '103', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3031', '103', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3032', '103', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3033', '103', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3034', '103', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3035', '103', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3036', '103', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3037', '103', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3038', '103', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3039', '103', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3040', '103', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3041', '103', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3042', '103', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3043', '103', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3044', '103', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3045', '103', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3046', '104', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3047', '104', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3048', '104', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3049', '104', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3050', '104', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3051', '104', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3052', '104', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3053', '104', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3054', '104', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3055', '104', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3056', '104', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3057', '104', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3058', '104', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3059', '104', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3060', '104', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3061', '104', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3062', '104', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3063', '104', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3064', '104', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3065', '104', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3066', '104', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3067', '104', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3068', '104', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3069', '104', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3070', '104', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3071', '104', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3072', '104', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3073', '104', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3074', '104', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3075', '104', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3076', '104', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3077', '104', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3078', '104', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3079', '105', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3080', '105', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3081', '105', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3082', '105', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3083', '105', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3084', '105', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3085', '105', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3086', '105', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3087', '105', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3088', '105', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3089', '105', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3090', '105', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3091', '105', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3092', '105', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3093', '105', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3094', '105', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3095', '105', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3096', '105', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3097', '105', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3098', '105', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3099', '105', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3100', '105', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3101', '105', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3102', '105', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3103', '105', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3104', '105', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3105', '105', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3106', '105', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3107', '105', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3108', '105', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3109', '105', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3110', '105', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3111', '105', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3112', '106', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3113', '106', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3114', '106', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3115', '106', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3116', '106', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3117', '106', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3118', '106', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3119', '106', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3120', '106', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3121', '106', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3122', '106', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3123', '106', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3124', '106', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3125', '106', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3126', '106', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3127', '106', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3128', '106', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3129', '106', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3130', '106', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3131', '106', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3132', '106', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3133', '106', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3134', '106', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3135', '106', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3136', '106', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3137', '106', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3138', '106', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3139', '106', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3140', '106', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3141', '106', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3142', '106', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3143', '106', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3144', '106', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3145', '107', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3146', '107', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3147', '107', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3148', '107', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3149', '107', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3150', '107', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3151', '107', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3152', '107', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3153', '107', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3154', '107', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3155', '107', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3156', '107', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3157', '107', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3158', '107', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3159', '107', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3160', '107', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3161', '107', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3162', '107', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3163', '107', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3164', '107', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3165', '107', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3166', '107', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3167', '107', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3168', '107', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3169', '107', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3170', '107', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3171', '107', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3172', '107', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3173', '107', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3174', '107', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3175', '107', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3176', '107', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3177', '107', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3178', '108', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3179', '108', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3180', '108', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3181', '108', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3182', '108', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3183', '108', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3184', '108', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3185', '108', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3186', '108', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3187', '108', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3188', '108', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3189', '108', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3190', '108', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3191', '108', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3192', '108', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3193', '108', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3194', '108', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3195', '108', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3196', '108', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3197', '108', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3198', '108', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3199', '108', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3200', '108', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3201', '108', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3202', '108', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3203', '108', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3204', '108', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3205', '108', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3206', '108', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3207', '108', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3208', '108', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3209', '108', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3210', '108', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3211', '109', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3212', '109', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3213', '109', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3214', '109', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3215', '109', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3216', '109', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3217', '109', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3218', '109', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3219', '109', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3220', '109', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3221', '109', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3222', '109', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3223', '109', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3224', '109', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3225', '109', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3226', '109', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3227', '109', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3228', '109', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3229', '109', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3230', '109', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3231', '109', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3232', '109', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3233', '109', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3234', '109', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3235', '109', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3236', '109', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3237', '109', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3238', '109', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3239', '109', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3240', '109', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3241', '109', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3242', '109', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3243', '109', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3244', '110', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3245', '110', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3246', '110', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3247', '110', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3248', '110', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3249', '110', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3250', '110', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3251', '110', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3252', '110', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3253', '110', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3254', '110', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3255', '110', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3256', '110', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3257', '110', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3258', '110', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3259', '110', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3260', '110', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3261', '110', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3262', '110', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3263', '110', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3264', '110', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3265', '110', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3266', '110', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3267', '110', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3268', '110', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3269', '110', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3270', '110', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3271', '110', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3272', '110', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3273', '110', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3274', '110', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3275', '110', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3276', '110', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3277', '111', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3278', '111', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3279', '111', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3280', '111', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3281', '111', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3282', '111', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3283', '111', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3284', '111', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3285', '111', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3286', '111', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3287', '111', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3288', '111', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3289', '111', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3290', '111', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3291', '111', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3292', '111', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3293', '111', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3294', '111', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3295', '111', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3296', '111', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3297', '111', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3298', '111', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3299', '111', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3300', '111', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3301', '111', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3302', '111', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3303', '111', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3304', '111', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3305', '111', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3306', '111', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3307', '111', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3308', '111', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3309', '111', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3310', '112', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3311', '112', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3312', '112', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3313', '112', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3314', '112', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3315', '112', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3316', '112', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3317', '112', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3318', '112', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3319', '112', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3320', '112', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3321', '112', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3322', '112', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3323', '112', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3324', '112', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3325', '112', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3326', '112', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3327', '112', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3328', '112', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3329', '112', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3330', '112', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3331', '112', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3332', '112', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3333', '112', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3334', '112', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3335', '112', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3336', '112', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3337', '112', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3338', '112', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3339', '112', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3340', '112', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3341', '112', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3342', '112', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3343', '113', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3344', '113', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3345', '113', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3346', '113', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3347', '113', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3348', '113', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3349', '113', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3350', '113', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3351', '113', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3352', '113', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3353', '113', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3354', '113', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3355', '113', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3356', '113', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3357', '113', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3358', '113', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3359', '113', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3360', '113', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3361', '113', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3362', '113', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3363', '113', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3364', '113', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3365', '113', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3366', '113', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3367', '113', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3368', '113', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3369', '113', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3370', '113', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3371', '113', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3372', '113', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3373', '113', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3374', '113', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3375', '113', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3376', '114', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3377', '114', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3378', '114', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3379', '114', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3380', '114', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3381', '114', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3382', '114', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3383', '114', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3384', '114', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3385', '114', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3386', '114', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3387', '114', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3388', '114', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3389', '114', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3390', '114', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3391', '114', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3392', '114', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3393', '114', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3394', '114', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3395', '114', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3396', '114', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3397', '114', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3398', '114', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3399', '114', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3400', '114', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3401', '114', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3402', '114', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3403', '114', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3404', '114', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3405', '114', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3406', '114', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3407', '114', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3408', '114', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3409', '115', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3410', '115', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3411', '115', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3412', '115', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3413', '115', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3414', '115', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3415', '115', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3416', '115', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3417', '115', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3418', '115', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3419', '115', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3420', '115', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3421', '115', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3422', '115', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3423', '115', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3424', '115', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3425', '115', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3426', '115', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3427', '115', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3428', '115', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3429', '115', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3430', '115', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3431', '115', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3432', '115', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3433', '115', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3434', '115', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3435', '115', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3436', '115', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3437', '115', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3438', '115', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3439', '115', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3440', '115', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3441', '115', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3442', '116', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3443', '116', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3444', '116', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3445', '116', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3446', '116', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3447', '116', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3448', '116', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3449', '116', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3450', '116', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3451', '116', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3452', '116', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3453', '116', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3454', '116', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3455', '116', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3456', '116', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3457', '116', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3458', '116', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3459', '116', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3460', '116', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3461', '116', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3462', '116', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3463', '116', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3464', '116', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3465', '116', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3466', '116', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3467', '116', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3468', '116', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3469', '116', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3470', '116', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3471', '116', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3472', '116', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3473', '116', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3474', '116', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3475', '117', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3476', '117', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3477', '117', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3478', '117', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3479', '117', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3480', '117', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3481', '117', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3482', '117', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3483', '117', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3484', '117', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3485', '117', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3486', '117', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3487', '117', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3488', '117', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3489', '117', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3490', '117', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3491', '117', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3492', '117', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3493', '117', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3494', '117', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3495', '117', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3496', '117', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3497', '117', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3498', '117', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3499', '117', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3500', '117', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3501', '117', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3502', '117', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3503', '117', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3504', '117', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3505', '117', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3506', '117', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3507', '117', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3508', '118', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3509', '118', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3510', '118', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3511', '118', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3512', '118', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3513', '118', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3514', '118', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3515', '118', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3516', '118', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3517', '118', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3518', '118', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3519', '118', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3520', '118', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3521', '118', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3522', '118', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3523', '118', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3524', '118', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3525', '118', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3526', '118', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3527', '118', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3528', '118', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3529', '118', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3530', '118', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3531', '118', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3532', '118', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3533', '118', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3534', '118', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3535', '118', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3536', '118', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3537', '118', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3538', '118', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3539', '118', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3540', '118', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3541', '119', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3542', '119', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3543', '119', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3544', '119', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3545', '119', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3546', '119', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3547', '119', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3548', '119', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3549', '119', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3550', '119', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3551', '119', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3552', '119', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3553', '119', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3554', '119', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3555', '119', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3556', '119', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3557', '119', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3558', '119', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3559', '119', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3560', '119', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3561', '119', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3562', '119', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3563', '119', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3564', '119', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3565', '119', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3566', '119', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3567', '119', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3568', '119', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3569', '119', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3570', '119', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3571', '119', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3572', '119', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3573', '119', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3574', '120', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3575', '120', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3576', '120', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3577', '120', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3578', '120', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3579', '120', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3580', '120', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3581', '120', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3582', '120', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3583', '120', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3584', '120', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3585', '120', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3586', '120', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3587', '120', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3588', '120', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3589', '120', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3590', '120', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3591', '120', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3592', '120', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3593', '120', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3594', '120', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3595', '120', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3596', '120', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3597', '120', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3598', '120', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3599', '120', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3600', '120', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3601', '120', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3602', '120', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3603', '120', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3604', '120', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3605', '120', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3606', '120', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3607', '121', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3608', '121', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3609', '121', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3610', '121', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3611', '121', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3612', '121', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3613', '121', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3614', '121', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3615', '121', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3616', '121', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3617', '121', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3618', '121', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3619', '121', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3620', '121', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3621', '121', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3622', '121', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3623', '121', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3624', '121', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3625', '121', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3626', '121', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3627', '121', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3628', '121', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3629', '121', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3630', '121', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3631', '121', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3632', '121', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3633', '121', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3634', '121', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3635', '121', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3636', '121', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3637', '121', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3638', '121', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3639', '121', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3640', '122', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3641', '122', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3642', '122', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3643', '122', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3644', '122', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3645', '122', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3646', '122', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3647', '122', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3648', '122', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3649', '122', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3650', '122', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3651', '122', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3652', '122', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3653', '122', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3654', '122', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3655', '122', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3656', '122', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3657', '122', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3658', '122', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3659', '122', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3660', '122', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3661', '122', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3662', '122', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3663', '122', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3664', '122', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3665', '122', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3666', '122', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3667', '122', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3668', '122', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3669', '122', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3670', '122', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3671', '122', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3672', '122', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3673', '123', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3674', '123', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3675', '123', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3676', '123', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3677', '123', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3678', '123', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3679', '123', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3680', '123', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3681', '123', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3682', '123', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3683', '123', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3684', '123', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3685', '123', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3686', '123', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3687', '123', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3688', '123', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3689', '123', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3690', '123', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3691', '123', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3692', '123', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3693', '123', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3694', '123', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3695', '123', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3696', '123', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3697', '123', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3698', '123', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3699', '123', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3700', '123', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3701', '123', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3702', '123', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3703', '123', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3704', '123', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3705', '123', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3706', '124', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3707', '124', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3708', '124', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3709', '124', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3710', '124', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3711', '124', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3712', '124', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3713', '124', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3714', '124', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3715', '124', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3716', '124', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3717', '124', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3718', '124', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3719', '124', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3720', '124', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3721', '124', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3722', '124', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3723', '124', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3724', '124', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3725', '124', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3726', '124', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3727', '124', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3728', '124', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3729', '124', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3730', '124', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3731', '124', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3732', '124', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3733', '124', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3734', '124', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3735', '124', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3736', '124', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3737', '124', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3738', '124', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3739', '125', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3740', '125', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3741', '125', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3742', '125', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3743', '125', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3744', '125', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3745', '125', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3746', '125', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3747', '125', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3748', '125', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3749', '125', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3750', '125', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3751', '125', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3752', '125', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3753', '125', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3754', '125', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3755', '125', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3756', '125', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3757', '125', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3758', '125', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3759', '125', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3760', '125', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3761', '125', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3762', '125', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3763', '125', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3764', '125', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3765', '125', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3766', '125', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3767', '125', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3768', '125', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3769', '125', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3770', '125', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3771', '125', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3772', '126', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3773', '126', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3774', '126', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3775', '126', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3776', '126', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3777', '126', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3778', '126', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3779', '126', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3780', '126', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3781', '126', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3782', '126', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3783', '126', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3784', '126', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3785', '126', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3786', '126', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3787', '126', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3788', '126', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3789', '126', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3790', '126', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3791', '126', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3792', '126', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3793', '126', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3794', '126', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3795', '126', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3796', '126', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3797', '126', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3798', '126', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3799', '126', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3800', '126', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3801', '126', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3802', '126', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3803', '126', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3804', '126', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3805', '127', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3806', '127', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3807', '127', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3808', '127', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3809', '127', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3810', '127', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3811', '127', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3812', '127', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3813', '127', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3814', '127', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3815', '127', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3816', '127', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3817', '127', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3818', '127', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3819', '127', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3820', '127', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3821', '127', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3822', '127', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3823', '127', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3824', '127', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3825', '127', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3826', '127', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3827', '127', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3828', '127', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3829', '127', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3830', '127', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3831', '127', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3832', '127', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3833', '127', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3834', '127', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3835', '127', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3836', '127', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3837', '127', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3838', '128', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3839', '128', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3840', '128', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3841', '128', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3842', '128', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3843', '128', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3844', '128', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3845', '128', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3846', '128', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3847', '128', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3848', '128', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3849', '128', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3850', '128', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3851', '128', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3852', '128', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3853', '128', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3854', '128', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3855', '128', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3856', '128', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3857', '128', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3858', '128', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3859', '128', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3860', '128', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3861', '128', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3862', '128', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3863', '128', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3864', '128', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3865', '128', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3866', '128', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3867', '128', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3868', '128', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3869', '128', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3870', '128', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3871', '129', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3872', '129', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3873', '129', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3874', '129', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3875', '129', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3876', '129', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3877', '129', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3878', '129', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3879', '129', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3880', '129', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3881', '129', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3882', '129', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3883', '129', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3884', '129', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3885', '129', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3886', '129', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3887', '129', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3888', '129', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3889', '129', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3890', '129', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3891', '129', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3892', '129', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3893', '129', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3894', '129', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3895', '129', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3896', '129', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3897', '129', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3898', '129', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3899', '129', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3900', '129', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3901', '129', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3902', '129', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3903', '129', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3904', '130', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3905', '130', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3906', '130', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3907', '130', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3908', '130', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3909', '130', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3910', '130', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3911', '130', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3912', '130', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3913', '130', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3914', '130', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3915', '130', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3916', '130', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3917', '130', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3918', '130', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3919', '130', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3920', '130', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3921', '130', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3922', '130', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3923', '130', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3924', '130', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3925', '130', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3926', '130', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3927', '130', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3928', '130', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3929', '130', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3930', '130', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3931', '130', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3932', '130', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3933', '130', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3934', '130', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3935', '130', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3936', '130', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3937', '131', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3938', '131', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3939', '131', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3940', '131', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3941', '131', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3942', '131', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3943', '131', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3944', '131', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3945', '131', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3946', '131', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3947', '131', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3948', '131', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3949', '131', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3950', '131', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3951', '131', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3952', '131', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3953', '131', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3954', '131', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3955', '131', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3956', '131', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3957', '131', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3958', '131', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3959', '131', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3960', '131', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3961', '131', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3962', '131', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3963', '131', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3964', '131', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3965', '131', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3966', '131', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3967', '131', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3968', '131', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('3969', '131', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3970', '132', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3971', '132', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3972', '132', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3973', '132', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3974', '132', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3975', '132', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3976', '132', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('3977', '132', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3978', '132', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3979', '132', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3980', '132', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3981', '132', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3982', '132', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3983', '132', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3984', '132', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3985', '132', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3986', '132', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3987', '132', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3988', '132', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3989', '132', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3990', '132', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('3991', '132', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3992', '132', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3993', '132', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('3994', '132', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('3995', '132', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('3996', '132', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3997', '132', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('3998', '132', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('3999', '132', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4000', '132', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4001', '132', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4002', '132', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4003', '133', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4004', '133', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4005', '133', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4006', '133', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4007', '133', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4008', '133', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4009', '133', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4010', '133', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4011', '133', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4012', '133', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4013', '133', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4014', '133', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4015', '133', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4016', '133', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4017', '133', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4018', '133', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4019', '133', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4020', '133', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4021', '133', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4022', '133', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4023', '133', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4024', '133', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4025', '133', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4026', '133', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4027', '133', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4028', '133', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4029', '133', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4030', '133', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4031', '133', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4032', '133', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4033', '133', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4034', '133', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4035', '133', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4036', '134', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4037', '134', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4038', '134', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4039', '134', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4040', '134', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4041', '134', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4042', '134', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4043', '134', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4044', '134', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4045', '134', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4046', '134', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4047', '134', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4048', '134', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4049', '134', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4050', '134', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4051', '134', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4052', '134', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4053', '134', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4054', '134', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4055', '134', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4056', '134', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4057', '134', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4058', '134', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4059', '134', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4060', '134', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4061', '134', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4062', '134', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4063', '134', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4064', '134', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4065', '134', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4066', '134', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4067', '134', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4068', '134', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4069', '135', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4070', '135', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4071', '135', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4072', '135', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4073', '135', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4074', '135', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4075', '135', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4076', '135', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4077', '135', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4078', '135', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4079', '135', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4080', '135', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4081', '135', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4082', '135', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4083', '135', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4084', '135', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4085', '135', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4086', '135', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4087', '135', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4088', '135', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4089', '135', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4090', '135', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4091', '135', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4092', '135', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4093', '135', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4094', '135', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4095', '135', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4096', '135', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4097', '135', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4098', '135', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4099', '135', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4100', '135', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4101', '135', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4102', '136', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4103', '136', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4104', '136', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4105', '136', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4106', '136', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4107', '136', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4108', '136', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4109', '136', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4110', '136', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4111', '136', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4112', '136', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4113', '136', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4114', '136', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4115', '136', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4116', '136', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4117', '136', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4118', '136', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4119', '136', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4120', '136', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4121', '136', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4122', '136', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4123', '136', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4124', '136', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4125', '136', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4126', '136', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4127', '136', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4128', '136', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4129', '136', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4130', '136', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4131', '136', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4132', '136', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4133', '136', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4134', '136', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4135', '137', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4136', '137', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4137', '137', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4138', '137', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4139', '137', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4140', '137', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4141', '137', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4142', '137', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4143', '137', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4144', '137', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4145', '137', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4146', '137', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4147', '137', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4148', '137', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4149', '137', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4150', '137', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4151', '137', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4152', '137', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4153', '137', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4154', '137', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4155', '137', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4156', '137', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4157', '137', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4158', '137', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4159', '137', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4160', '137', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4161', '137', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4162', '137', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4163', '137', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4164', '137', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4165', '137', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4166', '137', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4167', '137', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4168', '138', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4169', '138', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4170', '138', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4171', '138', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4172', '138', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4173', '138', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4174', '138', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4175', '138', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4176', '138', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4177', '138', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4178', '138', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4179', '138', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4180', '138', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4181', '138', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4182', '138', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4183', '138', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4184', '138', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4185', '138', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4186', '138', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4187', '138', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4188', '138', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4189', '138', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4190', '138', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4191', '138', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4192', '138', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4193', '138', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4194', '138', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4195', '138', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4196', '138', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4197', '138', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4198', '138', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4199', '138', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4200', '138', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4201', '139', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4202', '139', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4203', '139', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4204', '139', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4205', '139', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4206', '139', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4207', '139', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4208', '139', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4209', '139', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4210', '139', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4211', '139', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4212', '139', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4213', '139', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4214', '139', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4215', '139', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4216', '139', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4217', '139', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4218', '139', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4219', '139', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4220', '139', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4221', '139', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4222', '139', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4223', '139', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4224', '139', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4225', '139', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4226', '139', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4227', '139', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4228', '139', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4229', '139', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4230', '139', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4231', '139', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4232', '139', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4233', '139', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4234', '140', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4235', '140', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4236', '140', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4237', '140', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4238', '140', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4239', '140', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4240', '140', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4241', '140', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4242', '140', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4243', '140', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4244', '140', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4245', '140', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4246', '140', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4247', '140', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4248', '140', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4249', '140', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4250', '140', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4251', '140', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4252', '140', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4253', '140', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4254', '140', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4255', '140', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4256', '140', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4257', '140', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4258', '140', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4259', '140', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4260', '140', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4261', '140', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4262', '140', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4263', '140', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4264', '140', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4265', '140', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4266', '140', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4267', '141', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4268', '141', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4269', '141', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4270', '141', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4271', '141', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4272', '141', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4273', '141', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4274', '141', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4275', '141', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4276', '141', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4277', '141', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4278', '141', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4279', '141', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4280', '141', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4281', '141', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4282', '141', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4283', '141', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4284', '141', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4285', '141', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4286', '141', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4287', '141', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4288', '141', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4289', '141', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4290', '141', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4291', '141', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4292', '141', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4293', '141', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4294', '141', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4295', '141', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4296', '141', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4297', '141', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4298', '141', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4299', '141', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4300', '142', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4301', '142', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4302', '142', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4303', '142', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4304', '142', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4305', '142', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4306', '142', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4307', '142', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4308', '142', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4309', '142', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4310', '142', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4311', '142', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4312', '142', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4313', '142', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4314', '142', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4315', '142', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4316', '142', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4317', '142', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4318', '142', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4319', '142', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4320', '142', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4321', '142', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4322', '142', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4323', '142', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4324', '142', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4325', '142', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4326', '142', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4327', '142', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4328', '142', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4329', '142', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4330', '142', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4331', '142', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4332', '142', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4333', '143', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4334', '143', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4335', '143', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4336', '143', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4337', '143', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4338', '143', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4339', '143', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4340', '143', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4341', '143', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4342', '143', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4343', '143', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4344', '143', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4345', '143', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4346', '143', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4347', '143', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4348', '143', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4349', '143', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4350', '143', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4351', '143', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4352', '143', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4353', '143', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4354', '143', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4355', '143', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4356', '143', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4357', '143', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4358', '143', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4359', '143', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4360', '143', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4361', '143', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4362', '143', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4363', '143', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4364', '143', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4365', '143', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4366', '144', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4367', '144', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4368', '144', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4369', '144', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4370', '144', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4371', '144', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4372', '144', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4373', '144', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4374', '144', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4375', '144', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4376', '144', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4377', '144', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4378', '144', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4379', '144', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4380', '144', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4381', '144', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4382', '144', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4383', '144', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4384', '144', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4385', '144', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4386', '144', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4387', '144', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4388', '144', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4389', '144', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4390', '144', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4391', '144', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4392', '144', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4393', '144', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4394', '144', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4395', '144', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4396', '144', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4397', '144', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4398', '144', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4399', '145', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4400', '145', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4401', '145', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4402', '145', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4403', '145', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4404', '145', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4405', '145', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4406', '145', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4407', '145', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4408', '145', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4409', '145', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4410', '145', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4411', '145', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4412', '145', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4413', '145', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4414', '145', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4415', '145', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4416', '145', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4417', '145', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4418', '145', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4419', '145', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4420', '145', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4421', '145', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4422', '145', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4423', '145', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4424', '145', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4425', '145', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4426', '145', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4427', '145', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4428', '145', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4429', '145', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4430', '145', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4431', '145', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4432', '146', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4433', '146', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4434', '146', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4435', '146', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4436', '146', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4437', '146', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4438', '146', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4439', '146', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4440', '146', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4441', '146', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4442', '146', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4443', '146', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4444', '146', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4445', '146', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4446', '146', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4447', '146', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4448', '146', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4449', '146', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4450', '146', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4451', '146', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4452', '146', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4453', '146', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4454', '146', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4455', '146', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4456', '146', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4457', '146', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4458', '146', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4459', '146', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4460', '146', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4461', '146', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4462', '146', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4463', '146', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4464', '146', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4465', '147', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4466', '147', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4467', '147', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4468', '147', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4469', '147', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4470', '147', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4471', '147', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4472', '147', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4473', '147', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4474', '147', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4475', '147', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4476', '147', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4477', '147', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4478', '147', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4479', '147', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4480', '147', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4481', '147', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4482', '147', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4483', '147', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4484', '147', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4485', '147', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4486', '147', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4487', '147', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4488', '147', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4489', '147', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4490', '147', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4491', '147', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4492', '147', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4493', '147', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4494', '147', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4495', '147', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4496', '147', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4497', '147', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4498', '148', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4499', '148', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4500', '148', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4501', '148', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4502', '148', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4503', '148', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4504', '148', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4505', '148', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4506', '148', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4507', '148', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4508', '148', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4509', '148', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4510', '148', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4511', '148', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4512', '148', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4513', '148', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4514', '148', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4515', '148', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4516', '148', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4517', '148', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4518', '148', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4519', '148', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4520', '148', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4521', '148', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4522', '148', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4523', '148', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4524', '148', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4525', '148', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4526', '148', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4527', '148', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4528', '148', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4529', '148', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4530', '148', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4531', '149', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4532', '149', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4533', '149', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4534', '149', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4535', '149', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4536', '149', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4537', '149', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4538', '149', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4539', '149', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4540', '149', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4541', '149', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4542', '149', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4543', '149', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4544', '149', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4545', '149', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4546', '149', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4547', '149', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4548', '149', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4549', '149', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4550', '149', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4551', '149', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4552', '149', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4553', '149', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4554', '149', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4555', '149', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4556', '149', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4557', '149', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4558', '149', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4559', '149', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4560', '149', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4561', '149', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4562', '149', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4563', '149', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4564', '150', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4565', '150', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4566', '150', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4567', '150', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4568', '150', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4569', '150', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4570', '150', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4571', '150', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4572', '150', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4573', '150', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4574', '150', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4575', '150', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4576', '150', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4577', '150', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4578', '150', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4579', '150', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4580', '150', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4581', '150', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4582', '150', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4583', '150', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4584', '150', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4585', '150', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4586', '150', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4587', '150', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4588', '150', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4589', '150', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4590', '150', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4591', '150', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4592', '150', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4593', '150', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4594', '150', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4595', '150', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4596', '150', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4597', '151', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4598', '151', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4599', '151', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4600', '151', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4601', '151', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4602', '151', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4603', '151', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4604', '151', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4605', '151', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4606', '151', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4607', '151', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4608', '151', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4609', '151', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4610', '151', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4611', '151', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4612', '151', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4613', '151', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4614', '151', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4615', '151', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4616', '151', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4617', '151', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4618', '151', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4619', '151', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4620', '151', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4621', '151', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4622', '151', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4623', '151', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4624', '151', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4625', '151', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4626', '151', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4627', '151', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4628', '151', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4629', '151', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4630', '152', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4631', '152', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4632', '152', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4633', '152', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4634', '152', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4635', '152', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4636', '152', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4637', '152', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4638', '152', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4639', '152', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4640', '152', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4641', '152', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4642', '152', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4643', '152', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4644', '152', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4645', '152', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4646', '152', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4647', '152', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4648', '152', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4649', '152', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4650', '152', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4651', '152', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4652', '152', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4653', '152', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4654', '152', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4655', '152', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4656', '152', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4657', '152', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4658', '152', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4659', '152', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4660', '152', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4661', '152', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4662', '152', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4663', '153', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4664', '153', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4665', '153', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4666', '153', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4667', '153', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4668', '153', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4669', '153', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4670', '153', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4671', '153', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4672', '153', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4673', '153', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4674', '153', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4675', '153', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4676', '153', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4677', '153', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4678', '153', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4679', '153', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4680', '153', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4681', '153', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4682', '153', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4683', '153', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4684', '153', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4685', '153', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4686', '153', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4687', '153', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4688', '153', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4689', '153', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4690', '153', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4691', '153', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4692', '153', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4693', '153', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4694', '153', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4695', '153', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4696', '154', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4697', '154', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4698', '154', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4699', '154', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4700', '154', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4701', '154', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4702', '154', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4703', '154', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4704', '154', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4705', '154', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4706', '154', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4707', '154', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4708', '154', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4709', '154', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4710', '154', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4711', '154', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4712', '154', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4713', '154', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4714', '154', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4715', '154', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4716', '154', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4717', '154', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4718', '154', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4719', '154', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4720', '154', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4721', '154', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4722', '154', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4723', '154', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4724', '154', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4725', '154', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4726', '154', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4727', '154', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4728', '154', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4729', '155', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4730', '155', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4731', '155', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4732', '155', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4733', '155', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4734', '155', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4735', '155', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4736', '155', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4737', '155', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4738', '155', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4739', '155', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4740', '155', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4741', '155', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4742', '155', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4743', '155', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4744', '155', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4745', '155', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4746', '155', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4747', '155', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4748', '155', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4749', '155', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4750', '155', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4751', '155', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4752', '155', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4753', '155', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4754', '155', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4755', '155', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4756', '155', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4757', '155', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4758', '155', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4759', '155', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4760', '155', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4761', '155', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4762', '156', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4763', '156', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4764', '156', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4765', '156', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4766', '156', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4767', '156', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4768', '156', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4769', '156', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4770', '156', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4771', '156', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4772', '156', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4773', '156', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4774', '156', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4775', '156', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4776', '156', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4777', '156', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4778', '156', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4779', '156', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4780', '156', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4781', '156', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4782', '156', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4783', '156', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4784', '156', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4785', '156', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4786', '156', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4787', '156', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4788', '156', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4789', '156', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4790', '156', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4791', '156', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4792', '156', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4793', '156', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4794', '156', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4795', '157', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4796', '157', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4797', '157', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4798', '157', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4799', '157', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4800', '157', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4801', '157', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4802', '157', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4803', '157', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4804', '157', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4805', '157', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4806', '157', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4807', '157', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4808', '157', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4809', '157', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4810', '157', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4811', '157', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4812', '157', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4813', '157', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4814', '157', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4815', '157', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4816', '157', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4817', '157', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4818', '157', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4819', '157', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4820', '157', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4821', '157', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4822', '157', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4823', '157', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4824', '157', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4825', '157', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4826', '157', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4827', '157', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4828', '158', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4829', '158', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4830', '158', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4831', '158', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4832', '158', '_sale_price_dates_to', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4833', '158', 'total_sales', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4834', '158', '_tax_status', 'taxable'); 
INSERT INTO `mod63_postmeta` VALUES ('4835', '158', '_tax_class', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4836', '158', '_manage_stock', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4837', '158', '_backorders', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4838', '158', '_sold_individually', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4839', '158', '_weight', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4840', '158', '_length', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4841', '158', '_width', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4842', '158', '_height', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4843', '158', '_upsell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4844', '158', '_crosssell_ids', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4845', '158', '_purchase_note', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4846', '158', '_default_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4847', '158', '_virtual', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4848', '158', '_downloadable', 'no'); 
INSERT INTO `mod63_postmeta` VALUES ('4849', '158', '_product_image_gallery', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4850', '158', '_download_limit', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4851', '158', '_download_expiry', '-1'); 
INSERT INTO `mod63_postmeta` VALUES ('4852', '158', '_stock', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4853', '158', '_stock_status', 'instock'); 
INSERT INTO `mod63_postmeta` VALUES ('4854', '158', '_wc_average_rating', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4855', '158', '_wc_rating_count', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4856', '158', '_wc_review_count', '0'); 
INSERT INTO `mod63_postmeta` VALUES ('4857', '158', '_downloadable_files', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4858', '158', '_product_attributes', 'a:0:{}'); 
INSERT INTO `mod63_postmeta` VALUES ('4859', '158', '_product_version', '3.4.5'); 
INSERT INTO `mod63_postmeta` VALUES ('4860', '158', '_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4861', '159', '_sku', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4862', '159', '_regular_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4863', '159', '_sale_price', ''); 
INSERT INTO `mod63_postmeta` VALUES ('4864', '159', '_sale_price_dates_from', ''); 
INSERT INTO `mod63_postmeta` VALUES (