<?php
/**
 * Kadence_Recaptcha Settings Class
 *
 * @package Kadence Recaptcha
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Main Kadence_Recaptcha_Settings class
 */
class Kadence_Recaptcha_Settings {
	const OPT_NAME = 'kt_recaptcha';

	/**
	 * Action on init.
	 */
	public function __construct() {
		require_once KT_RECAPTCHA_PATH . 'inc/settings/load.php';
		// Need to load this with priority higher then 10 so class is loaded.
		add_action( 'after_setup_theme', array( $this, 'add_sections' ), 20 );
	}
	/**
	 * Add sections to settings.
	 */
	public function add_sections() {
		if ( ! class_exists( 'Kadence_Settings_Engine' ) ) {
			return;
		}
		$args = array(
			'opt_name'                         => self::OPT_NAME,
			'menu_icon'                        => '',
			'menu_title'                       => __( 'Recaptcha Settings', 'kadence-recaptcha' ),
			'page_title'                       => __( 'Kadence Recaptcha Settings', 'kadence-recaptcha' ),
			'page_slug'                        => 'kadence-recaptcha-settings',
			'page_permissions'                 => 'manage_options',
			'menu_type'                        => 'submenu',
			'page_parent'                      => ( apply_filters( 'kadence_recaptcha_network', false ) ? 'settings.php' : 'options-general.php' ),
			'page_priority'                    => null,
			'footer_credit'                    => '',
			'class'                            => '',
			'admin_bar'                        => false,
			'admin_bar_priority'               => 999,
			'admin_bar_icon'                   => '',
			'show_import_export'               => false,
			'version'                          => KT_RECAPTCHA_VERSION,
			'logo'                             => KT_RECAPTCHA_URL . 'inc/kadence-logo.png',
			'changelog'                        => KT_RECAPTCHA_PATH . 'changelog.txt',
			'network_admin'                    => apply_filters( 'kadence_recaptcha_network', false ),
			'database'                         => ( apply_filters( 'kadence_recaptcha_network', false ) ? 'network' : '' ),
		);
		$args['tabs'] = array(
			'settings' => array(
				'id' => 'settings',
				'title' => __( 'Settings', 'kadence-recaptcha' ),
			),
			'changelog' => array(
				'id' => 'changelog',
				'title' => __( 'Changelog', 'kadence-recaptcha' ),
			),
		);
		$args['sidebar'] = array(
			'facebook' => array(
				'title' => __( 'Web Creators Community', 'kadence-recaptcha' ),
				'description' => __( 'Join our community of fellow kadence users creating effective websites! Share your site, ask a question and help others.', 'kadence-recaptcha' ),
				'link' => 'https://www.facebook.com/groups/webcreatorcommunity',
				'link_text' => __( 'Join our Facebook Group', 'kadence-recaptcha' ),
			),
			'docs' => array(
				'title' => __( 'Documentation', 'kadence-recaptcha' ),
				'description' => __( 'Need help? We have a knowledge base full of articles to get you started.', 'kadence-recaptcha' ),
				'link' => 'https://www.kadencewp.com/knowledge-base/configure-kadence-recaptcha/',
				'link_text' => __( 'Browse Docs', 'kadence-recaptcha' ),
			),
			'support' => array(
				'title' => __( 'Support', 'kadence-recaptcha' ),
				'description' => __( 'Have a question, we are happy to help! Get in touch with our support team.', 'kadence-recaptcha' ),
				'link' => 'https://www.kadencewp.com/premium-support-tickets/',
				'link_text' => __( 'Submit a Ticket', 'kadence-recaptcha' ),
			),
		);
		Kadence_Settings_Engine::set_args( self::OPT_NAME, $args );
		Kadence_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id'     => 'kc_general',
				'title'  => __( 'API Keys', 'kadence-recaptcha' ),
				'long_title'  => __( 'Google reCaptcha API Keys', 'kadence-recaptcha' ),
				'desc'   => '',
				'fields' => array(
					array(
						'id'       => 'enable_v3',
						'type'     => 'select',
						'title'    => __( 'reCaptcha Version', 'kadence-recaptcha' ),
						'options'  => array(
							0 => __( 'Version 2', 'kadence-recaptcha' ),
							1 => __( 'Version 3', 'kadence-recaptcha' ),
						),
						'default'  => 0,
					),
					array(
						'id' => 'kt_re_site_key',
						'type' => 'text',
						'title' => __( 'V2 Site Key:', 'kadence-recaptcha' ),
						'help' => sprintf( __( 'Get API keys here: %s', 'kadence-recaptcha' ), '<a href="https://www.google.com/recaptcha/admin" target="_blank">https://www.google.com/recaptcha/</a>' ),
						'obfuscate' => true,
						'required' => array( 'enable_v3', '!=', 1 ),
					),
					array(
						'id' => 'kt_re_secret_key',
						'type' => 'text',
						'title' => __( 'V2 Secret Key:', 'kadence-recaptcha' ),
						'help' => sprintf( __( 'Get API keys here: %s', 'kadence-recaptcha' ), '<a href="https://www.google.com/recaptcha/admin" target="_blank">https://www.google.com/recaptcha/</a>' ),
						'obfuscate' => true,
						'required' => array( 'enable_v3', '!=', 1 ),
					),
					array(
						'id' => 'v3_re_site_key',
						'type' => 'text',
						'title' => __( 'V3 Site Key:', 'kadence-recaptcha' ),
						'help' => sprintf( __( 'Get API keys here: %s', 'kadence-recaptcha' ), '<a href="https://www.google.com/recaptcha/admin" target="_blank">https://www.google.com/recaptcha/</a>' ),
						'obfuscate' => true,
						'required' => array( 'enable_v3', '=', 1 ),
					),
					array(
						'id' => 'v3_re_secret_key',
						'type' => 'text',
						'title' => __( 'V3 Secret Key:', 'kadence-recaptcha' ),
						'help' => sprintf( __( 'Get API keys here: %s', 'kadence-recaptcha' ), '<a href="https://www.google.com/recaptcha/admin" target="_blank">https://www.google.com/recaptcha/</a>' ),
						'obfuscate' => true,
						'required' => array( 'enable_v3', '=', 1 ),
					),
					array(
						'id' => 'v3_pass_score',
						'type' => 'select',
						'title' => __( 'Recaptcha score threshold', 'kadence-recaptcha' ),
						'options' => array(
							'0' => __( '0', 'kadence-recaptcha' ),
							'0.1' => __( '0.1', 'kadence-recaptcha' ),
							'0.2' => __( '0.2', 'kadence-recaptcha' ),
							'0.3' => __( '0.3', 'kadence-recaptcha' ),
							'0.4' => __( '0.4', 'kadence-recaptcha' ),
							'0.5' => __( '0.5', 'kadence-recaptcha' ),
							'0.6' => __( '0.6', 'kadence-recaptcha' ),
							'0.7' => __( '0.7', 'kadence-recaptcha' ),
							'0.8' => __( '0.8', 'kadence-recaptcha' ),
							'0.9' => __( '0.9', 'kadence-recaptcha' ),
							'1' => __( '1', 'kadence-recaptcha' ),
						),
						'help' => __( 'Recaptcha will rank traffic and interactions based on a score of 0.0 to 1.0, with a 1.0 being a good interaction and scores closer to 0.0 indicating a good likelihood that the traffic was generated by bots', 'kadence-recaptcha' ),
						'default' => '0.5',
						'required' => array( 'enable_v3', '=', 1 ),
					),
					array(
						'id'       => 'recaptcha_url',
						'type'     => 'select',
						'title'    => __( 'reCaptcha URL', 'kadence-recaptcha' ),
						'options'  => array(
							'google' => __( 'google.com', 'kadence-recaptcha' ),
							'recaptcha' => __( 'recaptcha.net', 'kadence-recaptcha' ),
						),
						'help' => __( 'Both options still use google reCaptcha, however recaptcha.net is more likly to work in countries that block google.', 'kadence-recaptcha' ),
						'default'  => 'google',
					),
					array(
						'id'       => 'recaptcha_lang',
						'type' => 'text',
						'title' => __( 'Force Specific Language', 'kadence-recaptcha' ),
						'help' => sprintf( __( 'View language codes here: %s', 'kadence-recaptcha' ), '<a href="https://developers.google.com/recaptcha/docs/language" target="_blank">https://developers.google.com/recaptcha/docs/language/</a>' ),
					),
				),
			)
		);
		Kadence_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id'     => 'kc_forms',
				'title'  => __( 'Form Settings', 'kadence-recaptcha' ),
				'long_title'  => __( 'Form Settings', 'kadence-recaptcha' ),
				'desc'   => '',
				'fields' => array(
					array(
						'id' => 'enable_for_comments',
						'type' => 'switch',
						'title' => __( 'Enable for Post and Page Comments', 'kadence-recaptcha' ),
						'default' => 1,
					),
					array(
						'id' => 'enable_for_login',
						'type' => 'switch',
						'title' => __( 'Enable for Login', 'kadence-recaptcha' ),
						'default' => 0,
					),
					array(
						'id' => 'enable_for_lost_password',
						'type' => 'switch',
						'title' => __( 'Enable for Lost Password Form', 'kadence-recaptcha' ),
						'default' => 0,
					),
					array(
						'id' => 'enable_for_registration',
						'type' => 'switch',
						'title' => __( 'Enable for Registration', 'kadence-recaptcha' ),
						'default' => 0,
					),
					array(
						'id' => 'enable_for_woocommerce_checkout',
						'type' => 'switch',
						'title' => __( 'Enable for Woocommerce Checkout', 'kadence-recaptcha' ),
						'default' => 0,
					),
					array(
						'id' => 'enable_for_woocommerce',
						'type' => 'switch',
						'title' => __( 'Enable for Woocommerce Reviews', 'kadence-recaptcha' ),
						'default' => 1,
					),
					array(
						'id' => 'kt_recaptcha_design_info',
						'type' => 'info',
						'desc' => __( 'Google reCaptcha Style', 'kadence-recaptcha' ),
						'required' => array( 'enable_v3', '!=', 1 ),
					),
				),
			)
		);
		Kadence_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id'     => 'kc_design',
				'title'  => __( 'Design Settings', 'kadence-recaptcha' ),
				'long_title'  => __( 'Design Settings', 'kadence-recaptcha' ),
				'desc'   => '',
				'fields' => array(
					array(
						'id' => 'hide_v3_badge',
						'type' => 'switch',
						'title' => __( 'Hide reCAPTCHA badge', 'kadence-recaptcha' ),
						'help' => sprintf( __( 'Hiding requires that information about recaptcha be added to your form: %s', 'kadence-recaptcha' ), '<a href="https://developers.google.com/recaptcha/docs/faq#id-like-to-hide-the-recaptcha-badge.-what-is-allowed" target="_blank">See FAQ</a>' ),
						'default' => 0,
						'required' => array( 'enable_v3', '=', 1 ),
					),
					array(
						'id' => 'show_v3_notice',
						'type' => 'switch',
						'title' => __( 'Add default reCAPTCHA info to form', 'kadence-recaptcha' ),
						'help' =>  __( 'This will add the required reCAPTCHA version 3 informtion to your form.', 'kadence-recaptcha' ),
						'default' => 0,
						'required' => array( 
							array( 'enable_v3', '=', 1 ),
							array( 'hide_v3_badge', '=', 1 ),
						),
					),
					array(
						'id' => 'kt_re_theme',
						'type' => 'select',
						'title' => __( 'Choose a theme', 'kadence-recaptcha' ),
						'options' => array(
							'light' => __( 'Light', 'kadence-recaptcha' ),
							'dark' => __( 'Dark', 'kadence-recaptcha' ),
						),
						'default' => 'light',
						'width' => 'width:60%',
						'required' => array( 'enable_v3', '!=', 1 ),
					),
					array(
						'id' => 'kt_re_size',
						'type' => 'select',
						'title' => __( 'Choose a size', 'kadence-recaptcha' ),
						'options' => array(
							'normal' => __( 'Normal', 'kadence-recaptcha' ),
							'compact' => __( 'Compact', 'kadence-recaptcha' ),
						),
						'default' => 'normal',
						'width' => 'width:60%',
						'required' => array( 'enable_v3', '!=', 1 ),
					),
					array(
						'id' => 'kt_re_type',
						'type' => 'select',
						'title' => __( 'Choose a type', 'kadence-recaptcha' ),
						'options' => array(
							'image' => __( 'Image', 'kadence-recaptcha' ),
							'audio' => __( 'Audio', 'kadence-recaptcha' ),
						),
						'default' => 'image',
						'width' => 'width:60%',
						'required' => array( 'enable_v3', '!=', 1 ),
					),
					array(
						'id' => 'kt_re_align',
						'type' => 'select',
						'title' => __( 'Choose a alignment', 'kadence-recaptcha' ),
						'options' => array(
							'left' => __( 'Left', 'kadence-recaptcha' ),
							'center' => __( 'Center', 'kadence-recaptcha' ),
							'right' => __( 'Right', 'kadence-recaptcha' ),
						),
						'default' => 'left',
						'width' => 'width:60%',
						'required' => array( 'enable_v3', '!=', 1 ),
					),
					array(
						'id' => 'kt_recaptcha_gdpr_info',
						'type' => 'info',
						'desc' => __( 'Privacy Consent', 'kadence-recaptcha' ),
						'required' => array( 'enable_v3', '!=', 1 ),
					),
					array(
						'id' => 'enable_permission',
						'type' => 'switch',
						'title' => __( 'Enable privacy consent required before reCaptcha scripts are loaded', 'kadence-recaptcha' ),
						'default' => 0,
						'required' => array( 'enable_v3', '!=', 1 ),
					),
					array(
						'id' => 'consent_label',
						'type' => 'text',
						'title' => __( 'Consent Label', 'kadence-recaptcha' ),
						'required' => array(
							array( 'enable_permission', '=', 1 ),
							array( 'enable_v3', '!=', 1 ),
						),
					),
					array(
						'id' => 'consent_btn',
						'type' => 'text',
						'title' => __( 'Consent Button Text', 'kadence-recaptcha' ),
						'required' => array(
							array( 'enable_permission', '=', 1 ),
							array( 'enable_v3', '!=', 1 ),
						),
					),
					array(
						'id' => 'consent_cookie',
						'type' => 'text',
						'title' => __( 'Consent Cookie Name', 'kadence-recaptcha' ),
						'subtitle' => __( 'You can use a custom cookie name or one that matches another consent plugin.', 'kadence-recaptcha' ),
						'required' => array(
							array( 'enable_permission', '=', 1 ),
							array( 'enable_v3', '!=', 1 ),
						),
					),
				),
			)
		);
		if ( Kadence_Recaptcha::is_kadence_theme() ) {
			Kadence_Settings_Engine::set_section(
				self::OPT_NAME,
				array(
					'id'     => 'kc_theme',
					'title'      => __( 'Theme Form Settings', 'kadence-recaptcha' ),
					'long_title'  => __( 'Theme Form Settings', 'kadence-recaptcha' ),
					'desc'   => '',
					'fields' => array(
						array(
							'id' => 'enable_for_contact',
							'type' => 'switch',
							'title' => __( 'Enable for theme contact form', 'kadence-recaptcha' ),
							'default' => 0,
						),
						array(
							'id' => 'enable_for_testimonial',
							'type' => 'switch',
							'title' => __( 'Enable for testimonial form', 'kadence-recaptcha' ),
							'default' => 0,
						),
					),
				)
			);
		}
	}
}
new Kadence_Recaptcha_Settings();
